/* Power Render Types */

#ifndef _PRDEF_
#define _PRDEF_

#ifdef __cplusplus
  extern "C" {
#endif

/* Basic types */
#define PR_REAL float
#define PR_DWORD long
#define PR_WORD short
#define PR_BYTE char
#define PR_CHAR char
#define PR_UDWORD unsigned long
#define PR_UWORD unsigned short
#define PR_UBYTE unsigned char
#define PR_UCHAR unsigned char

#define MAXINT 2147483647


#define KEY_ESC        0x01
#define KEY_1          0x02
#define KEY_2          0x03
#define KEY_3          0x04
#define KEY_4          0x05
#define KEY_5          0x06
#define KEY_6          0x07
#define KEY_7          0x08
#define KEY_8          0x09
#define KEY_9          0x0a
#define KEY_0          0x0b
#define KEY_MINUS      0x0c
#define KEY_EQUALS     0x0d
#define KEY_BACKSPACE  0x0e
#define KEY_TAB        0x0f
#define KEY_Q          0x10
#define KEY_W          0x11
#define KEY_E          0x12
#define KEY_R          0x13
#define KEY_T          0x14
#define KEY_Y          0x15
#define KEY_U          0x16
#define KEY_I          0x17
#define KEY_O          0x18
#define KEY_P          0x19
#define KEY_LBRACE     0x1a
#define KEY_RBRACE     0x1b
#define KEY_ENTER      0x1c
#define KEY_CTRL       0x1d
#define KEY_A          0x1e
#define KEY_S          0x1f
#define KEY_D          0x20
#define KEY_F          0x21
#define KEY_G          0x22
#define KEY_H          0x23
#define KEY_J          0x24
#define KEY_K          0x25
#define KEY_L          0x26
#define KEY_SEMICOLON  0x27
#define KEY_DQUOTE     0x28
#define KEY_RQUOTA     0x29
#define KEY_LSHIFT     0x2a
#define KEY_BSLASH     0x2b
#define KEY_Z          0x2c
#define KEY_X          0x2d
#define KEY_C          0x2e
#define KEY_V          0x2f
#define KEY_B          0x30
#define KEY_N          0x31
#define KEY_M          0x32
#define KEY_COMMA      0x33
#define KEY_DOT        0x34
#define KEY_SLASH      0x35
#define KEY_RSHIFT     0x36
#define KEY_GREY_STAR  0x37
#define KEY_ALT        0x38
#define KEY_SPACE      0x39
#define KEY_CAPS       0x3a
#define KEY_F1         0x3b
#define KEY_F2         0x3c
#define KEY_F3         0x3d
#define KEY_F4         0x3e
#define KEY_F5         0x3f
#define KEY_F6         0x40
#define KEY_F7         0x41
#define KEY_F8         0x42
#define KEY_F9         0x43
#define KEY_F10        0x44
#define KEY_NUMLOCK    0x45
#define KEY_SCRLOCK    0x46
#define KEY_NUMPAD7    0x47
#define KEY_NUMPAD8    0x48
#define KEY_NUMPAD9    0x49
#define KEY_GREY_MINUS 0x4A    
#define KEY_NUMPAD4    0x4B
#define KEY_NUMPAD5    0x4C
#define KEY_NUMPAD6    0x4D
#define KEY_GREY_PLUS  0x4E    
#define KEY_NUMPAD1    0x4F
#define KEY_NUMPAD2    0x50
#define KEY_NUMPAD3    0x51
#define KEY_NUMPAD0    0x52
#define KEY_DECIMAL    0x53    

#define KEY_PAD_5      0x4c
#define KEY_F11        0x57
#define KEY_F12        0x58

#define KEY_UP         0xC8    /* UpArrow on arrow keypad */
#define KEY_PGUP       0xC9    /* PgUp on arrow keypad */
#define KEY_LEFT       0xCB    /* LeftArrow on arrow keypad */
#define KEY_RIGHT      0xCD    /* RightArrow on arrow keypad */
#define KEY_HOME       0xC7    /* Home on arrow keypad */
#define KEY_END        0xCF    /* End on arrow keypad */
#define KEY_DOWN       0xD0    /* DownArrow on arrow keypad */
#define KEY_PGDN       0xD1    /* PgDn on arrow keypad */
#define KEY_INSERT     0xD2    /* Insert on arrow keypad */
#define KEY_DEL        0xD3    /* Delete on arrow keypad */

#ifdef __WATCOMC__
#define main WatMain
#endif

#ifdef __cplusplus
}
#endif

#endif


