;
;		Channel Microcontroller Program
;		7/29/87		Joseph Hora
;
;
;       This program is a test version of a program to read data from 
;	counters and to output the sums to a main microcontroller that
;	controls several devices running this program.
;
;	This is the "slave" program, and the program for the
;	main microcontroller is the "master" program, not shown in this
;	sample.
;
;
;	Register assignments:  register Bank 0
;
;	R0 - Work register
;	R1 - Base Address of Bank to be used for current pass
;	R2 - Previous base address used
;	R3 - Previous PORT 1 reading
;	R4 - Previous PORT 2 reading
;	R5 - Current PORT 1 reading
;	R6 - Current PORT 2 reading
;	R7 - Work register
;
;
;
;		Constants	;These numbers are in Hexidecimal
CONST	BankA	20          	;Bank A: 32-63 (decimal)
CONST	BankB	40		;Bank B: 64-95     "
CONST	BankC	60		;Bank C: 96-127    "
;
;		Main Routine
	ORG	00		;Program starts here in memory
Begin	Call	Reset		;initialize parameters
	Jmp	Output		;
Main	JT0	Stat1		;If T0 set, goto Stat1
	JT1	Stat2		;If not T0 and T1, go here
	Mov	R1,#BankA	;Neither T0 or T1, so Bank A<<<<
	Jmp	StatEnd		;Exit Stat section
Stat1	JNT1	Stat3		;
	Mov	R1,#00		;If T1 also set, then WAIT mode<<<
	Jmp	Main
Stat3	Mov	R1,#BankB	;T0 and not T1, so Bank B<<<<
	Jmp	StatEnd		;
Stat2	Mov	R1,#BankC	;not T0 and T1, so Bank C<<<<
StatEnd	Mov	A,R1		;Get current base address
	XRL	A,R2		;Compare to base address last time
	JZ	TakDat		;If same, go increment counters
	MOV	A,R1		;Different bank this time, must reset
	MOV	R2,A		;set "old" base address here
	IN	A,P1		;set old port reading equal
	MOV	R3,A		;     to current one
	IN	A,P2		;same for port 2
	MOV	R4,A
	JMP	Main		;End of Main Program loop
;
;
;		Reset Routine
Reset	EN	I		;Enable interrupt
	MOV	R1,#00		;This will signal wait mode in the main prog
	MOV	R0,#BankA	;First address to be zeroed
	MOV	R7,#20		;32 decimal (16 channels *2 bytes)
	MOV	A,#00		;Zero A
Loop	MOV	@R0,A		;Zero memory at location given by R0
	INC	R0		;advance to next location
	MOV	@R0,A		;Zero next
	INC	R0		;
	MOV	@R0,A		;Zero Next (3 for 3 banks)
	INC	R0
	DJNZ	R7,#Loop	;Loop again if not done
	MOV	R2,A		;Set previous base to zero to initialize
	JMP	Main		;Return to main program
;
;
;		Data Output to Main Microcontroller
;
;	Data output to the main MC is controlled by the INT (interrupt) line.
;	When the INT is triggered while in the data taking routine, this
;	routine is called.  The interrupt line is disabled, meaning it can be
;	used as a testable signal pin.  After the interrupt is reset, the 
;	routine gets the first data to be transferred, places it on the BUS,
;	and waits for another interrupt.  This second interrupt is to signal
;	that the data is being read by the main MC.  When the MC is done
;	reading the data, it will reset the interrupt.  Then this routine will
;	stop waiting and place the next byte of data on the BUS.
;	     This process will continue until the MC has read all the data it
;	requires (either 1, 2, or 3 banks).  Then the MC will go on to other 
;	tasks, and this channel MC will wait in this routine until it receives
;	a RESET signal from the main MC.
;
Output	DIS	I		;Disable interrupt
Wait	JNI	Start		;Wait here until interrupt is reset
	JMP 	Wait		;
Start	MOV	R0,#BankA	;Set to beginning of data area
NxtDat	MOV	A,@R0		;Get Data, put in A
	OUTL	Bus,A		;Put data on bus for main MC to read
Wait1	JNI	Wait1		;Wait for another interrupt 
Wait2	JNI	Contin		;Wait until interrupt is false
	JMP	Wait2		; before going on
Contin	INC 	R0		;Proceed to next memory location
	JMP	NxtDat		;Output to MC
;
;
;		Reading channels and updating counters
;
;
;
TakDat	MOV 	A,R1		;
	MOV	R0,A		;Move base address into pointer
	IN 	A,P2		;Read port 2
	MOV	R6,A		;Store in register 6
	IN	A,P1		;Read port 1
	MOV	R5,A		;Store in R5
	XRL	A,R3		;Compare with previous reading
	MOV	R7,A		;Store comparison
	MOV	R3,#1		;Put a "1" in R3 (old PORT 1 not needed now)
	CPL	A		;not A
	CALL	Update		;Increment all counters 0-7
	MOV	A,R6		;Get current port 2
	XRL	A,R4		;Compare with old #2
	MOV	R7,A		;Store comparison
	CPL	A		;not A
	Call	Update		;Increment counters 8-15
	MOV	A,R5		;Get reading
	MOV	R3,A		;Store in "old" position
	MOV	A,R6		;get reading
	MOV	R4,A		;Store in "old" position
	JMP 	Main		;go back to main program
;
;
;		Update Subroutine
;
Update	CLR	C		;get ready for addition
	JB0	Clear0		;If not changed, do not add 1
	Mov	A,@R0		;Get current counter value
	Add	A,R3		;Increment by 1
	Mov	@R0,A		;Store result
Clear0	Inc	R0		;Move to next address in counter
	JNC	Bit1		;If carry not set, no need to update
	Inc	@R0		;Increment data location by one
Bit1	Inc	R0		;Move to bit 1 counter
	CLR	C		;clear carry
	JB1	Clear1		;If not changed, do not add 
	Mov	A,@R0		;Get current value
	Add	A,R3		;Add 1
	Mov	@R0,A		;Store result
Clear1	Inc	R0		;next location in counter
	JNC	Bit2		;leave if carry not set
	Inc	@R0		;Carry set, so increment high order byte
Bit2	Inc	R0		;Move to bit 2 counter
	CLR	C		;clear carry
	JB2	Clear2		;If not changed, do not add 
	Mov	A,@R0		;Get current value
	Add	A,R3		;Add 1
	Mov	@R0,A		;Store result
Clear2	Inc	R0		;next location in counter
	JNC	Bit3		;leave if carry not set
	Inc	@R0		;Carry set, so increment high order byte
Bit3	Inc	R0		;Move to bit 3 counter
	CLR	C		;clear carry
	JB3	Clear3		;If not changed, do not add 
	Mov	A,@R0		;Get current value
	Add	A,R3		;Add 1
	Mov	@R0,A		;Store result
Clear3	Inc	R0		;next location in counter
	JNC	Bit4		;leave if carry not set
	Inc	@R0		;Carry set, so increment high order byte
Bit4	Inc	R0		;Move to bit 4 counter
	CLR	C		;clear carry
	JB4	Clear4		;If not changed, do not add 
	Mov	A,@R0		;Get current value
	Add	A,R3		;Add 1
	Mov	@R0,A		;Store result
Clear4	Inc	R0		;next location in counter
	JNC	Bit5		;leave if carry not set
	Inc	@R0		;Carry set, so increment high order byte
Bit5	Inc	R0		;Move to bit 5 counter
	CLR	C		;clear carry
	JB5	Clear5		;If not changed, do not add 
	Mov	A,@R0		;Get current value
	Add	A,R3		;Add 1
	Mov	@R0,A		;Store result
Clear5	Inc	R0  		;next location in counter
	JNC	Bit6		;leave if carry not set
	Inc	@R0		;Carry set, so increment high order byte
Bit6	Inc	R0		;Move to bit 6 counter
	CLR	C		;clear carry
	JB6	Clear6		;If not changed, do not add 
	Mov	A,@R0		;Get current value
	Add	A,R3		;Add 1
	Mov	@R0,A		;Store result
Clear6	Inc	R0		;next location in counter
	JNC	Bit7		;leave if carry not set
	Inc	@R0		;Carry set, so increment high order byte
Bit7	Inc	R0		;Move to bit 7 counter
	CLR	C		;clear carry
	JB7	Clear7		;If not changed, do not add 
	Mov	A,@R0		;Get current value
	Add	A,R3		;Add 1
	Mov	@R0,A		;Store result
Clear7	Inc	R0		;next location in counter
	JNC	EndBit		;leave if carry not set
	Inc	@R0		;Carry set, so increment high order byte
EndBit	Inc	R0		;Proceed to next counter (in next bank)
	Ret			;Return to TakeDat
	