/*
 * File header
 */
typedef struct {
	unsigned short 	f_magic;	/* Magic nnumber */
	unsigned short 	f_nscns;	/* Number of section headers */
	long		f_timdat;	/* Time in seconds */
	long		f_symptr;	/* Symbol table offset */
	long		f_nsyms;	/* items i symbol table */
	unsigned short	f_opthdr;	/* Size of optional header */
	unsigned short	f_flags; 	/* Flags */
} S_FILEHDR;

#define COP8MAGIC 0x162

#define F_RELFLG	1
#define F_EXEC 		2
#define F_LNNO 		4
#define F_AR32WR	0x400

/*
 * Optional (aout) header
 */

typedef struct {
	short		magic;		/* Magic number */
	short		vstamp;		/* stamp */
	long		rs1;
	long		rs2;
	long		rs3;
	long		rs4;
	long		rs5;
	long		entry;		/* Entry point */
	long		rs6;
	long		rs7;
	unsigned short	rs8;
	unsigned short	flags;		/* flags */
} S_AOUTHDR;

/*
 * Section header
 */
typedef struct {
	char		s_name[8];	/* Section name */
	long		s_paddr;	/* Physical address */
	long		s_rs1;	
	long		s_size; 	/* Section size (multiple of 4) */	
	long		s_lnnoptr;	/* File pointer to line nnumbers */
	unsigned short	s_rs2;
	unsigned short	s_nlnno;	/* number of line number enntries */
	long		s_flags;	/* flags */
	long		s_modsym;	/* Symbol table file pointter */
	unsigned short	s_rs3;
	short		s_pad;		/* padding */
} S_SCNHDR;

#define STYP_REG	0

/*
 * bankinfo section raw data
 */
typedef struct {
	short 		flags;		/* flags */
	short		rs1;
	char		chip[16];	/* Chip name */
	long		bankptr;	/* pointter to bank info */
	long		portinfo;	/* pointer to port values */
	long		modindex;	/* file pointer to module symbol indices */
	long		rs2;
} S_HPCHDR;

/*
 * Bank structure	
 */
typedef struct {
	long		bank_name; 	/* file pointer to bank name */
	long		bank_ranges;	/* file pointer to bank ranges */
	long		bank_sections;	/* file pointer to bank sections */
	long		lines;		/* Index into line number table */
	long		local_start;	/* Index of local symbol start */
	long		local_end;	/* Index of local symbol end */
	long		global_start;	/* Index of global symbol start */
	long		global_end;	/* Index of global symbol end */
	char		bank_addr;	/* Bank address from BANK command */
	char		subbank_numb;	/* subbank number */
} S_COFFBNK;

/*
 * Bank section
 */
typedef struct {
	long		sectname;	/* File pointer to sectio name */
	char		memorytype;	/* bits 0-2 */
} S_BSECTION;

/*
 * Module information
 * Doesn't seem to be accessed anywhere
 */
typedef struct {
	long		modulename;	/* file pointer to module name */
	unsigned short	mstart;		/* Startingn address */
	unsigned short	mend;		/* ending address */
	unsigned short	minfo;		/* flags */
} S_BMODULE;

#define	SBM_SYMBOLIC	1
#define SBM_ASSEMBLY	2
#define	SBM_MODNUM(x)	((x)<<2)

/*
 * Module Symbol Info
 */
typedef struct {
	long		global_start;	/* Index of first global sym */
	long		global_end;	/* Index of last glboal sym */
	long		shared_start;	/* Index of first shared sym */
	long		shared_end;	/* Index of last shared sym */
} S_MODSYM;

/*
 * Port info
 */
typedef struct {
	short		addr;		/* Port address */
	unsigned char	bits[8]; 	/* Port bit mappings */
	short		count;		/* Number of init entries */
	/* An array of S_BPORTINITs goes here */
} S_BPORT;

typedef struct {
	short		address;	/* Init address */
	short		value;		/* Value to write */
} S_BPORTINIT;

/*
 * Line number info 
 */
typedef long l_symndx;
typedef struct {
	long		l_paddr;	/* address of line nnumber */
	unsigned short	l_lnno;		/* line nnumber */
} S_LINENUM;

#define LINESZ	sizeof(S_LINENUM)

/*
 * Symbol table values
 */

#define SVALUE(x,y) ((x)+((y)<<16))
#define SNBVALUE(x) (x)

/*
 * Symbol table entries
 */
typedef struct {
	union {
		char	n_name[8];	/* Name */
		struct {
			long	n_zeros;	/* Or if these are zero */
			long	n_offset;	/* pointer to name */
		} ofs;
	} sname;
	long		value;		/* value */
	short		n_scnum;	/* section number */
	unsigned short	n_type;		/* type */
	char		n_class;	/* storage class */
	char		n_numaux;	/* number of aux entries */
	char		n_env;		/* interp environment */
	char		n_flags;	/* flags */
} S_SYMBOL;

#define SYM_VISIBLE 1
#define SYM_REALVISIBLE 2
#define SyM_HIDDEN 4

#define C_EFCN		-1
#define C_NULL		0
#define C_AUTO		1
#define C_EXT		2
#define C_STAT		3
#define C_REG		4
#define C_EXTDEF	5
#define C_LABEL		6
#define C_ULABLE	7
#define C_MOS		8
#define C_ARG		9
#define C_STRTAG	10
#define C_MOU		11
#define C_UNTAG		12
#define C_TPDEF		13
#define C_USTATIC	14
#define C_ENTAG		15
#define C_MOE		16
#define C_REGPARM	17
#define C_FIELD		18
#define C_ASM_LABEL	81
#define	C_EXT_ASM_LABEL 82
#define C_BLOCK		100
#define C_FCN		101
#define C_EOS		102
#define C_FILE		103
#define C_LINE		104
#define C_ALIAS		105
#define C_HIDDEN	106
#define C_BANK		107

#define N_DEBUG		-2
#define N_ABS		-1
#define N_UNDEF		0

#define T_NULL		0
#define T_CHAR		2
#define T_SHORT		3
#define T_INT		4
#define T_LONG		5
#define T_FLOAT		6
#define T_DOUBLE	7
#define T_STRUCT	8
#define T_UNION		9
#define T_ENUM		10
#define T_MOE		11
#define T_UCHAR		12
#define T_USHORT	13
#define T_UINT		14
#define T_ULONG		16

#define DT_NON		0
#define DT_PTR		1
#define DT_FCN		2
#define DT_ARY		3

/* 
 * AUX symbol table entries
 */
typedef struct {
	char		x_fname[14];	/* Filename */
	char		x_pad[2];
	long		x_foff;		/* String table offs */
} S_AUXFILE;

typedef struct {
	long		x_scnlen;	/* Section length */
	unsigned short	x_nreloc;	/* unused */
	unsigned short	x_lineno;	/* Number of line numbers */
	long		x_linoptr;	/* Poiter to line number entries */
	char		x_pad[8];
} S_AUXSECTION;

typedef struct {
	char		x_pad[6];
	unsigned short	x_size;		/* Size in bytes */
	long		x_pad2;
	long		x_endndx;	/* Link index */
	long		x_pad3;
} S_AUXTAG;

typedef struct {
	long		x_tagndx;	/* pointer to tag */
	short		x_pad;
	unsigned short 	x_size;		/* Size */
	char		x_pad2[12];
} S_AUXSTRUCT;

typedef struct {
	long		x_tagndx;	/* tag (return value if struct)*/
	long		x_fsize;	/* size of function */
	long		x_lnnoptr;	/* Pointer to line numbers */
	long		x_endndx;	/* Likn index */
	unsigned short	x_callseq;	/* Calling sequece */
	unsigned short	x_level;	/* Nest level */
} S_AUXFUNC;

typedef struct {
	long		x_tagndx;	/* Pointer to tag */
	unsinged short	x_lnno;		/* Line number */
	unsigned short	x_size;		/* Size of array */
	unsigned short	x_dimen[4];	/* Dimennsions */
	long		x_pad; 
} S_AUXARRAY;

typedef struct {
	long		x_pad;
	unsigned short	x_lnno;		/* Linne number */
	char		x_pad2[12];
	unsigned short	x_plude;	/* Size of prelude or postlude */
} S_AUXENDBLOCK;

typedef struct {
	long		x_pad;
	unsigned short	x_lineno;	/* Linne nnumber */
	char		x_pad2[6];
	long		x_endndx;	/* linnk index */
	long		x_pad3;
} S_AUXSTARTBLOCK;