#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <dos.h>
#include "cmdline.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "extern.h"
#include "linker.h"
#include "maps.h"
#include "lexpr.h"
#include "partit.h"
#include "local.h"
#include "types.h"
#include "lines.h"

extern unsigned maxtype;
extern TYPE *globaltypetable;
extern LIST *objlist;
extern BOOL prm_autodepends;
extern BOOL prm_debug;
extern int usedfloat;
extern LIST *sectionlist;
extern LIST *unresolvedexterns;
extern BOOL prm_relocatable;
extern HASHREC **publichash, **localhash;
extern LDESCRIPTION *partitions;
extern uint maus;
extern uint bitspermau;
extern char bigendchar;
extern unsigned long maxconfig;
extern FILENAME *linelist;
extern PUBLIC *entrypoint;

BYTE checksum = 0;
LIST *fixuplist = 0;
LIST **nextfixup = &fixuplist;

#define LINKASCII

#ifdef LINKASCII
static void putascii(FILE *out,char *format, ...)
{
	char buffer[256];
	int i,l;
	va_list ap;

	va_start(ap, format);
	vsprintf(buffer, format, ap);
	l = strlen(buffer);
	for (i=0; i < l; i++)
		if (buffer[i] > 31)
			checksum+=buffer[i];
	va_end(ap);
	fprintf(out,buffer);
}

#endif
static void putcs(FILE *out, BOOL toclear)
{
	if (toclear) {
#ifdef LINKASCII
		putascii(out,"CS.\r\n");
#endif /* LINKASCII */
	}
	else {
#ifdef LINKASCII
		checksum += 'C';
		checksum += 'S';
		putascii(out,"CS%02X.\r\n",checksum & 127);
#endif
	}
	checksum = 0;
}
static void link_header(FILE *out, char *name)
{
	struct date thedate;
	struct time thetime;
	char fpspec = 'I';
	LIST *p;
	FILENAME *f;
	getdate(&thedate);
	gettime(&thetime);
	if (usedfloat)
		fpspec = 'F';
#ifdef LINKASCII
	putascii(out,"MB%cLINKPHIDOS,%02X%s.\r\n", fpspec, strlen(name), name);
	if (maxconfig)
		putascii(out,"CO104,08%08lX.\r\n",maxconfig);
	putascii(out,"AD%x,%x,%c.\r\n",bitspermau,maus,bigendchar);
	putascii(out,"DT%04d%02d%02d%02d%02d%02d.\r\n", 
			thedate.da_year,thedate.da_mon,thedate.da_day,
			thetime.ti_hour, thetime.ti_min, thetime.ti_sec);
#endif
	
	p = objlist;
	if (prm_autodepends)
		while (p) {
#ifdef LINKASCII
			putascii(out,"CO102,%02X%s.\r\n",strlen(p->data),p->data);
#endif
			p = p->link;
		}
	f = linelist;
	if (prm_debug)
		while (f) {
#ifdef LINKASCII
			putascii(out,"CO105,%02X%s.\r\n",strlen(f->name),f->name);
#endif
			f = f->link;
		}
#ifdef LINKASCII
	putascii(out,"CO101,07ENDHEAD.\r\n");
#endif
	putcs(out, FALSE);
}

static void link_trailer(FILE *out)
{
#ifdef LINKASCII
	putascii(out,"ME.\r\n");
#endif /* LINKASCII */
}
static void putsyms(FILE *out)
{
  int i;
	LIST *q = unresolvedexterns;

	if (prm_relocatable || prm_debug) {
	  for (i=0; i < HASH_TABLE_SIZE; i++) {
    	PUBLIC *p;
    	if ( (p =publichash[i]) != 0) {
				while (p) {
#ifdef LINKASCII
					putascii(out,"NI%X,%02X%s.\r\n",p->id, strlen(p->name), p->name);
					if (p->sect)
						putascii(out,"ASI%X,R%X,%X,+.\r\n", p->id, p->sect->parent->section, p->offset + p->sect->base + p->sect->parent->absbase);
					else
						putascii(out,"ASI%X,%X.\r\n", p->id, p->offset);
					if (prm_debug)
						if (p->datatype & TY_TYPE)
							putascii(out,"ATI%X,T%lX.\r\n", p->id, p->datatype &~TY_TYPE);
						else
							putascii(out,"ATI%X,%lX.\r\n", p->id, p->datatype);
					
#endif /* LINKASCII */
					p = p->link;
				}
			}
		}
		if (prm_debug) {
		  for (i=0; i < HASH_TABLE_SIZE; i++) {
  	  	LOCAL *p;
    		if ( (p =localhash[i]) != 0) {
					while (p) {
#ifdef LINKASCII
						putascii(out,"NN%X,%02X%s.\r\n",p->id, strlen(p->name)-4, p->name+4);
						putascii(out,"ASN%X,R%X,%X,+.\r\n", p->id, p->sect->parent->section, p->offset + p->sect->base + p->sect->parent->absbase);
						if (p->datatype & TY_TYPE)
							putascii(out,"ATN%X,T%lX,%X.\r\n", p->id, p->datatype &~TY_TYPE, p->module);
						else
							putascii(out,"ATN%X,%lX,%X.\r\n", p->id, p->datatype, p->module);
#endif /* LINKASCII */
						p = p->link;
					}
				}
			}
		}
	}
	while (q) {
		EXTERN *r = q->data;
		putascii(out,"NX%X,%02X%s.\r\n",r->id, strlen(r->name), r->name);
		if (prm_debug)
			if (r->datatype & TY_TYPE)
				putascii(out,"ATX%X,T%lX.\r\n", r->id, r->datatype &~TY_TYPE);
			else
				if (r->datatype & TY_NAME)
					putascii(out,"ATX%X,I%lX.\r\n", r->id, r->datatype & ~TY_NAME);
				else
					putascii(out,"ATX%X,%lX.\r\n", r->id, r->datatype);
		q = q->link;
	}
	putcs(out, FALSE);
}
static void puttypes(FILE *out)
{
	int i,j;
	TYPE *p = globaltypetable;
	if (!prm_debug)
		return;
	while (p) {
		putascii(out,"TY%X,",p->index);
                for (j=0; j < p->count-1; j++)
			if (p->types[j] & TY_TYPE)
				putascii(out,"T%lX,",p->types[j] & ~TY_TYPE);
			else
				putascii(out,"%lX,",p->types[j]);
		if (p->types[j]  & TY_TYPE)
				putascii(out,"T%lX.\r\n",p->types[j] & ~TY_TYPE);
		else
			putascii(out,"%lX.\r\n",p->types[j]);
		p = p->link;
	}
}
			
static void putsections(FILE *file)
{
	if (!partitions) {
	  LIST *q = sectionlist;
		while (q) {
			char buffer[30];
			int i;
			SECTION *p = q->data;
			long size = 0;
			if (prm_relocatable || !(p->flags & SECTION_8051BITS)) {
				putattribs(buffer,p);
				size = p->abssize;
				if (!prm_relocatable && size < p->abssize)
					size = p->abssize;
#ifdef LINKASCII
				putascii(file,"ST%X,",p->parent->section);
				for (i=0; i < strlen(buffer); i++)
					putascii(file,"%c,",buffer[i]);
				putascii(file,"%02X%s.\r\n",strlen(p->name), p->name);
				putascii(file,"SA%X,%x.\r\n",p->parent->section,p->parent->align);
				putascii(file,"ASS%X,%lX.\r\n",p->parent->section, size);
				if (!prm_relocatable)
					putascii(file,"ASL%X,%lX.\r\n",p->parent->section, p->parent->absbase);
#endif /* LINKASCII */
			}
			q = q->link;
		}
	}
	else {
		LDESCRIPTION *p = partitions;
		int i = 0;
		while (p) {
			if (p->type == TY_PARTITION) {
				LDESCRIPTION *o = p->downlink;
				while (o) {
					if (o->type == TY_OVERLAY) {
						long size = o->size, address = o->address;
						int bit51flag = 0;
						if (o->address == 0) {
							LDESCRIPTION *r = o->downlink;
							while (r) {
								if (r->type == TY_REGION) {
									long oaddress = address;
									address += r->address;
									size -= r->address;
									bit51flag |= r->sectype;
									break;
								}
								r = r->sidelink;
							}
						}
						if (prm_relocatable || !(bit51flag & SECTION_8051BITS)) {
#ifdef LINKASCII
							putascii(file,"ST%X,A,C,N,",i);
							putascii(file,"%02X%s.\r\n",strlen(o->name), o->name);
							putascii(file,"ASS%X,%lX.\r\n",i, size);
							putascii(file,"ASL%X,%lX.\r\n",i, address);
#endif /* LINKASCII */
						}
						i++;
					}
					o = o->sidelink;
				}
			}
			p = p->sidelink;
		}
	}
	if (entrypoint)
#ifdef LINKASCII
		if (prm_relocatable)
			putascii(file,"ASG,R%X,%X.\r\n",entrypoint->sect->parent->section, entrypoint->offset + entrypoint->sect->base + entrypoint->sect->parent->absbase);
		else 
			putascii(file,"ASG,%X.\r\n", entrypoint->offset + entrypoint->sect->base + entrypoint->sect->parent->absbase);
#endif /* LINKASCII */
	putcs(file, FALSE);
}
static long blankout(FILE *file, long start, long end)
{
	if (start >= end)
		return(start);
	while (end - start >= LDPERLINE) {
		int i = 0;
#ifdef LINKASCII
		putascii(file,"LD");
#endif
		for (i=0; i < 30; i++) {
#ifdef LINKASCII
			putascii(file,"FF");
#endif /* LINKASCII */
		}
#ifdef LINKASCII
		putascii(file,".\r\n");
#endif /* LINKASCII */
		start+=LDPERLINE;
	}
	if (start == end)
		return(start);
#ifdef LINKASCII
	putascii(file,"LD");
#endif
	while (start < end) {
#ifdef LINKASCII
			putascii(file,"FF");
			start++;
#endif /* LINKASCII */
	}
#ifdef LINKASCII
	putascii(file,".\r\n");
#endif /* LINKASCII */
	return(start);
}
	
static long putld(FILE *file, long start, long end, EMSMEM *eb)
{
	long count = 0;
		int i;
  BYTE *buf = PtrToEMSMem(eb,start);
	if (start == end)
		return(start);
	while (end - start >= LDPERLINE) {
#ifdef LINKASCII
		putascii(file,"LD");
#endif
		for (i=0; i < LDPERLINE; i++) {
#ifdef LINKASCII
			putascii(file,"%02X",buf[count++]);
#endif /* LINKASCII */
		}
		start += LDPERLINE;
#ifdef LINKASCII
		putascii(file,".\r\n");
#endif /* LINKASCII */
		if (count > MAX_EMS_READWRITE) {
			buf = PtrToEMSMem(eb, start);
			count = 0;
		}
	}
	if (start == end)
		return(start);
#ifdef LINKASCII
	putascii(file,"LD");
#endif
	while (start < end) {
#ifdef LINKASCII
		putascii(file,"%02X",buf[count++]);
#endif /* LINKASCII */
		start++;
	}
#ifdef LINKASCII
	putascii(file,".\r\n");
#endif /* LINKASCII */
	return(start);
}
static char *sprintexpr(char *buf,EXPRESSION *e)
{
	char *p = buf;
	if (e->left)
		p = sprintexpr(p, e->left);
	if (e->right)
		p = sprintexpr(p, e->right);
	*p++ = ',';
	switch( e->type) {
		case EXP_NUMBER:
			sprintf(p,"%lX",e->value);
			break;
		case EXP_PLUS:
			sprintf(p,"+");
			break;
		case EXP_MINUS:
			sprintf(p,"-");
			break;
		case EXP_TIMES:
			sprintf(p,"*");
			break;
		case EXP_DIVIDE:
			sprintf(p,"/");
			break;
		case EXP_PC:
			sprintf(p,"P");
			break;
		case EXP_REL:
			sprintf(p,"R%lX", e->value);
			break;
		case EXP_EXTERN:
			sprintf(p,"X%lX", e->value);
			break;
		case EXP_LOWLIMIT:
			sprintf(p,"L%lX", e->value);
			break;
		case EXP_EXTERNSEG:
			/* Hack to get segment values for xeterns on x86 */
			sprintf(p,"Y%lX", e->value);
			break;
	}
	p = p + strlen(p);
	return(p);
}
static long putlr(FILE *file, FIXUPS *p)
{
#ifdef LINKASCII
	char buf[200];
	sprintexpr(buf,p->exp);
	putascii(file,"LR(%s,%X).\r\n", buf+1, p->size->value);

	return(p->size->value);
#endif /* LINKASCII */
}
static void putsection(FILE *file, SECTION *sect)
{
	long size = sect->abssize;
	long org = sect->absbase;
	LIST *l = sect->fixups;
	while (l) {
		FIXUPS *f = l->data;
		org = putld(file, org - sect->absbase, f->address-sect->absbase, sect->buffer) + sect->absbase;
		org += putlr(file, f);
		l = l->link;
	}
	putld(file, org - sect->absbase, size, sect->buffer);
	putcs(file,FALSE);
}
static void putdata(FILE *file)
{
	if (!partitions) {
  	LIST *q = sectionlist;
		while (q) {
			SECTION *p = q->data;
			putascii(file, "SB%X.\r\n",p->section);
			putsection(file,p);
			q = q->link;
		}
	}
	else {
		LDESCRIPTION *p = partitions;
		int i = 0;
		while (p) {
			if (p->type == TY_PARTITION) {
				LDESCRIPTION *o = p->downlink;
				while (o) {
					if (o->type == TY_OVERLAY) {
						LDESCRIPTION *r = o->downlink;
						long base = 0;
						putascii(file, "SB%X.\r\n",i++);
						while (r) {
							if (r->type == TY_REGION) {
								LIST *l = sectionlist;
								SECTION *found = 0;
								while (l) {
									SECTION *q = l->data;
									if (!strcmp(q->name,r->name)) {
										found = q;
										break;
									}
									l = l->link;
								}
								if (found) {
									if (base) {
										blankout(file,base, found->absbase);
										putcs(file, FALSE);
									}
									putsection(file,found);
									base = found->absbase + found->abssize;
								}
								else
									if (r->maxsize) {
										if (base)
											blankout(file,base,r->address);
										blankout(file, 0, r->maxsize);
										putcs(file, FALSE);
										base = r->address + r->size;
									}
							}
							r = r->sidelink;
						}
					}
					o = o->sidelink;
				}
			}
			p = p->sidelink;
		}
	}
}

void linkerout(FILE *file, char*name)
{
	link_header(file, name);
	putsections(file);
	putsyms(file);
	putascii(file,"CO100,03SEP.\r\n");
	puttypes(file);
	putdata(file);
	link_trailer(file);
}