/*
 * Assembler core
 *
 * Copyright (c) 1996 LADSOFT
 *
 * David Lindauer, camille@bluegrass.net
 *
 * Core for a retargetable assembler
 *
 * This program may be freely used and redistributed, as long as the 
 * copyright notice remains intact.  The author holds no liabilty;
 * all risks, both direct and consequential, are the responsibilty of
 * the user.  You use this program at your own risk!
 *
 */
/*
 * fpexpr.c
 *
 * floating point expression handling
 */
#include <stdio.h>                     
#include <memory.h>
#include <string.h>
#include "utype.h"
#include "umem.h"
#include "asm.h"
#include "expr.h"
#include "gencode.h"
#include "interp.h"
#include "expr.h"
#include "fpmath.h"
#include "fpexpr.h"

extern BOOL setequ;
extern BYTE setequval[12];
extern int sectionnum;
extern BOOL setequ;
extern HASHREC **hashtable;
extern BOOL ifskip;
extern HASHREC **hashtable;
extern int setequfloat;

unsigned makefpbits(int start, int end)
{
  unsigned rv=0;
  int i;
	if (start < 8 && end < 8) {
    unsigned mask = 0x80 >> start;
  	for (i=start;i<=end;i++) {
			rv |= mask;
			mask>>=1;
		}
	}
	else
		rv |= start | end;
	return(rv);
}
/* make a new expression for the result */
EXPRESSION *makefpexp(BYTE *value, int isdef, char *name, int isintermed, int fpspec)
{
  EXPRESSION *rv = AllocateMemory(sizeof(EXPRESSION));
	memcpy(rv->x.floatptr,value,12);
  rv->isdef = isdef;
  if (name) {
		rv->name = AllocateMemory(strlen(name)+1);
		strcpy(rv->name, name);
	}
	else
		rv->name = 0;
	rv->reg1 = rv->reg2 = 0;
	rv->loclablink = 0;
	rv->islabel = FALSE;
  rv->isintermed = isintermed;
	rv->size = 0;
	rv->isextern = 0;
	rv->defpass = 0;
  rv->isopcode = FALSE;
  rv->ismacro = FALSE;
  rv->isoperand = FALSE;
  rv->ismovemreg = FALSE;
  rv->ischangeable = FALSE;
	rv->isstruct = FALSE;
	rv->rel = FALSE;
	rv->ispublic = FALSE;
	rv->islocalpub = FALSE;
	rv->xrefcount = 0;
	rv->relpc = FALSE;
	rv->relmode = RM_NONE;
	rv->id = 0;
	rv->section = 0;
	rv->isfp = TRUE;
	rv->floatspec = fpspec;
	rv->swapper = 0xffff;
	rv->datatype = TEXTENDED;
	return(rv);
}
/* define one */
EXPRESSION *deffpexpr(BYTE *value, EXPRESSION *exp1, EXPRESSION *exp2, int fpspec)
{
	EXPRESSION *rv = exp1;
	
	if (exp2)  {
		rv = (makefpexp(value, exp1->isdef && exp1->isdef, 0, TRUE,fpspec));
		delexpr(exp1,exp2);
	}
	else {
		memcpy(exp1->x.floatptr,value,12);
	}
	return(rv);
}
/* negate */
EXPRESSION *negfpexp(EXPRESSION *exp1, EXPRESSION *exp2)
{
  EXPRESSION *rv;
	rv = makefpexp(exp1->x.floatptr, exp1->isdef,0, TRUE,exp1->floatspec);
	delexpr(exp1,0);
	rv->x.floatptr[0] ^= 0x80;
	return(rv);
}
/* EQU */
void equfpexp(EXPRESSION *label, EXPRESSION *exp)
{
	if (!ifskip) {
		if (label == 0) 
			labelexpected();
		else 
			if (!exp->isdef)
				badexpression();

			else {
				label->islabel = FALSE;
				memcpy(label->x.floatptr,exp->x.floatptr,12);
				memcpy(setequval,exp->x.floatptr,12);
				label->isintermed = FALSE;
				label->section = 0;
	    	label->isfp = TRUE;
				label->floatspec = exp->floatspec;
				setequfloat = setequ = TRUE;
			}
	}
	delexpr(exp,0);
	dolist();
}
			
/* set and = */
void setfpexp(EXPRESSION *label, EXPRESSION *exp)
{
	if (!ifskip) {
	  EXPRESSION *q;
		if (!exp->isdef)
			badexpression();
		else {
			label->ischangeable = TRUE;
			memcpy(label->x.floatptr,exp->x.floatptr,12);
			memcpy(setequval,exp->x.floatptr,12);
			label->isintermed = FALSE;
			label->section = 0;
	    label->isfp = TRUE;
			label->floatspec = exp->floatspec;
	 		q = AddHash(hashtable,label);
			if (q) {
				if (!q->ischangeable)
					Error("Symbol can't be redefined");
				else {
					memcpy(q->x.floatptr,exp->x.floatptr,12);
					q->isfp = TRUE;
				}
				label->isintermed = TRUE;
			}
			setequfloat = setequ = TRUE;
		}
	}
	else
		label->isintermed = TRUE;
	delexpr(exp, label);
	dolist();
}