/*
 * Assembler core
 *
 * Copyright (c) 1996 LADSOFT
 *
 * David Lindauer, camille@bluegrass.net
 *
 * Core for a retargetable assembler
 *
 * This program may be freely used and redistributed, as long as the 
 * copyright notice remains intact.  The author holds no liabilty;
 * all risks, both direct and consequential, are the responsibilty of
 * the user.  You use this program at your own risk!
 *
 */
/*
 * loclabe.c
 *
 * local label support
 */
#include <stdio.h>       
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include "cmdline.h"
#include "umem.h"
#include "asm.h"
#include "gencode.h"
#include "loclab.h"

extern int pass;
extern int sectionnum;
extern BOOL ifskip;

static EXPRESSION *lastlabel=0;

void loclabinit(void)
{
  lastlabel = 0;
}
/*
 * add a local label to a list of local labels 
 */
BOOL registerlocallabel(EXPRESSION *exp)
{
		

	if (exp->name[0] != '.') {
		lastlabel = exp;
		return(FALSE);
	}
	else {
		EXPRESSION *q = lastlabel;
		if (!lastlabel) {
			Error("Can't define local label here");
			delexpr(exp,0 );
		}
		else {
			if (pass == 1) {
				if (CheckLocalLabel(exp->name)) {
					Error("Can't redefine local label");
					delexpr(exp,0 );
				  return(FALSE);
				}
				exp->section = sectionnum;
				while (q->loclablink)
					q = q->loclablink;
				exp->isintermed = FALSE;
				q->loclablink = exp;
			}
		}
	}
	return(TRUE);
}
/* See if
 * a label is on the local list
 */
EXPRESSION **CheckLocalLabel(char *string)
{
	EXPRESSION **rv = &lastlabel->loclablink;
  if (lastlabel) {
		while (*rv) {
			if (!strcmp((*rv)->name, string))
				return rv;
			rv = &((*rv)->loclablink);
		}
	}
	return(0);
}
/*
 * delete all labels off the local list
 */
void DeleteLocalLabels(EXPRESSION *exp)
{
  EXPRESSION *q = exp->loclablink;
	while (q) {
		EXPRESSION *r = q->loclablink;
		DeallocateMemory(q->name);
		DeallocateMemory(q);
		q = r;
	}
	lastlabel = 0;
}