/*
 * Assembler core
 *
 * Copyright (c) 1996 LADSOFT
 *
 * David Lindauer, camille@bluegrass.net
 *
 * Core for a retargetable assembler
 *
 * This program may be freely used and redistributed, as long as the 
 * copyright notice remains intact.  The author holds no liabilty;
 * all risks, both direct and consequential, are the responsibilty of
 * the user.  You use this program at your own risk!
 *
 */
/*
 * output.c
 *
 * binary dump.  Fixups ignored...
 */
#include <stdio.h>
#include "utype.h"
#include "umem.h"
#include "asm.h"
#include "output.h"
#include "sections.h"
#include "gencode.h"

extern long org;
extern BYTE *outputbuf;
extern int sectionnum;

/* Dump the MAIN section */
void do_output(FILE *outfile)
{
	SECTIONREC *p = getsection(1);
	if (getsection(2))
		fprintf(stderr, "named sections detected, only MAIN will be output\n");
	setorg(p->org);
	if (p->fixuplist) {
		fprintf(stderr,"fixups detected in section MAIN\n");
	}
	outputbuf = p->buffer;
	sectionnum = 1;
	fwrite(outputbuf,(unsigned) p->highest,	1, outfile);

	printf("0x%lx bytes written to output file\n", p->highest);
}					