/*This header file must be included for any "C" program that uses any of the 
DBASE "C" functions.*/

#define MAXFIELD        30      /*maximum fields per record*/
#define MAXRECLEN       512     /*maximum record length in bytes*/
#define MEMOMAX         2048    /*maximum memo field allowed to be read*/

/*DBASE header structure*/
struct dbhead
        {
        char    db;             /*file flag*/
        char    year;
        char    month;
        char    day;
        long    quan;           /*number of records in file*/
        int     idunno;         /*don't quite know what this is*/
        int     reclgth;        /*number of bytes in record*/
        char    misc[20];       /*other stuff*/
        };

/*DBASE field structure*/
struct dbfield
        {
        char name[11];          /*field name*/
        char type;              /*field type*/
        char guess[4];          /*your guess is as good as mine*/
        char length;             /*field length*/
        char decimal;           /*decimal positions if numeric*/
        char other[13];         /*other stuff??*/
        };

struct ndxhead                  /*index file header information*/
        {
        char dunno[18];         /*don't know what this is yet*/
        int  xrecsize;          /*index file record size*/
        char guess[4];          /*don't know what this is yet*/
        char ndxflds[100];      /*fields indexed by the .NDX file*/
        };

struct ndx                              /*index file informaton structure*/
        {
        char name[35];                  /*.NDX filename*/
        int filenum;                    /*DOS file handle number*/
        int fldnum;                    /*number of fields indexed in this file*/
        int xrecsize;                   /*# of bytes of each index file record*/
        char fields[MAXFIELD/3][11];    /*field names*/
        };

struct dbinfo
        {
        int     error;       /*non-zero indicates error code & empty structure*/
        char    filname[35];            /*file name*/
        int     filenum;                /*.DBF file number for program use*/
        int     ndxnum;                 /*number of index files with this .DBF*/
        struct  ndx     ndxfile[10]; /*index file information - up to 10 files*/
        int     dbtnum;                 /*.DBT file number for program use*/
        struct  dbhead info;            /*file header information*/
        int     fieldnum;               /*number of fields per record*/
        struct  dbfield field[MAXFIELD];         /*field pointer*/
        };

struct  cmemvar       /*character memory variable structure- 'cmem' is global*/
        {
        char    name[11];               /*memory variable name*/
        char    c30f[2];                /*these 2 want to be 0xC3 & 0x0F*/
                /*true only for the first record of a .MEM file*/
        char    null;                   /*null byte--00*/
        char    d84d[2];                /*these 2 wants to be 0xD8 & 0x4D*/
        char    size;                   /*size of character string*/
        char    nulls[15];              /*15 null bytes*/
        };

