/* -*- Mode: C -*- */
/* CardRecord.h - A record as a card
 * Created by Robert Heller on Fri Dec  6 20:20:08 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#ifndef _CRECORD_
#define _CRECORD_
#include <common.h>
#include <Card.h>

// This class maps between the card on disk (as a record) and the card
// in memory (as a Card structure).
// RawData is the disk record.  Card is the structure representation
class CardRecord {
	Record RawData;
	Card* card;
	Card* RecordToCard() const;	// parse a card record into a Card*
	void CreateRecord(const Card* card);	// convert a Card* to a record
	void UpdateRecord();	// convert a Card* to a record
public:
	// Constructors/type converters
	      CardRecord(const Record* record);	// Record to CardRecord
	      CardRecord(const CoreItem* coreitem);	// CoreItem to CardRecord
	      CardRecord(const Card* card);		// Card to CardRecord
	      CardRecord(const CardRecord& cardrecord); // CardRecord to CardRecord
	     ~CardRecord(); 			// get rid of a CardRecord
	// pointer magic - make a CardRecord look just like a Card*
	const Card* operator -> () const {return card;}
	const Card& operator *  () const {return *card;}
	const Card* operator &  () const {return card;}
	void  SetType(const CardType t) {card->type = t;UpdateRecord();}
	void  SetAuthor(const char* a)
		{
			card->author = (char*) a;
			UpdateRecord();
		}
	void  SetTitle(const char* a)
		{
			card->title = (char*) a;
			UpdateRecord();
		}
	void  SetPublisher(const char* a)
		{
			card->publisher = (char*) a;
			UpdateRecord();
		}
	void  SetCity(const char* a)
		{
			card->city = (char*) a;
			UpdateRecord();
		}
	void  SetDescription(const char* a)
		{
			card->description = (char*) a;
			UpdateRecord();
		}
	void  SetVol(const int v) {card->vol = v;UpdateRecord();}
	void  SetYear(const int y) {card->year = y;UpdateRecord();}
	// copier function
	CardRecord& operator = (const CardRecord& cardrecord);
	// Convert a CardRecord to a plain Record
	operator const Record  () const
		{
			return RawData;
		}
};

#endif


