program pinmoney;

  {This program permits the user to store several PINs or passwords
  in a single place so that they can be easily found.}

uses crt,printer,dos;
const
 version  = '1.00';
 strnum    = '0..9';
 stringnum = '0123456789';
 strlet    = 'A..Z';
 stringlet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
 strlow    = 'a..z';
 stringlow = 'abcdefghijklmnopqrstuvwxyz';
 strall    = 'a..z,A..Z';
 stringall = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
 strchr    = 'A..Z,0..9,+-.:;{}[]()*';
 stringchr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-.:;{}[]()*ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ';
 strunx    = 'a..z,A..Z,0..9,+-.:;{}[]()*';
 stringuna = 'abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz';
 stringunb = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-.:;{}[]()*0123456789+-.:;{}[]()*';
 strlab1   = 'pin   bank  faxcodhouse boxkeybuttonplug  pinboxdriverkey   save  lock1 faxkeyfoggy x-ray box   office';
 strlab2   = 'boxes check fax   car   sport keys  pinloklock2 pin   plate buttonkeyhollock  switchclock disk  box   ';
 vpos      = 4;
 hpos      = 3;
 vresp     = 15;

type
 string6 = string[6];

var
 found_file :searchrec;
 outfile    :text;
 yr,mo,da,dow:word;
 file_name,
 file_name_2,
 Code_Word,
 errorstring,
 stringunx,
 stringused,
 strshow,
 stringlabel,
 secretstuff:string;
 labelused  :string6;
 i,j,k,
 iok,jok,
 line_value :integer;
 filled     :array [1..26] of integer;
 savedata   :array [0..9,1..26] of char;
 savelabel  :array [0..9] of string[6];
 temp       :integer;
 overall_code,
 getme      :char;
 dot        :boolean;

procedure cleardata;
  var
  i,j   :integer;

  begin
  stringlabel :=strlab1+strlab2;
  stringunx := stringuna+stringunb;
  stringused := stringnum;
  k := random(length(stringlabel)-60);
  k := (k div 6)* 6+1;
  for i := 0 to 9 do
    begin
    for j := 1 to 26 do savedata[i,j] := stringused[random(length(stringused))+1];
    savelabel[i] := stringlabel[k]+stringlabel[k+1]+stringlabel[k+2]+stringlabel[k+3]+stringlabel[k+4]+stringlabel[k+5];
    k := k + 6;
    end;
  end;                                                        {----- cleardata}

procedure print_the_screen;
  begin
  getdate(yr,mo,da,dow);
  writeln(lst,'   ');
  writeln(lst,'.                                                                                .');
  writeln(lst,'   ');
  writeln(lst,'           A B C D E  F G H I J  K L M N O  P Q R S T  U V W X Y  Z  label');
  writeln(lst,'  ');
  for i := 0 to 9 do
   begin
   write(lst,'       ',i:1,'   ');
   for j := 1 to 26 do
     begin
     write(lst,savedata[i,j],' ');
     if j div 5 * 5 = j then write (lst,' ');
     end;
   writeln (lst,' ',savelabel[i]);
   end;
  writeln(lst,'   ');
  writeln(lst,'           A B C D E  F G H I J  K L M N O  P Q R S T  U V W X Y  Z  ',mo,'/',da,'/',yr-1900);
  writeln(lst,'   ');
  writeln(lst,'.                                                                                .');
  writeln(lst,'   ');
  end;                                                {------ print_the_screen}


procedure display_screen;

  begin
  gotoxy (hpos,vpos-2);
  writeln('     P I N M O N E Y  --  Keeps track of PINs      Version ',version);
  gotoxy(hpos,vpos);
  writeln('     A B C D E F G H I J K L M N O P Q R S T U V W X Y Z   label');
  for i := 0 to 9 do
   begin
   gotoxy(hpos,vpos+2+i);
   write(i:1);
   gotoxy(hpos+5,vpos+2+i);
   for j := 1 to 26 do write(savedata[i,j],' ');
   write ('  ',savelabel[i],'             ');
   end;
  writeln;
  gotoxy(hpos,vpos+13);
  writeln('     A B C D E F G H I J K L M N O P Q R S T U V W X Y Z   label');
  gotoxy(1,vpos+vresp);
  writeln ('                                                                 ');
  writeln ('Enter 0..9 to change a line     [ ]          L. P. Levine                ');
  writeln ('      S,s to save the data                   3942 N. Oakland Avenue      ');
  writeln ('      L,l to load new data                   Shorewood, WI 53211         ');
  writeln ('      P,p to print the form                  (414) 962-4719              ');
  writeln ('      X to exit.                             len@evax.milw.wisc.edu      ');
  gotoxy(33,vpos+vresp+1);
  write   ('[');
  repeat until keypressed;
  overall_code := readkey;
  end;                                                 {----- display_screen}


procedure get_code_word(var Code_Word:string);
 {get a string from the user.  String must be all letters, must be at least
   'n' characters long! and must have no repeats!.}
 var
  code  :string;
  i     :integer;
  alldone:boolean;

 begin
 clrscr;
 repeat     {until alldone = true}
  gotoxy (1,2);
  writeln ('           P I N M O N E Y  -  Keeps track of PIN numbers.');
  gotoxy (1,12);
  begin
  writeln ('           Enter a code word, all letters, no repeated letters.');
  writeln ('           The word should contain as many letters as are contained in ');
  writeln ('           the longest password or PIN you will be encoding.');
  writeln;
  writeln ('           Remember that word, it is stored nowhere in this program!');
  writeln;
  gotoxy(1,21);
  writeln ('           Examples: rosebud acegikmo baconstrip waxmonger');
  gotoxy(1,18);
  write   ('                                                  ');
  gotoxy(1,18);
  write   ('                   Codeword:  ');
  readln (code);
  alldone := true;
  for temp := 1 to 26 do filled[temp] := 0;
  for i := 1 to length(code) do
    begin
    if ((upcase(code[i]) < 'A') or (upcase(code[i]) > 'Z'))
          and (alldone = true) then
     begin
     alldone := false;
     writeln ('              The Character ',code[i],' is an invalid character   ');
     end; {if upcase...}
     filled[ord(upcase(code[i]))-64] := filled[ord(upcase(code[i]))-64] +1;
     if (filled[ord(upcase(code[i]))-64] > 1) and (alldone = true) then
       begin
       writeln('              The Character ',code[i],' is used more than once     ');
       alldone := false;
       end; {if filled...}
    end;
  end;
  if (length(code) < 4) and (alldone = true) then
    begin
    alldone := false;
     writeln ('              Use a longer codeword.                              ');
     end;   {length < 4 }
 until alldone = true;
 Code_Word := '';
 for i := 1 to length(code) do
   begin
   Code_Word := Code_Word + upcase(chr(ord(code[i])));
   end;
 clrscr;
 gotoxy(11,18);
 writeln('Your code word is "',Code_Word,'".  Remember it.');
 writeln;
 writeln ('                   press any key');
 overall_code := readkey;
 end;                                                     {----- get_code_word}

procedure getline(var line_number  :integer;
                  var stringused   :string;
                  var labelused    :string6;
                  var passcode     :string);

 begin
 val(overall_code,line_number,i);
 gotoxy(hpos+70,vpos+2+line_number); writeln ('<--');
 gotoxy(hpos+70,vpos+2+line_number); writeln ('<--');
 gotoxy(1,vpos+vresp);
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 gotoxy(1,vpos+vresp);
 write ('Enter Label (6 characters) '); readln(labelused);
 labelused := labelused + '       ';
 gotoxy(hpos+59,vpos+2+line_number); writeln (labelused);
 errorstring := '  ';
 repeat
 begin
 i:=9;
 while (i<1) or (i>6) do
   begin
   gotoxy(1,vpos+vresp);
   writeln ('                                                                         ');
   writeln ('                                                                         ');
   writeln ('                                                                         ');
   writeln ('                                                                         ');
   writeln ('                                                                         ');
   write   ('  ',errorstring,'                                                        ');
   gotoxy(1,vpos+vresp);
   writeln('Set 1: 0..9              Set 2: A..Z');
   writeln('Set 3: a..z              Set 4: a..z,A..Z');
   writeln('Set 5: A..Z,0..9,+-.:;{}[]()*');
   write  ('Set 6: a..z,A..Z,0..9,+-.:;{}[]()*   ');
   write  ('Which set?     '); getme := readkey;
   val(getme,i,j);
   end;
   case i of
      1:  begin
          stringused := stringnum;
          strshow    := strnum;
          end;
      2:  begin
          stringused := stringlet;
          strshow    := strlet;
          end;
      3:  begin
          stringused := stringlow;
          strshow    := strlow;
          end;
      4:  begin
          stringused := stringall;
          strshow    := strall;
          end;
      5:  begin
          stringused := stringchr;
          strshow    := strchr;
          end;
      6:  begin
          stringused := stringunx;
          strshow    := strunx;
          end;
      end;                             {case i of}
 gotoxy(1,vpos+vresp);
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 gotoxy(5,vpos+vresp+1);
 writeln('Characters:  ',strshow);
 gotoxy(5,vpos+vresp+3);
 write  ('Enter Passcode: '); readln(passcode);
 iok := 0;
 for i := 1 to length(passcode) do
   begin
   jok := 0;
   for j := 1 to length(stringused) do
   if passcode[i] = stringused[j] then jok := 1;
   iok := iok + jok;
   end;
 end;
 errorstring := 'Characters not in requested set, reenter please.';

 until iok = length(passcode)
 end;                                                           {----- getline}

procedure build_a_line;
begin
  getline(line_value,stringused, labelused, secretstuff);
  savelabel[line_value] := labelused;
  k := length(stringused);
  for j := 1 to 26 do
    begin
    savedata[line_value,j] := stringused[random(k)+1];
    end;
  for j := 1 to length(secretstuff) do
    begin
    savedata[line_value,ord(Code_Word[j])-64] := secretstuff[j]
    end;
end;                                                       {----- build_a_line}

procedure save_the_file;
  begin
 gotoxy(1,vpos+vresp);
 writeln ('                                                                         ');
 writeln ('   Save file to:         (enter name without extension.)                 ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 gotoxy(18,vpos+vresp+1);
 dot := false;
 readln(file_name);
 for i := 1 to length(file_name) do if file_name[i] = '.' then dot := true;
 if (not dot) then
   begin
   file_name_2 := file_name+'.pin';
   file_name := file_name+'.txt';
   end
   else
   begin
   file_name_2 := file_name;
   file_name := 'x.txt';
   end;
  assign(outfile,file_name_2);
  rewrite(outfile);
  for i := 0 to 9 do
   begin
   for j := 1 to 26 do write(outfile,savedata[i,j]);
   writeln(outfile,savelabel[i]);
   end;
  close (outfile);
  assign(outfile,file_name);
  rewrite(outfile);
  getdate(yr,mo,da,dow);
  writeln(outfile,'   A B C D E  F G H I J  K L M N O  P Q R S T  U V W X Y  Z  label');
  writeln(outfile,'   ');
  for i := 0 to 9 do
   begin
   write  (outfile,i,'  ');
   for j := 1 to 26 do
     begin
     write(outfile,savedata[i,j],' ');
     if j div 5 * 5 = j then write(outfile,' ');
     end;
   writeln(outfile,' ',savelabel[i]);
   end;
  writeln(outfile,'   ');
  writeln(outfile,'   A B C D E  F G H I J  K L M N O  P Q R S T  U V W X Y  Z  ',mo,'/',da,'/',yr-1900);
  close (outfile);
  end;                                                    {----- save_the_file}


procedure load_the_file;
  begin
 gotoxy(1,vpos+vresp-4);
 writeln ('                                                                        ');
 writeln ('         Files:                                                         ');
 writeln ('                                                                        ');
 writeln ('                                                                        ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 writeln ('                                                                         ');
 gotoxy(1,vpos+vresp);
 findfirst('*.pin',32,found_file);
 i := 25;
 j := vpos+vresp-3;
 while doserror <> 18 do
   begin
   gotoxy(i,j);
   write(found_file.name);
   i := i + 15;
   if i > 69 then
     begin
     writeln;
     i := 10;
     j := j + 1
     end;
   findnext(found_file);
   end;
 gotoxy(1,vpos+vresp+5);
 writeln ('   Load file from:         (enter file without extension)          ');
 gotoxy(20,vpos+vresp+5);
 dot := false;
 readln(file_name);
 for i := 1 to length(file_name) do if file_name[i] = '.' then dot := true;
 if (not dot) then file_name_2 := file_name+'.pin';
  assign(outfile,file_name_2);
  reset(outfile);
  for i := 0 to 9 do
   begin
   for j := 1 to 26 do read(outfile,savedata[i,j]);
   readln(outfile,savelabel[i]);
   end;
  close (outfile);
  clrscr;
  end;                                                    {----- load_the_file}


begin {main program procedure}
randomize;
get_code_word(Code_Word);
overall_code := ' ';
cleardata;
clrscr;
while overall_code <> 'X' do
begin
display_screen;
if (overall_code >= '0') and (overall_code <= '9') then
build_a_line;
if upcase(overall_code) = 'S' then
save_the_file;
if upcase(overall_code) = 'L' then
load_the_file;
if upcase(overall_code) = 'P' then
print_the_screen;
end;           {overall_code <> X}
clrscr;
end.

  { Search record used by FindFirst and FindNext
  SearchRec = record
                Fill: array[1..21] of Byte;
                Attr: Byte;
                Time: Longint;
                Size: Longint;
                Name: string[12];
              end;
  }
