/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   search.c: queries for REFERENCES database
   version 3.6
*/

#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <time.h>
#include "refs.h"
#include "search.h"
#include "str_fun.h"
#include "fl_ut.h"
#include "ix01_fun.h"
#include "sortbbf1.h"
#include "l_menu.h"
#include "sortbbf2.h"
#include "bbf_fun.h"
#include "abbruch.h"
#include "cfg_fun.h"
#include "keycodes.h"
#include "vtxt.h"

 extern config_set one_config_set;


#define SEARCHCMD_LEN    800

#define SCROLL2  wrtxt("\n");sc_gotoxy(1,one_config_set.sl-1)

#define SEARCH_C_T "SEARCH_C.T"

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 int c_insens;

 int max_oder;

   /*
      die maximale Anzahl ODER-Bedingungen, wenn 1,
      braucht bbt_datei_name nicht sortiert zu werden
   */
 extern char journal_pix_name[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 extern char desc_name[PFAD_LEN];
 extern char book_name[PFAD_LEN];
 extern char autorjl_name[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 extern char stichw_name[PFAD_LEN];
 extern char stichw_pix_name[PFAD_LEN];
 extern char archiv_datei_name[PFAD_LEN];
 extern char last_search_name[PFAD_LEN];
 
 char bbt_datei_name[PFAD_LEN];
 char bbt_in_datei_name[PFAD_LEN];
 char archiv_maske[160];
 char tmp_string[150];
 char search_cmd_name[150];

 char tmpix_name[PFAD_LEN];
 char newix_name[PFAD_LEN];


 char * in_zeile;
 char * ex_zeile;
 char * exex_zeile;
 char * exexex_zeile;
 char * indat_zeile;
 char * alloc_test_zeile;


 char zahl_ex[ZAHLSTRING_LEN +1];
 char zahl_exex[ZAHLSTRING_LEN +1];


 extern FILE * ix01file;

 extern FILE * fpjournal;
 extern FILE * fpbuch;
 extern FILE * fpdesc;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 extern FILE * fparchiv;
  static FILE * tmpix;
  static FILE * newix;
 extern FILE * fpquell;
 extern FILE * fpstichw;
  static FILE * fpsearchcmd;

 char import_name[150];

 extern journal_rec one_journal_rec;
 extern buch_rec one_buch_rec;
 extern quell_rec one_quell_rec;
 extern keylist_rec one_key_rec;
 extern refspix_rec ix01rec;
 extern quellpix_rec ix02rec;
 extern keylistpix_rec ix03rec;

 char fpjournalbuf[sizeof(one_journal_rec)];
 char fpbuchbuf[sizeof(one_buch_rec)];

 int search_main(char * datpath, char * exepfad);
 static void search_text_zeigen(const char * txt);
 static int get_bbt_filename(void);
 static int get_command(char * zeile);
 static int check_command(char * zeile);
 static void ix2bbt(const char * ix_name, const char * bbt_name);
 static void int2fn(int zahl, char * dateiname);
 static void steuerung(char * zeile);
 static void journal_search(const char * fieldlabel);
 static int jahreszahlok(char * suchstring, char * feldwert);
 static void buch_search(const char * fieldlabel);
 static void autorjl_search(const char * fieldlabel);
 static void autorbu_search(const char * fieldlabel);
 static void desc_search(const char * fieldlabel);
 static int search_cmd_schreiben(char * kommando);
 static int search_cmd_lesen_allein(char * kommando);
 static int bbt2ix(char * dateiname);


int search_main(char * datpath, char * exepfad)
{
     strcpy(search_cmd_name,exepfad);strcat(search_cmd_name,SEARCH_C_T);

     cls_line(SEARCH_HAUPTTITEL);

     strcpy(bbt_in_datei_name,"");

     if ((fpjournal=fopen(journal_name,"rb"))==NULL)
     {
        sprintf(fehlermeldung,"ERROR: Cannot read %s",journal_name);
        beenden(fehlermeldung,2);
     }

     if ((fpdesc=fopen(desc_name,"rb"))==NULL)
     {
        sprintf(fehlermeldung,"ERROR: Cannot read %s",desc_name);
        beenden(fehlermeldung,2);
     }

     if (setvbuf(fpjournal,fpjournalbuf,_IOFBF,sizeof(one_journal_rec))!=0)
     {
        sprintf(fehlermeldung,"ERROR: cannot allocate memory "
           "for fpjournalbuf");
        beenden(fehlermeldung,2);
     }

     if ((fpbuch=fopen(book_name,"rb"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",book_name);
         beenden(fehlermeldung,2);
     }
     if (setvbuf(fpbuch,fpbuchbuf,_IOFBF,sizeof(one_buch_rec))!=0)
     {
        sprintf(fehlermeldung,"ERROR: cannot allocate memory for "
           "fpbuchbuf");
        beenden(fehlermeldung,2);
     }

     if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
     {
        sprintf(fehlermeldung,"ERROR: Cannot read %s",autorjl_name);
        beenden(fehlermeldung,2);
     }
     if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",
            autorbu_name);
        beenden(fehlermeldung,2);
     }

     if  ((in_zeile = (char *) malloc((SEARCHCMD_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR in SearchR: cannot allocate memory for in_zeile\n");
        return 1;
     }
     if  ((ex_zeile = (char *) malloc((SEARCHCMD_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR in SearchR: cannot allocate memory for ex_zeile\n");
        return 1;
     }
     if  ((exex_zeile = (char *) malloc((SEARCHCMD_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR in SearchR: cannot allocate memory for exex_zeile\n");
        return 1;
     }
     if  ((exexex_zeile = (char *) malloc((SEARCHCMD_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR in SearchR: cannot allocate memory for exexex_zeile\n");
        return 1;
     }
     if  ((indat_zeile = (char *) malloc((SEARCHCMD_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("ERROR in SearchR: cannot allocate memory for indat_zeile\n");
        return 1;
     }

     if (get_bbt_filename())
     {
         static int menupos1, menupos2;
         search_cmd_lesen_allein(in_zeile);
         while (get_command(in_zeile))
         {
            int taste;
            cls_line(SEARCH_HAUPTTITEL);
            if (!check_command(in_zeile))
            {

               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            taste = lotus_menu_default(&menupos1,
                               "@Complete$Process search command on the complete database"
                               "@BBT-File$Select a BBT file which defines a subset of "
                                   "all records for searching" );
            if (taste==0) continue;
            if (taste==1) strcpy(bbt_in_datei_name,"");
            if (taste==2)
            {
               int option;
               static int datei_pos;
               option = datei_suchen_default("*.BBT",bbt_in_datei_name,&datei_pos);
               if (!option)
               {
                  strcpy(bbt_in_datei_name,"");
                  cls_line("");
                  sc_gotoxy(1,one_config_set.sl-1);
                  continue;
               }
            }
            if ((taste==2) && (filesize(bbt_in_datei_name) < sizeof(bbatchtable_rec)))
            {
                 sprintf(wrtxtbu,"\n%s is empty\n\n\n",bbt_in_datei_name);
                 wrtxt(wrtxtbu);
                 strcpy(bbt_in_datei_name,"");
                 sc_gotoxy(1,one_config_set.sl-1);
                 continue;
            }
            wrtxt("\n");
            sprintf(wrtxtbu,"SEARCH COMMAND: %s\n\n",in_zeile);
            wrtxt(wrtxtbu);
            taste = lotus_menu_default(&menupos2,
                               "Edit$Continue to edit the SEARCH-conditions@"
                               "Process$Process the search command case sensitive@"
                               "CaseInsensitive$Process the search command case insensitive@"
                               );
            if (taste==1) continue;
            if (taste==0)  break;
            if (taste==2 || taste == 3)
            {
               if (taste==3) c_insens = 1;
                  else c_insens = 0;
               sc_gotoxy(1,one_config_set.sl-1);
               max_oder = 0;
               wrtxt("Searching the database...\n");
               steuerung(in_zeile);
               continue;
            }
         }
         search_cmd_schreiben(in_zeile);

     }
     fclose(fpjournal);
     fclose(fpdesc);
     fclose(fpbuch);
     fclose(fpautorjl);
     fclose(fpautorbu);

     free(in_zeile);
     free(ex_zeile);
     free(exex_zeile);
     free(exexex_zeile);
     free(indat_zeile);
     cls_line("");
     return 0;
}

static void search_text_zeigen(const char * txt)
{
   int i, n_zeilen, taste;
   char zeile[SCREENLINE_LEN + 256];
   cls_line("");
   n_zeilen=countitem(txt,"\n");
   for (i=1;i<=n_zeilen;i++)
   {
      if ((i % (one_config_set.sl-3))==0)
      {
        wrtxt("\n");
        taste = lotus_menu(
           "NextPage$Show the next page of text@"
           "Cancel$Finish viewing the current text"
                          );
        if (taste==0 || taste==2)
        {
             break;
        }
        sc_gotoxy(1,one_config_set.sl-2);
      }
      extractitem(i,txt,"\n",zeile);
      sprintf(wrtxtbu,"%s\n",zeile);
      wrtxt(wrtxtbu);
   }
   if ((i % (one_config_set.sl-3))!=0) wrtxt("\n");

}

static int get_bbt_filename(void)
{
   static char eingabe[DOSDATEIVORNAME_LEN+1];
   int taste, option;
   do
   {
       if (strlen(eingabe)==0 || !isdosfilename(eingabe))
       {
          strcpy(eingabe,"ANSWER01");
       }
       info_zeile("Please edit the filename for the output batch-table, [Esc] to leave");
       strcpy(wrtxtbu,"Batch table........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe,
                   DOSDATEIVORNAME_LEN,
                   DOSDATEIVORNAME_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) return 0;
       if (isdosfilename(eingabe)==0)
       {
           taste=200;
           continue;
       }
       upper(eingabe);
   }
   while (taste!=ENTER_KEY);
   if (!strcmp(eingabe,"")) return 0;
   if (taste==ESC_KEY) return 0;
   strcpy(bbt_datei_name,eingabe);
   strcat(bbt_datei_name,".BBT");
   if (isfile(bbt_datei_name))
   {
      option = lotus_menu("Cancel$Quit the SEARCH procedure@"
                          "Overwrite$Overwrite the existent file");
      if (option<=1) return 0;
         else return 1;
   }
   return 1;
}

static int get_command(char * zeile)
{
   int taste;
   do
   {
       info_zeile("Enter SEARCH COMMAND, [Esc] to leave, [F1] for syntax, [F2] view text file");
       strcpy(wrtxtbu,"SEARCH conditions..");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   zeile,
                   80-strlen(wrtxtbu)-3,
                   SEARCHCMD_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl);sc_clreol();
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==F1_KEY)
       {
           search_text_zeigen(HILFESEARCH01);
           SCROLL2;
           continue;
       }
       if (taste==F2_KEY)
       {
           char textd_name[PFAD_LEN];
           static int dateinummer;
           strcpy(textd_name,"");
           if (!datei_suchen_default("*.TXT",textd_name,&dateinummer))
           {
                      wrtxt("\n[Please press any key]>");
                      tastelesen();
                      wrtxt("\n");
                      continue;
           }
           else
           {
                vtxt_main(textd_name);
           }

           continue;
       }
   }

   while (taste!=ENTER_KEY && taste!=ESC_KEY);
   if (taste==ESC_KEY) return 0;
   if (!strcmp(zeile,"")) return 0;
   else return 1;
}

static int check_command(char * zeile)
{
   char meldung[SEARCHCMD_LEN];
   int anzahl_und, anzahl_oder, anzahl_at;
   int i, j;
   anzahl_und = countitem(zeile,"&");

   for (i = 1;i<=anzahl_und;i++)
   {
      extractitem(i,zeile,"&",ex_zeile);
      anzahl_at = countitem(ex_zeile,"=");
      if (anzahl_at!=2)
      {
         sprintf(meldung,"%s [%i.'&-period']",WARNUNG01,i);
         wwrap(meldung,SCREENLINE_LEN);
         search_text_zeigen(meldung);
         SCROLL2;
         return 0;
      }
      extractitem(1,ex_zeile,"=",exex_zeile);
      trim(exex_zeile,' ');
      upper(exex_zeile);
      if ( strcmp(exex_zeile,"KEYW")
          && strcmp(exex_zeile,"AUTH")
          && strcmp(exex_zeile,"EDIT")
          && strcmp(exex_zeile,"TITA")
          && strcmp(exex_zeile,"TITB")
          && strcmp(exex_zeile,"DTYP")
          && strcmp(exex_zeile,"YEAR")
          && strcmp(exex_zeile,"JRNL")
          && strcmp(exex_zeile,"STAT")
          && strcmp(exex_zeile,"PUBL")
          && strcmp(exex_zeile,"PLAC")
          )
      {
         sprintf(meldung,"%s [%i.'&-period']",WARNUNG02,i);
         wwrap(meldung,SCREENLINE_LEN);
         search_text_zeigen(meldung);
         SCROLL2;
         return 0;
      }

      extractitem(2,ex_zeile,"=",exex_zeile);
      trim(exex_zeile,' ');
      if (!strlen(exex_zeile))
      {
         sprintf(meldung,"%s [%i.'&-period']",WARNUNG03,i);
         wwrap(meldung,SCREENLINE_LEN);
         search_text_zeigen(meldung);
         SCROLL2;
         return 0;
      }

      /* ein leeres oder-Kriterium abfangen... */
      anzahl_oder = countitem(exex_zeile,"|");
      for (j=1;j<=anzahl_oder;j++)
      {
          extractitem(j,exex_zeile,"|",exexex_zeile);
          trim(exexex_zeile,' ');
          if (!strlen(exexex_zeile))
          {
             sprintf(meldung,"%s [%i.'&-period', %i.'|-period']",WARNUNG04,i,j);
             wwrap(meldung,SCREENLINE_LEN);
             search_text_zeigen(meldung);
             SCROLL2;
             return 0;
          }
      }

      extractitem(1,ex_zeile,"=",exex_zeile);
      trim(exex_zeile,' ');
      upper(exex_zeile);
      if (!strcmp(exex_zeile,"DTYP"))
      {
          extractitem(2,ex_zeile,"=",exex_zeile);
          anzahl_oder=countitem(exex_zeile,"|");
          trim(exex_zeile,' ');
          for (j=1;j<=anzahl_oder;j++)
          {
              extractitem(j,exex_zeile,"|",exexex_zeile);
              trim(exexex_zeile,' ');
              upper(exexex_zeile);
              if (
                   strcmp(exexex_zeile,"J1") &&
                   strcmp(exexex_zeile,"B1") &&
                   strcmp(exexex_zeile,"B2")
                 )
              {
                  sprintf(meldung,"%s [%i.'&-period', %i.'|-period']",
                     WARNUNG02F,i,j);
                  wwrap(meldung,SCREENLINE_LEN);
                  search_text_zeigen(meldung);
                  SCROLL2;
                  return 0;
              }
          }
      }

      extractitem(1,ex_zeile,"=",exex_zeile);
      trim(exex_zeile,' ');
      upper(exex_zeile);

      if (!strcmp(exex_zeile,"YEAR"))
      {
          extractitem(2,ex_zeile,"=",exex_zeile);
          anzahl_oder=countitem(exex_zeile,"|");
          trim(exex_zeile,' ');
          for (j=1;j<=anzahl_oder;j++)
          {
              extractitem(j,exex_zeile,"|",exexex_zeile);
              trim(exexex_zeile,' ');
              if (strlen(exexex_zeile) >= ZAHLSTRING_LEN)
              {
                  sprintf(meldung,"%s [max %i characters allowed: %i.'&-period', %i.'|-period']",
                     WARNUNG02A,ZAHLSTRING_LEN,i,j);
                  wwrap(meldung,SCREENLINE_LEN);
                  search_text_zeigen(meldung);
                  SCROLL2;
                  return 0;
              }
              strcpy(zahl_ex,exexex_zeile);
              trim(zahl_ex,' ');
              if (countitem(zahl_ex,"-")==1)
              {
                 int ok;
                 long jahr;
                 string_in_long(zahl_ex,&jahr,&ok);
                 if (!ok)
                 {
                   sprintf(meldung,"%s [%i.'&-period', %i.'|-period']",
                      WARNUNG02B,i,j);
                   wwrap(meldung,SCREENLINE_LEN);
                   search_text_zeigen(meldung);
                   SCROLL2;
                   return 0;
                 }
              }

              if (countitem(zahl_ex,"-")==2)
              {
                 int ok;
                 long jahr1, jahr2;
                 extractitem(1,zahl_ex,"-",zahl_exex);
                 trim(zahl_exex,' ');
                 string_in_long(zahl_exex,&jahr1,&ok);
                 if (!ok)
                 {
                   sprintf(meldung,"%s [%i.'&-period', %i.'|-period']",
                      WARNUNG02C,i,j);
                   wwrap(meldung,SCREENLINE_LEN);
                   search_text_zeigen(meldung);
                   SCROLL2;
                   return 0;
                 }
                 extractitem(2,zahl_ex,"-",zahl_exex);
                 trim(zahl_exex,' ');
                 string_in_long(zahl_exex,&jahr2,&ok);
                 if (!ok)
                 {
                   sprintf(meldung,"%s [%i.'&-period', %i.'|-period']",
                      WARNUNG02D,i,j);
                   wwrap(meldung,SCREENLINE_LEN);
                   search_text_zeigen(meldung);
                   SCROLL2;
                   return 0;
                 }
                 if (jahr1 >= jahr2)
                 {
                   sprintf(meldung,"%s [%i.'&-period', %i.'|-period']",
                      WARNUNG02E,i,j);
                   wwrap(meldung,SCREENLINE_LEN);
                   search_text_zeigen(meldung);
                   SCROLL2;
                   return 0;
                 }
              }
          }
      }
   }
   return 1;
}


static void ix2bbt(const char * ix_name, const char * bbt_name)
{
    FILE * fpbbt;
    long anzahl_records, i,byte_zeiger;
    refspix_rec ix01rec;
    bbatchtable_rec one_bbt_rec;

    memset(&one_bbt_rec,0,sizeof(one_bbt_rec));

    if ((fpbbt= fopen(bbt_name,"wb"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: cannot create %s",bbt_name);
       beenden(fehlermeldung,2);
    }
    if ((newix = fopen(ix_name,"rb"))==NULL)
    {
       sprintf(fehlermeldung,"ERROR: cannot read %s",ix_name);
       beenden(fehlermeldung,2);
    }
    fseek(newix,0L,SEEK_END);
    byte_zeiger = ftell(newix);
    rewind(newix);
    anzahl_records = byte_zeiger/sizeof(ix01rec);
    anzahl_records--;
    for (i=0;i<=anzahl_records;i++)
    {
        if (fread(&ix01rec,sizeof(ix01rec),1,newix)==0)
        {
           sprintf(fehlermeldung,"ERROR: cannot read record in %s",ix_name);
           beenden(fehlermeldung,2);
        }
        strncpy(one_bbt_rec.kennziffer,ix01rec.kennziffer,KENNZIFFER_LEN);
        fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
    }

    fclose(newix);
    fclose(fpbbt);
}

static void int2fn(int zahl, char * dateiname)
{
   sprintf(dateiname,"%07i.ix$",zahl);
}


static void steuerung(char * zeile)
{
   int anzahl_und;
   time_t zeit1, zeit2;
   int i;
   char zkopie[SEARCHCMD_LEN+1];
   char pix1_name[150];

  /* Resultate auf 0 abfragen */
   time(&zeit1);
   anzahl_und = countitem(zeile,"&");
   int2fn(1,pix1_name);       /* Diese Datei aus BBT-Datei erzeugen */

   for (i=1;i<=anzahl_und;i++)
   {
     if (i==1)
     {
        if (strlen(bbt_in_datei_name) > 0)
        {
            if (bbt2ix(pix1_name))
            {
                strcpy(tmpix_name,pix1_name);
            }
            else
            {
               strcpy(bbt_in_datei_name,"");
               strcpy(tmpix_name,journal_pix_name);
            }
        }
        else
        {
          strcpy(tmpix_name,journal_pix_name);
        }
     }
     else
     {
        int2fn(i,tmpix_name);
     }
     int2fn(i+1,newix_name);
     if ((tmpix=fopen(tmpix_name,"rb"))==NULL)
     {
        sprintf(fehlermeldung,"ERROR: Cannot read %s",tmpix_name);
        beenden(fehlermeldung,2);
     }
     if (setvbuf(tmpix,NULL,_IOFBF,9000)!=0)
     {
        sprintf(fehlermeldung,"ERROR: cannot alloacate memory "
           "for tmpix-buffer");
        beenden(fehlermeldung,2);
     }

     if ((newix=fopen(newix_name,"wb"))==NULL)
     {
        sprintf(fehlermeldung,"ERROR: Cannot read %s",newix_name);
        beenden(fehlermeldung,2);
     }
     if (setvbuf(newix,NULL,_IOFBF,3000)!=0)
     {
        sprintf(fehlermeldung,"ERROR: cannot alloacate memory "
           "for newix-buffer");
        beenden(fehlermeldung,2);
     }
     /* Aufrufe */
     strcpy(zkopie,zeile);
     if (c_insens) upper(zkopie);
        /* den originalen Eingabestring nicht kapitalisieren! */

     extractitem(i,zkopie,"&",ex_zeile);
     extractitem(1,ex_zeile,"=",exex_zeile);
     trim(exex_zeile,' ');
     upper(exex_zeile);

     if (!strcmp(exex_zeile,"KEYW"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        desc_search("KEYW");
     }
     else if (!strcmp(exex_zeile,"TITA"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        journal_search("TITA");
     }
     else if (!strcmp(exex_zeile,"DTYP"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        journal_search("DTYP");
     }
     else if (!strcmp(exex_zeile,"YEAR"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        journal_search("YEAR");
     }
     else if (!strcmp(exex_zeile,"JRNL"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        journal_search("JRNL");
     }
     else if (!strcmp(exex_zeile,"STAT"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        journal_search("STAT");
     }
     else if (!strcmp(exex_zeile,"TITB"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        buch_search("TITB");
     }

     else if (!strcmp(exex_zeile,"PUBL"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        buch_search("PUBL");
     }
     else if (!strcmp(exex_zeile,"PLAC"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        buch_search("PLAC");
     }

     else if (!strcmp(exex_zeile,"AUTH"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        autorjl_search("AUTH");
     }

     else if (!strcmp(exex_zeile,"EDIT"))
     {
        extractitem(2,ex_zeile,"=",exex_zeile);
        trim(exex_zeile,' ');
        autorbu_search("EDIT");
     }

     /* Aufrufe Ende */
     fclose(tmpix);
     fclose(newix);
     if (i!=1)  /* Hauptindex nicht loeschen! */
     {
         remove(tmpix_name);
     }
     else
     {
         if (isfile(pix1_name)) remove (pix1_name);
     }
     if (filesize(newix_name)==0)
     {
        time(&zeit2);
        sprintf(wrtxtbu,"The result table is empty (%.0f sec required).\n\n\n",
              difftime(zeit2,zeit1));
        wrtxt(wrtxtbu);
        remove(newix_name);
        sc_gotoxy(1,one_config_set.sl-1);
        return;
     }
   }
   if (filesize(newix_name)>=sizeof(refspix_rec))
   {
       long rec_zeiger, byte_zeiger;

       ix2bbt(newix_name,"$1.bbt");
       remove(newix_name);
       if (max_oder > 1)
       {
          domergebbf1("$1.bbt","$2.bbt");
          wrtxt("\n");
          remove("$1.bbt");
          wrtxt("Removing duplicate records...");
          dupl_ex_bbf("$2.bbt",bbt_datei_name);
          remove("$2.bbt");
          wrtxt(" done.\n");
       }
       else
       {
          if (isfile(bbt_datei_name))
              remove(bbt_datei_name);
          rename("$1.bbt",bbt_datei_name);
       }
       byte_zeiger=filesize(bbt_datei_name);
       rec_zeiger=byte_zeiger/sizeof(bbatchtable_rec);
       time(&zeit2);
       sprintf(wrtxtbu,"%li references found (%.0f sec required) and saved in '%s',\n"
                       "View '%s' with commands 'EditView' 'BatchTableBrowse'\n"
                       "or select 'EditView' 'SearchBrowse'"
                       "\n\n\n",
           rec_zeiger,difftime(zeit2,zeit1),bbt_datei_name,bbt_datei_name);
       wrtxt(wrtxtbu);
       strcpy(last_search_name,bbt_datei_name);
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
   }
}


static void journal_search(const char * fieldlabel)
{
  /* Es wird in exex_zeile gesucht */
  int j, anzahl_oder;
  long byte_zeiger, rec_zeiger, anzahl_ixrecords, k;
  refspix_rec ix01rec;
  journal_rec one_journal_rec;
  char feld[MAXFELD_LEN + 1];

  fseek(tmpix,0L,SEEK_END);
  byte_zeiger=ftell(tmpix);
  anzahl_ixrecords = byte_zeiger / sizeof(ix01rec);
  anzahl_ixrecords--;
  fseek(newix,0L,SEEK_END);

  anzahl_oder = countitem(exex_zeile,"|");
  if (max_oder < anzahl_oder) max_oder = anzahl_oder;
  for (j=1;j<=anzahl_oder;j++)
  {
     rewind(tmpix);
     extractitem(j,exex_zeile,"|",exexex_zeile);
     trim(exexex_zeile,' ');
     for (k=0;k<=anzahl_ixrecords;k++)
     {
        fread(&ix01rec,sizeof(ix01rec),1,tmpix);
        rec_zeiger = ix01rec.journal_rptr;
        byte_zeiger = rec_zeiger * sizeof(one_journal_rec);
        fseek(fpjournal,byte_zeiger,SEEK_SET);
        fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

        if (!strcmp(fieldlabel,"TITA"))
        {
           strcpy(feld,one_journal_rec.titel);
           if (c_insens) upper(feld);
           if (is_substring(exexex_zeile,feld))
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
           }
        }
        if (!strcmp(fieldlabel,"DTYP"))
        {
           strcpy(feld,one_journal_rec.reftyp);
           if (c_insens) upper(feld); ///
           if (is_substring(exexex_zeile,feld))
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
           }
        }
        if (!strcmp(fieldlabel,"YEAR"))
        {
           strcpy(feld,one_journal_rec.jahrgang);
           if (jahreszahlok(exexex_zeile,feld))   /* Vorsicht bei Kopieren !*/
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
           }
        }
        if (!strcmp(fieldlabel,"JRNL"))
        {
           strcpy(feld,one_journal_rec.kuerzel);
           if (c_insens) upper(feld);
           if (strcmp(exexex_zeile,feld)==0)
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
           }
        }
        if (!strcmp(fieldlabel,"STAT"))
        {
           strcpy(feld,one_journal_rec.status);
           if (c_insens) upper(feld);
           if (is_substring(exexex_zeile,feld))
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
           }
        }

     }
  }
}

static int jahreszahlok(char * suchstring, char * feldwert)
{
    long jahrfeld;
    int okfeld;

    trim(feldwert,' ');
    string_in_long(feldwert,&jahrfeld,&okfeld);
    if (!okfeld) return 0;

    trim(suchstring,' ');
    strncpy(zahl_ex,suchstring,ZAHLSTRING_LEN);
    trim(zahl_ex,' ');
    if (countitem(zahl_ex,"-")==1)
    {
       int ok;
       long jahr1;
       string_in_long(zahl_ex,&jahr1,&ok);
       if (!ok) return 0;
       if (jahr1==jahrfeld) return 1;
    }
    if (countitem(zahl_ex,"-")==2)
    {
       int ok;
       long jahr1, jahr2;
       extractitem(1,zahl_ex,"-",zahl_exex);
       trim(zahl_exex,' ');
       string_in_long(zahl_exex,&jahr1,&ok);
       if (!ok) return 0;
       extractitem(2,zahl_ex,"-",zahl_exex);
       trim(zahl_exex,' ');
       string_in_long(zahl_exex,&jahr2,&ok);
       if (!ok) return 0;
       if ((jahrfeld >= jahr1) && (jahrfeld <= jahr2)) return 1;
    }
    return 0;
}

static void buch_search(const char * fieldlabel)
{
  /* Es wird in exex_zeile gesucht */
  int j, anzahl_oder;
  long byte_zeiger, rec_zeiger, anzahl_ixrecords, k;
  refspix_rec ix01rec;
  buch_rec one_buch_rec;
  char feld[MAXFELD_LEN + 1];

  fseek(tmpix,0L,SEEK_END);
  byte_zeiger=ftell(tmpix);
  anzahl_ixrecords = byte_zeiger / sizeof(ix01rec);
  anzahl_ixrecords--;
  fseek(newix,0L,SEEK_END);

  anzahl_oder = countitem(exex_zeile,"|");
  if (max_oder < anzahl_oder) max_oder = anzahl_oder;
  for (j=1;j<=anzahl_oder;j++)
  {
     rewind(tmpix);
     extractitem(j,exex_zeile,"|",exexex_zeile);
     trim(exexex_zeile,' ');
     for (k=0;k<=anzahl_ixrecords;k++)
     {
        fread(&ix01rec,sizeof(ix01rec),1,tmpix);
        rec_zeiger = ix01rec.buch_rptr;
        if (ix01rec.buch_rptr < 0) continue;
        byte_zeiger = rec_zeiger * sizeof(one_buch_rec);
        fseek(fpbuch,byte_zeiger,SEEK_SET);
        fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
        if (!strcmp(fieldlabel,"TITB"))
        {
           strcpy(feld,one_buch_rec.titel_bu);
           if (c_insens) upper(feld);
           if (is_substring(exexex_zeile,feld))
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
           }
        }

        if (!strcmp(fieldlabel,"PUBL"))
        {
           strcpy(feld,one_buch_rec.verlag);
           if (c_insens) upper(feld);
           if (is_substring(exexex_zeile,feld))
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
           }
        }
        if (!strcmp(fieldlabel,"PLAC"))
        {
           strcpy(feld,one_buch_rec.publ_ort);
           if (c_insens) upper(feld);
           if (is_substring(exexex_zeile,feld))
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
           }
        }
     }
  }
}

static void autorjl_search(const char * fieldlabel)
{
  /* Es wird in exex_zeile gesucht */
  int j, anzahl_oder;
  long byte_zeiger, rec_zeiger, anzahl_ixrecords, k, l, n_aued;
  refspix_rec ix01rec;
  author_rec one_aued_rec;
  char feld[MAXFELD_LEN + 1];

  fseek(tmpix,0L,SEEK_END);
  byte_zeiger=ftell(tmpix);
  anzahl_ixrecords = byte_zeiger / sizeof(ix01rec);
  anzahl_ixrecords--;
  fseek(newix,0L,SEEK_END);

  anzahl_oder = countitem(exex_zeile,"|");
  if (max_oder < anzahl_oder) max_oder = anzahl_oder;
  for (j=1;j<=anzahl_oder;j++)
  {
     rewind(tmpix);
     extractitem(j,exex_zeile,"|",exexex_zeile);
     trim(exexex_zeile,' ');
     for (k=0;k<=anzahl_ixrecords;k++)
     {
        fread(&ix01rec,sizeof(ix01rec),1,tmpix);
        rec_zeiger = ix01rec.autorjl_rptr;
        if (ix01rec.autorjl_rptr < 0) continue;
        byte_zeiger = rec_zeiger * sizeof(one_aued_rec);
        fseek(fpautorjl,byte_zeiger,SEEK_SET);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
        if (!strcmp(fieldlabel,"AUTH"))
        {
           strcpy(feld,one_aued_rec.au_nachname);
           if (c_insens) upper(feld);
           if (is_substring(exexex_zeile,feld))
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
             continue;
           }
        }
        n_aued = one_aued_rec.au_n;
        if (n_aued==1) continue;
        for (l=2;l<=n_aued;l++)
        {

           fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
           if (!strcmp(fieldlabel,"AUTH"))
           {
              strcpy(feld,one_aued_rec.au_nachname);
              if (c_insens) upper(feld);
              if (is_substring(exexex_zeile,feld))
              {
                fwrite(&ix01rec,sizeof(ix01rec),1,newix);
                break;
              }
           }
        }
     }
  }
}


static void autorbu_search(const char * fieldlabel)
{
  /* Es wird in exex_zeile gesucht */
  int j, anzahl_oder;
  long byte_zeiger, rec_zeiger, anzahl_ixrecords, k, l, n_aued;
  refspix_rec ix01rec;
  author_rec one_aued_rec;
  char feld[MAXFELD_LEN + 1];

  fseek(tmpix,0L,SEEK_END);
  byte_zeiger=ftell(tmpix);
  anzahl_ixrecords = byte_zeiger / sizeof(ix01rec);
  anzahl_ixrecords--;
  fseek(newix,0L,SEEK_END);

  anzahl_oder = countitem(exex_zeile,"|");
  if (max_oder < anzahl_oder) max_oder = anzahl_oder;
  for (j=1;j<=anzahl_oder;j++)
  {
     rewind(tmpix);
     extractitem(j,exex_zeile,"|",exexex_zeile);
     trim(exexex_zeile,' ');
     for (k=0;k<=anzahl_ixrecords;k++)
     {
        fread(&ix01rec,sizeof(ix01rec),1,tmpix);
        rec_zeiger = ix01rec.autorbu_rptr;
        if (ix01rec.autorbu_rptr < 0) continue;
        byte_zeiger = rec_zeiger * sizeof(one_aued_rec);
        fseek(fpautorbu,byte_zeiger,SEEK_SET);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
        if (!strcmp(fieldlabel,"EDIT"))
        {
           strcpy(feld,one_aued_rec.au_nachname);
           if (c_insens) upper(feld);
           if (is_substring(exexex_zeile,feld))
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
             continue;
           }
        }
        n_aued = one_aued_rec.au_n;
        if (n_aued==1) continue;
        for (l=2;l<=n_aued;l++)
        {

           fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
           if (!strcmp(fieldlabel,"EDIT"))
           {
              strcpy(feld,one_aued_rec.au_nachname);
              if (c_insens) upper(feld);
              if (is_substring(exexex_zeile,feld))
              {
                fwrite(&ix01rec,sizeof(ix01rec),1,newix);
                break;
              }
           }
        }
     }
  }
}



static void desc_search(const char * fieldlabel)
{
  /* Es wird in exex_zeile gesucht */
  int j, anzahl_oder;
  long byte_zeiger, rec_zeiger, anzahl_ixrecords, k, l, n_desc;
  refspix_rec ix01rec;
  desc_rec dr;
  char feld[MAXFELD_LEN + 1];

  fseek(tmpix,0L,SEEK_END);
  byte_zeiger=ftell(tmpix);
  anzahl_ixrecords = byte_zeiger / sizeof(ix01rec);
  anzahl_ixrecords--;
  fseek(newix,0L,SEEK_END);

  anzahl_oder = countitem(exex_zeile,"|");
  if (max_oder < anzahl_oder) max_oder = anzahl_oder;
  for (j=1;j<=anzahl_oder;j++)
  {
     rewind(tmpix);
     extractitem(j,exex_zeile,"|",exexex_zeile);
     trim(exexex_zeile,' ');
     for (k=0;k<=anzahl_ixrecords;k++)
     {
        fread(&ix01rec,sizeof(ix01rec),1,tmpix);
        rec_zeiger = ix01rec.desc_rptr;
        if (ix01rec.desc_rptr < 0) continue;
        byte_zeiger = rec_zeiger * sizeof(dr);
        fseek(fpdesc,byte_zeiger,SEEK_SET);
        fread(&dr,sizeof(dr),1,fpdesc);
        if (!strcmp(fieldlabel,"KEYW"))
        {
           strcpy(feld,dr.keywordsfield);
           if (c_insens) upper(feld);
           if (is_substring(exexex_zeile,feld))
           {
             fwrite(&ix01rec,sizeof(ix01rec),1,newix);
             continue;
           }
        }
        n_desc = dr.desc_n;
        if (n_desc==1) continue;
        for (l=2;l<=n_desc;l++)
        {

           fread(&dr,sizeof(dr),1,fpdesc);
           if (!strcmp(fieldlabel,"KEYW"))
           {
              strcpy(feld,dr.keywordsfield);
              if (c_insens) upper(feld);
              if (is_substring(exexex_zeile,feld))
              {
                fwrite(&ix01rec,sizeof(ix01rec),1,newix);
                break;
              }
           }
        }
     }
  }

}


static int search_cmd_lesen_allein(char * kommando)
{
   char ch;
   int i;
   i = 0;
   if ((fpsearchcmd=fopen(search_cmd_name,"r"))==NULL)
   {
      strcpy(kommando,"");
      return 0;
   }
   else
   {
      strcpy(kommando,"");
      do
      {
         ch = fgetc(fpsearchcmd);
         if (ch!=EOF && ch!='\n')
            kommando[i] = ch;
         else kommando[i] = '\0';
         i++;
      } while (ch!=EOF && ch!= '\n' && i < SEARCHCMD_LEN);
      kommando[SEARCHCMD_LEN]= '\0';
      fclose(fpsearchcmd);
   }
   if (strlen(kommando) > 0)
     return 1;
   else
     return 0;
}



static int search_cmd_schreiben(char * kommando)
{
   if ((fpsearchcmd=fopen(search_cmd_name,"w"))==NULL)
   {
      sprintf(wrtxtbu,"[Unexpected ERROR: unable to write into %s]>",
              search_cmd_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return 0;
   }
   fprintf(fpsearchcmd,"%s",kommando);
   fclose(fpsearchcmd);
   return 1;
}

static int bbt2ix(char * dateiname)
{
   FILE * fpbbt;     /* die zu lesende BBT-Datei */
   FILE * fppix1;    /* die neu zu schreibende Datei */

   long anzahl_records, i, byte_zeiger, ix_zeiger;
   refspix_rec ix01rec;
   bbatchtable_rec one_bbt_rec;

   if (!read_ix01(journal_pix_name))
   {
     sprintf(fehlermeldung,"ERROR: cannot read %s",journal_pix_name);
     beenden(fehlermeldung,2);
   }
   if ((fpbbt = fopen(bbt_in_datei_name,"rb"))==NULL)
   {
     sprintf(fehlermeldung,"ERROR: cannot read %s",bbt_in_datei_name);
     beenden(fehlermeldung,2);
   }
   if ((fppix1 = fopen(dateiname,"wb"))==NULL)
   {
     sprintf(fehlermeldung,"ERROR: cannot create/write into %s",
          dateiname);
     beenden(fehlermeldung,2);
   }
   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   rewind(fpbbt);
   anzahl_records = byte_zeiger / sizeof(one_bbt_rec);
   anzahl_records--;

   sprintf(wrtxtbu,"\nExtracting %li records from %s...",
       anzahl_records +1, bbt_in_datei_name);
   wrtxt(wrtxtbu);

   for (i=0;i<=anzahl_records;i++)
   {
      fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
      ix_zeiger = locate_ix01(one_bbt_rec.kennziffer,&ix01rec);
      if (ix_zeiger > -1)
      {
          fwrite(&ix01rec,sizeof(ix01rec),1,fppix1);
      }
   }
   close_ix01();
   fclose(fpbbt);
   fclose(fppix1);
   if (filesize(dateiname) < sizeof(ix01rec))
   {
      remove(dateiname);
      wrtxt("\n0 record extracted, therefore SEARCH in complete "
                "database...\n");
      return 0;
   }
   else
   {
      wrtxt("\n");
      return 1;
   }
}
