/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
#ifndef SEARCH_H
#define SEARCH_H

#define ZAHLSTRING_LEN 100

#define SEARCH_HAUPTTITEL "REFERENCES VERSION 3.6 * SEARCH FUNCTIONS"


#define WARNUNG01 "ERROR: Each '&'-period should contain two items separated\
 by the '='-sign. A field-label is expected as the first, and one or more\
 strings seperated by a '|' (logical OR) as the second."

#define WARNUNG02 "ERROR: The '=' sign must be preceded by a field label:\
 KEYW (keywords) or AUTH (authors of an article) or EDIT (editors of a book)\
 or TITA (title of an article) or TITB (title of a book) or DTYP (document\
 type: j1: article in a journal, b1: book, b2: chapter in a book) or YEAR\
 (year of publication) or STAT (status field) or PUBL (publisher of a book)\
 or PLACE (place of publication) or JRNL name of the journal\
 (four-letter-code)."

#define WARNUNG02A "ERROR: One of the YEAR-criteria seperated by '|' is\
 too long."



#define WARNUNG02B "ERROR: One of the YEAR-criteria cannot be converted into a\
 number."

#define WARNUNG02C "ERROR: One of the YEAR-criteria in the form '1991-1992'\
 cannot be processed: the first item cannot be converted into a number."

#define WARNUNG02D "ERROR: One of the YEAR-criteria in the form '1991-1992'\
 cannot be processed: the second item cannot be converted into a number."


#define WARNUNG02E "ERROR: One of the YEAR-criteria in the form '1993-1992'\
 cannot be processed: the first number should be smaller than the second."

#define WARNUNG02F "ERROR: DTYP (document type) criteria may only be j1,\
 b1 or b2."

#define WARNUNG03 "ERROR: An empty list of criteria (following '=') cannot be\
 processed."

#define WARNUNG04 "ERROR: The list of SEARCH criteria contains an empty item"


char HILFESEARCH01[] = "HELP * Searching for references\n"
" \n"
"SEARCH COMMANDS have the syntax: \n"
"     \n"
"   FLBL = condition [| condition [|...]] [& FLBL = condition [|...]] [&...]\n"
"     \n"
"FLBL: field-label, localizing search to the appropriate database-field:\n"
"                                                                            \n"
"   AUTH    author of an article in a journal or a chapter in a book        \n"
"   EDIT    editor or author of a book                                      \n"
"   DTYP    document type, j1: journal article, b1: book, b2: book chapter  \n"
"   JRNL    journal name (four-letter-code)                                 \n"
"   KEYW    keyword(s)                                                      \n"
"   PLAC    place(s) of publication (town(s)) (of a book: b1 or b2)         \n"
"   PUBL    publisher [Fr: 'diteur', Ger: 'Verlag']                        \n"
"   TITA    title of an article in a journal or a book (j1 or b2)           \n"
"   TITB    title of a book (b1 or b2)                                      \n"
"   YEAR    year(s, range(s) of years) of publication                       \n"
"   STAT    status field for user-defined classification of documents       \n"
"                                                                            \n"
" - In SEARCH COMMANDS, '&' (logical AND) separates '&-periods' with the \n"
"   field label as the first token ('word'). The field label must always be\n"
"   followed by '=' and a list of conditions separated by '|' (logical OR). \n"
"  \n"
" - CONDITIONS are strings or substrings to be searched for in the field\n"
"   'FLBL'.\n"
" \n"
" - A SEARCH COMMAND may consist of several '&' periods with the same field \n"
"   label. 'Appending' of *.BBT files is equivalent to the logical OR. \n"
" \n"
" - When searching in the YEAR field, '1996', or '1960-1980', '1980 | 1988'\n"
"   or even '1989-1990 | 1992 | 1994-1996' are allowed.\n"
" \n"
" - When searching in the AUTH or EDIT fields, first names must not be \n"
"   entered as conditions.\n"
" \n"
" - In order to save time, the conditions which exclude the most records \n"
"   should be placed first. Results of the SEARCH COMMAND are saved as BBT\n"
"   files with all duplicate results eliminated. \n";
#endif
