/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   re_edit.c edit REFERENCES records
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <malloc.h>
#include <dos.h>
#include <signal.h>
#include "cfg_fun.h"
#include "re_edit.h"
#include "refs.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "sortix01.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "l_menu.h"
#include "src_fun.h"
#include "key_fun.h"
#include "str_refs.h"
#include "re_fun.h"
#include "rfnr_fun.h"
#include "abbruch.h"
#include "vtxt.h"
#include "keycodes.h"

 extern journal_rec one_journal_rec;
 extern desc_rec one_desc_rec;
 extern buch_rec one_buch_rec;
 extern quell_rec one_quell_rec;
 extern refspix_rec ix01rec;

 extern config_set one_config_set;

 extern char datpath[PFAD_LEN];
 extern char journal_pix_name[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 extern char desc_name[PFAD_LEN];
 extern char book_name[PFAD_LEN];
 extern char autorjl_name[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 extern char stichw_name[PFAD_LEN];
 extern char stichw_pix_name[PFAD_LEN];

 extern char kennziff_temp_name[PFAD_LEN];
 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 /* Diese Variablen 'lokal' machen */
 static char * au_zeile;
 static char * ed_zeile;
 static char * desc_zeile;
 static char * showrec;
 static char * ex_au_zeile;

 static FILE * ix01;
 extern FILE * ix01file;

 static char kennziffer_global[KENNZIFFER_LEN+1];

 int re_edit_main(void);
 static void re_edit_hmenu(void);
 static void start_j1(void);
 static void start_b1(void);
 static void start_b2(void);
 static int get_j1_rec(journal_rec * one_rec);
 static int get_b1_rec(journal_rec * jl_rec, buch_rec * bo_rec);
 static int get_b2_rec(journal_rec * j1_rec, buch_rec * bu_rec);
 static void journal_rec_schreiben(void);
 static void buch_rec_schreiben(void);
 static void auedstring_schreiben(
                           const char * au_zeile,
                           const char * au_datei_name,
                           long * aued_rptr
                          );
 static void descstring_schreiben(
                           const char * desc_zeile,
                           const char * desc_datei_name,
                           long * desc_rptr
                         );
 static void descstring_lesen(
                           char * desc_zeile,
                           char * desc_datei_name,
                           long desc_rptr
                      );
 static void auedstring_lesen(
                           char * au_zeile,
                           char * au_datei_name,
                           long aued_rptr
                       );

 int alte_posit;

#define TMP_REC_KEY "R_KEY.T"

#define TMP01_IXDOLLAR "TMP01.IX$"
#define TMP01_IX       "TMP01.IX"
#define DEST01_IX      "DEST01.IX"

#define DUMMY_KEYW "--dummy keyword--"

int re_edit_main(void)
{
     strcpy(datpath,"");
     strcpy(kennziff_temp_name,datpath);strcat(kennziff_temp_name,TMP_REC_KEY);

     dateien_identifizieren();

     if ((au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("\n['EnterEdit': Memory allocation error 001]>");
        tastelesen();
        return 1;
     }

     if  ((ed_zeile = (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("\n['EnterEdit': Memory allocation error 002]>");
        tastelesen();
        return 1;
     }


     if  ((showrec = (char *) malloc((SHOWREC_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("\n['EnterEdit': Memory allocation error 003]>");
        tastelesen();
        return 1;
     }

     if  ((ex_au_zeile = (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("\n['EnterEdit': Memory allocation error 004]>");
        tastelesen();
        return 1;
     }
     if  ((desc_zeile = (char *) malloc((DESC_ZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        wrtxt("\n['EnterEdit': Memory allocation error 005]>");
        tastelesen();
        return 1;
     }
     strcpy(au_zeile,"");
     strcpy(ed_zeile,"");
     strcpy(ex_au_zeile,"");
     strcpy(desc_zeile,"");

     strcpy(kennziffer_global,"");
     kennziffer_lesen_allein(kennziffer_global);
     re_edit_hmenu();

     free(au_zeile);
     free(ed_zeile);
     free(showrec);
     free(ex_au_zeile);
     free(desc_zeile);
     kennziffer_schreiben(kennziffer_global);
   return 0;
}

static void re_edit_hmenu(void)
{

   FILE * fpjournal;
   int taste;
   refspix_rec ix01_local;

   static char eingabe_zeile[KENNZIFFER_LEN+2];
   long rec_zeiger, byte_zeiger, ix_pos ;

   /*
   Routine, die nach Kennziffer fragt und dann klaert, ob DS vorhanden;
   dann zum richtigen Datentyp verzweigt, von hier aus Neu und editieren
   moeglich
   */

   do
   {
       strcpy(au_zeile,"");
       cls_line("");
       do
       {
          cls_line(TITEL_ENTER_EDIT);
          memset(&one_journal_rec,0,sizeof(journal_rec));
          memset(&ix01rec,0,sizeof(refspix_rec));
          ix01rec.journal_rptr=-1;
          ix01rec.buch_rptr=-1;
          ix01rec.autorjl_rptr=-1;
          ix01rec.autorbu_rptr=-1;
          ix01rec.desc_rptr=-1;

          info_zeile("Enter number of a new or an existing reference, [Esc] Quit data entry");
          strcpy(wrtxtbu,"Ref.-number........");
          wrtxt(wrtxtbu);
          strcpy(eingabe_zeile,kennziffer_global);
          taste = e_zle(
                      1+strlen(wrtxtbu),
                      one_config_set.sl-1,
                      eingabe_zeile,
                      KENNZIFFER_LEN,
                      KENNZIFFER_LEN,
                      0
                   );
          sc_gotoxy(1,one_config_set.sl-1);sc_clreol();

          if (taste==ESC_KEY) break;
          strcpy(kennziffer_global,eingabe_zeile);
       }
       while ((taste!=ENTER_KEY) || (strlen(eingabe_zeile)==0));
       if (taste==ESC_KEY)
       {
          cls_line("");
          break;
       }
       cls_line("");

       /* Hier Optionen einbauen */

       strcpy(one_journal_rec.kennziffer,eingabe_zeile);


       if (!isfile(journal_pix_name))
       {
             sprintf(fehlermeldung,"ERROR: Cannot read %s",journal_pix_name);
             beenden(fehlermeldung,1);
       }
       if (!isfile(journal_name))
       {
             sprintf(fehlermeldung,"ERROR: Cannot read %s",journal_name);
             beenden(fehlermeldung,1);
       }
       if (isfile(TMP01_IX))
       {
          if (scanseq_ix01(eingabe_zeile,&ix01_local,TMP01_IX) >= 0)
          {
            sprintf(wrtxtbu,"Record '%s' has just been created,\n"
                   "for editing please close and reopen the EnterEdit function \n\n",
                    eingabe_zeile);
            wrtxt(wrtxtbu);
            wrtxt("[Please press any key to continue]>");sc_clreol();
            tastelesen();
            taste = 1;
            continue;
          }
       }
       if (filesize(journal_pix_name) < sizeof(refspix_rec))
       {
          ix_pos = -1;
       }
       else
       {
         read_ix01(journal_pix_name);
         ix_pos=locate_ix01(eingabe_zeile,&ix01rec);
         close_ix01();
         /*
            An dieser Stelle wird der Datensatz in die globale Variable
            eingelesen
         */
       }
       if (ix_pos!=-1)
       {
           rec_zeiger = ix01rec.journal_rptr;
           if ((fpjournal=fopen(journal_name,"rb"))==NULL)
           {
              sprintf(fehlermeldung,"ERROR: Cannot open %s",journal_name);
              beenden(fehlermeldung,1);
           }
           byte_zeiger=rec_zeiger * sizeof(journal_rec);
           fseek(fpjournal,byte_zeiger,SEEK_SET);
           fread(&one_journal_rec,sizeof(journal_rec),1,fpjournal);
           fclose(fpjournal);

           /* Hier Verzweigung zu verschiedenen Reftypen einbauen  */
           if (strcmp(one_journal_rec.reftyp,"j1")==0)
           {
               auedstring_lesen(au_zeile,autorjl_name,ix01rec.autorjl_rptr);
               descstring_lesen(desc_zeile,desc_name,ix01rec.desc_rptr);
               start_j1();
           }
           else if (strcmp(one_journal_rec.reftyp,"b1")==0)
           {
               auedstring_lesen(ed_zeile,autorbu_name,ix01rec.autorbu_rptr);
               descstring_lesen(desc_zeile,desc_name,ix01rec.desc_rptr);
               start_b1();
           }

           else /* if (strcmp(one_journal_rec.reftyp,"b2")==0) */
           {
               auedstring_lesen(ed_zeile,autorbu_name,ix01rec.autorbu_rptr);
               auedstring_lesen(au_zeile,autorjl_name,ix01rec.autorjl_rptr);
               descstring_lesen(desc_zeile,desc_name,ix01rec.desc_rptr);
               start_b2();
           }
       }
       else
       {
           strncpy(ix01rec.kennziffer,eingabe_zeile,KENNZIFFER_LEN+1);
           ix01rec.journal_rptr=-1;
           ix01rec.buch_rptr=-1;
           ix01rec.autorjl_rptr=-1;
           ix01rec.autorbu_rptr=-1;
           ix01rec.desc_rptr=-1;
           cls_line(TITEL_ENTER_EDIT_SELECT);
           taste = lotus_menu(TYPMENUTEXT);

           if (taste==1)
           {
              auedstring_lesen(au_zeile,autorjl_name,ix01rec.autorjl_rptr);
              descstring_lesen(desc_zeile,desc_name,ix01rec.desc_rptr);
              start_j1();
           }
           else if (taste==2)
           {
               auedstring_lesen(ed_zeile,autorbu_name,ix01rec.autorbu_rptr);
               descstring_lesen(desc_zeile,desc_name,ix01rec.desc_rptr);
               start_b1();
           }
           else if (taste==3)
           {
               auedstring_lesen(ed_zeile,autorbu_name,ix01rec.autorbu_rptr);
               auedstring_lesen(au_zeile,autorjl_name,ix01rec.autorjl_rptr);
               descstring_lesen(desc_zeile,desc_name,ix01rec.desc_rptr);
               start_b2();
           }
       }
       cls_line(TITEL_ENTER_EDIT);
       taste = lotus_menu(QUITMENUTEXT);
   }  while(taste==1);
   if (isfile(TMP01_IX))
   {
      /* Hier das "mergen" der Indexdatei einfuegen */

      if (filesize(TMP01_IX) > sizeof(refspix_rec))
      {
         domerge01(TMP01_IX,TMP01_IXDOLLAR);
         remove(TMP01_IX);
         rename(TMP01_IXDOLLAR,TMP01_IX);
      }
      if (filesize(journal_pix_name)==0)
      {
         remove(journal_pix_name);
         rename(TMP01_IX,journal_pix_name);
         wrtxt("Main index file created...\n");
      }
      else if (ok_appix01(journal_pix_name,TMP01_IX))
      {
         appendix01(journal_pix_name,TMP01_IX);
         wrtxt("New keys appended to main index file...\n");
         remove(TMP01_IX);
      }
      else
      {
         mrgeix01(journal_pix_name,TMP01_IX,DEST01_IX);
         remove(journal_pix_name);remove(TMP01_IX);
         rename(DEST01_IX,journal_pix_name);
         wrtxt("\nMain index file merged...\n");
      }
      wrtxt("\n[Please press any key]>");
      tastelesen();
   }
}

static void start_j1(void)
{
   int wahl, option;
   long au_rptr, desc_rptr;
   strcpy(one_journal_rec.reftyp,"j1");
   alte_posit=1;
   cls_line(TITEL_EE_J1);
   do
   {
      static int mposition;
      wahl = lotus_menu_default(&mposition,EDMENUTEXT);
      if (wahl == 1)
      {
         one_journal_rec.in_use = 1;
         get_j1_rec(&one_journal_rec);
      }
      else if (wahl==2)
      {
         cls_line("");
         j1_rec_zeigen(au_zeile,desc_zeile,showrec,ex_au_zeile);
      }
      else if  (wahl==3)
      {
         option = lotus_menu("Cancel$Do not save the current record@"
                             "Ok$Insert new record into file/overwrite "
                             "the current record");
         if (option==1 || option==0) continue;
         alte_posit=1;
         if((auedstring_ok(au_zeile,ex_au_zeile)) &&
            (descstring_ok(desc_zeile,ex_au_zeile) > -1))
         {
                 au_rptr = ix01rec.autorjl_rptr;
                 desc_rptr = ix01rec.desc_rptr;
                 auedstring_schreiben
                                     (
                                      au_zeile,
                                      autorjl_name,
                                      &au_rptr
                                     );
                ix01rec.autorjl_rptr = au_rptr;
                descstring_schreiben (
                                      desc_zeile,
                                      desc_name,
                                      &desc_rptr
                                     );
                ix01rec.desc_rptr = desc_rptr;
                journal_rec_schreiben();
                /*
                journal_rec_schreiben() aktualisiert auch den Index
                */
         } else continue;
         cls_line("");
         return;
      }
      else if (wahl==4)
      {
          text_zeigen(RE_ED_HILFE01);
      }
      else if (wahl==5)
      {
         char dn[PFAD_LEN];
         static int dpos;
         cls_line("");
         if (datei_suchen_default("*.TXT",dn,&dpos))
         {
           vtxt_main(dn);
         }
         else
         {
           wrtxt("\n[Please press any key]>");
           tastelesen();
           wrtxt("\n");
         }
         sc_gotoxy(1,one_config_set.sl-1);
      }
      if ((wahl==6) || (wahl==0))
      {
         int abbrtaste;
         abbrtaste = lotus_menu(QUITDATAENTRYMENUTEXT);
         if (abbrtaste==1)
         {
            wahl=1;
            continue;
         }
      }
   } while ((wahl!=6) && (wahl!=0));
}

static void start_b1(void)
{
   int wahl, option;
   long ed_rptr, desc_rptr;
   FILE * datfl;
   long byte_zeiger;
   alte_posit=1;
   /* hier Daten aus BOOK.DAT einlesen */
   if(ix01rec.buch_rptr!=-1)
   {
       if ((datfl=fopen(book_name,"rb"))==NULL)
       {
           sprintf(fehlermeldung,"Cannot open %s",book_name);
           beenden(fehlermeldung,1);
       }
       byte_zeiger=ix01rec.buch_rptr*sizeof(one_buch_rec);
       fseek(datfl,byte_zeiger,SEEK_SET);
       fread(&one_buch_rec,sizeof(one_buch_rec),1,datfl);

       fclose(datfl);
   }
   /* Hieraus eine eigene Funktion machen.. */
   else memset(&one_buch_rec,0,sizeof(one_buch_rec));
   strcpy(one_journal_rec.reftyp,"b1");
   cls_line(TITEL_EE_B1);
   do
   {
      static int mposition;
      wahl = lotus_menu_default(&mposition,EDMENUTEXT);
      if (wahl == 1)
      {
         one_journal_rec.in_use = 1;
         one_buch_rec.in_use_bu = 1;
         get_b1_rec(&one_journal_rec,&one_buch_rec);
      }
      else if (wahl==2)
      {
         cls_line("");
         b1_rec_zeigen(ed_zeile,desc_zeile,showrec,ex_au_zeile);
      }
      else if  (wahl==3)
      {
         option = lotus_menu("Cancel$Do not save the current record@"
                             "Ok$Insert new record into file/overwrite "
                             "the current record");
         if (option==1 || option==0) continue;
         alte_posit=1;
         if((auedstring_ok(ed_zeile,ex_au_zeile)) &&
            (descstring_ok(desc_zeile,ex_au_zeile) > -1))
         {
                 ed_rptr = ix01rec.autorbu_rptr;
                 desc_rptr = ix01rec.desc_rptr;
                 auedstring_schreiben
                                     (
                                      ed_zeile,
                                      autorbu_name,
                                      &ed_rptr
                                     );
                ix01rec.autorbu_rptr =ed_rptr;
                descstring_schreiben (
                                      desc_zeile,
                                      desc_name,
                                      &desc_rptr
                                     );
                ix01rec.desc_rptr = desc_rptr;

                buch_rec_schreiben();
                journal_rec_schreiben();
                /*
                journal_rec_schreiben() aktualisiert auch den Index, zuvor
                muessen auedstring_schreiben() und buch_rec_schreiben()
                aufgerufen werden, damit die record pointers bestimmt sind.
                */
         } else continue;
         cls_line("");
         return;
      }
      else if (wahl==4)
      {
          text_zeigen(RE_ED_HILFE01);
      }
      else if (wahl==5)
      {
         char dn[PFAD_LEN];
         static int dpos;
         cls_line("");
         if (datei_suchen_default("*.TXT",dn,&dpos))
         {
           vtxt_main(dn);
         }
         else
         {
           wrtxt("\n[Please press any key]>");
           tastelesen();
           wrtxt("\n");
         }
         sc_gotoxy(1,one_config_set.sl-1);
      }
      if ((wahl==6) || (wahl==0))
      {
         int abbrtaste;

         abbrtaste = lotus_menu(QUITDATAENTRYMENUTEXT);
         if (abbrtaste==1)
         {
            wahl=1;
            continue;
         }
      }
   } while ((wahl!=6) && (wahl!=0));
}


static void start_b2(void)
{
   int wahl, option;
   long ed_rptr;
   long au_rptr;
   long desc_rptr;
   FILE * datfl;  /* BOOK.DAT */
   long byte_zeiger;
   alte_posit=1;
   /* Hier Daten aus BOOK.DAT einlesen */
   if(ix01rec.buch_rptr!=-1)
   {
       if ((datfl=fopen(book_name,"rb"))==NULL)
       {
           sprintf(fehlermeldung,"Cannot open %s",book_name);
           beenden(fehlermeldung,1);
       }
       byte_zeiger=ix01rec.buch_rptr*sizeof(one_buch_rec);
       fseek(datfl,byte_zeiger,SEEK_SET);
       fread(&one_buch_rec,sizeof(one_buch_rec),1,datfl);

       fclose(datfl);
   }
   /* Hieraus eine eigene Funktion machen.. */
   else memset(&one_buch_rec,0,sizeof(one_buch_rec));
   strcpy(one_journal_rec.reftyp,"b2");
   cls_line(TITEL_EE_B2);
   do
   {
      static int mposition;
      wahl = lotus_menu_default(&mposition,EDMENUTEXT);
      if (wahl == 1)
      {
         one_journal_rec.in_use = 1;
         one_buch_rec.in_use_bu = 1;
         get_b2_rec(&one_journal_rec,&one_buch_rec);
      }
      else if (wahl==2)
      {
         cls_line("");
         b2_rec_zeigen(au_zeile,ed_zeile,desc_zeile,showrec,ex_au_zeile);
      }
      else if  (wahl==3)
      {
         option = lotus_menu("Cancel$Do not save the current record@"
                             "Ok$Insert new record into file/overwrite "
                             "the current record");
         if (option==1 || option==0) continue;
         alte_posit=1;
         if((auedstring_ok(au_zeile,ex_au_zeile)) &&
            (auedstring_ok(ed_zeile,ex_au_zeile)) &&
            (descstring_ok(desc_zeile,ex_au_zeile) > -1))
         {
                 ed_rptr = ix01rec.autorbu_rptr;
                 au_rptr = ix01rec.autorjl_rptr;
                 desc_rptr = ix01rec.desc_rptr;
                 auedstring_schreiben
                                     (
                                      ed_zeile,
                                      autorbu_name,
                                      &ed_rptr
                                     );
                 auedstring_schreiben
                                     (
                                      au_zeile,
                                      autorjl_name,
                                      &au_rptr
                                     );
                descstring_schreiben (
                                      desc_zeile,
                                      desc_name,
                                      &desc_rptr
                                     );
                ix01rec.autorbu_rptr =ed_rptr;
                ix01rec.autorjl_rptr =au_rptr;
                ix01rec.desc_rptr = desc_rptr;
                buch_rec_schreiben();
                journal_rec_schreiben();
                /*
                journal_rec_schreiben() aktualisiert auch den Index, zuvor
                muessen auedstring_schreiben() und buch_rec_schreiben()
                aufgerufen werden, damit die record pointers bestimmt sind.
                */
         } else continue;
         cls_line("");
         return;
      }
      else if (wahl==4)
      {
          text_zeigen(RE_ED_HILFE01);
      }
      else if (wahl==5)
      {
         char dn[PFAD_LEN];
         static int dpos;
         cls_line("");
         if (datei_suchen_default("*.TXT",dn,&dpos))
         {
           vtxt_main(dn);
         }
         else
         {
           wrtxt("\n[Please press any key]>");
           tastelesen();
           wrtxt("\n");
         }
         sc_gotoxy(1,one_config_set.sl-1);
      }
      if ((wahl==6) || (wahl==0))
      {
         int abbrtaste;

         abbrtaste = lotus_menu(QUITDATAENTRYMENUTEXT);
         if (abbrtaste==1)
         {
            wahl=1;
            continue;
         }
      }
   } while ((wahl!=6) && (wahl!=0));
}

static int get_j1_rec(journal_rec * one_rec)
{
   int taste,posit,POSIT_ENDE;
   taste = 1;
   posit = alte_posit;
   POSIT_ENDE = 13;
   one_rec->in_use =1;
   strcpy(one_rec->reftyp,"j1");
   sc_gotoxy(1,one_config_set.sl-1);

   do
   {
     if (strlen(desc_zeile)==0)
     {
         strcpy(desc_zeile,DUMMY_KEYW);
     }
     if (posit==1)
     {
       info_zeile("Current reference number cannot be edited, please continue with [Enter]");
       strcpy(wrtxtbu,"Ref.-number........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->kennziffer,
                   KENNZIFFER_LEN,
                   KENNZIFFER_LEN,
                   1
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       info_zeile("");
      }


     else
     if (posit==2)
     {
       if (strlen(au_zeile)==0) strcpy(au_zeile,"NN,N");
       info_zeile("Syntax: Author1,A; Author2,AA; Author3,AAA; ... [1..6] first names allowed");
       strcpy(wrtxtbu,"Authors............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   au_zeile,
                   80-strlen("Authors............")-3,
                   AUTORZEILE_LEN-1,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }

      else if (posit==3)
      {
       info_zeile("Enter title of journal article without final full stop (.)");
       strcpy(wrtxtbu,"Title..............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->titel,
                   80-strlen("Title..............")-3,
                   TITEL_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==4)
      {
       info_zeile("Journal code [1..4] characters - JOURNAL file menu [F2]");
       strcpy(wrtxtbu,"Journal........[F2]");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->kuerzel,
                   KUERZEL_LEN,
                   KUERZEL_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==5)
      {
       info_zeile("Date of publication: year");
       strcpy(wrtxtbu,"Publication year...");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->jahrgang,
                   JAHRGANG_LEN,
                   JAHRGANG_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==6)
      {
       info_zeile("Date of publication: month (optional): 1 (January) ... 12 (December)");
       strcpy(wrtxtbu,"Month..............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->monat,
                   MONAT_LEN,
                   MONAT_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==7)
      {
       info_zeile("Date of publication: day (optional): 1 ... 31");
       strcpy(wrtxtbu,"Day................");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->tag,
                   TAG_LEN,
                   TAG_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==8)
      {
       info_zeile("Volume of a journal");
       strcpy(wrtxtbu,"Volume.............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->band,
                   BAND_LEN,
                   BAND_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==9)
      {
       info_zeile("Issue number of journal (optional)");
       strcpy(wrtxtbu,"Issue number.......");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->issue_nummer,
                   ISSUE_NUMMER_LEN,
                   ISSUE_NUMMER_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==10)
      {
       info_zeile("Range of pages: first page");
       strcpy(wrtxtbu,"First page.........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->seite_von,
                   SEITE_VON_LEN,
                   SEITE_VON_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==11)
      {
       info_zeile("Range of pages: last page - optional, but recommended to enter");
       strcpy(wrtxtbu,"Last page..........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->seite_bis,
                   SEITE_BIS_LEN,
                   SEITE_BIS_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==12)
      {
       info_zeile("User-defined one-letter code for classification of documents");
       strcpy(wrtxtbu,"Status.............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   one_rec->status,
                   STATUS_LEN,
                   STATUS_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==13)
      {
       info_zeile("List of KEYWORDS, use comma (,) as delimiter; [F2] call KEYWORDS menu");
       strcpy(wrtxtbu,"Keywords.......[F2]");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   desc_zeile,
                   80-strlen("Keywords...........")-3,
                   DESC_ZEILE_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }


      if (taste==ENTER_KEY || taste==TAB_KEY ||
          taste==DOWN_KEY || taste==PGDN_KEY)
      {
         if (posit < POSIT_ENDE) posit++;
      }
      if (taste ==SHIFTTAB_KEY || taste==UP_KEY || taste==PGUP_KEY)
      {
        if (posit > 1) posit--;
      }
      if (taste==CTRLHOME_KEY) posit=1;
      if (taste==CTRLEND_KEY) posit=POSIT_ENDE;

      if ((posit==4) && (taste==F2_KEY))  /* F2 */
      {
         journal_menu(one_rec->kuerzel);
         sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      if ((posit==13) && (taste==F2_KEY))
      {
         stichw_menu(desc_zeile);
      }

   } while ((taste!=F10_KEY) && (taste!=ESC_KEY));
   alte_posit=posit;
   return taste;
}

static int get_b1_rec(journal_rec * j1_rec, buch_rec * bu_rec)
{
   int taste,posit,POSIT_ENDE;
   taste = 1;
   posit = alte_posit;
   POSIT_ENDE = 12;
   j1_rec->in_use =1;
   bu_rec->in_use_bu=1;
   strcpy(j1_rec->reftyp,"b1");
   strcpy(bu_rec->kennziffer,j1_rec->kennziffer);
   sc_gotoxy(1,one_config_set.sl-1);

   do
   {
     if (strlen(desc_zeile)==0)
     {
         strcpy(desc_zeile,DUMMY_KEYW);
     }
     if (posit==1)
     {
       info_zeile("Current reference number cannot be edited, please continue with [Enter]");
       strcpy(wrtxtbu,"Ref.-number........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->kennziffer,
                   KENNZIFFER_LEN,
                   KENNZIFFER_LEN,
                   1
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       info_zeile("");
      }


     else
     if (posit==2)
     {
       if (strlen(ed_zeile)==0) strcpy(ed_zeile,"NN,N");
       info_zeile("Syntax: Author1,A; Author2,AA; Author3,AAA; ... [1..6] first names allowed");
       strcpy(wrtxtbu,"Authors/Editors....");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   ed_zeile,
                   80-strlen("Authors/Editors....")-3,
                   AUTORZEILE_LEN-1,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }

      else if (posit==3)
      {
       info_zeile("Enter title of the book without final full stop (.)");
       strcpy(wrtxtbu,"Book title.........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   bu_rec->titel_bu,
                   80-strlen("Book title.........")-3,
                   TITELBUCH_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }


      else if (posit==4)
      {
       info_zeile("Entry of page numbers is optional for a BOOK-reference");
       strcpy(wrtxtbu,"First page.........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->seite_von,
                   SEITE_VON_LEN,
                   SEITE_VON_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }

      else if (posit==5)
      {
       info_zeile("Entry of page numbers is optional for a BOOK-reference");
       strcpy(wrtxtbu,"Last page..........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->seite_bis,
                   SEITE_BIS_LEN,
                   SEITE_BIS_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }




      else if (posit==6)
      {
       info_zeile("Place of publication (town), a comma (,)-delimited list may be entered");
       strcpy(wrtxtbu,"Published in.......");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   bu_rec->publ_ort,
                   80-strlen("Published in.......")-3,
                   PUBLORT_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==7)
      {
       info_zeile("Date of publication: year");
       strcpy(wrtxtbu,"Publication year...");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->jahrgang,
                   JAHRGANG_LEN,
                   JAHRGANG_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==8)
      {
       info_zeile("Please enter name of the publishing company");
       strcpy(wrtxtbu,"Publisher..........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   bu_rec->verlag,
                   80-strlen("Publisher..........")-3,
                   VERLAG_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==9)
      {
       info_zeile("No of edition; it is usually not necessary to enter 1 for the 1st edition");
       strcpy(wrtxtbu,"Edition no.........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->band,
                   BAND_LEN,
                   BAND_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==10)
      {
       info_zeile("International Standard Book Number -- ISBN (optional)");
       strcpy(wrtxtbu,"ISBN...............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   bu_rec->isbn,
                   ISBN_LEN,
                   ISBN_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==11)
      {
       info_zeile("User-defined one-letter code for classification of documents");
       strcpy(wrtxtbu,"Status.............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->status,
                   STATUS_LEN,
                   STATUS_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==12)
      {
       info_zeile("List of KEYWORDS, use comma (,) as delimiter; [F2] call KEYWORDS menu");
       strcpy(wrtxtbu,"Keywords.......[F2]");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   desc_zeile,
                   80-strlen("Keywords...........")-3,
                   DESC_ZEILE_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      if (taste==ENTER_KEY || taste==TAB_KEY ||
          taste==DOWN_KEY || taste==PGDN_KEY)
      {
         if (posit < POSIT_ENDE) posit++;
      }
      if (taste ==SHIFTTAB_KEY || taste==UP_KEY || taste==PGUP_KEY)
      {
        if (posit > 1) posit--;
      }
      if ((posit==12) && (taste==F2_KEY))
      {
         stichw_menu(desc_zeile);
      }
      if (taste==CTRLHOME_KEY) posit=1;
      if (taste==CTRLEND_KEY) posit=POSIT_ENDE;
   } while ((taste!=F10_KEY) && (taste!=ESC_KEY));
   alte_posit=posit;
   return taste;

}


static int get_b2_rec(journal_rec * j1_rec, buch_rec * bu_rec)
{
   int taste,posit,POSIT_ENDE;
   taste = 1;
   posit = alte_posit;
   POSIT_ENDE = 14;
   j1_rec->in_use =1;
   bu_rec->in_use_bu=1;
   strcpy(j1_rec->reftyp,"b2");
   strcpy(bu_rec->kennziffer,j1_rec->kennziffer);
   sc_gotoxy(1,one_config_set.sl-1);

   do
   {
     if (strlen(desc_zeile)==0)
     {
         strcpy(desc_zeile,DUMMY_KEYW);
     }
     if (posit==1)
     {
       info_zeile("Current reference number cannot be edited, please continue with [Enter]");
       strcpy(wrtxtbu,"Ref.-number........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->kennziffer,
                   KENNZIFFER_LEN,
                   KENNZIFFER_LEN,
                   1
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       info_zeile("");
      }


     else if (posit==2)
     {
       if (strlen(ed_zeile)==0) strcpy(ed_zeile,"NN,N");
       info_zeile("Syntax: Editor1,A; Editor2,AA; Editor3,AAA; ... [1..6] first names allowed");
       strcpy(wrtxtbu,"Editors of a book..");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   ed_zeile,
                   80-strlen("Editors of a book..")-3,
                   AUTORZEILE_LEN-1,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }

     else if (posit==3)
     {
       if (strlen(au_zeile)==0) strcpy(au_zeile,"NN,N");
       info_zeile("Please enter the authors' names of the article in the book");
       strcpy(wrtxtbu,"Authors............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   au_zeile,
                   80-strlen("Authors............")-3,
                   AUTORZEILE_LEN-1,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }

      else if (posit==4)
      {
       info_zeile("Enter title of the book without final full stop (.)");
       strcpy(wrtxtbu,"Book title.........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   bu_rec->titel_bu,
                   80-strlen("Book title.........")-3,
                   TITELBUCH_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }

      else if (posit==5)
      {
       info_zeile("Enter title of an article in the book without final full stop (.)");
       strcpy(wrtxtbu,"Title..............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->titel,
                   80-strlen("Title..............")-3,
                   TITEL_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==6)
      {
       info_zeile("Range of pages: first page");
       strcpy(wrtxtbu,"First page.........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->seite_von,
                   SEITE_VON_LEN,
                   SEITE_VON_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==7)
      {
       info_zeile("Range of pages: last page - optional, but recommended to enter");
       strcpy(wrtxtbu,"Last page..........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->seite_bis,
                   SEITE_BIS_LEN,
                   SEITE_BIS_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }

      else if (posit==8)
      {
       info_zeile("Place of publication (town), a comma (,)-delimited list may be entered");
       strcpy(wrtxtbu,"Published in.......");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   bu_rec->publ_ort,
                   80-strlen("Published in.......")-3,
                   PUBLORT_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==9)
      {
       info_zeile("Date of publication: year");
       strcpy(wrtxtbu,"Publication year...");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->jahrgang,
                   JAHRGANG_LEN,
                   JAHRGANG_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==10)
      {
       info_zeile("Please enter name of the publishing company");
       strcpy(wrtxtbu,"Publisher..........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   bu_rec->verlag,
                   80-strlen("Publiser...........")-3,
                   VERLAG_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==11)
      {
       info_zeile("No of edition; it is usually not necessary to enter 1 for the 1st edition");
       strcpy(wrtxtbu,"Edition no.........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->band,
                   BAND_LEN,
                   BAND_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==12)
      {
       info_zeile("International Standard Book Number -- ISBN (optional)");
       strcpy(wrtxtbu,"ISBN...............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   bu_rec->isbn,
                   ISBN_LEN,
                   ISBN_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==13)
      {
       info_zeile("User-defined one-letter code for classification of documents");
       strcpy(wrtxtbu,"Status.............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   j1_rec->status,
                   STATUS_LEN,
                   STATUS_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      else if (posit==14)
      {
       info_zeile("List of KEYWORDS, use comma (,) as delimiter; [F2] call KEYWORDS menu");
       strcpy(wrtxtbu,"Keywords.......[F2]");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   desc_zeile,
                   80-strlen("Keywords...........")-3,
                   DESC_ZEILE_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      if (taste==ENTER_KEY || taste==TAB_KEY ||
          taste==DOWN_KEY || taste==PGDN_KEY)
      {
         if (posit < POSIT_ENDE) posit++;
      }
      if (taste ==SHIFTTAB_KEY || taste==UP_KEY || taste==PGUP_KEY)
      {
        if (posit > 1) posit--;
      }
      if ((posit==14) && (taste==F2_KEY))
      {
         stichw_menu(desc_zeile);
      }
      if (taste==CTRLHOME_KEY) posit=1;
      if (taste==CTRLEND_KEY) posit=POSIT_ENDE;
   } while ((taste!=F10_KEY) && (taste!=ESC_KEY));
   alte_posit=posit;
   return taste;
}

/*
 In journal_rec_schreiben(void) wird auch der Index geschrieben, deshalb
 sind vorher buch_rec_schreiben() und auedstring_schreiben() aufzurufen.
*/

static void journal_rec_schreiben(void)
{
   FILE * datfl;
   FILE * tmpix01;
   long rec_zeiger, ix01_zeiger;
   refspix_rec ix01_local;

   long byte_zeiger;

   ix01_zeiger = -1;  /* aus formalen Gruenden initialisiert */

   if ((datfl=fopen(journal_name,"r+b"))==NULL)
   {
        sprintf(fehlermeldung,"Cannot write into %s",journal_name);
        beenden(fehlermeldung,1);
   }

   if (filesize(journal_pix_name)<=0)
   {
      rec_zeiger=-1;
   } else
   {
       read_ix01(journal_pix_name);
       ix01_zeiger = locate_ix01(one_journal_rec.kennziffer,&ix01_local);
       if (ix01_zeiger>=0)
       {
          rec_zeiger=ix01_local.journal_rptr;

       }
       else rec_zeiger=-1;
       close_ix01();
   }

   if (rec_zeiger==-1)
   {
       fseek(datfl,0L,SEEK_END);
       byte_zeiger = ftell(datfl);
       rec_zeiger = byte_zeiger/sizeof(journal_rec);

       strncpy(ix01rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       ix01rec.journal_rptr=rec_zeiger;
       tmpix01=fopen(TMP01_IX,"r+b");
       if (tmpix01==NULL)
       {
         tmpix01=fopen(TMP01_IX,"wb");
       }
       if (tmpix01==NULL)
       {
           sprintf(fehlermeldung,"ERROR: Cannot open/create tmp01.ix");
           beenden(fehlermeldung,2);
       }


       fseek(tmpix01,0L,SEEK_END);
       fwrite(&ix01rec,sizeof(ix01rec),1,tmpix01);
       fclose(tmpix01);

   } else
   {
       if ((ix01=fopen(journal_pix_name,"r+b"))==NULL)
       {
          sprintf(fehlermeldung,"ERROR: unable to update %s",journal_pix_name);
          beenden(fehlermeldung,1);
       }
       fseek(ix01,ix01_zeiger * sizeof(ix01rec),SEEK_SET);
       fwrite(&ix01rec,sizeof(ix01rec),1,ix01);
       fclose(ix01);

       byte_zeiger=rec_zeiger * sizeof(journal_rec);
       fseek(datfl,byte_zeiger,SEEK_SET);

   }
   fwrite(&one_journal_rec, sizeof(journal_rec), 1, datfl);
   fclose(datfl);
}


static void buch_rec_schreiben(void)
{
  FILE * datfl;
  long byte_zeiger, rec_zeiger /*ix01_zeiger*/ ;

  if ((datfl=fopen(book_name,"r+b"))==NULL)
  {
      sprintf(fehlermeldung,"Cannot open %s",book_name);
      beenden(fehlermeldung,1);
  }
  if (ix01rec.buch_rptr==-1)
  {
      /* Ein neuer Datensatz wird eingetragen */
      fseek(datfl,0L,SEEK_END);
      byte_zeiger=ftell(datfl);
      rec_zeiger=byte_zeiger/sizeof(one_buch_rec);
      ix01rec.buch_rptr=rec_zeiger;
  }
  else
  {
      /*
       Die Adresse eines vorhandenen Datensatzes wird ix01rec entnommen
      */
      rec_zeiger=ix01rec.buch_rptr;
      byte_zeiger=ix01rec.buch_rptr*sizeof(one_buch_rec);
  }
  fseek(datfl,byte_zeiger,SEEK_SET);
  fwrite(&one_buch_rec,sizeof(one_buch_rec),1,datfl);
  fclose(datfl);
}

static void auedstring_schreiben(
                           const char * au_zeile,
                           const char * au_datei_name,
                           long * aued_rptr
                         )
{
    FILE * datfl;
    long rec_zeiger, byte_zeiger;
    author_rec aued_rec;
    int i, anz_autoren_string, anz_autoren_datei;
    char a_name[AUNAME_LEN + AUVORNAMEN_LEN + 12 + 1];
    char v_name[AUNAME_LEN + AUVORNAMEN_LEN + 12 + 1];


    if (* aued_rptr>=0)
    {
       if((datfl=fopen(au_datei_name,"rb"))==NULL)
       {
           sprintf(fehlermeldung,"ERROR: Cannot open %s",au_datei_name);
           beenden(fehlermeldung,1);
       }
       fseek(datfl,(long) sizeof(author_rec)*(* aued_rptr),SEEK_SET);
       fread(&aued_rec,sizeof(author_rec),1,datfl);
       anz_autoren_datei=aued_rec.au_n;
       fclose(datfl);
    } else anz_autoren_datei=0;
    anz_autoren_string = countitem(au_zeile,";");

    if((datfl=fopen(au_datei_name,"r+b"))==NULL)
    {
        sprintf(fehlermeldung,"ERROR Cannot open %s",au_datei_name);
        beenden(fehlermeldung,1);
    }

    if (* aued_rptr==-1)
    {
        /* Neue Datensaetze an das Ende von au_datei_name */
        fseek(datfl,0L,SEEK_END);
        byte_zeiger=ftell(datfl);
        rec_zeiger = byte_zeiger/sizeof(author_rec);
    }
    else
    {
       /* alte Datensaetze ungueltig machen: in_use_au auf 0 setzen */
       memset(&aued_rec,0,sizeof(aued_rec));
       fseek(datfl,(long) sizeof(author_rec)*(* aued_rptr),SEEK_SET);
       for (i=1;i<=anz_autoren_datei;i++)
       {
          fwrite(&aued_rec,sizeof(aued_rec),1,datfl);
       }
       /* Dateizeiger in au_datei_name positionieren */
       if (anz_autoren_string > anz_autoren_datei)
       {
            /* Dateizeiger in au_datei_name an das Ende setzen */
            fseek(datfl,0L,SEEK_END);
            byte_zeiger=ftell(datfl);
            rec_zeiger = byte_zeiger/sizeof(author_rec);
       }
       else
       {
            /* Dateizeiger in au_datei_name an die vorherige Dateiposition setzen */
            fseek(datfl,(long) sizeof(author_rec)*(* aued_rptr),SEEK_SET);
            byte_zeiger = ftell(datfl);
            rec_zeiger = byte_zeiger/sizeof(author_rec);
       }
    }



    for (i=1;i<=anz_autoren_string;i++)
    {
        strcpy(ex_au_zeile,"");
        extractitem(i,au_zeile,";",ex_au_zeile);
        trim(ex_au_zeile,' ');
        ex_au_zeile[AUNAME_LEN + AUVORNAMEN_LEN + 12] = '\0';
        extractitem(1,ex_au_zeile,",",a_name);
        trim(a_name,' ');
        a_name[AUNAME_LEN]= '\0';
        extractitem(2,ex_au_zeile,",",v_name);
        trim(v_name,' ');
        v_name[AUVORNAMEN_LEN] = '\0';

        aued_rec.in_use_au = 1;
        aued_rec.au_i = i;
        aued_rec.au_n = anz_autoren_string;
        strncpy(aued_rec.au_kennziffer,ix01rec.kennziffer,KENNZIFFER_LEN+1);
        strncpy(aued_rec.au_nachname,a_name,AUNAME_LEN+1);
        strncpy(aued_rec.au_vornamen,v_name,AUVORNAMEN_LEN+1);
        fwrite(&aued_rec,sizeof(aued_rec),1,datfl);
    }
    fclose(datfl);
    * aued_rptr = rec_zeiger;
}


static void descstring_schreiben(
                           const char * desc_zeile,
                           const char * desc_datei_name,
                           long * desc_rptr
                         )
{
    FILE * datfl;
    long rec_zeiger, byte_zeiger;
    desc_rec dr;
    int i, anz_desc_string, anz_desc_datei;
    char * ex_desc_zeile;

    memset(&dr,0,sizeof(dr));

    if  ((ex_desc_zeile = (char *) malloc(DESC_ZEILE_LEN * sizeof(char)))==NULL)
    {
        beenden("'EnterEdit': Memory allocation error EX_DESC_ZEILE",1);
    }

    if (* desc_rptr>=0)
    {
       if((datfl=fopen(desc_datei_name,"rb"))==NULL)
       {
           sprintf(fehlermeldung,"ERROR: Cannot open %s",desc_datei_name);
           beenden(fehlermeldung,1);
       }
       fseek(datfl,(long) sizeof(dr)*(* desc_rptr),SEEK_SET);
       fread(&dr,sizeof(dr),1,datfl);
       anz_desc_datei=dr.desc_n;
       fclose(datfl);
    } else anz_desc_datei=0;
    anz_desc_string = countitem(desc_zeile,",");

    if((datfl=fopen(desc_datei_name,"r+b"))==NULL)
    {
        sprintf(fehlermeldung,"ERROR Cannot open %s",desc_datei_name);
        beenden(fehlermeldung,1);
    }
    if (* desc_rptr==-1)
    {
        /* Neue Datensaetze an das Ende von desc_datei_name */
        fseek(datfl,0L,SEEK_END);
        byte_zeiger=ftell(datfl);
        rec_zeiger = byte_zeiger/sizeof(dr);
    }
    else
    {
       /* alte Datensaetze ungueltig machen: in_use auf 0 setzen */
       memset(&dr,0,sizeof(dr));
       fseek(datfl,(long) sizeof(dr)*(* desc_rptr),SEEK_SET);
       for (i=1;i<=anz_desc_datei;i++)
       {
          fwrite(&dr,sizeof(dr),1,datfl);
       }
       /* Dateizeiger in desc_datei_name positionieren */
       if (anz_desc_string > anz_desc_datei)
       {
            /* Dateizeiger in desc_datei_name an das Ende setzen */
            fseek(datfl,0L,SEEK_END);
            byte_zeiger=ftell(datfl);
            rec_zeiger = byte_zeiger/sizeof(dr);
       }
       else
       {
            /*
               Dateizeiger in desc_datei_name an die vorherige
               Dateiposition setzen
             */
            fseek(datfl,(long) sizeof(dr)*(* desc_rptr),SEEK_SET);
            byte_zeiger = ftell(datfl);
            rec_zeiger = byte_zeiger/sizeof(dr);
       }
    }

    for (i=1;i<=anz_desc_string;i++)
    {
        strcpy(ex_desc_zeile,"");
        extractitem(i,desc_zeile,",",ex_desc_zeile);
        trim(ex_desc_zeile,' ');
        ex_desc_zeile[KEYWORDS_LEN] = '\0';

        dr.in_use = 1;
        dr.desc_i = i;
        dr.desc_n = anz_desc_string;
        strlimcpy(dr.kennziffer,ix01rec.kennziffer,KENNZIFFER_LEN);
        strlimcpy(dr.keywordsfield,ex_desc_zeile,KEYWORDS_LEN);
        fwrite(&dr,sizeof(dr),1,datfl);
    }
    fclose(datfl);

    if (anz_desc_string == 0)
    {
       * desc_rptr = -1;
    }
    else
    {
       * desc_rptr = rec_zeiger;
    }
    free(ex_desc_zeile);
    return;
}

static void auedstring_lesen(
                           char * au_zeile,
                           char * au_datei_name,
                           long aued_rptr
                      )
{
   FILE * datfl;
   author_rec aued_rec;
   int i, anz_autoren;

   strcpy(au_zeile,"");
   if (aued_rptr==-1)
   {
       return;
   }

   if ((datfl=fopen(au_datei_name,"rb"))==NULL)
   {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",au_datei_name);
         beenden(fehlermeldung,1);
   }
   fseek(datfl,aued_rptr*sizeof(aued_rec),SEEK_SET);
   fread(&aued_rec,sizeof(aued_rec),1,datfl);
   anz_autoren = aued_rec.au_n;
   fseek(datfl,aued_rptr*sizeof(aued_rec),SEEK_SET);

   for(i=1;i<=anz_autoren;i++)
   {
      if (i > MAX_N_AUTHORS)
      {
         trim(au_zeile,' ');
         break;
      }
      fread(&aued_rec,sizeof(aued_rec),1,datfl);
      strlimcat(au_zeile,aued_rec.au_nachname,AUTORZEILE_LEN);
      strlimcat(au_zeile,",",AUTORZEILE_LEN);
      strlimcat(au_zeile,aued_rec.au_vornamen,AUTORZEILE_LEN);
      strlimcat(au_zeile,";",AUTORZEILE_LEN);
   }
   trim(au_zeile,' ');
   fclose(datfl);
   return;
}

static void descstring_lesen(
                           char * desc_zeile,
                           char * desc_datei_name,
                           long desc_rptr
                      )

{
   FILE * datfl;
   desc_rec dr;
   int i, anz_desc;

   strcpy(desc_zeile,"");
   if (desc_rptr==-1)
   {
      return;
   }
   if ((datfl=fopen(desc_datei_name,"rb"))==NULL)
   {
         sprintf(fehlermeldung,"ERROR: Cannot read %s",desc_datei_name);
         beenden(fehlermeldung,1);
   }
   fseek(datfl,desc_rptr*sizeof(dr),SEEK_SET);
   fread(&dr,sizeof(dr),1,datfl);
   anz_desc = dr.desc_n;
   fseek(datfl,desc_rptr*sizeof(dr),SEEK_SET);

   for(i=1;i<=anz_desc;i++)
   {
      if (i > MAX_N_DESC)
      {
         trim(desc_zeile,' ');
         break;
      }
      fread(&dr,sizeof(dr),1,datfl);
      strlimcat(desc_zeile,dr.keywordsfield,DESC_ZEILE_LEN);
      if (i < anz_desc)
      {
        strlimcat(desc_zeile,", ",DESC_ZEILE_LEN);
      }
   }
   trim(desc_zeile,' ');
   fclose(datfl);
   return;

}
