#
#   REFERENCES -- bibliographic software
#   Copyright (C) 1995-2000  Volker Kiefel
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#   USA
#
#   Usage:
#
#      AWK -f MergeHar.Awk longref.txt shortref.txt
#
#   Merges file with \harvarditem{}{}{}s (longref.txt) and list of references
#   (shortref.txt)
#


BEGIN {
   if (ARGC != 3)
   {
    print "\nCreates a list of references for the LaTeX HARVARD package."
    
    if (hilfe=="FROM_SCRIPT")
    {
      print "\nUsage: MERGEHAR LONGREF.TXT SHORTREF.TXT"
    } else
    {
      print "\nUsage: " ARGV[0] " -f MERGEHAR.AWK LONGREF.TXT SHORTREF.TXT"
    }
    print   "\n       LONGREF.TXT  -- text with list of references"
    print     "       SHORTREF.TXT -- text with \\harvarditem{}{}{} entries\n"

    exit 1;
   }
   outfile = "REFS.TEX"

   longinfile = ARGV[1]
   shortinfile = ARGV[2]
   hitem=0
   shortin=""
   longin=""
   abbruch = 0
   print "%" > outfile
   print "% List of references for the HARVARD package (REFERENCES 3.6)" >> outfile
   print "%\n" >> outfile

   print "\nMerging " longinfile " + " shortinfile " -> " outfile

   for (;;)
   {
       if ((getline shortin < shortinfile) == 1)
       {
         if (length(shortin) > 0) shorts = shortin
       } else break
       if ((getline longin < longinfile) == 1)
       {
         if (length(longin) > 0) longs = longin
       } else break
       if (length(shortin) > 0 && length(longin))
       {
          if (index(shorts,"<") != 1 || index(longs,"<") !=1 || \
              index(shorts,"> ") > 14 || index(longs,"> ") > 14)
          {
              print "\nProblem: wrong `<RefNo>' - format"
              exit 1
          }

          if (substr(shorts,2,index(shorts,"> ")-2) != \
              substr(longs,2,index(longs,"> ")-2))
          {
              print "\nProblem: `<RefNo>'s do not correspond in " \
                     longinfile " and " shortinfile "."
              exit 1
          }
          pos = index(shorts,"> ")
          ex_shorts = substr(shorts,pos+2)
          exex_shorts = texen(ex_shorts)

          pos = index(longs,"> ")
          ex_longs = substr(longs,pos+2)
          exex_longs = texen(ex_longs)

          print exex_shorts       >> outfile
          print exex_longs "\n"   >> outfile
          hitem++
       }
   }
   close(outfile)
   close(longinfile)
   close(shortinfile)
   print outfile " closed, " hitem " \\harvarditem{}{}{}s written.\n"
}

function texen(a)
{

    gsub(/\$/,"{\\$}",a)      # $ -> {\$}
    gsub(/&/,"{\\\\&}",a)     # & -> {\&} cf. GAWK documentation
    gsub(/%/,"{\\%}",a)       # % -> {\%}
    gsub(/_/,"{\\_}",a)       # _ -> {\_}
    gsub(/"/,"''",a)          # " -> ''
    gsub(/\204/,"{\\\"a}",a)     #  -> {\"a}
    gsub(/\216/,"{\\\"A}",a)     #  -> {\"A}
    gsub(/\224/,"{\\\"o}",a)     #  -> {\"o}
    gsub(/\231/,"{\\\"O}",a)     #  -> {\"O}
    gsub(/\201/,"{\\\"u}",a)     #  -> {\"u}
    gsub(/\232/,"{\\\"U}",a)     #  -> {\"U}
    gsub(/\341/,"{\\ss}",a)      #  -> {\"ss}
    gsub(/\[/,"$[$",a)           # [ -> $[$
    gsub(/\]/,"$]$",a)           # ] -> $]$
    gsub(/</,"$<$",a)            # < -> $<$
    gsub(/>/,"$>$",a)            # > -> $>$
    gsub(/#/,"\\#",a)            # # -> \#

    gsub(/\207/,"{\\c{c}}",a)   #  -> {\c{c}}
    gsub(/\200/,"{\\c{c}}",a)   #  -> {\c{C}}
    gsub(/\202/,"{\\'{e}}",a)   #  -> {\'{e}}
    gsub(/\212/,"{\\`{e}}",a)   #  -> {\'{e}}
    gsub(/\210/,"{\\^{e}}",a)   #  -> {^{a}}
    gsub(/\211/,"{\\\"{e}}",a)  #  -> {\"{e}}
    gsub(/\220/,"{\\'{E}}",a)   #  -> {\'{E}}
    gsub(/\240/,"{\\'{a}}",a)   #  -> {\'{a}}
    gsub(/\205/,"{\\`{a}}",a)   #  -> {\'{a}}
    gsub(/\203/,"{\\^{a}}",a)   #  -> {^{a}}
    gsub(/\242/,"{\\'{o}}",a)   #  -> {\'{o}}
    gsub(/\225/,"{\\`{o}}",a)   #  -> {\'{o}}
    gsub(/\223/,"{\\^{o}}",a)   #  -> {^{o}}
    gsub(/\243/,"{\\'{u}}",a)   #  -> {\'{u}}
    gsub(/\227/,"{\\`{u}}",a)   #  -> {\'{u}}
    gsub(/\226/,"{\\^{u}}",a)   #  -> {^{u}}
    gsub(/\241/,"{\\'{i}}",a)   #  -> {\'{i}}
    gsub(/\215/,"{\\`{i}}",a)   #  -> {\'{i}}
    gsub(/\214/,"{\\^{i}}",a)   #  -> {^{i}}

    gsub(/\370/,"{\\ensuremath{^\\circ}}",a)    #  -> {\ensuremath{^\circ}}
    gsub(/\346/,"{\\ensuremath{\\mu}}",a)         #  -> {\ensuremath{\mu}}
    gsub(/\340/,"{\\ensuremath{\\alpha}}",a)      #  -> {\ensuremath{\alpha}}


    return a
}
