{$V-}
  program FixUUE;
  {
    Simple program for fixing translation problems of UUEencoded files
    Copyright (c) Mario A. Guerra 1991.

    This program is for the public domain. It can't be used for
    commercial purposes without my written permission.

    This program is nothing more than a modified version of the
    Blockwrite example in Turbo Pascal online help!!

    Bitnet address: MGUERRA@UCRVM2

    26/08/91 - Version 1.1 - You specify the input file and the number of
                             files to be fixed (optional).
  }

  uses
    DOS;

  var
    FromF, ToF: file;
    FileName: string;
    NumRead, NumWritten: word;
    Buf: array[1..2048] of char;
    Nfiles : integer;
    Seq : word;
    Dir : DirStr;
    Fname : PathStr;
    Ext : ExtStr;
    SeqStr : string;
    Processed : byte;
    NfilesStr : string;
    i, j : word;
    k : integer;

  begin

    if (ParamCount < 1) or (ParamCount > 2) then
      begin
        Writeln ('Usage: FIXUUE <input file> [<number of files>]');
        Halt;
      end
    else if ParamCount = 1 then
      Nfiles := 1
    else
      begin
        NfilesStr := ParamStr (2);
        Val (NfilesStr, Nfiles, k);
      end;
    Processed := 0;


    FileName := ParamStr (1);
    FSplit (Filename, Dir, Fname, Ext);
    Val (Copy (Fname, Length(FName), 1), Seq, k);

    repeat
      Assign(FromF, Filename);
{$I-}
      Reset(FromF, 1);
{$I+}
      if Ioresult <> 0 then
        begin
          Writeln (FileName, ' could not be open. Halting FIXUUE');
          Halt;
        end;

      Assign(ToF, 'FIXUUE.$$$');

{$I-}
      Rewrite(ToF, 1);
{$I+}

      if Ioresult <> 0 then
        begin
          Writeln ('FIXUUE.$$$ could not be open. Halting FIXUUE');
          Halt;
        end;
      WriteLn('Fixing ', FileSize(FromF), ' bytes in file ', Filename);

      repeat
        BlockRead(FromF,Buf,
                  SizeOf(Buf),NumRead);
        for i := 1 to 2048 do
          if Buf [i] = '' then Buf [i] := '['
            else if Buf [i] = '' then Buf [i] := ']';
        BlockWrite(ToF,Buf,NumRead,NumWritten);
      until (NumRead = 0) or (NumWritten <> NumRead);

      Close(FromF);
      Close(ToF);
      Erase(FromF);
      Rename(ToF, Filename);

      Inc (Seq); Inc (Processed);

      Str (Seq, SeqStr);
      Fname := Copy (Fname, 1, Length(Fname) - Length(SeqStr)) + SeqStr;
      Filename := Dir + Fname + Ext;
   until (Processed >= Nfiles);

  end.