/* mimeqp.c */
/* convert 7 bit encoded text to 8 bit text and vice versa */
/* default is 7 to 8 */

/*
 * Encoding is suited to text files in which the 8 bit ASCII characters
 * that have bit 7 set are in the minority.
 *
 * Encoding replaces all control characters except \n and \t,
 * all ='s, and all characters whose ASCII code is greater than 127
 * with =XX where XX is the hex value of the ASCII.
 *
 * Decoding (which is the default) does the opposite.
 *
 * mimeqp infile [outfile] [-option]
 * -e            encode  (default is decode)
 * if no output file given, output replaces input
 */

#include <stdio.h>
#include <stdlib.h>

void fputch( char blivit, FILE *f )
{
/*   if (blivit == '\n') fputc( '\r', f );*/
   fputc( blivit, f );
}

int classify_args( int narg,
                   char *rawargs[], char *fileargs[], char *optargs[] )
{
   int index, jndex, kndex;
   char *argptr;

   for ( index = 0, jndex = 0, kndex = 0; index < narg; index++ )
   {
      argptr = rawargs[index];
      if (*argptr == '-')
      {
         argptr++;
         optargs[kndex++] = argptr;
      }
      else
      {
         fileargs[jndex++] = argptr;
      }
   }

   return kndex;
}

unsigned char decode_hex( char *streamptr )
{
   unsigned char result = 0;
   char blivit;

   blivit = *streamptr++;
   if ( blivit >= 'a' ) blivit -= ' ';
   if ( blivit > '9' ) blivit -= 0x07;

   result = blivit & 0x0F;
   result <<= 4;

   blivit = *streamptr++;
   if ( blivit >= 'a' ) blivit -= ' ';
   if ( blivit > '9' ) blivit -= 0x07;

   result |= blivit & 0x0F;

   return result;
}

char *encode_hex( char *stream_ptr, unsigned char blivit )
{
   unsigned char accum;

   *stream_ptr++ = '=';

   accum = blivit;
   accum >>= 4;
   if ( accum > 9 ) accum += 7;
   accum += '0';
   *stream_ptr++ = (char)accum;

   accum = blivit;
   accum &= 0x0F;
   if ( accum > 9 ) accum += 7;
   accum += '0';
   *stream_ptr++ = (char)accum;

   return stream_ptr;
}

char *fileargs[64], *optargs[64];

int main( int nargs, char *cargs[] )
{
   int n_options, n_files, index, jndex, state=0;
   enum { ENCODE, DECODE } whattodo = DECODE;
   int help_flag = 0, replace_flag = 0, poopflag = 0;
   FILE *fin, *fout;
   unsigned char blivit, preblivit = 0;
   char buf[80];
   char *cptr, *altptr;

   n_options = classify_args( nargs, cargs, fileargs, optargs );

   n_files = nargs - n_options;

   if ( n_files < 2 ) help_flag = 1;

   for ( index = 0; index < n_options; index++ )
   {
      if ( ( optargs[index][0] == 'e' ) ||
           ( optargs[index][0] == 'E' ) ) whattodo = ENCODE;
      if ( optargs[index][0] == '?' ) help_flag = 1;
   }

   if ( help_flag )
   {
      printf( "mimeqp infile [outfile] [-option] [-option] etc.\n\n"
              "convert between 8 bit ASCII and MIME q-p format\n\n"
              "        -e       MIME q-p encode (default is decode)\n"
              "        -?       display help message\n\n"
              "if no outfile given, output file replaces infile\n" );
   }

   if ( n_files < 2 ) exit(0);

   fin = fopen( fileargs[1], "r" );

   if ( fin == 0 )
   {
      printf( "%s file not found\n", fileargs[1] );
      exit(-1);
   }

   if ( n_files > 2 )
   {
      fout = fopen( fileargs[2], "w" );
      if ( fout == 0 )
      {
         printf( "Couldn't open %s for output\n", fileargs[2] );
      }
   }
   else
   {
      fout = fopen( "$$$$$$$$.$$$", "wb" );
      replace_flag = 1;
   }

   index = 0;
   cptr = buf;
   preblivit = 'X';

   while (1)
   {
      if (feof( fin ) ) break;
      blivit = fgetc( fin );
      if ( (blivit != '\n') && (feof( fin ) ) ) break;

      if ( whattodo == ENCODE )
      {

         if ( ( (blivit >= ' ') && ( blivit <= '\x7F' ) &&
              ( (blivit != '.') || (preblivit != '\n') ) &&
                                   ( blivit != '='   ) ) ||
              (blivit == '\n') || (blivit == '\t') /*|| (blivit == '\r')*/ )
         {
            *cptr++ = (char)blivit;
            index++;
         }
         else
         {
            altptr = encode_hex( cptr, blivit );
            index += altptr - cptr;
            cptr = altptr;
            preblivit = '=';
         }

         if ( blivit == '\n' )
         {
            poopflag = 1;
            if ( (preblivit == ' ') || (preblivit == '\t') )
            {
               do
               {
                  index--;
                  cptr--;
               } while ( (*cptr == '\n') /*|| (*cptr == '\r')*/ );

               index++;
               cptr++;

               *cptr++ = '=';
/*               *cptr++ = '\r';*/
               *cptr++ = '\n';
/*               *cptr++ = '\r';*/
               *cptr++ = '\n';
               index += 3;
            }
         }
         else if ( index >= 72 )
         {
            *cptr++ = '=';
            *cptr++ = '\n';
/*            *cptr++ = '\r';*/
            index += 2;
            poopflag = 1;
         }

         /*if ( blivit != '\r' )*/ preblivit = blivit;

         if ( poopflag )
         {
            poopflag = 0;
            for ( jndex = 0; jndex < index; jndex++ )
            {
               fputch( buf[jndex], fout );
            }
            index = 0;
            cptr = buf;
         }
      }
      else /* if decoding */
      {
         switch ( state )
         {
            case 0:
            if ( blivit == '=' ) state = 1;
            else fputch( blivit, fout );
            break;

            case 1:
            if ( blivit == '\n' )
            {
               state = 0;
            }
/*            else if ( blivit == '\r' )
            {
            }*/
            else if ( ( (blivit < '0') || (blivit > '9') ) &&
                      ( (blivit < 'A') || (blivit > 'F') ) &&
                      ( (blivit < 'a') || (blivit > 'f') ) )
            {
               fputch( '=', fout );
               if ( index != 0 ) fputch( buf[0], fout );
               fputch( blivit, fout );
               state = 0;
            }
            else if ( index < 1 )
            {
               buf[index++] = blivit;
            }
            else
            {
               buf[index++] = blivit;
               blivit = decode_hex( buf );
               fputch( blivit, fout );
               index = 0;
               state = 0;
            }
         }
      }
   }

   if ( whattodo == ENCODE )
   {
      if ( index != 0 )
      {
         for ( jndex = 0; jndex < index; jndex++ )
         {
            fputch( buf[jndex], fout );
         }
      }
   }

   fclose( fin );
   fclose( fout );

   if ( replace_flag )
   {
      remove( fileargs[1] );
      rename( "$$$$$$$$.$$$", fileargs[1] );
   }
}
