/******************************************************************************
* Module    :   Identify a binary file.
*
* Author    :   John Stevens
******************************************************************************/

#include    <stdio.h>
#include    <stdlib.h>
#include    <errno.h>
#include    <string.h>

#include    "post.h"

extern  char    *sys_errlist[];

typedef struct
{
    long            Offset;
    int             length;
    char            *string;
    char            ext[5];
    BIN_TYPES       FileType;
} FILE_TYPES;

static  FILE_TYPES  FileTypes[] =
{
    {   0L, 6,  "GIF87a",   ".gif",     GIF87A          },
    {   0L, 6,  "GIF89a",   ".gif",     GIF89A          },
    {   6L, 4,  "JFIF",     ".jpg",     JFIF_JPEG       },
    {   0L, 4,  "hsi1",     ".hsi",     HSI1_JPEG       },
    {   0L, 0,  "",         "",         UNKNOWN_TYPE    }
};

/*-----------------------------------------------------------------------------
| Routine   :   IdBinFile() --- Identify a binary file.  Currently this only
|               works for graphics that I have access to.
|
| Inputs    :   FlPtr   - Pointer to binary file.
|
| Returns   :   Returns the file type.
-----------------------------------------------------------------------------*/

BIN_TYPES   IdBinFile(FILE  *FlPtr,
                      char  *ext)
{
    register    int     i;
    register    int     j;
    auto        int     c;

    /*  Run file types, looking for all listed types.   */
    strcpy(ext, ".bin");
    for (i = 0; FileTypes[i].length; i++)
    {
        /*  Seek to proper offset.  */
        if (fseek(FlPtr, FileTypes[i].Offset, 0) != 0)
        {
            fprintf(stderr,
                    "%s %d : Error - %s\n",
                    __FILE__,
                    __LINE__,
                    sys_errlist[errno]);
            return( UNKNOWN_TYPE );
        }

        /*  Read and compare bytes. */
        for (j = 0; j < FileTypes[i].length; j++)
        {
            /*  Get a character from the file.  */
            if ((c = fgetc( FlPtr )) == -1)
            {
                fprintf(stderr,
                        "%s %d : Error - %s\n",
                        __FILE__,
                        __LINE__,
                        sys_errlist[errno]);
                return( UNKNOWN_TYPE );
            }

            /*  Compare character read from file with expected
            *   character.
            */
            if (FileTypes[i].string[j] != (char) c)
                break;
        }

        /*  Check for file type found.  */
        if (j == FileTypes[i].length)
        {
            strcpy(ext, FileTypes[i].ext);
            return( FileTypes[i].FileType );
        }
    }

    /*  Return type unknown.    */
    return( UNKNOWN_TYPE );
}
