/******************************************************************************
* Module    :   Bit Mapped Set Functions.
*
* Author    :   John W. M. Stevens.
******************************************************************************/

#include    "sets.h"

#define     NUL     '\0'
#define     EOL     '\n'

/*-----------------------------------------------------------------------------
| Routine   :   InSet() --- Test to see if a character is a member of a set.
|
| Inputs    :   CSet    - Character set to test against.
|               c       - Character to test.
|
| Returns   :   Zero for not in the set, non-zero for in set.
-----------------------------------------------------------------------------*/

int InSet(SET           CSet,
          unsigned char c)
{
    return( (int) (CSet[c / INT_SIZE] & (1 << (c % INT_SIZE))) );
}

/*-----------------------------------------------------------------------------
| Routine   :   CrtSet() --- Create a character set.
|
| Inputs    :   Str     - String containing set elements.
| Outputs   :   CSet    - Initialized character set.
-----------------------------------------------------------------------------*/

void    CrtSet(unsigned char    **Str,
               SET              CSet)
{
    register    int             i;
    register    int             c;
    auto        int             NegateFlag;
    auto        unsigned char   LastCh;

    /*  If the first character of the set is a '^', this is a negated
    *   set.
    */
    if (**Str == '^')
    {
        NegateFlag = 1;
        (*Str)++;
    }
    else
        NegateFlag = 0;

    /*  Clear the set first.    */
    for (i = 0; i < SET_SIZE; i++)
        CSet[i] = 0;

    /*  Get characters of set.  */
    for (LastCh = '\0'; **Str && **Str != ']'; (*Str)++)
    {
        /*  Check for escape character. */
        if (**Str == '\\')
            (*Str)++;
        else if (**Str == '-')
        {
            /*  Check to make sure that this is a range separator
            *   character.
            */
            if ( LastCh )
            {
                /*  Get termination character.  */
                if ((*Str)[1] && (*Str)[1] != ']')
                {
                    /*  Skip escape character.  */
                    if ((c = *++(*Str)) == '\\')
                        c = *++(*Str);

                    /*  Fill in range.  */
                    for (i = LastCh + 1; i < c; i++)
                        CSet[i / INT_SIZE] |= 1 << (i % INT_SIZE);
                    LastCh = '\0';
                }
            }
        }

        /*  Add character to set.   */
        CSet[**Str / INT_SIZE] |= 1 << (**Str % INT_SIZE);
        LastCh = **Str;
    }
    if (**Str == ']')
        (*Str)++;

    /*  Negate set if necesary. */
    if ( NegateFlag )
    {
        for (i = 0; i < SET_SIZE; i++)
            CSet[i] = ~CSet[i];
    }

    /*  Do not EVER match a '\0' or '\n'.   */
    CSet[0] &= ~1;
    CSet[EOL / INT_SIZE] &= ~(1 << (EOL % INT_SIZE));
}
