#include <ctype.h>
#include "calendar.h"
#include "dos.h"
#include "help.h"
#include "mouser.h"
#include "gifford.h"
#include "alter.h"

alter::alter(data & dta, data test, bstring hme, Mcursor & mouse) : the_lines(4), buttons(12), the_mouse (mouse), the_data (dta)
	{
	advance = 0;
	compare_data = test;
	home =  hme;
	}

alter::~alter()
	{
	}

void alter::show ()
	{
	int exit = 0;

	gr_clear ();

	display_all();

	mouser read_mouse (buttons, 11, the_mouse, 9);

	read_mouse.show();

	while (!exit)
		{
		char keypress;

		int change = 0;

		int option = read_mouse.get (keypress, the_lines, 4, change, 0);

		if (change)
			{
			change = 0;

			for (int j = 0; j < 4; j++)
				the_data.note[j] = the_lines[j].getstring();
			}

		if ((option == -1 && keypress == 27) || option == 4) //exit
			{
			save_okay();
			exit = -1;
			}

		if (option < 4 && option >= 0)
			{
			set_lines(option);
			}

		if (option == 5) // change the level
			{
			set_level ();
			gr_clear ();
			display_all ();
			read_mouse.init (buttons, 11);
			read_mouse.show();
			}

		if (option == 6) // change the warning
			{
			set_warning ();
			gr_clear ();
			display_all ();
			read_mouse.init (buttons, 11);
			read_mouse.show();
			}

		if (option == 7) // change the day it occurs
			{
			calendar	*the_calendar  = new calendar(the_data.real_month,
						the_data.real_year, the_data.home, the_mouse);
			the_calendar->add();

			if (the_calendar->day)
				the_data.set_real (the_calendar->month,
					the_calendar->day, the_calendar->year);

			delete the_calendar;


			gr_clear ();
			display_all ();
			read_mouse.init (buttons, 11);
			read_mouse.show();
			}

		if (option == 8) // change how often it occurs
			{
			set_occur ();
			if (advance)
				exit = -1;
			else
			   {
			   gr_clear ();

			   display_all ();
			   read_mouse.init (buttons, 11);
			   read_mouse.show();
			   }
			}

		if (option == 9) // save & exit
			{
			if (can_save())
				{
				fix_up ();
				the_data.write ();
				exit = -1;
				}
			else
				{
				gr_clear();
				display_all();
				read_mouse.show();
				}
			}

		if (option == 10) // help
			{
			alter_help ();
			read_mouse.show();
			}
		}

	}

int alter::can_save ()
	{
	if (the_data.occur_type1 == -1 || the_data.occur_level == -1)
		{
		Bevel saver;

		saver.init (122, 185, 396, 100, THICK);
		saver.show ();

		write3d (205,"You cannot save.  First you must set all the");
		write3d (215,"items that say THIS NEEDS TO BE SET.");

		buttons[0].init(getmaxx()/2-20,245," OK ",TEXT);

		mouser 	read_mouse (buttons, 1, the_mouse, 0);
		read_mouse.show();

		int exit = 0;

		while (!exit)
			{
			char keypress;
			int option = read_mouse.get (keypress);

			if (option == 0)
				exit = 1;
			}
		return 0;
		}
	else
		return 1;
	}


void alter::save_okay ()
	{
	if (the_data.occur_type1 == -1 || the_data.occur_level == -1)
		return;
	if (the_data == compare_data)
		return;

	Bevel saver;

	saver.init (122, 185, 396, 100, THICK);
	saver.show ();

	write3d (205,"Save your changes before exiting?");

	buttons[0].init(250,245," Yes ",TEXT);
	buttons[1].init(340,245," No ",TEXT);

	mouser 	read_mouse (buttons, 2, the_mouse, 0);
	read_mouse.show();

	int exit = 0;

	while (!exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		if (option == 0 || (option == -1 && tolower(keypress) == 'y'))
			{
			fix_up ();
			the_data.write ();
			exit = 1;
			}
		if (option == 1 ||  (option == -1 && tolower(keypress) == 'n'))
			exit = 1;
		}
	}

void alter::set_lines (int option)
	{
	int input_exit = 0;

	while (!input_exit)
		{
		the_lines[option].get_form_mouse_input ();
		the_data.note[option] = the_lines[option].getstring();

		if (the_lines[option].dnarrowhit() ||
		    the_lines[option].tabhit() ||
		    the_lines[option].uparrowhit() ||
		    the_lines[option].returnhit())
		    {
		    if (the_lines[option].uparrowhit())
			option--;
		    else
			option++;

		    if (option < 0 || option >= 4)
			{
			input_exit = 1;
			}
		    }

		else
			input_exit = 1;
		}
	}


void alter::fix_up ()
	{
	struct date d;
	struct date new_date;
	long julian;
	long today;

	getdate (&d);

	gifford	gif_date;

	julian = gif_date.ConvertJulian (the_data.real_day, the_data.real_month,
			 the_data.real_year);

	today = gif_date.ConvertJulian (d.da_day, d.da_mon, d.da_year);

	if (the_data.warning)
		{
		julian -= the_data.warning;

		if (today > julian)
			julian = today;

		new_date = gif_date.ConvertGregorian (julian);
			the_data.next_day = new_date.da_day;
			the_data.next_month = new_date.da_mon;
			the_data.next_year = new_date.da_year;
		}
	else
		{
		the_data.next_day = the_data.real_day;
		the_data.next_month = the_data.real_month;
		the_data.next_year = the_data.real_year;
		}
	}

void alter::alter_help ()
	{
	bstring temp_filename = "IMPRO.HL2";
	bstring help_location = the_data.home + temp_filename;

	help the_help (the_mouse, help_location);

	the_help.show ();

	gr_clear ();
	display_all ();
	}


void alter::set_occur ()
	{
	gr_clear ();
	display_occur ();

	buttons[0].init (10,getmaxy()-70, "    Set To Occur Daily     ",TEXT);
	buttons[1].init (10,getmaxy()-100,"    Set To Occur Yearly    ",TEXT);
	buttons[2].init (10,getmaxy()-130,"  Set To Occur Only Once   ",TEXT);
	buttons[3].init (10,getmaxy()-160,"    A Historical Event     ",TEXT);
	buttons[4].init (10,getmaxy()-190," Use Advanced Calculations ",TEXT);
	buttons[5].init (10,getmaxy()-220,"          EXIT             ",TEXT);

	int exit = 0;
	int the_default = 3;

	if (the_data.occur_type1 == -1)
		the_default = 2;

	if (the_data.occur_type1 == 1)
		the_default = 0;

	if (the_data.occur_type1 == 4)
		the_default = 1;

	if (the_data.occur_type1 == 12)
		the_default = 2;

	if (the_data.occur_type1 == 13)
		the_default = 3;

	mouser 	read_mouse (buttons, 6, the_mouse, the_default);
	read_mouse.show();

	while (!exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		if ((option == -1 && keypress == 27) || option == 5)
			exit = -1;

		if (option == 0)
			{
			the_data.occur_type1 = 1;
			the_data.viewed = 1;
			exit = 1;
			}

		if (option == 1)
			{
			the_data.occur_type1 = 4;
			the_data.occur_type2 = 1;
			the_data.viewed = 1;
			exit = 1;
			}

		if (option == 2)
			{
			the_data.occur_type1 = 12;
			the_data.viewed = 1;
			exit = 1;
			}


		if (option == 3)
			{
			the_data.occur_type1 = 13;
			the_data.viewed = 4;
			exit = 1;
			}

		if (option == 4)
			{
			advance = 1;
			exit = 1;
			}

		}
	}



void alter::set_warning ()
	{
	gr_clear ();
	display_warning ();

	int spacing = 0;

	buttons[0].init (getmaxx()/2-80,120,"   NO WARNING    ",TEXT);

	for (int i = 1; i <= 9; i++)
		{
		bstring the_warning;
		the_warning += " A ";
		the_warning += char(i+48);
		the_warning += " Day Warning ";
		buttons[i].init (getmaxx()/2-80,120+spacing+(i*30),the_warning.return_string(),TEXT);

		if (i == 3)
			spacing = 20;
		}

	buttons[10].init (getmaxx()/2-80,90,"      EXIT       ",TEXT);

	int exit = 0;

	mouser 	read_mouse (buttons, 11, the_mouse, the_data.warning);
	read_mouse.show();


	while (!exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		if ((option == -1 && keypress == 27) || option == 10)
			exit = -1;

		if (option >= 0 && option < 10)
			{
			the_data.warning = option;
			exit = 1;
			}
		}
	}

void alter::set_level()
	{
	gr_clear ();
	display_level ();

	buttons[0].init (289,200,"  Nonessential  ",TEXT);
	buttons[1].init (289,170,"    Important   ",TEXT);
	buttons[2].init (289,140," Very Important ",TEXT);
	buttons[3].init (289,230,"      EXIT      ",TEXT);

	int exit = 0;

	int the_default = the_data.occur_level - 1;

	if (the_default < 0)
		the_default = 2;

	mouser 	read_mouse (buttons, 4, the_mouse, the_default);
	read_mouse.show();

	while (!exit)
		{

		char keypress;
		int option = read_mouse.get (keypress);

		if ((option == -1 && keypress == 27) || option == 3)
			exit = -1;

		if (option >= 0 && option < 3)
			{
			the_data.occur_level = option+1;
			exit = 1;
			}
		}
	}


void alter::display_all ()
	{

	display_lines();

	buttons[4].init ((getmaxx()-75),(getmaxy()-30)," DONE ",TEXT);
	buttons[9].init ((getmaxx()-195),(getmaxy()-30)," SAVE & EXIT ",TEXT);
	buttons[10].init((getmaxx()-260),(getmaxy()-30)," Help ",TEXT);

	display_level ();

	display_warning ();

	display_next ();

	display_occur ();

/*	for (int i = 0; i < 4; i++)
		the_lines[i].show(); */

	}


void alter::display_next ()
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	outtextxy (15,getmaxy()-140,"The event is set to occur next on: ");

	gifford	date_manip;

	bstring the_date;
	the_date += " ";
	the_date += date_manip.MonthName (the_data.real_month);
	the_date += " ";
	if (the_data.real_day > 9)
		{
		int t_d = the_data.real_day/10;
		int o_d = the_data.real_day - t_d*10;

		the_date += char(t_d+48);
		the_date += char(o_d+48);
		}
	else
		the_date += char(the_data.real_day+48);

	the_date += ", ";
	int tyr = the_data.real_year/1000;
	int hyr = (the_data.real_year-tyr*1000)/100;
	int teyr = (the_data.real_year-tyr*1000-hyr*100)/10;
	int oyr = (the_data.real_year-tyr*1000-hyr*100-teyr*10);

	the_date += char(tyr+48);
	the_date += char(hyr+48);
	the_date += char(teyr+48);
	the_date += char(oyr+48);
	the_date += " ";

	buttons[7].init (295,getmaxy()-150,the_date.return_string(),TEXT);
	}

void alter::display_lines ()
	{
	bstring	line_info;
	line_info = " Line x ";

	for (int i = 0; i < 4; i++)
		{
		the_lines[i].init (100,29+(i*25),66,0,0);
		the_lines[i].preset (the_data.note[i].return_string());
		line_info[6] = char (i+49);
		buttons[i].init (10,20+(i*25),line_info.return_string(),TEXT);
		}
	}

void alter::display_level ()
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	outtextxy (10,150, "This event is classified as being: ");

	if (the_data.occur_level == -1)
		buttons[5].init (289,140," THIS NEEDS TO BE SET ",TEXT);
	else
		{
		switch (the_data.occur_level)
			{
			case 1:
				buttons[5].init (289,140," Nonessential ",TEXT);
				break;
			case 2:
				buttons[5].init (289,140," Important ",TEXT);
				break;
			case 3:
				buttons[5].init (289,140," Very Important ",TEXT);
				break;
			}
		}
	 }

void alter::display_warning ()
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	outtextxy (10,240,"The warning indicates how many days before the event the user is notified");
	outtextxy (10,250,"the event is going to occur.  For this event the warning is set at:");

	if (!the_data.warning)
		buttons[6].init (getmaxx()/2-80,260,"   NO WARNING    ",TEXT);
	else
		{
		bstring the_warning;
		the_warning += " A ";
		the_warning += char(the_data.warning+48);
		the_warning += " Day Warning ";
		buttons[6].init (getmaxx()/2-80,260,the_warning.return_string(),TEXT);
		}
	}

void alter::display_occur ()
	{
	gifford	date_manip;
	bstring the_text;

	if (the_data.occur_type1 == 13)
		the_text = "This is a historical event - an event that does not update or disappear.";

	if (the_data.occur_type1 == 12) // a one time event
		the_text = "This event is a one time event.";

	if (the_data.occur_type1 != 12 && the_data.occur_type1 != -1 &&
		the_data.occur_type1 != 13)
		the_text = "This event is set to occur ";

	if (the_data.occur_type1 == -1) // not set
		the_text += "THIS NEEDS TO BE SET";

	if (the_data.occur_type1 == 1) // daily
		the_text += "daily.";

	if (the_data.occur_type1 == 4)
		{
		the_text += "on ";
		the_text += date_manip.MonthName (the_data.real_month);
		the_text += " ";

		if (the_data.real_day > 9)
			{
			int t_m = the_data.real_day / 10;
			int o_m = the_data.real_day - (t_m * 10);
			the_text += char(t_m+48);
			the_text += char(o_m+48);
			}
		else
			the_text += char(the_data.real_day + 48);

		the_text += " every ";
		the_text += this_often ();
		the_text += "year";
		if (the_data.occur_type2 > 2)
			the_text += "s";
		the_text += ".";
		}

	if (the_data.occur_type1 != 1 && the_data.occur_type1 != 4 &&
		the_data.occur_type1 != 12 && the_data.occur_type1 != -1
		&& the_data.occur_type1 != 13)
		the_text += "using advanced calculations.";

	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	if (the_data.occur_type1 == -1)
		setcolor (LIGHTMAGENTA);

	outtextxy (15,getmaxy()-40,the_text.return_string());

	setcolor (BLACK);

	buttons[8].init (10,getmaxy()-70," How often ",TEXT);
	}

void alter::write3d (int y,char *text)
	{
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(BLACK);
	outtextxy(getmaxx()/2,y,text);
	setcolor(WHITE);
	outtextxy((getmaxx()/2)-1,y-1,text);
	}


bstring alter::this_often ()
	{
	bstring result;

	switch (the_data.occur_type2)
			{
			case 1:
				result = "";
				break;
			case 2:
				result = "other ";
				break;
			default:
				result += char(the_data.occur_type2 + 48);
				result += " ";
				break;
			}
	return (result);
	}

void alter::gr_clear ()
	{
	the_mouse.hide();
	setfillstyle (SOLID_FILL,LIGHTBLUE);
	bar (0,0,getmaxx(),getmaxy());
	}
