#include <ctype.h>
#include "gifford.h"
#include "jgmatch.h"
#include <fstream.h>
#include <assert.h>
#include "data.h"

data::data () : note(4)
	{
	initialized = 0;
	}

data::data (bstring hme) : note(4)
	{
	initialized = 1;
	file_name = hme;
	file_name += "DATA.001";
	location = -1;
	erase();
	}

data::data (bstring hme, long int loc) : note(4)
	{
	file_name = hme;
	file_name += "DATA.001";
	location = loc;
	int read_result = read();
	assert (read_result != 0); // assert didn't exceed file boundry
	if (read_result < 0)
		{
		location = 0;
		erase();
		}
	}

data::~data()
	{
	}

void data::erase ()
	{
	for (int i = 0; i < 4; i++)
		note[i] = "";
	next_year = -1;
	occur_level = -1;
	real_year = -1;
	warning = 0;
	occur_type1 = -1;
	occur_type2 = 0;
	occur_type3 = 0;
	occur_type4 = 0;
	occur_type5 = 0;
	occur_type6 = 0;
	viewed = 1; // 1 = not viewed, 3 = deleted
	next_month = -1;
	next_day = -1;
	real_month = -1;
	real_day = - 1;
	occur_length = 0;
	}

void data::init (bstring hme)
	{
	initialized = 1;
	home = hme;
	file_name = hme;
	file_name += "DATA.001";
	location = -1;
	erase();
	}

void data::init (bstring hme, long int loc)
	{
	initialized = 1;
	home = hme;
	file_name = hme;
	file_name += "DATA.001";
	location = loc;
	int read_result = read();
	assert (read_result != 0); // assert didn't exceed file boundry
	if (read_result < 0)
		{
		location = 0;
		erase();
		}
	}


long int data::search (bstring the_string, long int loc)
	{
	long int result = quicksearch (the_string, loc);

	read();

	return result;
	}


long int data::quicksearch (bstring the_string, long int loc)
	{
	assert (initialized);

	char	this_char;

	if (loc == 0)
		loc = location;

	location = loc;

	fstream	file;
	file.open (file_name, ios::in | ios::nocreate);

	if (!file)
		return (-1);

	file.seekg (((location-1)*340L), ios::beg);

	while (file >> viewed) // check if more info exists & if this message is deleted
		{
		if (viewed != 3)
			{
			for (int i = 0; i < 4; i++)
				{
				bstring temp_note (66);
				// seek to location, note i
				file.seekg (((location-1)*340L)+61L+(70L*i), ios::beg);
				while (file.get(this_char) && this_char != '"')
					{
					char upper_char = toupper(this_char);

					temp_note += upper_char;
					}

				jgmatch matcher(the_string, temp_note);

				int match_found = matcher.is_match();

				if (match_found)
					{
					file.close();
					return (location);
					}

				}
			}
		location++;
		file.seekg (((location-1)*340L), ios::beg);
		}

	location = -1;

	file.close ();

	return 0;
	}


long int data::find (int month, int day, int year, long int loc)
	{
	long int result = quickfind (month, day, year, loc);

	read();

	return result;
	}

long int data::quickfind (int month, int day, int year, long int loc)
	{
	assert (initialized);
	assert (month > 0);
	assert (year > 0);
	assert (day > 0);

	if (loc == 0)
		loc = location;

	location = loc;

	fstream file;

	file.open (file_name, ios::in | ios::nocreate);

	if (!file)
		return (-1);

	file.seekg (((location-1)*340L), ios::beg);

	while (file >> viewed)
		{
		file >> next_year;
		file >> next_month;
		file >> next_day;

		if (viewed != 3 && viewed != 4)
			{
			gifford	g_date;

			unsigned short f_date = g_date.ConvertJulian (next_day,
						next_month, next_year);
			unsigned short t_date = g_date.ConvertJulian (day,
						month, year);

			if (f_date <= t_date)
				{
				file >> occur_level;
				file.close ();

				return (location);
				}
			}

		location = location + 1L;

// change below to ios::cur seek

		file.seekg (((location-1)*340L), ios::beg);

//		file.seekg (xL, ios::cur);
		}

	location = -1;

	file.close();

	return 0;
	}

long int data::realfind (int month, int day, int year, long int loc)
	{
	long int result = realquickfind (month, day, year, loc);

	read();

	return result;
	}

long int data::realquickfind (int month, int day, int year, long int loc)
	{
	assert (initialized);
	assert (month > 0);
	assert (year > 0);
	assert (day >= 0);

	if (loc == 0)
		loc = location;

	location = loc;

	fstream file;

	file.open (file_name, ios::in | ios::nocreate);

	if (!file)
		return (-1);

	file.seekg (((location-1)*340L), ios::beg);

	while (file >> viewed)
		{
		file >> next_year;
		file >> next_month;
		file >> next_day;
		file >> occur_level;
		file >> real_year;
		file >> real_month;
		file >> real_day;

		if (viewed != 3 && day && real_year == year && real_month == month &&
		    real_day == day)
		    {
		    file.close();

		    return (location);
		    }

		if (viewed != 3 && !day && real_year == year && real_month == month)
			{
			file.close();

			return (location);
			}

		location = location + 1L;

// change below to ios::cur seek

		file.seekg (((location-1)*340L), ios::beg);
		}

	location = -1;

	file.close();

	return 0;
	}


int data::remove ()
	{
	viewed = 3;

	return (write());
	}

int data::read ()
	{
	assert (initialized);

	char	this_char;

	fstream file;

	file.open (file_name, ios::in | ios::nocreate);

	if (!file)
		return (-1);

// change below
	file.seekg (((location-1)*340L), ios::beg);

	if (!(file >> viewed))
		return (0);

	file >> next_year;

	file >> next_month;
	file >> next_day;

	if (viewed == 3) // 3 = deleted
		return (-2);

	file >> occur_level;
	file >> real_year;
	file >> real_month;
	file >> real_day;
	file >> warning;
	file >> occur_type1;
	file >> occur_type2;
	file >> occur_type3;
	file >> occur_type4;
	file >> occur_type5;
	file >> occur_type6;
	file >> occur_length;

	for (int i = 0; i < 4; i++)
		{
		bstring temp_note(66);

// seek past first quotation mark
		file.seekg (((location-1)*340L)+61L+(70L*i), ios::beg);
		while (file.get(this_char) && this_char != '"')
			temp_note += this_char;

		note[i] = temp_note;
		}

	file.close();

	return (1);
	}

int data::write ()
	{
	assert (initialized);

	int found_location = 0;

	if (location > 0)
		found_location = 3; // viewed == 3, so this conforms to
				    // that specification.

	fstream file;

	file.open (file_name,ios::in | ios::out	| ios::nocreate);

	if (!file)
			return (-1);

// change below
	file.seekg (0L, ios::beg);

	if (found_location == 0)
		{
		location = 1;

		while (file >> found_location && found_location != 3)
			{
			location += 1;
// change below
			file.seekg (((location-1)*340L), ios::beg);
			}
		}

	file.close();

	if (found_location != 3)
		{
		file.open (file_name,ios::out |
			ios::binary | ios::nocreate | ios::app);
		if (!file)
			return (-1);
		}
	else
		{
		file.open (file_name,ios::out | ios::in |
			ios::binary | ios::nocreate);
		if (!file)
			return (-1);

// change below
		file.seekg (((location-1)*340L), ios::beg);
		}

	file << viewed << "\r\n";

	file << next_year << "\r\n";// next_year

	if (next_month < 10)
		{
		file << " ";
		}
	file << next_month << "\r\n";// next_month

	if (next_day < 10)
		{
		file << " ";
		}
	file << next_day << "\r\n";// next_day

	file << occur_level << "\r\n";

	file << real_year << "\r\n";// real_year

	if (real_month < 10)
		{
		file << " ";
		}
	file << real_month << "\r\n";// real_month

	if (real_day < 10)
		{
		file << " ";
		}
	file << real_day << "\r\n";// real_day

	file << warning << "\r\n";
	if (occur_type1 < 10)
			{
			file << " ";
			}
	file << occur_type1 << "\r\n";
	file << occur_type2 << "\r\n";
	file << occur_type3 << "\r\n";
	file << occur_type4 << "\r\n";
	file << occur_type5 << "\r\n";
	if (occur_type6 < 10)
		{
		file << " ";
		}
	file << occur_type6 << "\r\n";
	file << occur_length << "\r\n";

	for (int k = 0; k < note.length(); k++)
		{
		file << '"';
		file << note[k];
		file << '"';
		for (int i = note[k].length(); i <= 65; i++)
			file << ' ';
		file << "\r\n";
		}

	file.close();

	return (location);
	}

long int data::get_loc ()
	{
	return location;
	}

void data::set_next (int month, int day, int year)
	{
	assert (initialized);

	next_year = year;
	next_month = month;
	next_day = day;
	}

void data::set_real (int month, int day, int year)
	{
	assert (initialized);

	real_year = year;
	real_month = month;
	real_day = day;
	}

void data::set_occurance (int type1, int type2, int type3, int type4,
		int type5, int type6)
	{
	assert (initialized);

	occur_type1 = type1;
	occur_type2 = type2;
	occur_type3 = type3;
	occur_type4 = type4;
	occur_type5 = type5;
	occur_type6 = type6;
	}

int operator == (const data one, const data two)
	{
	int result = 1;

	if ((one.viewed == two.viewed)
		&&(one.next_year == two.next_year)
		&&(one.next_month==two.next_month)
		&&(one.next_day==two.next_day)
		&&(one.occur_level==two.occur_level)
		&&(one.real_year==two.real_year)
		&&(one.real_month==two.real_month)
		&&(one.real_day==two.real_day)
		&&(one.warning==two.warning)
		&&(one.occur_type1==two.occur_type1)
		&&(one.occur_type2==two.occur_type2)
		&&(one.occur_type3==two.occur_type3)
		&&(one.occur_type4==two.occur_type4)
		&&(one.occur_type5==two.occur_type5)
		&&(one.occur_type6==two.occur_type6)
		&&(one.occur_length==two.occur_length)
		&&(one.note.length()==two.note.length()))
		{
		for (int k = 0; k < one.note.length(); k++)
			{
			if (one.note[k].length() != two.note[k].length())
				result = 0;
			else
				{
				for (int j = 0; j < one.note[k].length(); j++)
					{
					if (one.note[k][j] != two.note[k][j])
						result = 0;
					}
				}
			}
		}
	else
		result = 0;

	return result;
	}