#include <graphics.h>
#include <stdlib.h>
#include "gifford.h"
#include <dos.h>
#include "setup.h"
#include <fstream.h>

setup::setup(bstring home)
	{
	file_name = home;
	file_name += "DATA.000";
	}

setup::~setup()
	{
	}

int setup::get_info ()
	{
	ifstream	file;

	file.open(file_name,ios::in | ios::nocreate);

	if (!file)
		return (-1);

	file >> screen_type;
	file >> version;

// julian install date
	file >> id_1;
// julian install date / 69 + 13
	file >> id_2;
// julian install date / 497 + 11
	file >> id_3;

	file.close();

	return (checksum());
	}

int setup::checksum ()
	{
	if (id_1 / 69 + 13 != id_2)
		return 1;
	if (id_1 / 497 + 11 != id_3)
		return 1;

	struct date d;
	getdate (&d);
	gifford gif;

	unsigned int check = gif.ConvertJulian (d.da_day,d.da_mon,d.da_year);

	if (id_1+90 < check)
		return 4;

	if (id_1+45 < check)
		return 3;

	if (id_1+30 < check)
		{
		return 2;
//		int winlose = rand() % 3;

//		if (winlose == 2)
//			return 2;
		}
	return 0;
	}

void setup::grclear(int the_color)
	{
	setfillstyle(SOLID_FILL,the_color);
	bar(0,0,getmaxx(),getmaxy());
	}

void setup::display()
	{
//	setgraphbufsize(1086420U);

	switch (screen_type)	{
		case 0:
			screen.VGA_480_16();
			break;
		case 1:
			screen.VGA_350_16();
			break;
		case 2:
			screen.VGA_200_16();
			break;
		case 3:
			screen.VGA_200_256();
			break;
		}
	}
