/*--------------------------------------------------------------------------
 * filecopy the class
 *
 * Original Code by Ed Mulroy 1992
 * Modified by Al Gifford 1993
 * Modified into a class by Jeff Goke 1994 (no major internal changes)
 *
 * Original code was written to demonstrate a file copy from inside a C
 * program.  This code is a function which can be easily included into your
 * code to allow you to copy files from one directory to another.
 *
 * If you get errors indicating there is not enough memory, you can either
 * decrease the size of the copy buffer, or you can increase the size of
 * your memory model.
 *
 * There are still many changes which could be made to this function.  Feel
 * free to do so.
 *
 * Version 1.10 - added some features that users requested
 *              - error checking on reads & writes
 *              - setting DOS' verify flag on
 *              - reporting DOS error messages
 *              - writes are of the number actually read
 *                rather than the number requested to be read
 *
 * Version 1.20 - Changed copy program example to a function call.
 *              - free'd copy buffer after function call.
 *              - modified new file's time and date stamp to accurately
 *                reflect the time and date stamp of the original file.
 *
 * permission granted for any private or commercial use
 *
 */


#ifndef __DUTIL_H
#define __DUTIL_H

class dutil
	{
	public:
		dutil ();
		~dutil ();
		int fcopy(char *file1,char *file2,int overwrite=1);
		// set overwrite == 0 not to automatically overwrite
		// duplicate files.
		/* returns:
			0 - success
			2 - Not enough memory to run program
			3 - Error opening source file
			4 - Error creating destination file
			5 - Read file error
			6 - Write file error
			7 - Input file close error
			8 - Output file close error
			9 - File exists, will not overwrite
			    If fcopy returns this simply delete the file
			    then use fcopy again!

		*/
	private:
		int save_verify;                  /* save the old value of the verify flag */

	};

#endif /* __DUTIL_H */