/* class written by jeff goke, jjgoke@cs.csbsju.edu -- (c) 1994.
   this class may be freely used/distributed as long as credit is
   given to the author, jeff goke */


#include <ctype.h>
#include <fstream.h>
#include <dos.h>
#include "gifford.h"
#include "mouser.h"
#include "vector.h"
#include "dutil.h"
#include <dir.h>
#include <graphics.h>
#include "prepare.h"
#include "gui.h"
#include <conio.h>
#include <iostream.h>
#include "bstring.h"
#include "seperate.h"

void say_goodbye ();

void autoexec_edit (bstring copy_to);
int yes_no (bstring message);
void an_error (int error);
void write3d (int y,char *text);
void okay (void);
void gr_clear (void);
extern Mcursor the_mouse;

main (int argc, char *argv[])
	{
	the_mouse.init();
	the_mouse.arm();
	the_mouse.show ();

/*	clrscr ();

	cout << "Please note that INTERMEM Professional requires 16-color 640x480 VGA graphics.\n";
	cout << "If you do not have this graphic capability, this install program and INTERMEM\n";
	cout << "Professional will fail to work properly.\n\n";

	cout << "Press any key to continue installation . . . \n";

	getch();

	clrscr(); */

	seperate	*sep = new seperate ();
	bstring home = sep->home (argv[0]);

	delete sep;

	prepare		*prep = new prepare (home, the_mouse);
	prep->show ();

	int exit = 0;

	bstring dest;

	while (!exit)
		{
		dest = prep->destination ();

		if (dest[dest.length()-1] == '\\')
			dest = dest(0,dest.length()-1);

		if (dest.length () >= 5)
			{
			if (dest[dest.length()-1] == 'O' && dest[dest.length()-2] == 'R'
				&& dest[dest.length()-3] == 'P'
				&& dest[dest.length()-4] == 'M'
				&& dest[dest.length()-5] == 'I')
				exit = 0;
			else
				exit = 1;
			}
		else
			exit = 1;
		}


	delete prep;

	mkdir (dest);

	dest += "\\";

	dutil	util;

	write3d (getmaxx()/2,"One moment, copying files . . .");

	vector <bstring>	files(13);

// don't copy many of these files in registered version
// like register.me, install.exe, setup.pcx.
// do copy file_id.diz and say, registered verson: don't distribute
//	files[0] = "REGISTER.ME";
	files[0] = "README.TXT";
//	files[2] = "INSTALL.EXE";
	files[1] = "IMPRO.EXE";
//	files[4] = "SETUP.PCX";
	files[2] = "DATA.ICN";
	files[3] = "IMPRO.HL1";
	files[4] = "IMPRO.HL2";
	files[5] = "IMPRO.HL3";
	files[6] = "IMPRO.HL4";
//	files[10] = "FILE_ID.DIZ";
	files[7] = "IMSETUP.DAT";
	files[8] = "DATA.001";

	bstring from;
	bstring to;

	int overwrite = 0;

	for (int i = 0; i < 7; i++)
		{
		from = home + files[i];
		to = dest + files[i];

		int error = 0;

		int done = 0;

		while (!done)
			{
			error = util.fcopy (from.return_string(), to.return_string(),overwrite);

			if (overwrite == 0 && error == 9)
				{
				gr_clear ();

				int answer = yes_no ("Another version of INTERMEM exists, update?");

				if (answer == 0)
					{
					closegraph();
					return (1);
					}
				else
					overwrite = 1;

				gr_clear ();

				write3d (getmaxx()/2,"One moment, copying files . . .");

				error = 0;
				}
			else
				done = 1;
			}

		if (error)
			{
			an_error (error);

			write3d (getmaxy()/2-30,"Error #0001 occured while trying to copy the files.  Installation cancelled.");

			okay ();

			closegraph ();
			return (-1);
			}
		}
		// copy data file 001

	from = home + files[7];
	to = dest + files[8];

	int error = util.fcopy (from.return_string(), to.return_string(),0);


	if (error == 9)
		{
		gr_clear ();

		int answer = yes_no ("Keep your previous data file?");

		error = 0;

		if (answer == 0)
			error = util.fcopy (from.return_string(), to.return_string());

		gr_clear ();

		write3d (getmaxx()/2,"One moment, copying files . . .");
		}

	if (error)
		{
		an_error (error);
		write3d (getmaxy()/2-30,"Error #0002 occured while trying to copy the files.  Installation cancelled.");

		okay ();

		closegraph ();
		return (-1);
		}


	ofstream		file;

	bstring        dest_filename = "DATA.000";
	bstring data_file = dest + dest_filename;

	file.open (data_file.return_string());

	file << "0\r\n";
	file << "103\r\n";

	gifford gif;

	struct date d;

	getdate (&d);

	unsigned short today =	gif.ConvertJulian (d.da_day,d.da_mon,d.da_year);

	file << today << "\r\n";
	file << today/69+13 << "\r\n";
	file << today/497+11 << "\r\n";

	file.close ();

	gr_clear ();


	autoexec_edit (dest);

	say_goodbye ();

	closegraph ();

	return 0;
	}

int yes_no (bstring message)
	{
	vector<Button> buttons(2);

	flushkeys ();


	Bevel yesno;
	yesno.init (122, 185, 396, 100, THICK);
	yesno.show ();

	write3d (205,message.return_string());


	buttons[0].init(250,245," Yes ",TEXT);
	buttons[1].init(340,245," No ",TEXT);

	mouser 	read_mouse (buttons, 2, the_mouse, 0);
	read_mouse.show();

	int the_exit = 0;

	while (!the_exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		if (option == 0 || (option == -1 && tolower(keypress) == 'y'))
			return 1;
		if (option == 1 ||  (option == -1 && tolower(keypress) == 'n'))
			return 0;
		if (option == -1 && keypress == 27) // escape
			{
			closegraph ();

			clrscr ();

			cprintf ("INTERMEM Professional installation was canceled by the user.\n\n\n");

			exit (1);
			}

		}
	return 0;
	}

void say_goodbye ()
	{
	gr_clear ();

	write3d (10,"VERY IMPORTANT INFORMATION");
	write3d (55, "You MUST reboot for the changes to your AUTOEXEC.BAT to take place.");
	write3d (75,"Once you reboot, at any DOS prompt type IMPRO (ie: C:\\>IMPRO) to run INTERMEM.");
	write3d (95,"INTERMEM Professional automatically displays any waiting events you have");
	write3d (115,"every time you turn on your computer.");

	write3d (155,"The first time you boot up you will see a list of every event currently");
	write3d (175,"set to occur.  You may edit/delete these events as you see fit.  When you");
	write3d (195,"are done click DONE & SAVE and INTERMEM will be ready for normal use.");

	write3d (getmaxy ()-175,"The file README.TXT contains important information you should read.");

	write3d (getmaxy ()-115,"Click DONE or hit ESCAPE at any menu to GO BACK A MENU.  Hit EXIT");
	write3d (getmaxy ()-95,"or ESCAPE when at the main calendar (dark blue background) to");
	write3d (getmaxy ()-75,"QUIT TO DOS or WINDOWS.");

	write3d (getmaxy ()-40,"This freeware program is provided to you as-is by");
	write3d (getmaxy ()-20,"Jeff Goke");

	okay ();
	}

void autoexec_edit (bstring copy_to)
	{
	bstring	real;
	bstring the_copy;

	gr_clear ();

	write3d (getmaxy () /2 - 100,"Unless you are replacing a previous version of INTERMEM PRO, your AUTOEXEC.BAT");
	write3d (getmaxy () /2 - 80,"file needs to be modified.");

	int doit = yes_no ("Have INTERMEM automatically make the changes?");

	if (!doit)
		{
		gr_clear ();
		bstring the_message = "You must add ";
		the_message += copy_to;
		write3d (30,copy_to.return_string());
		write3d (50,"to your autoexec's PATH statement.  You must also add the line");
		write3d (70,"IMPRO -a to the end of your AUTOEXEC.BAT file (before you call");
		write3d (90,"DOSSHELL or WIN).  See the documentation for more information.");
		return;
		}

	bstring incoming;

	real = "C:\\AUTOEXEC.BAT";
	the_copy = "C:\\AUTOEXEC.IM";

	gr_clear ();

	write3d (getmaxy () /2 - 20, "INTERMEM:  Backuping up autoexec.bat to autoexec.im");

	dutil	util;

	int error = util.fcopy (real.return_string(), the_copy.return_string());

	if (error)
		{
		gr_clear ();

		write3d (getmaxy ()/2 - 50, "INTERMEM could not copy your AUTOEXEC.BAT file.  Please read the");
		write3d (getmaxy ()/2 - 30, "section INSTALLING INTERMEM MANUALLY in the file IMPORTNT.DOC");

		okay ();

		return;
		}

	write3d (getmaxy () /2, "INTERMEM:  Removing old autoexec.bat");

	remove(real.return_string());

	write3d (getmaxy () /2 + 20, "INTERMEM:  Modifying autoexec.bat");

	vector<bstring> scan(3);

	scan[0] = "PATH";
	scan[1] = "WIN";
	scan[2] = "DOSSHELL";

	fstream user_read;
	fstream user_write;

	user_read.open (the_copy.return_string(),ios::in | ios::out | ios::binary
		| ios::nocreate);

	user_write.open (real.return_string(),ios::out | ios::binary);

	if (!user_read || !user_write)
		{
		gr_clear ();

		write3d (getmaxy ()/2 - 50, "An error occured modifying your AUTOEXEC.BAT file.  Please read the");
		write3d (getmaxy ()/2 - 30, "section INSTALLING INTERMEM MANUALLY in the file IMPORTNT.DOC");

		user_write.close ();
		user_read.close();

		okay ();

		return;
		}

	int yes;
	char	a_line [330];


	int last = 0;


	while (user_read.getline (a_line,320))
		{
		int now = 0;
		incoming = a_line;

		if (incoming.length () > 3)
			{
			int i = 0;
			int correct = 0;
			int correct_2 = 0;
			int correct_3 = 0;

			while (incoming[i] == ' ' && i < incoming.length())
				i++;


			int j = i;
			int k = i;

			while (i < incoming.length() && scan[0][correct] == toupper(incoming[i]))
				{
				i++;
				correct++;
				}

			while (j < incoming.length() && scan[1][correct_2] == toupper(incoming[j]))
				{
				j++;
				correct_2++;
				}


			while (k < incoming.length() && scan[2][correct_3] == toupper(incoming[k]))
				{
				k++;
				correct_3++;
				}


			if (correct == scan[0].length())
				{
				if (last == 0)
					{
					// move past spaces, etc.
					while (i < incoming.length() && (incoming[i] == ' ' || incoming[i] == '='))
						i++;

					user_write << "PATH " << copy_to << ';';
					while (i < incoming.length())
						{
						user_write << incoming[i];
						i++;
						}
					user_write << endl;
					yes = 1;
					now = 1;
					}
				last = 2;
				}

			if (correct_2 == scan[1].length())
				user_write << "IMPRO -a" << endl;

			if (correct_3 == scan[2].length())
				user_write << "IMPRO -a" << endl;
			}

		if (last > 0)
			last--;

		if (!now)
			user_write << (incoming) << endl;
		else
			now = 0;
		}
	if (yes != 1)
		user_write << "PATH=" << copy_to << ";%PATH%" << endl;


	if (incoming[incoming.length()-1] != '\r' && incoming[incoming.length()-1] != '\n')
		user_write << endl;


	user_write << "IMPRO -a" << endl;

	user_write.close();
	user_read.close();

	return;
	}

void an_error (int error)
	{
	gr_clear ();

	switch (error)
		{
		case 2:
			write3d (getmaxy()/2-50,"Insufficient Memory.");
			break;
		case 3:
			write3d (getmaxy()/2-50,"Could not find an essential file.  Obtain a new copy of IMPRO and try again.");
			break;
		case 4:
			write3d (getmaxy()/2-50,"Error writing file.  Disk full?");
			break;
		case 5:
			write3d (getmaxy()/2-50,"Error in an essential file.  Try obtaining a new copy of IMPRO and trying again.");
			break;
		case 6:
			write3d (getmaxy()/2-50,"Error writing to disk, is it full?");
			break;
		case 7:
			write3d (getmaxy()/2-50,"Error closing source file.");
			break;
		case 8:
			write3d (getmaxy()/2-50,"Error closing destination file.");
			break;
		}
	}

void write3d (int y,char *text)
	{
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(BLACK);
	outtextxy(getmaxx()/2,y,text);
	setcolor(WHITE);
	outtextxy((getmaxx()/2)-1,y-1,text);
	}


void gr_clear (void)
	{
	the_mouse.hide();
	setfillstyle (SOLID_FILL,BLUE);
	bar (0,0,getmaxx(),getmaxy());
	}

void okay (void)
	{
	flushkeys ();

	vector <Button> buttons(1);

	buttons[0].init(getmaxx()/2-20,245," OK ",TEXT);

	mouser 	read_mouse (buttons, 1, the_mouse, 0);
	read_mouse.show();

	int exit = 0;

	while (!exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		if (option == 0)

		exit = 1;
		}
	}
