*   JDB.PRG demonstrates how to interface the JCAL utilities, J2GBIN
*   and G2JBIN to dBase III+.
set talk off
set bell off
set century on  && this is needed for a 4 digit year
set status off
set menu off
set safety off
set function 2 to 'do jdb;'
set function 3 to 'modi comm jdb;'
set function 4 to 'copy file jdb.bak to jdb.dbf;'
load g2jbin
load j2gbin
clear
text
Each record of the database contains a name, a Gregorian date (date type)
and a Jewish date (string type).

By selecting "1" from the menu you can view and edit the dates.

Then by selecting "2" or "3" from the menu you can have the JCAL utilities
update the corresponding dates.

endtext
wait

* file structure of jdb.dbf:
* NAME  CHARACTER   15
* GDATE DATE         8
* JDATE CHARACTER   10

use jdb
do while .t.
    clear
    ? ' 1  Edit/View Database'
    ? ' 2  Update All Jewish Dates'
    ? ' 3  Update All Gregorian Dates'
    ? ' 4  Quit'
    ?
    Accept '   Make a choice  ' to choice
    clear
    if .not. choice $'1234'
        ?? chr(7)
        loop
    endif
    do case
        case choice='1'
            goto top
            browse
        case choice='2'
            goto top
            do while .not. eof()
                store dtoc(gdate) to param
***   pad with leading zeros to bring to length of 10 characters
                param=replicate('0',10-len(param))+param
                call g2jbin with param
                replace jdate with param
***  param in previous line contains the Jewish date string returned from g2jbin
                skip
            enddo
        case choice='3'
            goto top
            do while .not. eof()
                store trim(jdate) to jparam  && get rid of trailing blanks
***   pad with leading zeros to bring to length of 10 characters
                jparam=replicate('0',10-len(jparam))+jparam
                call j2gbin with jparam
                store ctod(jparam) to tempdate
***  jparam in previous line contains the Gregorian date string returned from j2gbin
                replace gdate with tempdate
                skip
            enddo
        case choice='4'
            close database
            release module g2jbin
            release module j2gbin
            exit
    endcase
enddo
