/* event.c: Make an entry in the dates file for reminder, using
 * full-screen input editing.
 *
 * This version is for MS-DOS only, using the CXL library (v5.0).
 *
 * By Richard J. Reiner, rreiner@vm1.yorku.ca (BITNET),
 * grad3077@writer.yorku.ca (Internet).  2 Dec 89.
 *
 * Derived from remind.c by Ken Van Camp, ARDEC, October 1987.
 *
 *
 * exit codes:	0 -- normal completion
 *				1 -- error opening reminders file
 *				2 -- user abort
 *
 *
 * event leaves the screen undisturbed: it pops up, and restores
 * the obscured area on exit.  this is intended for applications
 * like the following batch file:
 *
 *		echo off
 *		cls
 *		cal
 *		event
 *
 * where cal is like the *nix utility of the same name (which shows
 * the current month's calendar when called w/o parms).  This batch
 * file leaves the calendar visible while the user is in event.
 *
 */

/*
 *	11-18-89	RjR		Port of remind.c to MS C.  Uses ".\dates".
 *  12-02-89	RjR		Renamed to event.c; calls to getdata() and
 *						getdata() itself replaced with CXL code;
 *						output fixed to not leave a space after the
 *						time if the time is blank.
 */

#define DATEFILE ".\\dates"

#include <fcntl.h>
#include <stdio.h>
#include <string.h>

#include <cxl\cxldef.h>
#include <cxl\cxlvid.h>
#include <cxl\cxlwin.h>
#include <cxl\cxlstr.h>

int fsread(void);
void initcxl(void);
int validnocolon(char *);
char *strrtrim(char *);

FILE	*fd;
char	line[256],
		event[128],
		person[128],
		tim[20],
		dat[30],
		ndays[10];


main(int argc,char **argv)
{
	if (argc > 1)
	{
		if ((fd = fopen (argv[1], "a")) == NULL)
		{
			fprintf(stderr,"event: error: can't open file '%s'\n",argv[1]);
			exit(1);
		}
	}
	else
	{
		if ((fd = fopen (DATEFILE, "a")) == NULL)
		{
			fprintf(stderr,"event: error: can't open file '%s'\n",DATEFILE);
			exit(1);
		}
	}

	initcxl();

	if (fsread() != W_ESCPRESS)
		if (*tim != '\0')
			fprintf(fd,"%s:%s:%s %s:%s:N\n", dat, ndays, tim, event, person);
		else
			fprintf(fd,"%s:%s:%s:%s:N\n", dat, ndays, event, person);
	else
	{
		fprintf(stderr,"\nevent: error: user abort\n");
		fclose(fd);
		exit(2);
	}

	fclose(fd);
	fprintf(stderr,"\nevent: done\n");
	exit(0);
}


/*---------------------------------------------------------------------------*/
/* fsread -- input a record in full-screen mode */
int fsread(void)
{
	WINDOW editwin;
	int editstat;

	editwin=wopen( 9, 1,18,78,1,LGREY|_BLACK,LGREY|_BLACK);
	wcenters(0,LMAGENTA|_BLACK,"Enter event for reminder");

	/* set up defaults */
	*event=*person=*tim=*dat=*ndays='\0';
	strcpy(dat,sysdate(3));
	strcpy(ndays,"3");

	winpbeg(LGREY|_BLACK,BLACK|_LGREY);
		wprints( 2, 1,LGREY|_BLACK,"Event:");
		winpdef( 2,14,event ,"*************************************************************",0,1,validnocolon,0);
		wprints( 3, 1,LGREY|_BLACK,"Person:");
		winpdef( 3,14,person,"*************************************************************",0,1,validnocolon,0);
		wprints( 4, 1,LGREY|_BLACK,"Time (hhmm):");
		winpdef( 4,14,tim,   "<012>#<012345>#",                                              0,1,validnocolon,0);
		wprints( 5, 1,LGREY|_BLACK,"Date:");
		winpdef( 5,14,dat,   "********",                                                     0,1,validnocolon,0);
		wprints( 6, 1,LGREY|_BLACK,"Days notice:");
		winpdef( 6,14,ndays, "%%%",                                                          0,1,validnocolon,0);
	editstat=winpread();

	wclose();

	/* kill all the trailing whitespace */
	strrtrim(event);
	strrtrim(person);
	strrtrim(tim);
	strrtrim(dat);
	strrtrim(ndays);

	return (editstat);
}


/*---------------------------------------------------------------------------*/
/* initialize CXL video and keyboard handling */
void initcxl(void)
{
    _vinfo.dvcheck=0;				// don't check for DESQview
	videoinit();
    _vinfo.usebios=0;
	wfillch('');					// background char for windows
	wsetesc(1);						// set ESC checking on
}


/*---------------------------------------------------------------------------*/
/* make sure input contains no colons */
int validnocolon(char *s)
{
	char *colptr;

	if ((colptr=strchr(s,':')) == NULL)
		return 0;
	else
	{
		beep();
		return (colptr - s + 1);
	}
}


/*---------------------------------------------------------------------------*/
/* strrtrim -- kill trailing whitespace in a string */
char *strrtrim(char *s)
{
	char *p;
	p=s + strlen(s) - 1;	/* point at the last data char */

	while (*p==' ' || *p=='\t' || *p=='\n' || *p=='\r')
		p--;

	*(++p)='\0';

	return(s);
}