/*----------------------------------*/
/*  Types commonly used by DV API.  */
/*----------------------------------*/
typedef char BOOLEAN;
typedef unsigned char BYTE;
typedef unsigned long ULONG;
typedef void far *HANDLE;
typedef unsigned int SEGMENT;

/* Field table header. */
typedef struct {
   char nFields;                             /* # fields              */
   char Bits;                                /* screen behaviour bits */
                                             /*   see FTH* below      */
   char CurrInp;                             /* current input field   */
                                             /*   ***read-only***     */
   char CurrSel;                             /* current select field  */
                                             /*   ***read-only***     */
   char AttrSel1;                            /* attr if pointed at    */
   char AttrSel2;                            /* attr if selected      */
} FT_HEADER;

/* Field table entry. */
typedef struct {
   char SRow, SCol;                          /* start row/col            */
   char ERow, ECol;                          /* end row/col              */
   char Type;                                /* field type               */
                                             /*   see FTE* below         */  
   char Modifier;                            /* modifier                 */
                                             /*   if input fld see FTE*  */
                                             /*   else 1st key           */
   char Colour;                              /* colour of select field   */
   char Key2;                                /* for select fld, 2nd key  */
} FT_ENTRY;


/*----------------*/
/*  Definitions.  */
/*----------------*/
#define MAGIC            0x1b                /* introduces stream commands */
#define NIL_OBJ          ((HANDLE) 0)        /* null object handle */
                                             /* also means use my whatever */

/* Types of objects returned by type_obj(). */
#define NOT_AN_OBJ       0
#define WINDOW           8                   /* nb: same as TASK */
#define TASK             8                   /* nb: same as WINDOW */
#define MAILBOX          9
#define KEYBOARD         10
#define TIMER            11
#define OBJECTQ          12
#define POINTER          15
#define PANEL            16

/* Keyboard behaviour bits. */
#define KBD_FIELD        0x01                /* field mode */
#define KBD_HARDCURSOR   0x02                /* hardware cursor displayed */
#define KBD_INSERT       0x04                /* insert mode active */
#define KBD_NOWAIT       0x08                /* no wait while input ongoing */
#define KBD_FILTER       0x10                /* filter keys via SETESC */
#define KBD_EXCLUSIVE    0x20                /* exclusive input */
                                             /*   nb: DV v2.2+ */

/* Types of stream commands. */
#define S_WINDOW         0x00                /* window streams */
#define S_QUERY          0x01                /* query streams */
#define S_MANAGER        0x10                /* manager streams */

/* 
 * Logical attributes. They correspond to the colours on the palette.
 * By themselves, they give the foreground colour; multiplied by 16,
 * they give the background colour.
 */
#define ATTR_NORMAL      1
#define ATTR_HINORM      2
#define ATTR_HELP        3
#define ATTR_HIHELP      4
#define ATTR_ERROR       5
#define ATTR_HIERROR     6
#define ATTR_EMPH        7
#define ATTR_MARKED      8
#define ATTR_REVERSE     8                   /* add to others */

/* Screen behaviour for select fields as specified in field table header. */
#define FTH_READARRAY    0x01                /* data returned as array */
#define FTH_READALL      0x02                /* data returned, all fields */
#define FTH_READMOD      0x03                /* data returned, mod fields */
#define FTH_AUTORESET    0x04                /* reset mod bits automaticly */
#define FTH_CONTENTS     0x08                /* return contents, not 1/0 */
#define FTH_RIGHTMB      0x10                /* right mouse ends entry */
#define FTH_LEFTMB       0x20                /* left mouse ends entry */
#define FTH_MOUSE        0x30                /* either mouse ends entry */
#define FTH_KBDSELECT    0x40                /* kbd selects fields too */

/* Types of fields possible. */
#define FTE_INACTIVE     0x00
#define FTE_OUTPUT       0x40
#define FTE_INPUT        0x80
#define FTE_DESELECT     0xc0
#define FTE_SELECT       0xc2

/* Field modifiers. */
#define FTE_CURSOR       0x04                /* return as cursor leaves fld */
                                             /*   API level 2.02+           */
#define FTE_CLEAROLD     0x08                /* clear field with 1st key */
#define FTE_UPCASE       0x10                /* force input to uppercase */
#define FTE_JUSTIFY      0x20                /* right justify (numbers) */
#define FTE_JUMPFULL     0x40                /* auto move when field full */
#define FTE_AUTOCR       0x80                /* auto CR when field full */


/*------------------------*/
/*  Function prototypes.  */
/*------------------------*/
/* Low-level functions to communicate with DV API */
HANDLE send_DVstream(HANDLE window, BYTE *stream);

/* Miscellaneous functions */
void giveup_tslice(void);
void sound_tone(int freq, int ticks);
void begin_critical(void);
void end_critical(void);
void set_api(int vers);
void set_cstyle(BOOLEAN flag);
int isdv(void);

/* Fields */
void clear_fld(HANDLE window, BYTE field);
void fill_fld(HANDLE window, BYTE field, BYTE fillchar);
void colour_fld(HANDLE window, BYTE field, BYTE colour);
void write_fld(HANDLE window, BYTE field, char far *buf, int len);
void set_cursor_fld(HANDLE window, BYTE field);
void set_type_fld(HANDLE window, BYTE field, BYTE ftype);
void set_header_fld(HANDLE window, FT_HEADER far *header);
void scroll_fld(HANDLE window, BYTE field, BYTE direction);
void reset_fld(HANDLE window);
void read_fld(HANDLE window, BYTE field, BYTE * buf);
void get_entry_fld(HANDLE window, BYTE field, FT_ENTRY *entry);
int get_size_fld(HANDLE window, BYTE field);
BYTE get_type_fld(HANDLE window, BYTE field);
void get_header_fld(HANDLE window, FT_HEADER *header);

/* Keyboards */
HANDLE my_kbd(void);
HANDLE id_kbd(HANDLE task);
HANDLE create_kbd(void);
void free_kbd(HANDLE task);
void read_kbd(HANDLE key, BYTE far * far *buf, int far *len);
void write_kbd(HANDLE key, BYTE far *buf, int len, int status);
void set_priority_kbd(HANDLE key, long priority);
long get_priority_kbd(HANDLE key);
long sizeof_kbd(HANDLE key);
void set_bits_kbd(HANDLE key, int bits);
void reset_bits_kbd(HANDLE key, int bits);
void open_kbd(HANDLE window, HANDLE key);
void close_kbd(HANDLE key);
void erase_kbd(HANDLE key);
int check_kbd(HANDLE key);

/* Mailboxes */
HANDLE my_mbx(void);
HANDLE id_mbx(HANDLE task);
HANDLE create_mbx(void);
void free_mbx(HANDLE task);
void read_mbx(HANDLE task, BYTE far * far *buf, long far *len);
void write_mbx(HANDLE task, BYTE far *msg, long len);
void set_priority_mbx(HANDLE mbox, long priority);
long get_priority_mbx(HANDLE mbox);
long sizeof_mbx(HANDLE task);
void addto_mbx(HANDLE mbox, BYTE far *msg, long len, int status);
void write_ptr_mbx(HANDLE mbox, BYTE far *msg, long len, int status);
void open_mbx(HANDLE task);
void close_mbx(HANDLE task);
void erase_mbx(HANDLE mbox);
int check_mbx(HANDLE mbox);
void name_mbx(HANDLE mbox, char far *mboxname, int len);
void lock_mbx(HANDLE mbox);
HANDLE find_mbx(char far *mboxname, int len);
   
/* Objects and object queues */
int is_obj(HANDLE object);
HANDLE my_obq(void);
HANDLE id_obq(HANDLE task);
HANDLE read_obq(HANDLE task);
void addto_obq(HANDLE task, HANDLE object);
long sizeof_obq(HANDLE task);
void remove_obq(HANDLE task, HANDLE object);
void open_obq(HANDLE task);
void close_obq(HANDLE task);
void erase_obq(HANDLE task);
int check_obq(HANDLE task);
int type_obj(HANDLE object);

/* Panels */
HANDLE create_pan(void);
void free_pan(HANDLE panel);
void dir_pan(HANDLE panel, BYTE far *pfile, int far *len);
int write_pan(HANDLE panel, HANDLE window, char far *pname,\
   int len, HANDLE far *win_ret, HANDLE far *key_ret);
int get_count_pan(HANDLE panel);
int open_pan(HANDLE panel, char far *pfilename, int len);
void close_pan(HANDLE panel);
int check_pan(HANDLE panel);

/* Tasks */
extern long task_inbuf;
extern BYTE task_orphan;
void restart_tsk(SEGMENT task);
void post_tsk(SEGMENT task);
void stop_tsk(SEGMENT task);
HANDLE create_tsk(char *titel, int len, int rows, int cols, BYTE *stk, \
     int stksiz, void (*entry) (void));
void free_tsk(HANDLE task);


/* Timers */
HANDLE create_tim(void);
void free_tim(HANDLE timer);
ULONG read_tim(HANDLE timer);
void set_tim(HANDLE timer, ULONG secths);
void set_priority_tim(HANDLE timer, ULONG priority);
ULONG get_priority_tim(HANDLE timer);
ULONG get_elapsed_tim(HANDLE timer);
ULONG get_remain_tim(HANDLE timer);
void addto_tim(HANDLE timer, ULONG secths);
void open_tim(HANDLE timer);
void close_tim(HANDLE timer);
void erase_tim(HANDLE timer);
int check_tim(HANDLE timer);

/* Windows */
void put_char_win(SEGMENT window, BYTE chr, BYTE atr);
HANDLE my_win(void);
HANDLE create_win(char far *titel, int len, int rows, int cols, int inbuf);
void free_win(HANDLE task);
void read_win(HANDLE window, BYTE far *buf, int far *len);
HANDLE write_win(HANDLE window, BYTE far *buf, int len);
void set_lcurpos_win(HANDLE window, BYTE row, BYTE col);
void set_pos_win(HANDLE window, BYTE row, BYTE col);
void set_size_win(HANDLE window, BYTE rows, BYTE cols);
void set_viewport_win(HANDLE window, BYTE rows, BYTE cols);
void set_vsize_win(HANDLE window, BYTE rows, BYTE cols);
void move_win(HANDLE window, char rows, char cols);
void resize_win(HANDLE window, char rows, char cols);
void unhide_win(HANDLE window);
void hide_win(HANDLE window);
void set_colour_win(HANDLE window, BYTE colour);
void redraw_win(HANDLE window);
void make_systop_win(HANDLE window);
void make_top_win(HANDLE window);
void make_bot_win(HANDLE window);
int sizeof_win(HANDLE window);
int get_width_win(HANDLE window);
void fill_win(HANDLE window, int fillchar);
void erase_win(HANDLE window);
void read_chars_win(HANDLE window, BYTE far *buf, int far *len);
int display_err_win(HANDLE window, char far *buf, int len, \
   int rows, int cols, int beep, int buttons);
int get_rows_win(HANDLE window);
int get_cols_win(HANDLE window);
int get_vrows_win(HANDLE window);
int get_vrows_win(HANDLE window);
void get_size_win(HANDLE window, BYTE *rows, BYTE *cols);
void get_viewport_win(HANDLE window, BYTE *rows, BYTE *cols);
void get_vsize_win(HANDLE window, BYTE *rows, BYTE *cols);

