/*---------------------------------------------------------
* SYSLOG.H
* $Revision:   1.0  $
* $Date:   19 Mar 1990 19:04:28  $
*----------------------------------------------------------*/

#define SL_MAX_MSG_SIZE (256)

#define SL_LINK	(0x01)
#define SL_UNLINK	(0x02)
#define SL_MSG 	(0x03)

#define SL_LINK_QUIET 	(0x01)
#define SL_UNLINK_QUIET	(0x01)
#define SL_MSG_URGENT	(0x01)

/* Format of Link message
**
** Total length: n bytes
**
**	Ofs	Length	Description
**	---	------	-----------
**  0			1		Message type == 0
**  1		   1		Control flags
**  2	     n-2	   Program name
**
**
**  Control flags:
**		Bit 0: 		0 == announce link
**				 		1 == do not announce link
**	   Bits 1 - 7: reserved 
**
*/

/* Format of Unlink message 
**
** Total length: n bytes
**
**	Ofs	Length	Description
**	---	------	-----------
**  0			1		Message type == 1
**  1		   1		Control flags
**  2	     n-2	   Program name
**
**  Control flags:
**		Bit 0: 		0 == announce unlink
**				 		1 == do not announce unlink
**	   Bits 1 - 7: reserved 
*/


/* Format of Msg message 
**
** Total length: n bytes
**
**	Ofs	Length	Description
**	---	------	-----------
**  0			1		Message type == 2
**  1		   1		Control flags
**  2		  n-2		Message
**
**  Control flags:
**		Bit 0: 		0 == normal message
**				 		1 == urgent message
**	   Bits 1 - 7: reserved 
*/
