;                                                                           ;
;                       ATTRIB.S  v1.04   01-31-1999                        ;
;                     Copyright 1997-1999, Charles Dye                      ;
;                       email:  raster@highfiber.com                        ;
;                                                                           ;
;       This is source for Eric Isaacson's shareware assembler, A86.        ;
;       Re-assemble by typing A86 ATTRIB.S.                                 ;
;                                                                           ;
;       This program is copyrighted, but may be freely distributed          ;
;       under the terms of the Free Software Foundation's GNU General       ;
;       Public License v2 (or later.)  See the file COPYING for the         ;
;       legalities.  If you did not receive a copy of COPYING, you          ;
;       may request one from the Free Software Foundation, Inc.,            ;
;       59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           ;
;       ABSOLUTELY NO WARRANTY -- use it at your own risk!                  ;
;                                                                           ;

radix 16                               ; gentlemen prefer hex

doscall macro                          ; call to dos int_21 with a
mov ah,#1                              ; one-byte function in ah
int 21
#em

doscall2 macro                         ; call to dos int_21 with a
mov ax,#1                              ; two-byte function in ax
int 21
#em

dosprint macro                         ; call to dos string-print function
mov dx,offset #1
mov ah,09
int 21
#em

zprint macro                           ; call to program's asciiz-print
mov di,offset #1                       ; subroutine
call zprint1
#em

zero macro                             ; zero a 16-bit register
xor #1,#1
#em

bomb macro                             ; jump to handler for various errors
call bombs_away                        ; does not return!
dw #1                                  ; inline:  address of error message
db #2                                  ; inline:  errorlevel return code
#em


fn_max   equ  0050                     ; max number of characters in filename


country  equ  005c                     ; put country data in the psp
country_date equ country + 00          ; local date format, usa-eur-japan
country_thou equ country + 07          ; local thousands char (',' in usa)
country_dsep equ country + 0b          ; local date separator ('-' in usa)
country_tsep equ country + 0d          ; local time separator (':' in usa)
country_time equ country + 11          ; local time format (0 12hr, 1 24hr)

temp         equ  006e                 ; local temp variable (byte or word)

a_altered    equ  0070                 ; new attributes for file


; -------------------------------------- START OF CODE:

begin:
doscall2 3000                          ; check ms-dos version:
cmp al,02
ja dos_okay
bomb msg_err_dos_bad,17                ; complain and exit with errorlevel 23
dos_okay:
cmp bh,0fd                             ; running under freedos?
jne not_freedos                        ; if not, never mind
jcxz freedos_fix
cmp cx,0ffff                           ; early beta dos-c kernel?
jne not_freedos
freedos_fix:                           ; if so, fix attributes mask
or w [mask_4301],0010                  ; so subdir bit is passed to 21/4301
not_freedos:
mov ax,sp                              ; examine stack pointer:
cmp ax,stack_end                       ; plenty of room?
jae > l1
trs_80:                                ; not enough memory:
bomb msg_trs_80,11                     ; complain and exit with errorlevel 17
l1:
mov sp,stack_end                       ; reduce stack size
push cs
pop es
mov bx,(stack_end / 10) + 2
doscall 4a                             ; and shrink program's memory block
jc trs_80

call get_country_info                  ; get current country info
mov dx,offset dta
doscall 1a                             ; set up disk transfer area
call get_vga_lines                     ; figure default scroll length
mov b [last_dir_shown],00              ; note directory name not displayed

mov si,0080                            ; read from command line

parse_main:                            ; PRIMARY PARSER LOOP:
inc si
switch_done:
mov al,b [si]                          ; examine next character
call force_uc                          ; in uppercase:
call test_eol                          ; end of line?
je parse_done                          ; if so, terminate primary parser
call test_space                        ; is it a space?
je parse_main                          ; if so, ignore it
cmp al,'/'                             ; is it a switch character?
je found_switch                        ; if so, interpret it
cmp al,'+'
je found_op                            ; plus is set-attribute operator
cmp al,'-'
je found_op                            ; minus is clear-attribute operator
cmp al,'~'
je found_op                            ; tilde is toggle-attribute operator
cmp al,','
je found_comma                         ; microsoft undocumented feature
mov bx,w [pointer_pointer]             ; otherwise, this is the start of a
mov w [filespec_pointers+bx],si        ; filespec; remember it
inc bx
inc bx
mov w [pointer_pointer],bx             ; save pointer to start of filespec
cmp bx,0040                            ; too many filespecs?
jb l2                                  ; if so,
bomb msg_err_specs_galore,10           ; complain and exit with errorlevel 16
l2:
call parse_fn                          ; parse through the filespec
mov al,b [si]
call test_eol                          ; if the end of the line was found,
je parse_done                          ; terminate primary parser
jmp parse_main                         ; otherwise, keep on truckin'

found_op:                              ; plus, minus, tilde operator :
jmp handle_operator                    ; jump to handler
found_comma:                           ; comma operator :
jmp handle_comma                       ; jump to handler

found_switch:                          ; FOUND A SWITCH CHARACTER:
inc si
lodsb                                  ; examine next character
call force_uc                          ; in uppercase:
mov bx,0ffff                           ; start at beginning of switch table
l0:
inc bx
cmp b [switches+bx],00                 ; run out of legal switches to try?
je syntax                              ; if so, syntax error
cmp b [switches+bx],al                 ; found this letter in table?
jne l0                                 ; if not, keep looking
shl bx,01                              ; multiply .bx by two
mov ax,w [switch_routines+bx]          ; and get address of switch routine
jmp ax                                 ; to jump to

syntax:                                ; SYNTAX ERROR IN COMMAND LINE:
call error_out
dosprint msg_syntax                    ; print error message
doscall2 4c10                          ; and exit with errorlevel 16

parse_done:                            ; DONE WITH PRIMARY PARSER:
mov bx,w [pointer_pointer]
or bx,bx                               ; found any filespecs at all?
jne > l1
mov ax,offset everything_cr
mov w [filespec_pointers],ax           ; if not, slip in a star-dot-star-cr
inc bx
inc bx
l1:
zero ax
mov w [filespec_pointers+bx],ax        ; add a null to end of list
mov w [pointer_pointer],ax             ; and point to the start of the list

call hook_int_24                       ; disable critical-error handling
call alloc_tree_buffer                 ; create buffer for /s tree if needed
call alloc_list_buffer                 ; get buffer for file list
call template_fix                      ; transfer template bits to chgattr
call prompt_fix                        ; check usage of /p
call fix_paging                        ; disable paging if output redirected

big_loop:                              ; LOOP THROUGH COMMAND-LINE FILESPECS:
mov bx,w [pointer_pointer]
mov ax,w [filespec_pointers+bx]        ; get offset of command-line filespec
or ax,ax                               ; have we run out yet?
je big_loop_done                       ; if so, exit
add w [pointer_pointer],0002           ; otherwise, point to next filespec
mov si,ax
call parse_fn                          ; and parse this one
call clean_up_filespec                 ; canonicalize it

filespec_loop:
call get_fn_from_list                  ; read filespec from list, if needed
jc big_loop                            ; if eof, back for next user filespec
subdir_loop:
call alter_multiple_files              ; alter files matching this filespec
call find_any_subdirs                  ; add any subdirectories to tree buff.
call use_next_subdir                   ; is there a subdirectory in buffer?
jnc subdir_loop                        ; if so, alter any files in it
test b [flags],04                      ; using a file list?
jne filespec_loop                      ; if so, get next filespec from it
jmp big_loop

big_loop_done:                         ; done with all user filespecs:
call show_file_count
call show_total_counts                 ; display num. of files found, changed
doscall2 4c00                          ; exit with errorlevel 0

parse_tfn:                             ; READ TEMPLATE FILENAME:
mov w [tfn_attr],0016                  ; directories are okay, hidden, etc.
and b [flags],0fe                      ; turn off quote mode
or b [flags],04                        ; turn on at-mode
mov di,offset tfbuf                    ; point to template filename buffer
jmp parse_fn_0

parse_fn:                              ; READ FILESPEC FROM COMMAND LINE:
and b [flags],0fa                      ; turn off quote-mode and at-mode
mov di,offset fnbuf                    ; point to filespec buffer
parse_fn_0:
mov cl,00                              ; no characters yet
mov b [di],cl                          ; empty the buffer

parse_fn_1:                            ; parse filename loop:
lodsb                                  ; get a character from command line
call force_uc                          ; and force it to uppercase
cmp al,'?'
je > l0                                ; found a wildcard in the filespec?
cmp al,'*'
jne > l1                               ; if not, never mind
l0:
and b [tfn_attr],0ef                   ; if so, disallow subdirectories
l1:
call test_eol                          ; end of line?
je parse_fn_eol                        ; if so, handle it
call test_space                        ; space or tab?
je parse_fn_space                      ; if so, handle it
cmp al,'"'                             ; quote mark?
je parse_fn_quote                      ; if so, handle it
cmp al,'/'                             ; forward slash?
jne > l2
mov al,'\'                             ; if so, convert to backslash
l2:
cmp al,'@'                             ; at sign?
jne parse_fn_char                      ; no, treat like a normal character
cmp cl,00                              ; yes:  got any characters yet?
jne parse_fn_char                      ; yes:  at sign is part of filename
test b [flags],05                      ; quote-mode or at-mode?  if either,
jne parse_fn_char                      ; at sign is part of filename
or b [flags],04                        ; note:  file list
jmp parse_fn_1                         ; continue parsing

parse_fn_char:                         ; NORMAL CHARACTER IN FILENAME:
mov ah,00
mov w [di],ax                          ; stash it, and null-terminate buffer
inc di
inc cl                                 ; increment count of characters
cmp cl,fn_max                          ; buffer overflow?
jb parse_fn_1                          ; if not, continue parsing
bomb msg_err_fn_ovf,10                 ; complain and exit with errorlevel 16

parse_fn_eol:                          ; FOUND THE END OF COMMAND LINE:
cmp cl,00                              ; found a filename yet?
jne > l0                               ; if not,
bomb msg_err_in_filespec,10            ; complain and exit with errorlevel 16
l0:
dec si                                 ; let the primary parser see it
ret                                    ; and we're done parsing the filespec

parse_fn_space:                        ; FOUND A SPACE IN THE FILESPEC:
test b [flags],01                      ; parsing between quotes?
jne parse_fn_char                      ; if so, treat like any other char
cmp cl,00                              ; any characters in filespec yet?
jne > l1                               ; if not,
bomb msg_err_in_filespec,10            ; complain and exit with errorlevel 16
l1:
dec si                                 ; if so, we're done parsing filespec
ret

parse_fn_quote:                        ; found a quote mark:
test b [flags],01                      ; has an opening quote been found?
jne parse_close_quote                  ; if so, this is a close quote
cmp cl,00                              ; is the filename empty?
jne parse_fn_char                      ; if not, quote is part of filename
or b [flags],01                        ; note that open quote was found
jmp parse_fn_1                         ; and continue parsing
parse_close_quote:
cmp cl,00                              ; empty filename?
jne ret                                ; if so,
bomb msg_err_in_filespec,10            ; complain and exit with errorlevel 16


alter_multiple_files:                  ; ALTER FILES MATCHING CURRENT SPEC:
call append_short_filespec             ; add user's filespec
mov dx,offset fnbuf                    ; point to working filespec
mov cl,b [find_attr]
mov ch,00
doscall 4e                             ; find first matching file
alter_multi_1:
jc ret                                 ; any error, exit loop
cmp b [dta_name],'.'
je alter_multi_next
call show_cur_dir_maybe                ; display current directory if need be
add w [found_lo],0001                  ; add one to count of files found
adc w [found_hi],0000
call alter_file                        ; do it to it!
call pause_check
alter_multi_next:
doscall 4f                             ; find next matching file
jmp alter_multi_1                      ; till the cows come home

alter_file:                            ; CHANGE FILE ATTRIBUTES IF NEEDED :
mov al,b [chgattr]
or al,b [newattr]                      ; are both chgattr and newattr zero?
cmp al,00
jne > l44
jmp l9                                 ; if so, don't alter attributes
l44:
call append_found_filespec             ; copy filename into fnbuf
mov cl,b [dta_attr]                    ; .cl contains file's old attributes
test b [more_flags],04                 ; was ~z specified on command line?
je > l55                               ; if not, ~z fix not needed
test cl,07                             ; if any bit of s h or r is set,
je > l55
or cl,07                               ; pretend they're all set!
l55:                                   ; .cl contains old attribs with ~z fix
mov ah,b [chgattr]
xor ah,0ff
mov al,b [newattr]
and al,ah                              ; .al contains attributes to toggle
xor cl,al                              ; .cl attributes have been toggled
mov al,b [chgattr]
and al,b [newattr]                     ; .al contains attributes to set
or cl,al                               ; .cl attributes have been set
mov al,b [chgattr]
xor al,0ff
or al,b [newattr]                      ; .al inverse of bits to clear
and cl,al                              ; .cl attributes have been cleared
cmp cl,b [dta_attr]                    ; is this a significant change?
je > l9                                ; if not, don't bother
mov b [a_altered],cl                   ; save new attributes for file
call prompt_user                       ; prompt user if so desired
jne > l9                               ; if user declined, do not alter
mov cl,b [a_altered]
and cx,w [mask_4301]                   ; clear the subdirectory bit
mov dx,offset fnbuf
doscall2 4301                          ; and use dos call to alter attribs
jc > l20                               ; any error, go to error handler
mov dx,offset fnbuf
doscall2 4300                          ; get file's new attributes to check
mov al,cl                              ; actual file attributes in .al
mov ah,b [a_altered]                   ; desired file attributes in .ah
and ax,2727                            ; only interested in these attributes
cmp al,ah                              ; do they match?
jne > l22                              ; if not, error!
mov al,b [a_altered]
mov b [dta_attr],al                    ; update attributes byte in the dta
l8:
add w [alter_lo],0001                  ; add one to count of files changed
adc w [alter_hi],0000
l9:
call show_file_info                    ; display filename, attribs, date etc.
call show_bytes_maybe                  ; display 'bytes' string if needed
jmp crlf                               ; terminate print line and exit
l22:                                   ; error was not reported by dos :
mov b [dta_attr],cl                    ; update dta with actual attributes
zero ax                                ; pretend this is dos error zero
l20:                                   ; error was reported by dos :
push ax                                ; save dos error number
call show_file_info                    ; show file name, size, date, etc.
dosprint msg_failed                    ; print 'failed' message
pop ax                                 ; get dos error number
or ax,ax                               ; was it zero?
je > l24                               ; if so, don't display number
call decout                            ; if not, display dos error number
l24:
add w [error_lo],0001                  ; add one to the count of failures
adc w [error_hi],0000
call crlf                              ; end of line
ret                                    ; and exit

show_file_info:                        ; DISPLAY FILE'S DATE, TIME, ATTRIBS:
test b [more_flags],10
jne > l1                               ; if output is to the screen,
mov dl,0d                              ; move cursor to the start of the line
doscall 02
l1:
dosprint msg_info_space_4              ; tab in four spaces
call show_cur_filename                 ; and display current filename
mov al,b [dta_attr]
call show_attribs                      ; display file's attributes
mov ax,w [dta_date]
call show_dow                          ; compute and show day of week
mov ax,w [dta_date]
call show_date                         ; display file's date stamp
dosprint msg_info_space
mov ax,w [dta_time]
call show_time                         ; display file's time stamp
call show_size                         ; display file size
ret

find_any_subdirs:                      ; FIND SUBDIRECTORIES, ADD TO TREE BUF
test b [flags],08                      ; was /s specified?
je ret                                 ; if not, don't bother finding subdirs
mov si,offset star_dot_star            ; copy star-dot-star filespec
mov di,w [last_bs]                     ; just after the final backslash
inc di
call copy_string
cmp di,offset fnbuf + fn_max           ; did the copy overflow the buffer?
jna > l2                               ; no, continue
jmp error_fnbuf_over                   ; yes, crash and burn
l2:
mov dx,offset fnbuf
mov cx,0016                            ; look for subdir, hidden, system ...
doscall 4e
dir_loop:
jc dir_loop_exit                       ; any error, stop subdir search
test b [dta_attr],10                   ; is the item found a subdir?
je dir_loop_next                       ; if not, keep looking
cmp b [dta_name],'.'                   ; stupid dos . or .. entries?
je dir_loop_next                       ; if so, keep looking
call append_found_filespec             ; add subdir name to current dir name
mov es,w [tree_seg]
call find_es_zz                        ; find the end of the tree buffer
mov dx,si                              ; and remember where it was
mov di,si
mov si,offset fnbuf                    ; copy full pathname of found subdir
call copy_string_far                   ; into the tree buffer
mov cx,di
stosb                                  ; and add a second null
push ds
pop es
cmp cx,dx                              ; did we overflow the tree buffer?
jb tree_buffer_over                    ; if so, bomb out
dir_loop_next:                         ; look for next subdirectory:
doscall 4f                             ; dos find-next-handle function
jmp dir_loop
dir_loop_exit:                         ; done looking for subdirectories:
ret

tree_buffer_over:                      ; TREE BUFFER HAS OVERFLOWED:
bomb msg_tree_buffer_over,16           ; complain and exit with errorlevel 22

use_next_subdir:                       ; IS A DIRECTORY NAME BUFFERED?
test b [flags],08                      ; was /s specified?
jne > l1
l0:
stc                                    ; if not, exit with no new subdir
ret
l1:                                    ; /s was specified:
mov es,w [tree_seg]
cmp b [es:0000],00                     ; is there anything in the buffer?
je l0                                  ; if not, don't use it.  duh.
push ds
pop es
mov di,offset fnbuf                    ; es:di points to fnbuf
mov ds,w [tree_seg]
zero si                                ; ds:si points to start of tree buffer
call copy_string_far                   ; get directory name from buffer
cmp b [si],00                          ; was it the last name in the buffer?
jne > l4
mov w [0000],0000                      ; if so, empty the tree buffer
jmp > l6
l4:                                    ; if not,
zero di                                ; copy to the start of the tree buffer
mov es,w [cs:tree_seg]
l5:
lodsb                                  ; copy one byte from tree buffer
stosb                                  ; down into its new location
cmp al,00                              ; null marking end of one subdir name?
jne l5
cmp b [si],00                          ; if so, look for second (final) null
jne l5                                 ; and keep copying until you find it
stosb                                  ; store final null to new location
l6:
push cs                                ; restore
push cs
pop ds                                 ; data segment
pop es                                 ; and extra segment
call find_null_fnbuf                   ; find the end of fnbuf
mov w [last_bs],di
mov w [di],00 by '\'                   ; add a backslash and terminal null
clc                                    ; and exit with carry clear
ret                                    ; to indicate new dir. name present

show_total_counts:                     ; FINAL DISPLAY OF ALL FOUND, CHANGED:
call crlf                              ; print a blank line
dosprint msg_total_found               ; print 'Total found'
mov ax,w [total_found_lo]
mov dx,w [total_found_hi]
call dec_print_big                     ; and number found.
dosprint msg_num_altered               ; print ', changed'
mov ax,w [total_alter_lo]
mov dx,w [total_alter_hi]
call dec_print_big                     ; and number changed.
mov ax,w [error_lo]
or  ax,w [error_hi]                    ; were there any errors?
or ax,ax                               ; if not,
je > l10                               ; skip ahead
dosprint msg_num_errors                ; if there were, print 'errors'
mov ax,w [error_lo]
mov dx,w [error_hi]
call dec_print_big                     ; and the number of failures
l10:
call crlf                              ; terminate print line
ret                                    ; and exit.

handle_operator:                       ; FOUND A PLUS, MINUS OR TILDE:
mov cl,al                              ; save it
inc si
op_parse:
lodsb                                  ; examine next character
call force_uc                          ; in uppercase:
zero bx                                ; start at beginning of attrib table
l0:
cmp al,b [attributes+bx]               ; found the correct letter yet?
je > l2                                ; if so, go handle it
inc bx                                 ; if not, try the next letter
cmp bx,0004                            ; run out of letters yet?
jb l0                                  ; nope, keep looking
cmp al,'Z'                             ; yes; was the letter a Z ?
jne > l20
jmp attrib_z                           ; if so, go handle Z pseudo-attribute
l20:                                   ; unrecognized attribute letter :
cmp al,'!'
ja > l10                               ; if the 'letter' was a bang or below,
mov w [msg_err_odd_attr1+0],2021       ; patch the error message string to
mov w [msg_err_odd_attr1+2],2000       ; end in an exclamation point
jmp > l11
l10:                                   ; if the 'letter' was above a space,
mov b [msg_err_odd_attr1+1],al         ; poke it into the error message
l11:
bomb msg_err_odd_attr,10               ; complain and exit with errorlevel 16
l2:                                    ; found an attribute letter:
mov ah,b [attrib_values+bx]            ; get value of the attribute bit
l25:
test b [chgattr],ah
jne > l9                               ; has this attribute bit been set yet?
test b [newattr],ah                    ; if so, error -- go handle it
jne > l9
cmp cl,'~'                             ; tilde?
je > l5                                ; if so, toggle this attribute bit
cmp cl,'-'                             ; minus?
je > l4                                ; if so, clear this attribute bit
or b [chgattr],ah                      ; plus:  this bit will be changed
or b [newattr],ah                      ; this bit will be set
xor ah,0ff
jmp > l7                               ; remove bit from template mask, exit
l4:
or b [chgattr],ah                      ; minus:  this bit will be changed
xor ah,0ff
and b [newattr],ah                     ; this bit will be cleared
jmp > l7                               ; remove bit from template mask, exit
l5:
or b [newattr],ah                      ; tilde:  toggle this attribute bit
xor ah,0ff
and b [chgattr],ah                     ; instead of setting / clearing it
l7:
and b [template_mask],ah               ; remove bit from template mask
mov al,b [si]                          ; examine next character
call force_uc                          ; as uppercase
cmp al,'A'
jb > l75                               ; is it a letter?
cmp al,'Z'                             ; if not, done parsing operator
ja > l75
jmp op_parse                           ; if so, assume it's another attribute
l75:
jmp switch_done                        ; and exit
l9:                                    ; duplicate setting for attribute:
cmp al,'Z'                             ; was it the z attribute?
jne > l99                              ; no, skip over z fix
mov ah,b [chgattr]
or  ah,b [newattr]                     ; get the value of duplicated bits
mov al,'S'
test ah,04                             ; if bit 2 is set,
jne > l99                              ; assume it's the s bit
mov al,'H'
test ah,02                             ; if bit 1 is set,
jne > l99                              ; assume it's the h bit
mov al,'R'                             ; otherwise, assume it's the r bit
l99:
mov b [msg_err_multi_chg1],al          ; poke attribute letter into string
bomb msg_err_multi_chg,10              ; complain and exit with errorlevel 16
attrib_z:                              ; found the Z pseudo-attribute:
cmp cl,'~'                             ; after a tilde?
jne > l28
or b [more_flags],04                   ; if so, note the fact
l28:
mov ah,07                              ; load S, H, and R bits
jmp l25                                ; and handle normally

handle_comma:                          ; MICROSOFT UNDOCUMENTED FEATURE :
inc si                                 ; skip over the comma
cmp b [chgattr],00
jne > l9                               ; if either chgattr or newattr is
cmp b [newattr],00                     ; nonzero, do nothing and exit
jne > l9
test b [more_flags],20                 ; if a template file was specified,
jne > l9                               ; do nothing and exit
mov b [chgattr],27                     ; otherwise, clear all attributes
l9:
jmp switch_done                        ; done with comma handler

switch_c:                              ; /C -- TEMPLATE FILE
mov al,b [si]                          ; examine the next character
call test_colon                        ; colon or equals sign?
je > l1
jmp switch_c_err                       ; if not, automatic syntax error
l1:
test b [more_flags],20                 ; was there a previous /c ?
jne switch_c_dupe                      ; if there was, signal an error
inc si                                 ; skip over the colon
call parse_tfn                         ; parse the template filename
or b [more_flags],20                   ; note that we have a template file
mov dx,offset tfbuf                    ; use template filespec
mov cx,w [tfn_attr]                    ; and template attributes
doscall 4e                             ; attempt to locate matching file
jnc > l3
call error_out
dosprint msg_err_temp_open             ; problem -- print error message
zprint tfbuf                           ; and template filename
doscall2 4c12                          ; and exit with errorlevel 18
l3:
mov cl,b [dta_attr]                    ; get attributes of found file
and cl,27                              ; mask off unwanted bits
mov b [template_bits],cl               ; save new attributes
jmp switch_done                        ; done getting template attributes

switch_c_err:                          ; PROBLEM WITH /C SYNTAX :
call error_out
dosprint msg_err_sw_c
doscall2 4c10
switch_c_dupe:                         ; MORE THAN ONE /C PRESENT:
bomb msg_err_c_dupe,10                 ; complain and exit with errorlevel 16

switch_s:                              ; /S -- RECURSE INTO SUBDIRECTORIES
or b [flags],08
jmp switch_done

switch_p:                              ; /P /Q -- PROMPT USER, YES OR NO
or b [flags],40
jmp switch_done

switch_d:                              ; /D -- WILDCARDS MAY MATCH SUBDIRS
or b [flags],20
jmp switch_done

switch_h:                              ; /H -- DO NOT HOOK INT 24
or b [more_flags],08
jmp switch_done

switch_f_dupe:                         ; MORE THAN ONE /F ON COMMAND LINE:
bomb msg_err_dupe,10                   ; complain and exit with errorlevel 16

switch_f:                              ; /F -- DATE FORMAT
test b [flags],80                      ; has there already been a /f ?
jne switch_f_dupe                      ; if so, problem
or b [flags],80                        ; note it
mov al,b [si]                          ; examine the next character
call test_colon                        ; colon or equals sign?
jne switch_f_err                       ; if not, automatic syntax error
inc si                                 ; skip over colon
mov al,b [si]                          ; examine the next character
call force_uc                          ; in uppercase:
cmp al,'U'                             ; /f:u ?
je switch_f_u                          ; if so, force united states format
cmp al,'E'                             ; /f:e ?
je switch_f_e                          ; if so, force european date format
cmp al,'J'                             ; /f:j ?
je switch_f_j                          ; if so, force japanese date format
switch_f_err:                          ; PROBLEM WITH /F SYNTAX
call error_out
dosprint msg_err_sw_f                  ; complain
doscall2 4c10                          ; and exit with errorlevel 16
switch_f_u:
mov b [country_date],00                ; united states: use date format 0
inc si                                 ; skip over the u
jmp switch_done                        ; and exit
switch_f_e:
mov b [country_date],01                ; european: use date format 1
inc si                                 ; skip over the e
jmp switch_done                        ; and exit
switch_f_j:
mov b [country_date],02                ; japanese: use date format 2
inc si                                 ; skip over the j
jmp switch_done                        ; and exit

switch_m_err:                          ; PROBLEM WITH /M SYNTAX
call error_out
dosprint msg_err_sw_m                  ; display error message
doscall2 4c10                          ; and exit with errorlevel 16

switch_m:                              ; /M -- CONTROL PAGING
mov al,b [si]                          ; examine the next character:
cmp al,'?'                             ; is it a question mark?
je switch_m_err                        ; if so, display syntax help
call test_colon                        ; is the next character a colon?
jne > l1
inc si                                 ; if so, skip over it
mov al,b [si]                          ; and expect the next character
call test_digit                        ; to be a digit
jne switch_m_err                       ; colon but no digit = syntax error!
l1:                                    ; no colon:
call test_digit                        ; is the character a digit?
je > l3                                ; if so, skip ahead, get user value
mov al,b [vga_lines]
mov b [screen_lines],al                ; otherwise, default to 23 lines
jmp switch_done                        ; and return to main parse loop
l3:                                    ; user-specified paging value:
call get_num                           ; read it in
cmp ah,00                              ; more than 255?
jne switch_m_err                       ; if so, problem
mov b [screen_lines],al                ; otherwise, save it
jmp switch_done                        ; and exit

show_cur_dir_maybe:                    ; DISPLAY DIRECTORY NAME IF NEEDED:
cmp w [last_bs],0000                   ; is there a backslash in fnbuf?
je ret                                 ; if not, exit in disgust
mov si,offset fnbuf
mov di,offset last_dir_shown
l2:
lodsb
cmp al,b [di]
jne > l8
inc di
cmp si,w [last_bs]
jbe l2
cmp b [di],00
je ret
l8:
call show_file_count
call crlf                              ; display a blank line

show_cur_dir:
mov si,offset fnbuf                    ; point to start of filespec buffer
mov di,offset last_dir_shown
mov ah,02                              ; dos print-a-character function
l0:
cmp si,w [last_bs]                     ; passed the final backslash yet?
ja > l8                                ; if so, exit
mov dl,b [si]                          ; get a character from directory name
inc si
mov b [di],dl
inc di
int 21                                 ; and print it out
jmp l0                                 ; and loop back for more
l8:                                    ; done printing current directory name
mov b [di],00
call crlf                              ; terminate the current print line
ret                                    ; get outta here

show_cur_filename:                     ; DISPLAY FILENAME OF FOUND FILE:
mov di,offset dta_name                 ; point to start of found filename
mov ah,02                              ; dos print-a-character function
mov cx,000e                            ; must print 14 characters
l0:
mov dl,[di]                            ; get a character from filename
inc di
call petercase_dl                      ; force uppercase or lowercase
cmp dl,00                              ; found the terminal null yet?
je > l1
int 21                                 ; if not, print the character
dec cx                                 ; decrement the characters index
jmp l0                                 ; and loop back
l1:                                    ; done printing filename:
mov dl,20
l2:
int 21                                 ; print spaces
loop l2                                ; until 13 characters have been shown
ret                                    ; then quit

petercase_dl:
test b [dta_attr],10
jne > l4
cmp dl,'A'
jb ret
cmp dl,'Z'
ja ret
or dl,20
ret
l4:
cmp dl,'a'
jb ret
cmp dl,'z'
ja ret
and dl,0df
l5:
ret

show_date:                             ; display file's date stamp:
push ax                                ; stash date stamp
mov al,b [country_date]                ; check country's date format
cmp al,01
je show_datee                          ; 01, european date format
cmp al,02
je show_datej                          ; 02, japanese date format
pop ax
push ax                                ; file's date stamp:
and ah,01
mov cl,05
shr ax,cl                              ; get month value in al
mov ah,80                              ; suppress leading zeroes
call time_print                        ; print month
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax
push ax                                ; file's date stamp:
and al,1f                              ; get day value in al
mov ah,00                              ; print leading zeroes
call time_print                        ; print day
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax                                 ; file's date stamp:
mov cl,09
shr ax,cl                              ; get year value in al
add ax,01980xd                         ; and normalize
call decout                            ; print the year
ret

show_datee:                            ; show date, european:
pop ax
push ax                                ; file's date stamp:
and ax,001f                            ; get day value in al
or ah,80
call time_print                        ; print day without leading zeroes
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ah,01
mov cl,05
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax                                 ; file's date stamp:
mov cl,09
shr ax,cl                              ; get year value in al
add ax,01980xd                         ; and normalize
call decout                            ; print the year
ret

show_datej:                            ; show date, japanese:
pop ax
push ax                                ; file's date stamp:
mov cl,09
shr ax,cl                              ; get year value in al
add ax,01980xd                         ; and normalize
call decout                            ; print the year
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ah,01
mov cl,05
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,b [country_dsep]
doscall 02                             ; and the date separator
pop ax                                 ; file's date stamp:
and ax,001f                            ; get day value in al
jmp time_print                         ; print day with leading zeroes, exit

show_time:                             ; display file's time stamp:
push ax                                ; save time stamp for future reference
mov cl,0b
shr ax,cl                              ; get hour in al
cmp b [country_time],00                ; do the locals use a 24-hour clock?
jne show_time_20                       ; if so, skip all am / pm fiddling
mov b [msg_info_ampm+1],'a'            ; assume a.m.
cmp al,00                              ; is it midnight?
jne show_time_15                       ; no, continue ....
mov al,0c                              ; display midnight as '12 am'
jmp show_time_20
show_time_15:                          ; not midnight:
cmp al,0c                              ; is it before noon?
jb show_time_20                        ; if so, don't need to manipulate it
mov b [msg_info_ampm+1],'p'            ; noon or later:  display as 'pm'
cmp al,0c                              ; is it noon?
je show_time_20                        ; if so, display as '12 pm'
sub al,0c                              ; otherwise, normalize hours
show_time_20:                          ; done fiddling with hours:
mov ah,80                              ; suppress leading zeroes
call time_print                        ; and print hours
mov dl,b [country_tsep]
doscall 02                             ; followed by the time separator char
pop ax
push ax                                ; file's time stamp:
and ah,07
mov cl,05
shr ax,cl                              ; get minutes in al
call time_print                        ; print minutes with leading zeroes
mov dl,b [country_tsep]
doscall 02                             ; followed by the time separator char
pop ax                                 ; file's time stamp:
and ax,001f
shl ax,01
call time_print                        ; print seconds with leading zeroes
cmp b [country_time],00                ; do the locals use a 24-hour clock?
jne show_time_30
dosprint msg_info_ampm                 ; if not, display a.m. or p.m.
ret
show_time_30:
dosprint msg_info_space                ; if so, just print some blanks
ret

time_print:                            ; STUPID TWO-DIGIT DECIMAL PRINT:
mov dx,'0' by '0'
time_print_1:
cmp al,0a                              ; did i mention that it's stupid?
jb time_print_2
sub al,0a
inc dl                                 ; tens digit in .dl as ascii
jmp time_print_1
time_print_2:
add dh,al                              ; ones digit in .dh as ascii
test ah,80                             ; supposed to suppress leftmost zero?
je time_print_3
cmp dl,'0'                             ; if so, is the tens digit a zero?
jne time_print_3
mov dl,20                              ; if both true, convert it to a space
time_print_3:
mov ah,02
int 21                                 ; print tens digit (or space)
mov dl,dh
int 21                                 ; print ones digit
ret                                    ; gawd, is this stupid

show_dow_err:                          ; error computing day of week:
mov dx,0007                            ; return 7 (no day-of-week)
jmp show_dow_x

show_dow:                              ; compute and display day of week:
mov w [temp],ax                        ; save date in directory format
mov cl,09
shr ax,cl
mov w [date3],ax                       ; save year
mov bl,1c                              ; assume february has 28 days
cmp ax,0120xd                          ; year 2100 (dos year 120) ?
je > l1                                ; if so, not a leap year
test al,03                             ; year divisible by 4 ?
jne > l1                               ; if it isn't, not a leap year
inc bl                                 ; leap year -- february has 29 days
l1:
mov b [months_table+1],bl              ; stash length of february
mov ax,w [temp]
mov cl,05
shr ax,cl
and ax,000f                            ; extract month value
cmp al,01                              ; month less than 1?
jb show_dow_err                        ; if so, no day-of-week
cmp al,0c                              ; month greater than 12?
ja show_dow_err                        ; if so, no day-of-week
mov w [date1],ax                       ; save month
mov ax,w [temp]
and ax,001f                            ; extract day value
cmp al,01                              ; day less than 1?
jb show_dow_err                        ; if so, no day-of-week
mov w [date2],ax                       ; save day
mov bx,w [date1]
mov cl,b [months_table-1+bx]           ; get length of month in .cl
cmp cl,b [date2]                       ; date greater than maximum?
jb show_dow_err                        ; if so, no day-of-week
zero bx
l3:
mov al,b [months_table+bx]             ; get length of month
cbw                                    ; as a word
inc bx
cmp bx,w [date1]                       ; hit the user's month yet?
je > l4                                ; yes, exit this loop
add w [date2],ax                       ; no, add month length into julian
jmp l3                                 ; and loop back for next month
l4:                                    ; added in lengths of previous months:
mov bx,w [date3]                       ; get dos year in .bx
or bx,bx                               ; dos year zero?
je > l8                                ; if so, skip following calculations
inc w [date2]                          ; add one for leap day 1980
mov ax,bx
mov dx,0365xd
mul dx                                 ; multiply year number by 365
add w [date2],ax                       ; and add into the julian number
mov ax,bx
dec ax                                 ; decrement year number
shr ax,01
shr ax,01                              ; and divide by four
add w [date2],ax                       ; add leap days into julian number
cmp bx,0120xd                          ; year greater than 2100?
jbe > l8
dec w [date2]                          ; if so, subtract one leap day
l8:                                    ; done computing julian number:
zero dx
mov ax,w [date2]                       ; get julian date as 32-bit number
inc ax                                 ; add one (1-1-1980 was a tuesday)
mov cx,0007                            ; divide julian number by seven
div cx                                 ; remainder in .dx is the day of week
show_dow_x:
shl dx,01
shl dx,01                              ; multiply dow number by four
add dx,offset dow_names                ; to get offset within dow names table
doscall 09                             ; print dow name
mov dl,20                              ; and a space
doscall 02
ret                                    ; exit

show_attribs:                          ; display file's attributes:
mov dl,al                              ; save attributes byte
zero si                                ; pointer to bit-name letters
mov cl,20                              ; highest bit is #5 (archive)
attr_loop:
mov al,'.'                             ; assume a space
test dl,cl                             ; is this bit set?
je attr_go                             ; clear, use the space
mov al,b [attr1+si]                    ; set, get the bit-name letter instead
attr_go:
mov b [msg_attrib+si],al               ; poke space or letter into string
inc si                                 ; and point to the next letter
attr_skip:
shr cl,1                               ; and shift right to next bit
test cl,08                             ; bit 3 (volume label) we
jne attr_skip                          ; don't care about, so skip it
cmp cl,00                              ; run out of bits?
jne attr_loop                          ; no, loop back for next
dosprint msg_attrib                    ; yes, print the attribute string
ret

show_bytes_maybe:
test b [dta_attr],10
jne ret
dosprint msg_bytes
ret

show_size:
test b [dta_attr],10
jne show_size_subdir
mov ax,w [dta_size+0]
mov dx,w [dta_size+2]
mov b [dp_min],0b
call dec_print_big
mov dl,20
doscall 02
ret
show_size_subdir:
dosprint msg_subdir
ret

show_file_count:                       ; SHOW NUMBER OF FILES FOUND, CHANGED:
mov ax,w [found_lo]
or ax,w [found_hi]                     ; found any at all?
or ax,ax
je ret                                 ; if not, do nothing and exit
call crlf                              ; found some; print a blank line
dosprint msg_num_found                 ; and 'files found' message
mov ax,w [found_lo]
mov dx,w [found_hi]
call dec_print_big                     ; print number of files found
dosprint msg_num_altered               ; print 'files changed' message
mov ax,w [alter_lo]
mov dx,w [alter_hi]
call dec_print_big                     ; and number of files changed
dosprint msg_in_dir
zprint last_dir_shown
mov ax,w [found_lo]
add w [total_found_lo],ax              ; add number found
mov ax,w [found_hi]
adc w [total_found_hi],ax              ; to total number found
mov ax,w [alter_lo]
add w [total_alter_lo],ax              ; add number changed
mov ax,w [alter_hi]
adc w [total_alter_hi],ax              ; to total number changed
zero ax
mov w [found_lo],ax
mov w [found_hi],ax                    ; then zero out files-found count
mov w [alter_lo],ax
mov w [alter_hi],ax                    ; and files-changed count
ret

dec_print_big:                         ; DISPLAY DOUBLEWORD IN DX:AX
mov w [dp_t1],ax                       ; save the doubleword value
mov w [dp_t2],dx                       ; for later use
mov b [dp_t4],00
mov bx,000a                            ; ten decimal is our divisor
push bx                                ; also our end-of-stack marker
mov cl,00                              ; init digits-between-commas count
dec_print_1:                           ; main decimal division loop
zero dx
mov ax,w [dp_t2]                       ; dx:ax contains the high word as quad
div bx                                 ; divide by ten
mov w [dp_t2],ax                       ; save new high-order word
mov ax,w [dp_t1]                       ; get the old low word
div bx                                 ; and divide by ten
mov w [dp_t1],ax                       ; save new low word
add dx,0030                            ; convert remainder to ascii digit
push dx                                ; and save it on the stack
inc b [dp_t4]
or ax,ax                               ; anything left?
jne dec_print_12                       ; if so, continue with divisions
cmp w [dp_t2],0000
je dec_print_15                        ; if not, print out digits
dec_print_12:
test ch,80                             ; supposed to print commas?
jne dec_print_1                        ; if not, loop back for next digit
inc cl                                 ; increment digits-between-commas
cmp cl,03                              ; three digits yet?
jne dec_print_1                        ; if not, loop back for next digit
mov cl,00                              ; yes, zero counter
mov dl,b [country_thou]                ; and push a comma on the stack
push dx
inc b [dp_t4]
jmp dec_print_1                        ; and loop back for next digit
dec_print_15:                          ; done with divisions:
mov ah,02                              ; dos print-character function:
cmp b [dp_min],00                      ; right-justified?
je dec_print_2                         ; if not, print digits now
mov cl,b [dp_min]
sub cl,b [dp_t4]
jbe dec_print_2
mov ch,00
mov dl,20
dec_print_17:
int 21
loop dec_print_17
dec_print_2:                           ; decimal printout loop
pop dx                                 ; get a digit from the stack
cmp dx,000a                            ; hit the end of stack yet?
je dec_print_3                         ; if so, exit decimal print routine
int 21                                 ; otherwise, print the digit
jmp dec_print_2                        ; and loop back for next digit
dec_print_3:
mov b [dp_min],00
ret

dp_t1:                                 ; holds low-order word
dw 0000
dp_t2:                                 ; holds high-order word
dw 0000
dp_t4:                                 ; count of characters pushed on stack
db 00
dp_min:                                ; minimum number of chars to print
db 00

decout:                                ; DECIMAL PRINT, ONE WORD, NO COMMAS:
zero dx
push dx                                ; save zero as end-of-stack marker
mov cx,000a                            ; use ten as decimal divisor
decout1:                               ; decimal division loop:
div cx                                 ; divide to get next lowest digit
add dx,'0'                             ; convert to ascii
push dx                                ; and save on the stack
zero dx                                ; recover high word for division
cmp ax,dx                              ; and check whether done dividing yet
jne decout1                            ; if not, loop back for more
mov ah,02                              ; dos print-a-character function
decout2:                               ; decimal print loop:
pop dx                                 ; get a word from the stack
or dx,dx                               ; run out of decimal digits yet?
je decout3                             ; if so, we're done
int 21                                 ; otherwise, print this digit
jmp decout2                            ; and loop back for more
decout3:
ret

get_num:                               ; READ DEC. NUMBER FROM COMMAND LINE:
mov al,b [si]                          ; examine first digit
call test_digit                        ; it is a digit, right?
jne get_num_err                        ; if not, exit with carry set
zero bx                                ; start with zero
get_num_loop:
lodsb                                  ; get digit from command line
sub al,'0'                             ; and convert to a value
mov cl,al                              ; save it in .cl
mov ch,00                              ; as a word value
mov ax,bx                              ; get interim value
mov bx,000a
mul bx                                 ; and multiply by ten
or dx,dx                               ; if overflow on multiply,
jne get_num_err                        ; abort
add ax,cx                              ; add in value of most recent digit
jc get_num_err
mov bx,ax                              ; and save
mov al,b [si]                          ; examine next character
call test_digit                        ; is it a decimal digit?
je get_num_loop                        ; if so, use it as well
mov ax,bx                              ; if not, done -- return value in .ax
clc                                    ; with carry clear
ret
get_num_err:                           ; overflow, or no number at all:
stc                                    ; exit with carry set
ret

force_uc:                              ; FORCE CHARACTER IN .AL TO UPPERCASE:
cmp al,'a'
jb ret                                 ; lowercase letter?
cmp al,'z'                             ; if not, make no changes
ja ret 
and al,0df                             ; if so, force to uppercase
ret

test_space:                            ; IS CHARACTER IN .AL A SPACE OR TAB?
cmp al,20                              ; exit with zero-flag set if it is
je ret
cmp al,09
ret

test_colon:                            ; IS CHAR. IN .AL A COLON OR EQUALS?
cmp al,':'                             ; exit with zero-flag set if it is
je ret
cmp al,'='
ret

test_digit:                            ; IS CHARACTER IN .AL A DECIMAL DIGIT?
cmp al,'0'                             ; exit with zero-flag set if it is
jb ret
cmp al,'9'
ja ret
cmp al,al
ret

test_eol:                              ; IS CHARACTER IN .AL AN EOL OR NULL?
cmp al,0d                              ; exit with zero flag set if it is
je ret
cmp al,00
ret


get_vga_lines:                         ; FIGURE DEFAULT SCROLL LENGTH
push cs
pop es                                 ; point es:di
mov di,offset dta                      ; to temporary buffer
mov ax,1b00                            ; vga call:
zero bx
int 10                                 ; get state information
cmp al,1b                              ; was call successful?
jne ret                                ; if not, done with paging setup
mov al,b [dta+22]                      ; get number of lines
sub al,02                              ; and subtract 2
mov b [vga_lines],al                   ; save as number of lines to scroll
ret

clean_up_filespec:                     ; CANONICALIZE FILESPEC:
call fix_last_bs                       ; find final backslash
call must_have_drive                   ; supply drive letter if needed
call must_have_path                    ; supply pathname if needed
call never_ends_in_bs                  ; make sure filespec doesn't end in \
call check_for_wildcards               ; check filespec for '?' and '*'
call doesnt_name_dir                   ; make sure it isn't a directory name
call dots_fix                          ; eliminate any . or .. entries
call no_double_bs                      ; remove any duplicated backslashes
call get_short_filespec                ; extract short filespec from long
ret

must_have_drive:                       ; MAKE SURE FILESPEC HAS A DRIVE:
mov ax,w [fnbuf]                       ; examine first two characters:
cmp ax,'\' by '\'                      ; is this a unc filespec?
je > l2                                ; if so, don't muck about with it
cmp ah,':'                             ; is the second character a colon?
jne > l0                               ; if not, add drive letter
cmp al,'A'
jb > l0                                ; is the first a letter?
cmp al,'Z'                             ; if not, add drive letter
ja > l0                                ; a drive letter was specified:
cmp b [fnbuf+2],00                     ; was there anything after it?
je > l5                                ; if not, add star-dot-star
ret                                    ; otherwise, exit with no change
l0:
call find_null_fnbuf                   ; find the end of the filespec
mov si,di                              ; source for copy
add di,0002                            ; and add 2 (destination)
cmp di,offset fnbuf + fn_max           ; will this overflow fnbuf?
jae > l7                               ; if so, problem
l1:
mov al,b [si]                          ; copy a byte from source
dec si
mov b [di],al                          ; to destination
dec di
cmp si,offset fnbuf                    ; done yet?
jae l1                                 ; no, continue
doscall 19                             ; get current drive number
add al,'A'                             ; and convert to a letter
mov ah,':'
mov w [fnbuf],ax                       ; stash it in the filename buffer
cmp w [last_bs],0000                   ; if a backslash was found,
je > l2
add w [last_bs],0002                   ; add 2 to its location
l2:
ret                                    ; and we're done
l5:                                    ; only a drive letter found:
mov si,offset star_dot_star
mov di,offset fnbuf+2                  ; supply a star-dot-star
jmp copy_string                        ; and exit
l7:                                    ; adding a drive would overflow fnbuf:
jmp error_fnbuf_over                   ; handle error

must_have_path:                        ; SUPPLY PATHNAME IF NEEDED:
cmp w [fnbuf],'\' by '\'               ; is this a unc filespec?
je > l4                                ; if so, don't muck about with it
cmp b [fnbuf+2],'\'                    ; did the user supply an abs. path?
je > l4                                ; if so, exit without further ado
mov si,offset fnbuf+2                  ; starting immediately after colon,
mov di,offset dta                      ; copy everything to temp buffer
call copy_string
mov w [fnbuf+2],00 by '\'              ; poke in initial backslash
mov dl,b [fnbuf]                       ; get drive letter
sub dl,40                              ; and convert to a number
mov si,offset fnbuf + 3
doscall 47                             ; get current directory name
call find_null_fnbuf                   ; find the end of the pathname
dec di
cmp b [di],'\'                         ; does path already end in backslash?
je > l3
inc di
l3:
mov b [di],'\'                         ; terminate pathname
inc di
mov si,offset dta
call copy_string                       ; and copy remainder of filespec back
call fix_last_bs                       ; repair last_bs variable
l4:
ret

never_ends_in_bs:                      ; FIX PATHNAMES ENDING IN BACKSLASH:
mov di,w [last_bs]                     ; get address of final backslash
inc di                                 ; and examine the following char.
cmp b [di],00                          ; is it a null?
jne ret                                ; if not, do nothing and exit
mov si,offset star_dot_star            ; if so, tack on a star-dot-star
call copy_string                       ; after the backslash
cmp di,offset fnbuf + fn_max           ; didn't overflow the buffer, did we?
jna ret
jmp error_fnbuf_over                   ; oops

check_for_wildcards:                   ; SEARCH FOR WILDCARDS IN FILESPEC :
and b [flags],0ef                      ; assume that there isn't
zero si                                ; from beginning of buffer :
l1:
lodsb                                  ; grab a character
cmp al,00                              ; end of filename?
je ret                                 ; if so, exit
cmp al,'?'
je > l3                                ; question mark or asterisk?
cmp al,'*'                             ; if no, loop back for next character
jne l1
l3:
or b [flags],10                        ; if so, note wildcard and exit
ret

doesnt_name_dir:                       ; MAKE SURE IT'S NOT A DIRECTORY NAME:
and b [more_flags],0bf
mov al,06
test b [flags],20
je > l0
mov al,16
l0:
mov b [find_attr],al
call find_null_fnbuf                   ; find end of filename
push di                                ; and remember it
mov si,offset slash_star_dot_star      ; tack on a \*.*
call copy_string
mov di,w [last_bs]
inc di                                 ; check first character after final \
cmp b [di],'.'                         ; if it's a period,
je > l4                                ; assume this is a directory name
mov cx,0006
mov dx,offset fnbuf
doscall 4e                             ; search for files
jnc > l3                               ; if no problem, leave it like this!
cmp ax,0012
je > l3                                ; empty directory, leave it like this!
cmp ax,0002
je > l3
pop di                                 ; not a directory:
mov b [di],00                          ; remove the \*.*
ret
l3:                                    ; fnbuf actually names a directory:
test b [flags],10                      ; any wildcards in the filespec?
je > l7                                ; if not, it's okay to use this subdir
l4:
pop ax
mov w [last_bs],ax                     ; save address of last backslash
add ax,0004                            ; calculate address of terminal null
cmp ax,offset fnbuf + fn_max           ; overflowed the working buffer?
jae > l5
ret                                    ; no, exit
l5:
jmp error_fnbuf_over                   ; yes, apologize
l7:
pop di                                 ; get pointer to end of filespec
mov b [di],00                          ; and null-terminate it again
mov b [find_attr],16                   ; okay to find subdirectories
or b [more_flags],40
ret

dots_fix:                              ; LOOK FOR . OR .. ENTRIES:
mov si,offset fnbuf                    ; start at beginning of filespec
l0:
mov ax,w [si]                          ; look at two bytes at a time
inc si
cmp al,00                              ; found the end of the filespec yet?
jne > l1
l9:
jmp fix_last_bs                        ; if so, exit
l1:
cmp ax,'.' by '\'                      ; found a . entry?
jne l0                                 ; if not, keep looking
mov cx,0001                            ; one dot found so far
l2:
inc si                                 ; skip past that first dot
mov al,b [si]                          ; examine the next character
cmp al,00                              ; end of filespec?
je l9                                  ; if so, exit
cmp al,'.'                             ; another dot?
jne > l3
inc cx                                 ; if so, count it
jmp l2                                 ; and keep parsing
l3:
cmp al,'\'                             ; another backslash?
jne l0                                 ; if not, ignore this (weird) entry
mov di,si                              ; point .di to backslash after dots
l4:
dec di                                 ; and scan backwards through fnbuf
cmp di,offset fnbuf                    ; fell off the beginning of fnbuf?
jbe > l8                               ; if so error
cmp b [di],'\'                         ; found a backslash?
jne l4                                 ; if not, keep searching backwards
loop l4                                ; decrement dots count, continue
call copy_string                       ; copy string after dots down
jmp dots_fix                           ; and loop back for more .\ entries
l8:                                    ; too many dot entries:
bomb msg_err_dots_fix,15               ; complain and exit with errorlevel 21

no_double_bs:                          ; remove any duplicated backslashes :
mov di,offset fnbuf                    ; start at beginning of filename
l10:
inc di
mov ax,w [di]                          ; examine two characters at a time
cmp al,00                              ; found the end of the filespec yet?
je ret                                 ; if so, exit
cmp ax,'\' by '\'                      ; duplicate backslashes?
jne l10                                ; if not, loop back, keep searching
l20:
mov si,di                              ; copy down
inc si                                 ; from the second backslash
call copy_string                       ; onto the first
dec w [last_bs]                        ; adjust last-backslash pointer
jmp no_double_bs                       ; and loop back for more abuse

get_short_filespec:                    ; EXTRACT SHORT FILESPEC FROM LONG:
mov si, offset fnbuf + 2               ; copy entire filespec
cmp w [last_bs],0000                   ; or, if directory was specified,
je > l0
mov si,w [last_bs]                     ; the filespec immediately following
inc si                                 ; the last backslash
l0:
mov di,offset nambuf                   ; into the name buffer
push ds
pop es
l1:
lodsb                                  ; copy one character at a time
stosb                                  ; into the short name buffer
cmp al,00                              ; until the terminal null is found
jne l1                                 ; then stop.
cmp di,offset nambuf + 0e              ; overflowed the short name buffer?
jae > l3
ret                                    ; no, bliss
l3:                                    ; nambuf has overflowed:
bomb msg_err_nambuf_over,10            ; complain and exit with errorlevel 16


alloc_tree_buffer:                     ; CREATE BUFFER FOR /S TREE IF NEEDED:
test b [flags],08                      ; /s specified?
je ret                                 ; no, don't bother with tree buffer
mov bx,1000                            ; yes, allocate 64k
doscall 48                             ; for tree buffer
jnc > l0
jmp trs_80                             ; any problem, complain and abort
l0:
mov w [tree_seg],ax                    ; no problem, remember segment
mov es,ax
zero ax
mov w [es:0000],ax                     ; and empty the tree buffer
ret

alloc_list_buffer:                     ; CREATE BUFFER FOR FILE LIST:
mov bx,0100                            ; allocate four kilobytes
doscall 48                             ; for list buffer
jnc > l0
jmp trs_80                             ; any problem, complain and abort
l0:
mov w [list_seg],ax                    ; no problem, remember segment
mov w [list_pnt],2000                  ; and note that the buffer is empty
ret

get_fn_from_list:                      ; READ FILESPEC FROM FILE LIST:
test b [flags],04                      ; are we using a file list?
jne > l1
clc
ret                                    ; if not, simply exit with carry clear
l1:
cmp w [auxhandle],0000                 ; is it open yet?
jne > l3                               ; if so, continue
mov dx,offset fnbuf
doscall2 3d20                          ; open file list file
jnc > l2
dosprint msg_err_listfile              ; problem:  print error message
zprint fnbuf                           ; and filename
stc                                    ; and exit with carry
ret
l2:
mov w [auxhandle],ax                   ; save file handle
mov w [list_pnt],2000                  ; and note that the buffer is empty
l3:
mov di,offset fnbuf
mov b [di],00                          ; empty the filespec buffer
and b [flags],0fe                      ; not between quotes
read_fn_loop:
call read_from_list                    ; get a character from the file list
cmp al,1a                              ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,20                              ; end of line?
jb read_fn_eol                         ; if so, deal with it
call test_space                        ; space?
je read_fn_sp                          ; if so, deal with it
cmp al,'"'                             ; quote mark?
je read_fn_qu                          ; if so, deal with it
cmp al,';'                             ; semicolon?
je read_fn_semi                        ; if so, deal with it
cmp al,':'                             ; colon?
je read_fn_semi                        ; if so, deal with it
call force_uc
cmp al,'/'                             ; slash?
jne read_fn_ch
mov al,'\'                             ; if so, convert to a backslash
read_fn_ch:                            ; got a legal character for filename:
mov b [di],al                          ; put it in the buffer
inc di
mov b [di],00                          ; and null-terminate it
cmp di,offset fnbuf + fn_max           ; blown past the end of the buffer?
jb read_fn_loop                        ; no, loop back for more
jmp read_fn_spam                       ; yes, deal with it
read_fn_eof:                           ; found end of list file:
mov bx,w [auxhandle]
doscall 3e                             ; close the list file
mov w [auxhandle],0000                 ; and mark it closed
and b [flags],0fb                      ; no more file list!
cmp b [fnbuf],00                       ; was a filename retrieved before eof?
je > l1
clc                                    ; yes, exit with carry clear
ret
l1:
stc                                    ; no, exit with carry set
ret
read_fn_sp:                            ; found a space:
test b [flags],01                      ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
read_fn_eol:                           ; found end of line:
cmp b [fnbuf],00                       ; anything in the buffer yet?
je read_fn_loop                        ; if not, keep looking
call clean_up_filespec                 ; clean it up
clc
ret                                    ; and exit
read_fn_qu:                            ; found a quote:
test b [flags],01                      ; was there an open quote?
jne read_fn_eol                        ; if so, it ends the filespec
cmp b [fnbuf],00                       ; anything in the buffer yet?
jne read_fn_ch                         ; if so, treat like any other char
or b [flags],01                        ; otherwise, this is an open quote
jmp read_fn_loop                       ; keep reading
read_fn_semi:                          ; found a semicolon:
test b [flags],01                      ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
cmp b [fnbuf],00                       ; anything in the buffer yet?
jne read_fn_ch                         ; if so treat like any other char
cmp al,':'                             ; was comment character a colon?
je read_fn_notice                      ; if so, this is a printable 'notice'
read_fn_remark:                        ; NONPRINTABLE COMMENT IN FILE LIST:
call read_from_list                    ; get a character from the file list
cmp al,1a                              ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,20                              ; found the end of the remark?
jae read_fn_remark                     ; if not, keep looking
jmp read_fn_loop                       ; otherwise, resume hunt for filespec
read_fn_notice:                        ; PRINTABLE NOTICE IN FILE LIST:
dosprint msg_notice                    ; introduce it
l0:
call read_from_list                    ; get a character from the file list
cmp al,1a                              ; end of file?
je > l2                                ; if so, deal with it
cmp al,20                              ; found the end of the notice?
jae > l1
call crlf                              ; if so, terminate the output line
jmp read_fn_loop                       ; and go back to the filespec search
l1:
mov dl,al                              ; otherwise, this is a printable char
doscall 02                             ; print it
jmp l0                                 ; and continue scanning through notice
l2:                                    ; end-of-file within notice:
call crlf                              ; terminate the output line
jmp read_fn_eof                        ; and the input file

read_fn_spam:                          ; overflowed the working buffer:
mov b [fnbuf],00                       ; empty the working buffer
dosprint msg_err_list_spam             ; print an error message
jmp read_fn_eof                        ; and kill the current file list

read_from_list:                        ; GET CHARACTER FROM FILE LIST FILE:
mov ax,w [list_pnt]
cmp ax,1000                            ; need to refill the buffer?
jb read_list                           ; nope, skip ahead
mov cx,1000                            ; read four kilobytes
mov bx,w [auxhandle]                   ; from the file list
zero dx                                ; to the start
mov ds,w [list_seg]                    ; of the list buffer
doscall 3f
push cs
pop ds                                 ; restore data segment
jnc > l3
bomb msg_err_read_list,13              ; complain and exit with errorlevel 19
l3:
mov w [list_pnt],0000                  ; move pointer back to start of buffer
cmp ax,1000                            ; got four kilobytes?
je read_list                           ; cool!
or ax,ax                               ; got anything at all?
jne > l4
mov al,1a                              ; if not, return end-of-file
ret
l4:
mov si,ax                              ; got less than four kilobytes:
mov es,w [list_seg]                    ; poke in an eof
mov b [es:si],1a                       ; just to be on the safe side
read_list:                             ; get buffered char from file list:
mov es,w [list_seg]                    ; segment of file list buffer
mov si,w [list_pnt]                    ; pointer into list buffer
mov al,b [es:si]                       ; get character from buffer
inc si
mov w [list_pnt],si                    ; and increment the pointer
push ds
pop es                                 ; fix data segment
ret                                    ; and exit

find_null_fnbuf:                       ; FIND END OF FILESPEC:
mov di,offset fnbuf                    ; fall through to:

find_null:                             ; FIND END OF ASCIIZ STRING:
cmp b [di],00                          ; found null yet?
je ret                                 ; yes, exit
inc di
jmp find_null

fix_last_bs:                           ; REPAIR LAST_BS VARIABLE:
mov w [last_bs],0000                   ; note no backslashes found yet
mov si,offset fnbuf                    ; point to start of filespec buffer
l0:
mov al,b [si]                          ; look at character
cmp al,00                              ; terminal null?
je > l2                                ; if so, exit
cmp al,'\'                             ; backslash?
jne > l1
mov w [last_bs],si                     ; if so, save its address
l1:
inc si                                 ; and keep on going
jmp l0
l2:                                    ; found the terminal null
cmp si,offset fnbuf + fn_max           ; have we wandered off the edge?
jae > l4                               ; if so, problem
ret
l4:                                    ; spammed fnbuf:
jmp error_fnbuf_over                   ; abort

prompt_user:                           ; PROMPT USER, IF NEEDED:
test b [flags],40                      ; was /p or /q specified?
je prompt_user_x                       ; if not, bug out
dosprint msg_info_space_4
call show_cur_filename
call show_file_info
dosprint msg_query                     ; display prompt message
l0:
call flush_key_buffer                  ; empty keyboard buffer
mov ah,00
int 16                                 ; get a keystroke
call force_uc                          ; and convert it to uppercase
cmp al,'A'                             ; 'a' for 'all' ?
je prompt_user_all                     ; if so, deal with it
cmp al,'Q'                             ; 'q' for 'quit' ?
je prompt_user_quit                    ; if so, deal with it
cmp al,'N'                             ; 'n' for 'no' ?
je prompt_user_1                       ; if so, normal exit
cmp al,'Y'                             ; 'y' for 'yes' ?
jne l0                                 ; if not, ignore this keystroke
prompt_user_1:                         ; 'y' or 'n' pressed:
push ax                                ; save the keystroke
dosprint msg_unquery                   ; erase the prompt message
pop ax                                 ; and check the user's keystroke
cmp al,'Y'                             ; was it 'y' for 'yes' ?
prompt_user_x:                         ; exit
ret
prompt_user_all:                       ; 'a' for 'all' :
and b [flags],0bf                      ; turn off prompting
mov al,'Y'                             ; pretend this was a 'y'
jmp prompt_user_1                      ; and exit normally
prompt_user_quit:                      ; 'q' for 'quit' :
dosprint msg_unquery                   ; erase prompt message
call crlf                              ; terminate the current print line
call show_file_count                   ; show current files found / changed
jmp big_loop_done                      ; and break out of big_loop

flush_key_buffer:                      ; EMPTY KEYBOARD BUFFER:
mov ah,01
int 16                                 ; check keyboard buffer
je ret                                 ; exit if empty
mov ah,00                              ; otherwise,
int 16                                 ; get a keystroke from buffer
jmp flush_key_buffer                   ; and loop back
ret

get_country_info:                      ; time and date formats, etcetera
mov dx,offset country
doscall2 3800                          ; get current country info
ret                                    ; and exit

append_found_filespec:                 ; ADD FOUND FILESPEC AFTER PATHNAME:
mov di,w [last_bs]                     ; destination is
inc di                                 ; character following final backslash
mov si,offset dta_name                 ; source is filename in dta
call copy_string                       ; copy found filename into fnbuf
cmp di,offset fnbuf + fn_max           ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

append_short_filespec:                 ; ADD USER FILESPEC AFTER PATHNAME:
mov di,w [last_bs]                     ; destination is
inc di                                 ; character following final backslash
mov si,offset nambuf                   ; source is short filespec buffer
call copy_string                       ; copy found filename into fnbuf
cmp di,offset fnbuf + fn_max           ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

error_fnbuf_over:                      ; fnbuf has overflowed:
bomb msg_err_fnbuf_over,14             ; complain and exit with errorlevel 20

copy_string:                           ; COPY ASCIIZ STRING [SI] TO [DI]:
push ds                                ; make .es equal to .ds
pop es                                 ; and fall through ....

copy_string_far:                       ; COPY ASCIIZ STRING [SI] TO [ES:DI]:
lodsb                                  ; get a character from [ds:si]
stosb                                  ; put it in [es:di]
cmp al,00                              ; until the final null is found
jne copy_string_far
ret                                    ; then quit

find_es_zz:                            ; FIND TERMINAL DOUBLE-NULL:
zero si                                ; start at beginning of tree buffer
cmp w [es:si],0000                     ; is the tree buffer empty?
je > l2                                ; if so, return zero in .si
l0:                                    ; scan forward through tree buffer:
cmp w [es:si],0000                     ; found the double null null yet?
je > l1
inc si                                 ; if not, increment pointer
jmp l0                                 ; and keep looking
l1:                                    ; found the double null:
inc si                                 ; return offset of _second_ null
l2:
ret                                    ; exit

zprint1:                               ; PRINT ASCIIZ STRING VIA .DI:
mov ah,02                              ; dos print-a-character function
l0:
mov dl,b [di]                          ; get a byte from string
inc di
cmp dl,00                              ; found the final null?
je > l1                                ; if so, deal with it
int 21                                 ; otherwise, print the character
jmp l0                                 ; and loop back for more abuse
l1:                                    ; found the final null:

crlf:                                  ; END OF PRINT LINE:
dosprint msg_crlf                      ; print a carriage return, line feed
test b [more_flags],10                 ; was stdout redirected?
jne > l25                              ; if so, skip control-key handler
push es
mov es,0040
test b [es:0017],04                    ; is control key down?
je > l20                               ; if not, never mind
l10:                                   ; control pressed, so do brief delay :
test b [es:006c],01                    ; wait for an even jiffy
jne l10
l15:
test b [es:006c],01                    ; then wait for an odd jiffy
je l15
l20:
pop es
l25:
cmp b [line],00                        ; paging output?
jne pause_maybe                        ; if so, check whether pause needed
ret                                    ; otherwise, just exit

pause_maybe:                           ; CHECK WHETHER PAUSE NEEDED:
dec b [line]                           ; decrement line count
; cmp b [line],00                      ; hit zero yet?
jne ret                                ; if not, just exit
l0:                                    ; time for a pause:
dosprint msg_pause                     ; announce it
call flush_key_buffer                  ; empty keyboard buffer
l1:
mov ah,00
int 16                                 ; get a keystroke
call force_uc                          ; and force it to uppercase
call unpause                           ; erase pause message
cmp al,0d                              ; enter?
je pause_cr                            ; if so, deal with it (scroll line)
cmp al,'/'                             ; slash?
je pause_slash                         ; if so, deal with it (scroll half)
cmp al,'C'                             ; C ?
je pause_c                             ; if so, deal with it (continuous)
cmp al,1b                              ; escape ?
je pause_c                             ; if so, deal with it (continuous)
mov al,b [screen_lines]                ; otherwise, move scroll value
mov b [line],al                        ; into line count
ret                                    ; and exit
pause_cr:                              ; scroll line:
inc b [line]                           ; set line count to one
ret                                    ; and exit
pause_slash:                           ; scroll half:
mov al,b [screen_lines]                ; get normal scroll value
shr al,01                              ; divide by two
inc al                                 ; and add one
mov b [line],al                        ; save new line count
ret                                    ; and exit
pause_c:                               ; continuous:
mov b [line],00                        ; set for no paging
ret                                    ; and exit

unpause:                               ; ERASE PAUSE MESSAGE FROM SCREEN:
push ax                                ; save .ax
mov ah,02                              ; dos print-a-character function
mov dl,0d                              ; carriage return
int 21                                 ; move cursor to start of line
mov dl,20                              ; ascii space
mov cx,004f                            ; 79 repetitions:
l0:
int 21                                 ; print a space
loop l0                                ; over and over again
mov dl,0d                              ; then another carriage return
int 21                                 ; move cursor to start of line
pop ax                                 ; restore previous .ax value
ret                                    ; and exit

pause_check:                           ; allow pausing a continuous scroll:
test b [more_flags],10                 ; was output redirected?
jne ret                                ; if so, never mind
cmp b [line],00                        ; continuous scrolling?
jne ret                                ; if not, never mind
mov ah,02
int 16                                 ; get keyboard shift status
test al,08                             ; is alt key pressed?
je ret                                 ; if not, never mind
call flush_key_buffer                  ; pause request!  empty key buffer
mov b [line],01                        ; and note that next line should pause
cmp b [screen_lines],00
jne ret                                ; if number of screen lines not set,
mov al,b [vga_lines]
mov b [screen_lines],al                ; set screen lines to 23
ret

template_fix:                          ; TRANSFER TEMPLATE BITS TO VARIABLES:
test b [more_flags],20                 ; was /c specified?
je > l7                                ; if not, exit without further ado
mov ah,b [template_mask]               ; get the template mask bits
mov al,b [chgattr]                     ; neither chgattr
or  al,b [newattr]                     ; nor newattr should have any bits set
and al,ah                              ; in common with the template mask
cmp al,00                              ; if they do,
jne > l8                               ; flag an error
or b [chgattr],ah                      ; note these attributes will change
and ah,b [template_bits]               ; get appropriate bits from template
or b [newattr],ah                      ; and poke them into the new values
l7:
ret                                    ; exit
l8:                                    ; MASK CONFLICTS WITH CHANGERS:
bomb msg_err_c_bits,10                 ; complain and exit with errorlevel 16

prompt_fix:                            ; CHECK USAGE OF /P :
mov al,b [chgattr]
or al,b [newattr]                      ; supposed to change any attributes?
cmp al,00
jne > l1                               ; if so, accept /p
and b [flags],0bf                      ; if not, disregard any /p
ret
l1:
test b [flags],40                      ; was /p specified?
jne error_out                          ; if so, redirect output to screen
ret                                    ; otherwise, simply exit

error_out:                             ; FORCE STDOUT TO STDERR:
mov cx,0001                            ; force stdout
mov bx,0002                            ; to stderr
doscall 46
mov b [line],00                        ; and disable paging
and b [more_flags],0ef                 ; note that output is to the screen
ret

fix_paging:                            ; CHECK FOR OUTPUT REDIRECTION :
mov bx,0001                            ; standard output handle
doscall2 4400                          ; ioctl get handle info
and dl,82
cmp dl,82                              ; is this the console device?
je > l0
mov b [screen_lines],00                ; if not, disable paging
or b [more_flags],10                   ; and note stdout was redirected
l0:
mov al,b [screen_lines]                ; use paging value
mov b [line],al                        ; to initialize lines count
ret                                    ; and exit

hook_int_24:                           ; DISABLE CRITICAL-ERROR HANDLING:
test b [more_flags],08                 ; was /h specified?
jne ret                                ; if not, do not hook int 24
mov dx,offset new_int_24               ; address of new int 24 handler
doscall2 2524                          ; intercept int 24
ret

new_int_24:                            ; REPLACEMENT INT 24 HANDLER
mov al,03                              ; always fail
iret

bombs_away:                            ; HANDLE PARSE ERRORS:
call error_out                         ; reset output to console
dosprint msg_err_begin                 ; print start of error message
pop di
mov dx,w [di]                          ; get pointer to error message
doscall 09                             ; print error message
mov al,b [di+02]                       ; get errorlevel
doscall 4c                             ; and exit program
int 20


; -------------------------------------- TEXT AND STRINGS :

msg_markver:                           ; for mark aitchison's version utility
db 'VeRsIoN=1.04',00
db 'CoPyRiGhT=Copyright 1999, Charles Dye',00

msg_syntax:
db 0d,0a
db 'ATTRIB.COM   v1.04   01-31-1999   C. Dye   raster@highfiber.com',0d,0a
db 'Freeware.  Copyright 1997-1999, Charles Dye.  No warranty!',0d,0a
db 0a
db 'ATTRIB [operators] [filespecs] [switches]',0d,0a
db 0a
db '   + set   - clear   ~ toggle',0d,0a
db '   A  Archive    H  Hidden',0d,0a
db '   S  System     R  Read-only',0d,0a,0a
db '   /S  recurse into subdirectories',0d,0a
db '   /P  offer yes/no prompt',0d,0a
db '   /M  page output',0d,0a
db 0a
db 'This program may be freely distributed under the terms of the Free',0d,0a
db 'Software Foundation''s GNU General Public License, version 2; or, at',0d,0a
db 'your option, any later version of that License.  See the file COPYING',0d,0a
db 'for details.'

msg_crlf:
db 0d,0a,'$'

switches:
db 'SPQFMDCH',00

switch_routines:
dw switch_s, switch_p, switch_p, switch_f, switch_m, switch_d, switch_c
dw switch_h


months_table:                          ; number of days in each month
db 1f, 1c, 1f, 1e, 1f, 1e, 1f, 1f, 1e, 1f, 1e, 1f

dow_names:
db 'Sun$Mon$Tue$Wed$Thu$Fri$Sat$---$'

msg_err_begin:
db 0d,0a,'Error:  $'

msg_err_dos_bad:
db 'Requires DOS 3.0 or higher!',0d,0a,'$'

msg_trs_80:
db 'Not enough memory!',0d,0a,'$'

msg_err_fn_ovf:
db 'Filespec too long!',0d,0a,'$'

msg_err_in_filespec:
db 'In filespec!',0d,0a,'$'

msg_err_specs_galore:
db 'More than 31 filespecs!',0d,0a,'$'

msg_err_dots_fix:
db 'Resolving dots!',0d,0a,'$'

msg_err_listfile:
db 'Can''t open file list:  $'

msg_err_temp_open:
db 0d,0a,'Error:  Problem with template file $'

msg_err_read_list:
db 'Problem reading from file list!$'

msg_err_fnbuf_over:
db 'Spammed working buffer!',0d,0a,'$'

msg_tree_buffer_over:
db 'Tree buffer overflow!',0d,0a,'$'

msg_err_list_spam:
db 'Filespec too long in file list!  Closing file list.',0d,0a,'$'

msg_err_nambuf_over:
db 'Filename longer than 12 characters!',0d,0a,'$'

msg_err_dupe:
db 'More than one /F specified!',0d,0a,'$'

msg_err_c_dupe:
db 'More than one /C specified!',0d,0a,'$'

msg_err_c_bits:
db '/C mask conflict!',0d,0a,'$'

msg_err_multi_chg:
db 'More than one setting for '
msg_err_multi_chg1:
db '# bit!',0d,0a,'$'

msg_err_odd_attr:
db 'Unknown attribute'
msg_err_odd_attr1:
db ' # !',0d,0a,'$'

msg_failed:
db ' ERROR $'

msg_err_sw_c:
db 0d,0a
db 'ATTRIB /C=filename  -- copy attributes from file',0d,0a,0a
db 'Filename may contain wildcards or name a subdirectory.',0d,0a
db '$'

msg_err_sw_f:
db 0d,0a
db 'ATTRIB /F:x  -- format for date display',0d,0a,0a
db '/F:U   MM-DD-YYYY',0d,0a
db '/F:E   DD-MM-YYYY',0d,0a
db '/F:J   YYYY-MM-DD',0d,0a
db '$'

msg_err_sw_m:
db 0d,0a
db 'ATTRIB /M:x  -- pause every x lines (More)',0d,0a,0a
db 'Sets the number of lines to display before pausing.  The value x',0d,0a
db 'is optional.  Screen pausing will be disabled if /P is specified',0d,0a
db 'or output is redirected.',0d,0a
db '$'

msg_notice:
db 'Notice:  $'

attributes:
db 'ASHR',00

attrib_values:
db 20,04,02,01

msg_info_ampm:
db ' am  $'

msg_bytes:
db 'bytes$'

msg_info_space_4:
db '  '

msg_info_space:
db '  $'

msg_attrib:
db '-----  $'

attr1:
db 'ADSHR'

msg_subdir:
db '     <Dir>  $'

msg_num_found:
db 'Files found: $'

msg_num_altered:
db '; altered: $'

msg_in_dir:
db ' in $'

msg_total_found:
db 'Total found: $'

msg_num_errors:
db '; errors: $'

msg_query:
db ' [Y/N] ? $'

msg_unquery:
db 0a dup 08, 0a dup 20, '$'

msg_pause:
db ' -- MORE --  <space> page, <enter> line, </> half page, <C> continuous $'

slash_star_dot_star:
db '\'

star_dot_star:
db '*.*',00

everything_cr:
db '*.*',0d


; -------------------------------------- BYTE LENGTH VARIABLES :

flags:                                 ; bit 7 = user date fmt           /F
db 00                                  ; bit 6 = prompt user          /P /Q
                                       ; bit 5 = subdirs okay            /D
                                       ; bit 4 = wildcard in filespec
                                       ; bit 3 = subdirectories          /S
                                       ; bit 2 = use file list    @filename
                                       ; bit 1 = 
                                       ; bit 0 = parsing between quotes

more_flags:                            ; bit 7 = 
db 00                                  ; bit 6 = user filespec names subdir
                                       ; bit 5 = template filespec       /C
                                       ; bit 4 = stdout is redirected
                                       ; bit 3 = do not hook int 24      /H
                                       ; bit 2 = toggle three            ~Z

chgattr:                               ; which attributes to change?
db 00

newattr:                               ; new attributes
db 00

template_mask:                         ; use which attributes from template?
db 27

template_bits:                         ; attributes from template file
db 00

find_attr:                             ; legal attributes for findfirst/next:
db 06                                  ; 06 files only, 16 files and subdirs

vga_lines:                             ; default number of lines to scroll
db 17

screen_lines:                          ; lines to print between pauses
db 00

line:                                  ; lines remaining before next pause
db 00


even ; --------------------------------- WORD LENGTH VARIABLES :

auxhandle:                             ; handle for file list
dw 0000

last_bs:                               ; offset of final backslash in fnbuf
dw 0000

tree_seg:                              ; segment of tree buffer
dw 0000

list_seg:                              ; segment of file list buffer
dw 0000

list_pnt:                              ; pointer into file list buffer
dw 0000

pointer_pointer:                       ; pointer into list of filespec
dw 0000                                ; pointers

tfn_attr:                              ; legal attributes for template file
dw 0000

mask_4301:                             ; which attributes should be passed
dw 0027                                ; to 21/4301 ?

date1:                                 ; first  number in user-specified date
dw 0000                                ;    (month in u.s. format)
date2:                                 ; second number in user-specified date
dw 0000                                ;    (day in u.s. format)
date3:                                 ; third  number in user-specified date
dw 0000                                ;    (year in u.s. format)

found_lo:                              ; number of files found in current
dw 0000                                ; directory:
found_hi:                              ; low word / high word
dw 0000

alter_lo:                              ; number of files changed in current
dw 0000                                ; directory:
alter_hi:                              ; low word / high word
dw 0000

total_found_lo:                        ; total number of files found so far:
dw 0000                                ; low word / high word
total_found_hi:
dw 0000

total_alter_lo:                        ; total number of files changed:
dw 0000                                ; low word / high word
total_alter_hi:
dw 0000

error_lo:                              ; number of files we failed to change:
dw 0000                                ; low word / high word
error_hi:
dw 0000


; -------------------------------------- UNINITIALIZED DATA AND STACK :

filespec_pointers:                               ; room for 32 pointers
                                                 ; (31 valid plus final null)

dta       equ  filespec_pointers + 0040          ; disk transfer area:
dta_attr  equ  dta + 0015                        ; attribute of found file
dta_time  equ  dta + 0016                        ; time stamp of found file
dta_date  equ  dta + 0018                        ; date stamp of found file
dta_size  equ  dta + 001a                        ; size of found file
dta_name  equ  dta + 001e                        ; name of found file


fnbuf     equ  dta + 0040                   ; filespec of files to alter,
                                            ; or of file list

tfbuf     equ  fnbuf + fn_max               ; filespec of template file

last_dir_shown  equ  tfbuf + fn_max         ; last directory name displayed

nambuf    equ  last_dir_shown + fn_max      ; filename of files to alter,
                                            ; without directory name


stack_start  equ  (nambuf * 10 + 10f) / 10       ; stack starts on paragraph
stack_end    equ  stack_start + 0800             ; stack is about 2k long


;   Errorlevels:
;   00   Normal exit
;   16   General syntax, buffer overflow
;   17   Not enough memory
;   18   Problem with template file
;   19   Problem with list file
;   20   Internal buffer overflow
;   21   Error resolving directory name
;   22   Tree buffer overflow
;   23   Bad DOS version
;
;
;   Version log:
;
;   1.00   08-12-1997
;          Switches:  /S recurse into subdirectories, /P /Q prompt user,
;          /F set date format, /D allow wildcards to match subdirectory
;   names, /C copy attributes from template, /H do not hook INT 24, /M page
;   output
;   Operators:  - clear, + set, ~ toggle, comma clear all
;   Attributes:  Archive System Hidden Read-only, plus Z pseudo-attribute
;   for setting/clearing S H and R simultaneously
;
;   1.01   11-01-1997
;          Template filespec may now include wildcards; the first matching
;          file (not subdirectory!) will be used.
;
;   1.02   08-05-1998   6056 bytes
;          Various tweaks for FreeDOS compatibility.  NUL and CR are both
;          legal end-of-line markers.  Duplicate backslashes are removed from
;   the filespec.  Will not convert subdirectories into files.  Also fixed
;   a problem which prevented changing attributes of empty subdirectories
;   under DOS-C.
;
;   1.02a  08-13-1998   6121 bytes
;          Fixes an incompatibility with 8086 and 8088 CPUs (logical shifts
;   with immediate count values.)  Also adds version and copyright strings
;   for Mark Aitchison's VERSION.EXE program.
;
;   1.03   09-11-1998   6000 bytes
;          No significant changes in operation, but now it's distributed
;   under the GNU General Public License.  I've modified the syntax display
;   accordingly.  Also moved the filespec buffers out into the uninitialized
;   data area, and generally rearranged things to save space.  Other minor
;   tweaks to shave the program size.  Also corrected the /C? message, which
;   still said /C didn't permit wildcards.
;
;   1.03a  01-14-1999   6000 bytes
;          Fix for /H, which didn't actually do a bloody thing.  Also adds
;   the year of the original release to the copyright message in the syntax
;   screen.
;
;   1.04   01-31-1999   6000 bytes
;          Two changes to scrolling.  The key to pause a continuous scroll is
;   now Alt (was Esc.)  This fixes the annoying problem where ATTRIB ate all
;   keystrokes in the typeahead buffer.  Also, the Control key may now be
;   used to slow a scrolling display.
;
