---------------------------- CHNGFIL.DOC (cut here) ---------------------------
Use CHNGFIL.COM to change a file's attributes.

Syntax: CHNGFIL filename [/R] [/H] [/S]

/R = read-only		/H = hidden		/S = system

1) If a switch is not included, then the corresponding attribute is not set.
2) The filename may be wildcarded.

Example:
CHNGFIL *.C /R
Changes all files in current directory with .c extension to read-only.
------------------------ end of CHNGFIL.DOC (cut here) ------------------------

---------------------------- CHNGFIL.ASM (cut here) ---------------------------
;Program to change file attributes
;by Robert Lenoil; August 23, 1984

;Placed in the public domain, June 1986.
;Author's electronic mail address:
;USENET: lenoil@mit-eddie.uucp		ARPA: lenoil@eddie.mit.edu

CODE	SEGMENT
ASSUME	CS:CODE,DS:CODE

;data:
ORG	80H
CMDLEN	DB	?			;command line length

ORG	100H
START:	JMP	BEGIN

ATTRIB	DB	0			;attribute to change to
FNSTART	DW	?			;start of fname on cmd line
FNLEN	DW	?			;end of filename
FPTR	DW	?			;where to put returned filename
PATHSTR	DB	78 DUP (?)		;where the path will live
DTA	DB	128 DUP (?)		;disk transfer address
ERR1MSG	DB	'Proper syntax: CHNGFIL filename [/R][/H][/S]$'

;code:
BEGIN:	CLD				;eat leading spaces
	MOV	SI,81H
	MOV	AH,32
EAT:	LODSB
	DEC	CMDLEN
	JS	ER1JMP
	CMP	AL,AH
	JE	EAT
	INC	CMDLEN
	DEC	SI
	MOV	FNSTART,SI
	MOV	DI,SI
	MOV	AL,AH			;search for end of fname
	SUB	CX,CX
	MOV	CL,CMDLEN
	SUB	DX,DX
	REPNE	SCASB
	JNE	L1
	INC	DX
	DEC	DI
L1:	MOV	BX,DI
	SUB	BX,FNSTART
	MOV	FNLEN,BX
	MOV	BYTE PTR [DI],0
	TEST	DX,DX
	JZ	SEARCH			;no attributes on cmd line
	MOV	AX,3700H		;get system switch character into DL
	INT	21H
	MOV	SI,DI			;scan for switches
	INC	SI
SCAN:	LODSB
	CMP	AL,13			;end of cmd line?
	JE	SEARCH
	CMP	AL,32			;eat spaces
	JE	SCAN
	CMP	AL,DL			;switch?
	JE	SCAN1
ER1JMP:	JMP	ERROR1
SCAN1:	LODSB
	AND	AL,0DFH
	MOV	BL,1
	CMP	AL,'R'
	JE	SCAN2
	SHL	BX,1
	CMP	AL,'H'
	JE	SCAN2
	SHL	BX,1
	CMP	AL,'S'
	JNE	ER1JMP
SCAN2:	OR	ATTRIB,BL
	JMP	SHORT	SCAN

SEARCH:	MOV	SI,FNSTART		;does name have drive letter or path?
	ADD	SI,FNLEN
	STD
	DEC	SI
SLOOP:	LODSB
	CMP	AL,'/'
	JE	PATH
	CMP	AL,'\'
	JE	PATH
	CMP	AL,':'
	JE	PATH
	CMP	SI,FNSTART
	JA	SLOOP
	MOV	FPTR,OFFSET PATHSTR
	JMP	SHORT DOCHNG

PATH:	INC	SI			;copy pathname to pathstr
	MOV	CX,SI
	MOV	SI,FNSTART
	SUB	CX,SI
	INC	CX
	MOV	FPTR,CX
	MOV	DI,OFFSET PATHSTR
	ADD	FPTR,DI
	CLD
	REP	MOVSB

DOCHNG:	MOV	AH,1AH			;set DTA
	MOV	DX,OFFSET DTA
	INT	21H
	MOV	AH,4EH			;search for file(s)
	MOV	DX,FNSTART
	MOV	CX,7
	JMP	SHORT CLOOP1
CLOOP:	MOV	AH,4FH
CLOOP1:	INT	21H
	MOV	AL,0
	JC	EXIT			;no more files

	MOV	SI,OFFSET DTA + 30	;copy fname to end of pathstr
	MOV	DI,FPTR
	MOV	CX,13
	CLD
	REP	MOVSB

	MOV	AX,4301H		;perform attribute change
	MOV	DX,OFFSET PATHSTR
	MOV	CL,DTA[21]		;leave modified flag untouched
	AND	CL,0F8H
	OR	CL,ATTRIB
	INT	21H
	JMP	SHORT CLOOP

ERROR1:	MOV	DX,OFFSET ERR1MSG
ERROR:	MOV	AH,9
	INT	21H
	MOV	AL,1
EXIT:	MOV	AH,4CH
	INT	21H

CODE	ENDS

END	START
------------------------ end of CHNGFIL.ASM (cut here) ------------------------
