DIRECTORY(1V)          C LIBRARY FUNCTIONS          DIRECTORY(1V)

NAME
     opendir, readdir, rewinddir, closedir - directory operations

SYNOPSIS
     #include "dirent.h"

     DIR *opendir(dirname)
     char *dirname;

     struct dirent *readdir(dirp)
     DIR *dirp;

     void rewinddir(dirp)
     DIR *dirp;

     int closedir(dirp)
     DIR *dirp;

DESCRIPTION
     opendir() opens the directory named by dirname  and  associ-
     ates  a  directory  stream  with  it.   opendir()  returns a
     pointer to be used to identify the directory stream in  sub-
     sequent  operations.   A NULL pointer is returned if dirname
     cannot be accessed or is not a directory, or  if  it  cannot
     malloc enough memory to hold the whole thing.

     readdir() returns a pointer to the next directory entry.  It
     returns  NULL  upon  reaching  the  end  of the directory or
     detecting an invalid seekdir() operation.

     rewinddir() resets  the  position  of  the  named  directory
     stream to the beginning of the directory.  It also causes the
     directory stream to  refer  to  the  current  state  of  the
     corresponding  directory,  as a call to opendir() would have
     done.

     closedir() closes the named directory stream and  frees  the
     structure associated with the DIR pointer.

NOTES
     An open directory must always be closed with the closedir() function
     to ensure the next attempt to open that directory is successful.

RETURN VALUES
     opendir() returns a pointer to an object of type DIR on suc-
     cess.   On  failure, it returns NULL and sets errno to indi-
     cate the error.

     readdir() returns a pointer to  an  object  of  type  struct
     dirent  on  success.   On  failure, it returns NULL and sets
     errno to indicate the error.  When the end of the  directory
     is  encountered,  readdir()  returns  NULL  and leaves errno
     unchanged.

     closedir() returns:

     0    on success.

     -1	  on failure and sets errno to indicate the error.

ERRORS
     If any of the following  conditions  occur,  opendir()  sets
     errno to:

     ENOMEM	Not enough memory to allocate a DIR object.

     ENOENT	The named directory does not exist.

     For each of the following conditions, when the condition  is
     detected, readdir() and closedir() set errno to the following:

     EBADF	dirp does not refer to an open directory stream.

EXAMPLES
     Sample code which searchs a directory for entry ``name'' is:

		dirp = opendir(".");
		for (dp = readdir(dirp); dp != NULL; dp = readdir(dirp))
		    if (!strcmp(dp->d_name, name)) {
			closedir (dirp);
			return FOUND;
		    }
		closedir (dirp);
		return NOT_FOUND;

MSDOS/VMS Release 1.1   Last change: 22 June 1994
