{$M $A000,$10000,$A0000 $R+}
program DRLG;               {Pretty much ready for distribution}
uses                        {<G>lobal & <J>ust Totals features in}
   DOS,
   CRT;

type
   Str2   = string[2];
   Str3   = string[3];
   Str6   = string[6];
   Str7   = string[7];
   Str10  = string[10];
   Str12  = string[12];
   Str14  = string[14];
   Str17  = string[17];
   Str20  = string[20];
   Str31  = string[31];
   Str46  = string[46];
   Str80  = string[80];
   Str128 = string[128];

const
   MaxFiles = 1500;
   HeadSpace:byte = 7;
   Marker: array [1..11] of char = 'Colors: Reg';
   RegC:   byte = $07;
   MarkV:  array[1..3] of char = 'Vol';
   VolC:   byte = $08;
   MarkD:  array[1..3] of char = 'Dir';
   DirC:   byte = $30;
   MarkF:  array[1..3] of char = 'Frm';
   FrameC: byte = $0E;
   MarkE:  array[1..3] of char = 'Exc';
   ExeC:   byte = $0A;
   MarkS:  array[1..3] of char = 'HSR';
   SpookC: byte = $08;
   months: array [1..12] of Str3 = ('Jan','Feb','Mar','Apr','May','Jun',
                                    'Jul','Aug','Sep','Oct','Nov','Dec');
   PathSigns  = [':','\'];
   PramSigns  = [':','/','='];
   Numerals   = ['0'..'9'];
   ParamSigns =  ['-','/'];
   Logo       = ' DRL 2.0 beta (DiRectory Lister)';
   ByLine     = 'Copyright (C) R. N. Wisan 1999';
   LF  = #10;
   FF  = #12;
   CR  = #13;
   NL  = #13#10;
   Global: boolean = False;

type
   NStr        = Str20;
   NPtr        = ^NType;
   NType       = record
                    N:    NStr;
                    Next: NPtr;
                 end; {record}
   GPtr        = ^GlobDirType;
   GlobDirType = record
                    S: PathStr;
                    Next: GPtr;
                 end; {record}
   DirStPtr    = ^PathStr;
   SRecPtr     = ^SearchRec;
   DStrType    = array[1..MaxFiles] of SRecPtr;
   SortType    = (None,FileName,Extension,Date,Siz);
   DrivDat     = record
                   NSec:   word;
                   FatSeg: word;
                   FatOff: word;
                   SecSiz: word;
                   Clstrs: word;
                end; {DrivDat}
   DirPtrType   = ^DirType;
   DirType      = record
                     Name: PathStr;
                     Next: DirPtrType;
                  end; {DirType}
   FSplitType   = record
                     P: PathStr;
                     D: DirStr;
                     N: NameStr;
                     E: ExtStr;
                  end;
   TotalsType   = record
                     NrDirs:  word;
                     NrFiles: word;
                     FilSiz:  longint;
                     NrClust: word;
                  end;
   DriveType    = record
                     Num: byte;
                     Let: char;
                  end;





var
   Ch:          char;
   TotSize:     longint;
   DskErr,
   FixedColumns,
   FoundC,
   Kount,
   Columns,
   ColWidth,
   LnsPerPg:    byte;
   LnsOnPg,
   LnsSoFar:    integer;
   DrK,
   NDirs,
   E:           word;
   B:           byte;
   NumFiles,
   ExitWarning,
   AttStrg:     Str10;
   Title:       Str80;
   ThatDir,
   CurDir, S:   string;
   ThatDrv:     DriveType;
   Volume:      Str12;
   SR:          searchrec;
   WaitBase,
   RealAtt,
   FilAtt:      integer;
   JustTotals,
   NoSuchDir,
   MoreThan1,
   Reverse,
   ShoNorm:     boolean;
   Sort:        SortType;
   DSt:         DStrType;
   FNam,
   FFnam,
   PathStub,
   OutFile:     Str128;
   OutF:        text;
   DriveData:   DrivDat;
   TotClust,
   ClusterSize,
   L:           longint;
   NameBase,
   NamePtr:     NPtr;
   GlobDirBase: GPtr;
   GlobDirPtr:  GPtr;
   BadEnds:     set of char;
   GlobTot:     TotalsType;
   DirBase,
   DirPtr:     DirPtrType;
   Pth:        PathStr;
   Err:        word;
   SplitName:  FSplitType;
  (* Recurses:   word; *)

{================= General Utilities=================================}
(*
{$F+} function HeapFunc(Size: Word): integer; {$F-}
*)

{$F+} function HeapFunc(Size : Word) : integer; {$F-}

{ Used to handle heap errors }{ Borland's but Doesn't seem to work }
{ It DOES work, but only if placed outside of other procedures.    }
{ Must be in its own block. }

begin
   HeapFunc := 1       { Forces New or GetMem to return a nil pointer }
end; {HeapFunc}

procedure StartClock;
var
   Hr, Min, Sec,Sec100: word;
begin
   GetTime(Hr,Min,Sec,Sec100);
   WaitBase := Sec100 + 100*Sec + 6000*Min
                      + 360000*Hr - 25; { 25/100th sec overhead?}
end; {StartClock}

procedure WaitTil(N: word);
   {Delays until approximately N hundredths of a second after the time }
   {set with StartClock.  Differs from TP's delay function in that the }
   {delay is timed from StartClock, thus you can call StartClock, then }
   {do anything else you like and THEN call WaitTil.  It will delay un-}
   {til the overall time, including your other activities, has elapsed.}
   {If called between midnight and 12:02 am, WaitTil exits immediately }
   {to avoid looping for the better part of a day.                     }
var
   Hr, Min, Sec,Sec100: word;
   TimeUpAt,TimeNow:    longint;
   Ch:                  char;
begin
   GetTime(Hr,Min,Sec,Sec100);
   TimeUpAt := WaitBase + N;
   repeat
      GetTime(Hr,Min,Sec,Sec100);
      TimeNow := Sec100 + 100*Sec + 6000*Min + 360000*Hr;
   until (TimeUpAt<=TimeNow) or (TimeUpAt<12000);
end; {WaitTil}

procedure Beep;                                                        {.CP4}
begin
  { StartClock;
   sound(456);}
end; {Beep}

procedure Bop;                                                         {.CP4}
begin
  { WaitTil(72); StartClock;
   nosound; WaitTil(45);
   sound(362); WaitTil(117);
   nosound; WaitTil(189);}
end; {Bop}

function  StrgB(B,L: Byte): Str80;           {Number expressed in decimal}
var
   S: Str80;
begin
   str(B:L,S);
   StrgB := S
end; {StrgB}

function  StrgR(R: real;L1,L2: Byte): Str80;
var
   S: Str80;
begin
   str(R:L1:L2,S);
   StrgR := S
end; {StrgR}

function  StrgI(B,L: Integer): Str80;
   var
   S: Str80;
begin
   str(B:L,S);
   StrgI := S
end; {StrgI}

function  StrgW(B,L: word): Str80;
   var
   S: Str80;
begin
   str(B:L,S);
   StrgW := S
end; {StrgW}

function  StrgLI(B,L: longint): Str80;
   var
   S: Str80;
begin
   str(B:L,S);
   StrgLI := S
end; {StrgLI}

function Commified(N: Str80):Str80;
var
   S: Str80;
   K,P: byte;
begin
   S := '';
   K := 0;
   for P := length(N) downto 1 do begin
      if N[P] in Numerals then begin
         if K mod 3 = 0 then S := ',' + S;
         inc(K);
      end; {if Numeral};
      S := N[P] + S;
   end; {for P}
   if S[length(S)]=',' then dec(S[0]);
   Commified := S;
end; {Commified}

function InCapitals(S: string): string; Assembler;
{PC Techniques HAX 144 v3n6 (adding Hax 147 is not faster)}
ASM
   push ds           {Preserve data segment}
   lds  si,S         {Load DS:SI w S's address}
   les  di,@result   {Load ES:DI w function result's address}
   cld               {SI will be incremented}
   lodsb             {Get S[0]; put it in AL}
   stosb             {Store AL in ES:01}
   xor cx,cx         {Zero CX}
   cmp al,cl         {Check for zero length  --This is what HAX 144 missed}
   je  @out
   mov cl,al         {Length of S into counter CL}
@more:
   lodsb             {next char -> AL}
   cmp al,'a'        {is it 'a'?}
   jb  @no           {if below, skip out}
   cmp al,'z'        {is it 'z'?}
   ja  @no           {if above, skip out}
   sub al,20h        {subtract 32 = lower case}
@no:
   stosb             {store AL in ES:DI}
@loopy:
   loop @more        {Go back for next until CX=0}
@out:
   pop  ds           {Restore data segment}
end; {InCapitals}

function PrePadded(S: string; Len: byte): string;
begin
   while length(S)<Len do S := ' ' + S;
   PrePadded := S;
end; {PrePadded}

function PaddedTo(S: string; Len: byte):string;
begin
   while length(S)<Len do S := S+ ' ';
   PaddedTo := S;
end; {PaddedTo}

function  KbIn(var Extended: boolean): char;
var
   C:              char;
begin
   C := ReadKey;
   if C<>#0 then
      Extended := False
   else begin         {get extended code}
      Extended := True;
      C := ReadKey
   end; {else}
   KbIn := C;
end; {KbIn}

function LongDate(Month,Day,Year: word): Str14;
begin {FileDate}
   LongDate := Months[Month] + ' ' + StrgI(Day,1) + ', '
             + StrgI(Year,1);
end; {LongDate}

function ShortDate(Month,Day,Year: word): Str14;
begin
   ShortDate := StrgI(Month,1) + '/' + StrgI(Day,1) + '/'
             + StrgI(Year-1900,1);
end; {ShortDate}

function LongTime(Hour,Min,Sec: word): Str14;
var
   Temp: Str14;
begin
   if Sec>=30 then inc(Min);
   if Min>59 then begin
      inc(Hour);
      Min := 0;
   end; {if Min}
   Temp := ' pm';
   case hour of
      0:      begin
                 Hour := 12;
                 Temp := ' am'
              end; {midnight-1 am}
      13..24: Hour := Hour - 12;
      else    Temp := ' am'
   end; {case hour}
   Temp := StrgI(Min,1) + Temp;
   if Min<10
      then LongTime := StrgI(Hour,1) + ':0' + Temp
      else LongTime := StrgI(Hour,1) + ':' + Temp
end; {LongTime}

function PresentTime: Str80;
var
   Hr,Min,Sec,Sec100: word;
begin
   GetTime(Hr,Min,Sec,Sec100);
   if Sec100>49 then inc(Sec);
   PresentTime := LongTime(Hr,Min,Sec);
end; {PresentTime}

function PresentLongDate: Str80;
var
   Mon,Day,Year,DayOWeek:word;
begin
   GetDate(Year,Mon,Day,DayOWeek);
   PresentLongDate := LongDate(Mon,Day,Year);
end; {PresentLongDate}

function PresentShortDate: Str80;
var
   Mon,Day,Year,DayOWeek:word;
begin
   GetDate(Year,Mon,Day,DayOWeek);
   PresentShortDate := ShortDate(Mon,Day,Year);
end; {PresentDate}

function CurrentDrive: byte;
{Returns 0 for A:, 1 for B:, etc.}
{Needs type DOS.Registers}
var
   Regs: DOS.Registers;
begin
   Regs.AH := $19;
   MsDos(Regs);
   CurrentDrive := Regs.AL
end; {CurrentDrive}

function CurrentDriveAndDirectory: Str80;
{Returns full current drive:\directory}
{Needs types: LineType, DOS.Registers}
var
   Data: array[1..64] of char;
   Regs: DOS.Registers;
   Bt:  byte;
   S:    Str80;

begin
   Bt := CurrentDrive;
   with Regs do begin
      AH := $47;
      DL := succ(Bt);
      DS := Seg(Data);
      SI := Ofs(Data);
      MsDos(Regs);
   end; {with Regs}
   S := char(Bt+65) + ':\';
   Bt := 1;
   while Data[Bt]<>#0 do begin
      S := S + UpCase(Data[Bt]);
      inc(Bt)
   end; {while}
   CurrentDriveAndDirectory := S
end; {CurrentDriveAndDirectory}

procedure WriteStdError(S: string);
var
   R: registers;
begin
   with R do begin
      AH := $40;        {write to file with handle}
      BX := 2;          {2 is handle for Standard Error}
      CX := length(S);
      DS := seg(S[1]);
      DX := ofs(S[1]);
      MsDos(R);
   end; {with R}
end; {WriteStdErr}

function Pad22(Tmp: string;filler: char): Str2;
begin
   if length(Tmp)=1 then
      Tmp := Filler + Tmp;
   Pad22 := Tmp;
end; {ZeroLead}

function IsDir(DirSpec: PathStr): byte;
{Using ChDir instead of FindFirst because Win95 DOS box flubs FindFirst}
{& FindFirst can't find a root directory}
{Changed here from boolean type to Byte.  Returns IOResult, so 0 = OK.}
var
   Orig: string;
begin
   GetDir(0,Orig);
   if Orig<>DirSpec then begin
      {$I-}
      ChDir(DirSpec);
      {$I+}
      IsDir := IOResult;
   end
   else
      IsDir := 0; {we're already there}
   ChDir(CurDir);  {back to where we wuz}
end; {ChangedDir}

{==================== Procedures for DRL =============================}

procedure Emit(S: string);
begin
   if (OutFile='&&') or (OutFile='')  then begin
      Write(S);
   end
   else
      Write(OutF,S);
end; {Emit}

procedure EmitLn(S:string);
begin
   Emit(S + NL);
end; {EmitLn}

procedure EmitIf(S: string);
begin
   if (Outfile<>'&&') and (S[length(S)]<>LF) then begin
      if S[length(S)]in BadEnds then
         dec(S[0]);
      while S[length(S)]=' ' do
         dec(S[0]);
      S := S + NL;
   end;
   Emit(S);
end; {EmitIf}

procedure Bummer(S: Str80;ErrNo: byte);
begin
   Beep;
   WriteStdError(S+NL);
   {$I-}
   ChDir(CurDir);
   {$I+}
   Bop;
   Halt(ErrNo);
end; {Bummer}

function FileAttStrg(Attr: integer): Str6;
var
   S: Str6;
begin
   S := '';
   if Attr=0 then
      S := '     '
   else if Attr<$3F then begin
      if (Attr and 1) = 1
         then S := S + 'R';
      if (Attr and 2) = 2
         then S := S + 'H';
      if (Attr and 4) = 4
         then S := S + 'S';
      if (Attr and 8) = 8
         then S := S + 'L';
      if (Attr and $10) = $10
         then S := S + 'D';
      if (Attr and $20) = $20
         then S := S + 'A';
   end; {if < $3F}
   while length(S)<5 do
      S := S + ' ';
   FileAttStrg := S;
end; {FileAttStrg}

function Root(P: PathStr): boolean;
var
   N,I: byte;
begin
   N := 0;
   for I := 1 to length(P) do
       if P[I]='\' then inc(N);
   Root := N=0;
   if (N=1) and (P[length(P)]='\') then
      Root := True;
end; {Root}

function Slash(P:PathStr): PathStr;
begin
   if P[length(P)]<>'\'
      then P := P + '\';
   Slash := P;
end; {Slash}


procedure Pause;
const
   PauseLetters = [' ',#3];
var
   S:    Str80;
   LS:   Str12;
   Troo: boolean;
begin
   if LnsOnPg>=(LnsPerPg-2) then
      if (Outfile='') or (OutFile='&&') then begin
         S := 'Space => Next Line   Crtl-C => Stop   Any other key => Next Page';
         LS := 'Line #' + StrgW(LnsSoFar,1);
         while (length(S) + length(LS)) < 78 do
            S :=  S + ' ';
         S := S + LS;
         WriteStderror(S);
         Ch := KBin(Troo);
         WriteStdError(CR);
         if (Not Troo) and not (Ch in PauseLetters) then
            LnsOnPg := 0
         else if (Not Troo) and (Ch=#3) then begin
            WriteStdError('   --------------------------- Stopping on command ---------------------------'+NL);
            halt;
         end;
      end; {if not Outfile}
end; {Pause}

procedure Display(var DStr: DStrType; DirK: word;FNam: PathStr);
Type
   PauseType = (Line,Page);
const
   SingV: char = #179;
   SingH: char = #196;
   DblH:  char = #205;
   MidT:  char = #209;
   MidB:  char = #207;
   MidTS: char = #194;
   MidBS: char = #193;
   MidMS: char = #197;

var
   Ch:     char;
   Troo:   boolean;
   SL,SC,
   SR,S:   Str80;
   AtStr:  Str10;
   D:      PathStr;
   Ext:    Str3;
   W,I,Lng,
   Dot:    byte;
   NrOfRows,
   J,K,{Tot,}
   Strt,Fin,
   Wdth:   word;
   SRec:   SearchRec;
   DStrg:  PathStr;
   TotLn:  string;
   Tabs:   Str7;

   procedure SortOnFileName;
   var
      M,J,G: word;
      B: SRecPtr;

   begin
      G := DirK;
      for M := 1 to pred(DirK) do begin
        J := 1;
        B := DStr[succ(M)];
        (*while BiggerThan(B,T.TrmDat[J]) and (J<=M) do*)
        while (B^.Name >= DStr[J]^.Name) and (J<=M) do
           inc(J);
        if (J<=M) then begin   {insert}
           move(DStr[(J)],Dstr[succ(J)],SizeOf(DStr[1])*succ(M-J)); {shift}
           DStr[(J)] := B;
        end;
      end; {for M}
   end; {SortOnFileName}

   procedure SortOnDate;
   var
      M,J,G: longint;
      B: SRecPtr;

      function DateString(SR: SRecPtr): string;
      var
         D: DateTime;
         S: string;

      begin
         UnpackTime(SR^.Time, D);
         with D do begin
             S := StrgW(Year,4)
                  + Pad22(StrgW(Month,1),'0')
                  + Pad22(StrgW(Day,1),'0')
                  + Pad22(StrgW(Hour,1),'0')
                  + Pad22(StrgW(Min,1),'0')
                  + Pad22(StrgW(Sec,1),'0');
         end; {with D}
         DateString := S;
      end; {DateString}

   begin
      G := DirK;
      for M := 1 to pred(DirK) do begin
        J := 1;
        B := DStr[succ(M)];
        (*while BiggerThan(B,T.TrmDat[J]) and (J<=M) do*)
        while (DateString(B) >= DateString(DStr[J])) and (J<=M) do
           inc(J);
        if (J<=M) then begin   {insert}
           move(DStr[(J)],Dstr[succ(J)],SizeOf(DStr[1])*succ(M-J)); {shift}
           DStr[(J)] := B;
        end;
      end; {for M}
   end; {SortOnDate}

   procedure SortOnExt;
   var
      M,J,G: word;
      B: SRecPtr;

      function GT(A,B:Str12):boolean;
      var
         K: byte;
      begin
         K := pos('.',A);
         if K>0 then
            A := copy(A,succ(K),3)
         else
            A := '';
         K := pos('.',B);
         if K>0 then
            B := copy(B,succ(K),3)
         else
            B := '';
         GT := A>B;
      end; {GT}

   begin
      G := DirK;
      for M := 1 to pred(DirK) do begin
        J := 1;
        B := DStr[succ(M)];
        (*while BiggerThan(B,T.TrmDat[J]) and (J<=M) do*)
        while GT(B^.Name,DStr[J]^.Name) and (J<=M) do
           inc(J);
        if (J<=M) then begin   {insert}
           move(DStr[(J)],Dstr[succ(J)],SizeOf(DStr[1])*succ(M-J)); {shift}
           DStr[(J)] := B;
        end;
      end; {for M}
   end; {SortOnExt}

   procedure SortOnSize;
   var
      M,J,G: word;
      B: SRecPtr;
   begin
      G := DirK;
      for M := 1 to pred(DirK) do begin
        J := 1;
        B := DStr[succ(M)];
        (*while BiggerThan(B,T.TrmDat[J]) and (J<=M) do*)
        while (B^.Size >= DStr[J]^.Size) and (J<=M) do
           inc(J);
        if (J<=M) then begin   {insert}
           move(DStr[(J)],Dstr[succ(J)],SizeOf(DStr[1])*succ(M-J)); {shift}
           DStr[(J)] := B;
        end;
      end; {for M}
   end; {SortOnSize}

   function BlankLine:Str80;
   var
      S: Str80;
      K: byte;
   begin
      S := '';
      for K := 1 to 80 do S := S + ' ';
      BlankLine := S;
   end;{BlankLine}


   procedure Blank2file;
   begin
      if OutFile<>'&&' then
         emitln('')
      else
         emit(BlankLine);
   end;

   procedure NameString(var S: Str80);
   begin
      NamePtr := NameBase;
      if pos('*',S)=0 then
         S := S + NamePtr^.N;
      while NamePtr^.Next<>nil do begin
         NamePtr := NamePtr^.Next;
         S := S + ' ' + NamePtr^.N;
      end; {while}
   end; {NameString}

   Function SearchRecStrg(SR: SearchRec): PathStr;
   {Supplies 39 character DIR type string}
   var
      S:            string;
      At:           Str10;
      B:            byte;
      D:            DateTime;
      Pct:          real;
      ClusterBytes,
      L:            longint;
      NrClusters,
      Clstrs:       word;

      function SizeString(Size: longint): string;
      var
         R: real;
         S: string;
      begin
         if (Size<100000) or (Columns=1) then begin
            R := Size;
            S := StrgR(R,W,0);
         end
         else if size>=1000000000 then begin
            R := Size/1000000000;
            if R>=100 then
               S := StrgR(R,W,1)
            else if R>=10 then
               S := StrgR(R,W,2)
            else
               S := StrgR(R,W,3);
            S := S + 'G';
         end
         else if Size>=1000000 then begin
            R := Size/1000000;
            if R>=100 then
               S := StrgR(R,W,1)
            else if R>=10 then
               S := StrgR(R,W,2)
            else
               S := StrgR(R,W,3);
            S := S + 'M';
         end
         else if Size>=100000 then begin
            R := Size/1000;
            if R>1000 then
               S := StrgR(R,W{4},0)
            else if R>100 then
               S := StrgR(R,W,1)
            else if R>=10 then
               S := StrgR(R,W,2)
            else
               S := StrgR(R,W,3);
            S := S + 'K';
         end; {if Size}
         SizeString := S;
      end; {SizeString}

      procedure ClustUsed(FileSize:longint);
      var
         L: longint;
      begin
         NrClusters := FileSize div ClusterSize; {NrClusters = Nr of clusters}
         L := NrClusters * ClusterSize;
         if L<FileSize then                         {did div leave remainder?}
            inc(NrClusters);                   {Number of Clusters NrClusters}
         Clstrs := NrClusters;
         ClusterBytes := NrClusters*ClusterSize;
         Pct := 100 * (FileSize/ClusterBytes);   {(NrClusters*ClusterSize));}
         TotClust := TotClust + NrClusters;      {running total}
      end; {ClustUsed}

   begin {SearchRecStrg}
      S := SR.Name;

      if S[1]='3' then
         W := W;

      if (length(S)<12) and (pos('.',S)<>0) then
            while pos('.',S)<9 do insert(' ',S,pos('.',S));
      S := PaddedTo(S,ord(Tabs[1]));
      if (SR.Attr and Directory) = Directory then
         S := S + PrePadded('<Dir> ',succ(W))
      else if SR.Attr and VolumeID = VolumeID then
         S := S + PrePadded('<Vol> ',succ(W))
      else
         S := S + SizeString(SR.Size);
      S := PaddedTo(S,ord(Tabs[2]));

      UnpackTime(SR.Time,D);
      with D do begin
          S := S + Pad22(StrgW(Day,1),' ') + '-'
                 + Months[Month] + '-'
                 + Copy(StrgW(Year,4),3,2); {+ ' ';}
          S := PaddedTo(S,ord(Tabs[3]));
          S:= S + Pad22(StrgW(Hour,1),'0')  + ':'
                + Pad22(StrgW(Min,1),'0')  + ':'
                + Pad22(StrgW(Sec,1),'0')  + ' ';
      end; {with D}
      if Columns=1 then begin
         S := PaddedTo(S,ord(Tabs[4]));
         if SR.Size>0 then begin
            ClustUsed(SR.Size);
            S := S + StrgW(NrClusters,5);
            S := PaddedTo(S,ord(Tabs[5]));
            if ClusterBytes = SR.Size then
               Pct := 100;
            if Pct>=99.95 then begin
               if OutFile='' then       {hi-bit for file & screen, not for StdOut}
                  S := S + ' 100%'
               else
                  S := S + '100%'
            end
            else
               S := S + StrgR(Pct,4,1) + '%';
         end
         else
            S := S + '  --    --- ';
         S := PaddedTo(S,ord(Tabs[6])) ;
         S := S + ' ' +FileAttStrg(SR.Attr);
      end; {if Col=1}
      S := PaddedTo(S,ord(Tabs[7]));
      SearchRecStrg := S;
   end; {SearchRecStrg}


   procedure BarLine(MidCh: char);
   var
      K,J:   byte;
      Horiz: char;
      S:     Str80;
   begin
      Pause;
      if Midch in [MidTS,MidBS,SingV,MidMS] then
         Horiz := SingH
      else
         Horiz := DblH;
      SL := '';
      SR := '';
      SC := '';
      S := '';
      for K := 1 to Columns do begin
         for J := 1 to Wdth do
            S := S + Horiz;
         S := S + MidCh;
      end; {for K}
      dec(S[0]);
      for K := length(S) to 79 do
         S := S + Horiz;
      Emitif(S);
      inc(LnsOnPg); inc(LnsSoFar);
   end; {BarLine}

   procedure EndLine;
   var
      S: string;
   begin
      while (length(SL)<length(SR)) and
            ((length(SL)+length(SC)+length(SR))<Lng) do
         SL := SL + ' ';
      while (length(SL)>length(SR)) and
            ((length(SL)+length(SC)+length(SR))<Lng) do
         SR := ' ' + SR;
      while (length(SL)+length(SC)+length(SR))<Lng do begin
         SC := SC + ' ';
         if (length(SL)+length(SC)+length(SR))<Lng then
            SC := ' ' + SC;
      end; {while}
      S :=  SL + SC + SR;
      while length(S)<Lng do
         S := ' ';
      EmitIf(S);
      inc(LnsOnPg); inc(LnsSoFar);;
   end; {EndLine}

   procedure Center(var S:Str80);
   var
      K: byte;
   begin
      for K := length(S) div 2 to 37 do
         S := ' ' + S;
   end; {Center}

   procedure TopLine(FNam: PathStr);
   var
      K: byte;
   begin
      TextAttr := (FoundC);
      SR := ' ' + PresentTime + ', ' + PresentLongDate + ' ';
      SL := ' ' + FNam;
      if Title='' then
         NameString(SL);
      if (length(SL)+length(SC)+length(SR)) > 76 then
         SR := ' ' + PresentTime + ', ' + PresentShortDate + ' ';

      if (length(SL)+length(SC)+length(SR)) > 76 then begin
         SL := FFNam + '...';
         if pos('Global',FNam)<>0
            then SL := SL + ' (Global)';
      end;
      if (FilAtt<$3F) and (length(SL)+length(SC)+length(SR)<72) then begin
         SL := SL + '  Attr:' ;
         if ShoNorm then
            if RealAtt>0 then begin
               SL := SL + 'N' + AttStrg;
               if AttStrg[length(AttStrg)]=' ' then
                  dec(SL[0]);
           end {if ShoNorm}
           else
              SL := SL + 'N'
         else
            SL := SL + AttStrg;
      end;
      Pause;
      if (OutFile<>'&&') or Global then
         {emit(BlankLine);}
         Blank2File;
      inc(LnsOnPg); inc(LnsSoFar);
      Pause;
      Blank2File;{emit(BlankLine);}
      inc(LnsOnPg); inc(LnsSoFar);
      if LnsOnPg>=(LnsPerPg - 2) then Pause;
      EndLine;
      TextAttr := FrameC;
      if not (JustTotals or Global) then
         BarLine(DblH)
      else
         Barline(MidT);
   end; {TopLine}

   procedure BottomLines(Last: boolean);  {2 dirs}
   var
    { L: longint;}
     Ch:   char;
     K:    byte;
     NDrs    : word;
     TotClst : word;
     NFils   : word;
     TempN,
     TotSiz  : longint;
   begin
      if not Last then begin
         NDrs    := NDirs;
         TotClst := TotClust;
         NFils   := DirK;
         TotSiz  := TotSize;
      end
      else
         with GlobTot do begin
            Ndrs    := NrDirs;
            NFils   := NrFiles;
            TotSiz  := FilSiz;
            TotClst := NrClust;
         end; {with GlobTot}
      TextAttr := (FrameC);
      if (DskErr<15) or  not NoSuchDir then begin
         if not (Last or ( JustTotals)) then
            BarLine(MidBS);
         if global and Last then begin
            if LnsOnPg>=(LnsPerPg - 2) then Pause;

            SC := ' Grand Totals:';
            {SC := '';
            SR := '';}
            TopLine(FFNam + ' (Global)');
            if LnsOnPg>=(LnsPerPg - 2) then Pause;
            SL := '  Dirs: '
         end {if Global & Last}
         else
            SL := 'Dirs: ';
         if NDrs=0
            then SL := SL + 'None  Files: '
            else SL := SL + StrgW(NDrs,1)+ '  Files: ';
         if NFils-NDrs = 0 then
            SL := SL + 'None  '
          else
            SL := SL + Commified(StrgW(NFils-NDrs,1));
         SL := SL + ' (' + commified(StrgLI(TotSiz,1)) + ') ' ; {totbytes}
         SC := '';
         SR := 'Clusters: ';
         if TotClst=0 then
            SR := SR + 'None '
         else
            SR := SR + StrgLI(TotClst,1) + ' (' + Commified(StrgLI(TotClst*ClusterSize,1))
            + ')';
         SR := SR +  '  % Used: ';
         if TotClst>0 then
             SR := SR + StrgR(100 * (TotSiz/(TotClst*ClusterSize)),4,1)
         else
             SR := SR + '  --  '; {TotBytes}
         if DskErr<>3 then begin
            Pause;
            EndLine;
         end; {if DskErr}
         if Last or not Global then begin
            Sc := '';
            if global and Last
              then SL := '  Disk '
              else SL :=  'Disk ';
            SL := SL + ThatDrv.Let + ':';
            TempN := DiskSize(ThatDrv.Num);
            if TempN<0
               then SC := 'N/A '
               else SC := commified(StrgLI(TempN,1)) + ' bytes      ';
            SC := 'Capacity: ' +SC;
            TempN := DiskFree(ThatDrv.Num);
            if TempN<0
               then SR := 'N/A '
               else SR := commified(StrgLI(TempN,1)) + ' bytes';
            SR := 'Free: ' + SR;
            Pause;
            EndLine;
         end; {if not Global &c}
      end; {if not NoSuchDir or DiskErr}
      Barline(DblH);
      TextAttr := (FoundC);
      if (not Global) or last {or (DirPtr^.Next=nil)} then begin
        SL := Logo;
        SR := ' ' + ByLine + ' ';
        SC := '';
        if LnsOnPg>=(LnsPerPg - 2) then Pause;
        EndLine;
      end {if not global &c}
      else
         Last := Last;
      if Global and not Last then
         with GlobTot do begin
            NrDirs    := NrDirs + NDrs;
            NrFiles   := NrFiles + NFils;
            FilSiz    := FilSiz  + TotSiz;
            NrClust   := NrClust + TotClst;
         end; {with GlobTot}
   end; {BottomLines}

   function Extn(D: PathStr): Str3;
   var
      K: byte;
   begin
      Dot := pos('.',D);
      if (Dot=0) or (Dot>9) then
         D := ''
      else
         D := copy(S,succ(Dot),3);
      while pos(' ',D)<>0 do
         dec(D[0]);
      Extn := D;
   end; {Extn}

   procedure SendALine(J,K: word);
   var
      X:         word;
      Idx,
      ShortFall: byte;
   begin
      if not JustTotals then begin
         TextAttr := RegC;
         ShortFall := Lng - pred(Columns*succ(Wdth));
         {inc(Tot);}
         if (K+(J*NrOfRows)<=Dirk) then begin
            S := copy(SearchRecStrg(DStr[K+(J*NrOfRows)]^),1,Wdth);
            Ext := Extn(S);
            Dot := DStr[K+(J*NrOfRows)]^.Attr;
         end {if <=DirK}
         else begin;
            S := '';
            for X := 1 to Wdth do S := S + ' ';
            Ext := '';
            Dot := 0;
         end; {>DirK}
         if((Dot and Hidden) = Hidden)
            or ((Dot and SysFile) = SysFile)
            or ((Dot and 6) = 6)  then
               textAttr := SpookC
         else if Dot and ReadOnly = ReadOnly then
            TextAttr := SpookC
         else if (Ext = 'EXE') or (Ext = 'COM') or (Ext = 'BAT') then
            TextAttr := ExeC
         else if Dot and Directory = Directory then
            TextAttr := DirC
         else if Dot and VolumeID = VolumeID then
            TextAttr := VolC;

         Emit(Copy(S,1,12));
         TextAttr := RegC;
         delete(S,1,12);
         Emit(S);
         TextAttr := FrameC;
         if (Reverse and (J>0)) or ((Not Reverse) and (J<pred(Columns))) then begin
               emit(SingV);
               dec(ShortFall);
         end
         else if OutFile='&&' then begin
            TextAttr := RegC;
            S := '';
            for Idx := 1 to Shortfall do
                S := S + ' ';
            emit(S);
         end;
      end {if not JustTotals}
      else if (K+(J*NrOfRows)<=Dirk) then
         S := copy(SearchRecStrg(DStr[K+(J*NrOfRows)]^),1,Wdth);
      TextAttr := RegC;
   end; {SendALine}

begin {Display}
    if OutFile='' then begin
      SingV := '|';
      SingH := '-';
      DblH  := '=';
      MidT  := '+';
      MidB  := '+';
      MidTS := '+';
      MidBS := '+';
      MidMS := '+';
   end;

   If Dirk>0 then begin
      Case Sort of
         FileName:  SortOnFileName;
         Date:      SortOnDate;
         Siz:      SortOnSize;
         Extension: SortOnExt;
      end; {Case}
      if FixedColumns=0 then begin
         if DirK<=(LnsPerPg - HeadSpace) then
            Columns := 1
         else if DirK<= (2*(LnsPerPg - (HeadSpace div 2))) then
            Columns := 2
         else if DirK<= (4*(LnsPerPg - HeadSpace div 2)) then
            Columns := 4
         else
            Columns := 6;
      end {if not Fixed}
      else
         Columns := FixedColumns;
      if Columns>1 then begin
         Tabs := #13#20#30  + #41#49#54#76;
         W := 5;
      end
      else begin
         Tabs := #13#25#36   + #42#52#58#77;
         W := 10;
      end;
   end; {if DirK>0}
   if (OutFile='&&')
     then Lng := 80
     else Lng := 78;
   if (DirK=0) or JustTotals then begin
      Columns := 1;
      NrOfRows := 1;
      if JustTotals then NrOfRows := DirK;
   end
   else begin
      Title :='File';
      Title := PaddedTo(Title,ord(Tabs[2])-6);
      Title := Title + 'Size     Date';
      Title := PaddedTo(Title,ord(Tabs[3])+ 2);
      Title := Title + 'Time   Clust  Used  Attr';
      While length(Title)<Lng do
         Title := Title + ' ';
      NrOfRows := DirK div Columns;
      if (NrOfRows*Columns)<DirK then inc(NrOfRows);
         Case Columns of
            1: Wdth := 77;
            2: Wdth := 38;
            4: Wdth := 19;
            6: Wdth := 12;
         end; {case}
   end;
   BadEnds := [DblH,SingH,' '];
   {Tot := 0;}
   SC := Volume;
   while pos('.',SC)<>0 do delete(SC,pos('.',SC),1);
   SC := '  Volume: '+ SC;
   TopLine(FNam);
   TextAttr := FrameC;
   if (Dirk=0) then begin
      if Title='' then begin
         Title :=     'No files';
         AtStr := '';
         if AttStrg<>'All' then begin
            Title := Title + ' with ';
            if length(SC + AttStrg + FNam) > 68
               then Title := Title + 'att '
               else Title := Title + 'attribute ';
            AtStr := Attstrg;
            if ShoNorm then begin
               AtStr := 'N' + AtStr;
               if AtStr[length(AtStr)]=' ' then
                  dec(AtStr[0]);
            end; {else ''}
         end; {else not All}
         NamePtr := NameBase;
         Title := Title + AtStr + ' match ' + FNam;
         NameString(Title);
      end; {else not nosuchdir}
      while length(Title)<Lng do begin
         Title := Title + ' ';
         if length(Title)<Lng then
            Title := ' ' + Title;
      end; {while length}
      Pause;
      EmitIf(Title);
      inc(LnsOnPg); inc(LnsSoFar);
   end {if no dir or no files}
   else begin
      if not JustTotals then begin
         Title[0] := pred(char(Wdth));
         S := '';
         for J := 1 to Columns do begin
            S := S + Title;
            for K := length(Title) to pred(Wdth) do
               S := S + ' ';
            if J<Columns then
               S := S + SingV;
         end; {for J}
         Title := S;
         while length(Title)<Lng do
            Title := Title + ' ';
         Pause;
         EmitIf(Title);
         inc(LnsOnPg); inc(LnsSoFar);
      end; {if not JustTotals}
      if Reverse then
         for K := NrOfRows downto 1 do begin
            S := '';
            Pause;
            for J := pred(Columns) downto 0 do
                SendALine(J,K);
            if not JustTotals then begin
               if K>1 then Pause;
               EmitIf('');
            end; {if not JustTotals}
               inc(LnsOnPg); inc(LnsSoFar);
         end {for K}
      else
         for K := 1 to NrOfRows do begin
            S := '';
            Pause;
            for J := 0 to pred(Columns) do
               SendALine(J,K);
            if not JustTotals then begin
               EmitIf('');
               inc(LnsOnPg); inc(LnsSoFar);;
             end; {if not JustTotals}
      end; {for K}
   end; {else got dir and files}
   BottomLines(False);
   if Global and (DirPtr^.Next=nil) then
      with GlobTot do
         BottomLines(True);
end; {Display}

procedure FindEm(N:    Str128;
                 Att:  word;
             Var DirK: word;
             Var DStr: DStrType;
             Var SR:   SearchRec;
                 Err:  word);

   function FoundFile(Path:    string;
                      Attr:    word;
                      RealAtt: word): boolean;
   {If Path & Attr are NOT identical with Pth and Att, calls FindFirst,
   otherwise calls FindNext.  To re-initialize for same file spec, must
   first call with Path='' or known non-existent file}
   const
      Pth: string = '';
   var
      E:    word;
      Troo: boolean;
   begin
      Path := Incapitals(Path);
      if (Attr<>Att) or (Path<>Pth) then begin {find first file w right attr}
         Pth := Path;
         Att := Attr;  {save for later comparisons}
         FindFirst(Pth,Att,SR);
         Err := DosError;
         if Err<>0 then            {found nothing}
            Troo := False
         else if ((SR.Attr and Att)<>0)
                 or (ShoNorm and (SR.Attr=0)) then
            Troo := True                     {found file w right attr}
         else repeat
            SR.Attr  := Att;
            FindNext(SR);                    {found file but wrong attr}
            Err := DosError;
            Troo := ((SR.Attr and Att)<>0) or (ShoNorm and (SR.Attr=0));
         until (Err<>0) or Troo;
      end {if New Request}
      else begin
         repeat
            FindNext(SR);
            Err := DosError;
            Troo := ((SR.Attr and RealAtt)<>0) or (ShoNorm and (SR.Attr=0))
         until (Err<>0) or Troo;
      end; {Repeat Request}
      FoundFile := (Err=0) and Troo;
   end; {FoundFile}

   function Duplicate(Rec: SearchRec): boolean;
   var
      I: word;
   begin
      Duplicate := False;
      for I := 1 to DirK do
         if Rec.Name=DStr[I]^.Name then begin
            Duplicate := True;
            exit;
         end; {if Rec.Name}
   end; {Duplicate}

begin {FindEm}
   while (FoundFile(N, FilAtt,RealAtt)) do begin
      if DirK>MaxFiles then begin
         Bummer('Too many files',1);
      end; {if too many}
      if (SR.Name<>'') and (SR.Name[1]<>'.') then begin
         if not Duplicate(SR) then begin
            inc(DirK);
            inc(TotSize,SR.Size);
            if SR.Attr and Directory = Directory then
               inc(NDirs);
            New(DStr[DirK]);
            if (DStr[DirK]=nil) or (DirK>MaxFiles) then begin
               ExitWarning := '           ERROR BUT NOTE: Directory contains more than these '
                              + StrgB(pred(DirK),1)+' files.';
               exit;
            end; {if>MaxFiles}
            DStr[DirK]^ := SR;
         end; {if not Dup}
      end; {if not dots}
   end; {While FoundFile}
end; {FindEm}

procedure FindAndShow(PathStub: PathStr);
var
   DStr: DStrType;
   DirK: word;
   Att,
   Err,
   K:     word;
   SR:    SearchRec;

begin {FindAndShow}
      Att := FilAtt;
      DirK := 0;
      TotClust := 0;
      TotSize  := 0;
      NDirs    := 0;
      PathStub := Slash(PathStub);
      for K := 1 to MaxFiles do DStr[K] := nil;
      NamePtr := NameBase;
      while NamePtr<>Nil do begin
         FindEm(PathStub + NamePtr^.N,Att,DirK,DStr,SR,Err);
         NamePtr := NamePtr^.Next;
      end; {while not Nil}
      Display(DStr,DirK,PathStub);
      for K := 1 to DirK do
         Dispose(DStr[K]);
end; {FindAndShow}

procedure GiveHelp;
begin
   EmitLn(Logo + '   ' + ByLine +NL);
   EmitLn(' Syntax: DRL [d:][\path\]filename [filename..] [/attr] [/sort]');
   EmitLn('         [/V] [/1|2|4|6] [/G] [/J] [/O[=filespec]]' );
   EmitLn('     (Only the first filespec may contain drive or path.)'+NL);
   EmitLn('     /attr specifies files by attribute(s); may be one or more of:');
   EmitLn('               N = <N>ormal          L = Volume <L>abel');
   EmitLn('               R = <R>ead-only       D = <D>irectory');
   EmitLn('               H = <H>idden          A = <A>rchive');
   EmitLn('               S = <S>ystem         All = All files  (default)'{+NL});
   EmitLn('     /sort may be by:         F <F>ile Name      T <T>ime (& date)');
   EmitLn('                              X e<X>tension      B <B>ytes (file size)');
   EmitLn('     /V = re<V>erse the order                    U <U>nsorted (default)');
   EmitLn('     /number = number of columns; may be 1, 2, 4, or 6');
   EmitLn('        (if omitted, DRL tries to put the whole display on one screen)');
   EmitLn('     /G = <G>lobal (display whole directory tree)');
   EmitLn('     /J = Just Totals (without showing files).');
   EmitLn('     /O = send <O>utput to Standard Output (in pure ASCII w/o hi-bit chars)');
   EmitLn('     /O=filespec = send output (hi-bits & all) to file (may be PRN)' + NL);
   EmitLn(' Parameters can be combined: /XGO = /X /G /O (but O=filespec must come last)' );
     Emit(' DRL /?, /H or /HELP gets this screen.');
   halt;
end; {GiveHelp}

procedure GetParams;
const
   LegitN    = ['1','2','4','6'];
   AttrChars = ['N','R','H','S','L','D','A'];
   SortChars = ['F','X','B','T','U','V','O','G','J'];

var
   Temp   : Str128;
   CharStr: string[1];
   Err:     word;
   V:       integer;
   K:       byte;
   SLetter: char;

   procedure GetFatDat(DrvNum: char; var D: DrivDat);
   var
      Reg: Registers;
      {Dv:  byte;}
   begin
      with Reg do begin
         AH := $1C;
         DL := ThatDrv.Num;
         intr($21,Reg);
         with D do begin
            NSec   := AL; {sectors/cluster}
            FatSeg := DS; {FAT starts at FatSeg:FatOff}
            FatOff := BX;
            SecSiz := CX; {Bytes/sector}
            Clstrs := DX;  {Nr of clusters on drive}
            ClusterSize := NSec * SecSiz;
         end; {with D}
      end; {with Reg}
   end; {GetFatDat}

   function ScreenLinesPerPage: byte;
   var
      R: registers;
      N: byte;
   begin
     with R do begin
         AX := $1130;
         BH := 0;
         intr($10,R);
         N := succ(DL); {DL has highest row where lowest=0}
      end; {with R}            {Some EGA's have 1 too much here}
      if N in [44,51] then
         dec(N);
      ScreenLinesPerPage := N;
   end; {ScreenLinesPerPage}

   function ColorsAsFound: byte;
   var
      R:    DOS.Registers;
      X,Y:  byte;
   begin
      X := WhereX; Y := WhereY;
      dec(Y);
      GotoXY(1,Y);   {Read 1st char of prompt}
      with R do begin
         AH := $08;
         BH := 0;
         Intr($10,R);           {AH now has current attribute}
         ColorsAsFound := AH
         {TextColor(AH and 15);
         TextBackground((AH and 112) shr 4);}
      end; {with R}
      inc(Y);
      GotoXY(X,Y);   {Return whence you came}
   end; {ColorsAsFound}

   function UnpackedAttribute(Str: string;var RealAtt: integer): integer;
   var
      K:      byte;
      Result: integer;
   begin
      if (Str='') or (Str='All') or (Str='ALL') then begin
         Result := $3F;
         RealAtt := $3F;
         ShoNorm := True;
      end {''}
      else begin
         Result := 0;
         RealAtt := 0;
         for K := 1 to length(Str) do begin
            case Str[K] of
               'N': ShoNorm := True;
               'R': begin
                       Result := Result or 7;
                       RealAtt := RealAtt or 1;
                    end; {Read}
               'H': begin
                       Result := Result or 6;
                       RealAtt := RealAtt or 2;
                    end; {H}
               'S': begin
                       Result := Result or 6;
                       RealAtt := RealAtt or 4;
                    end; {S}
               'L': begin
                       Result := Result or 8;
                       RealAtt := RealAtt or 8;
                    end; {V}
               'D': begin
                       Result := Result or $10;
                       RealAtt := RealAtt or $10;
                    end; {D}
               'A': begin
                       Result := Result or $20;
                       RealAtt := RealAtt or $20;
                    end; {A}
            end; {case}
         end; {for K}
      end; {else not "All"}
      UnPackedAttribute := Result;
   end; {UnpackedAttribute}

   procedure SetOutPut;
   var
      Err: word;
   begin
      if OutFile = '' then begin
            assign(Output,'');
            rewrite(Output);
         end
         else begin
            Err := 0;
            assign(OutF,OutFile);
            {$I-}
            reset(OutF);
            {$I+}
            if IOresult<>0 then begin
               {$I-}
               rewrite(OutF);
               {$I+}
               Err := IOresult;
            end  {if IOresult}
            else begin
               {$I-}
               append(OutF);
               {$I+}
               Err := IOResult;
            end; {else}
         if Err<>0 then
            Bummer('Can''t open ' + OutFile,1);
      end; {else OutFile}
   end; {SetOutPut}

   function DeNamed(P: Str128): Str128;
   var
      K: byte;
   begin
      K := length(P);
      while (not (P[K] in PathSigns)) and (length(P)>0) do
         dec(K);
      P[0] := char(K);
      DeNamed := P;
   end; {DeNamed}

   function Depathed(P: Str128): NStr;
   var
      K: byte;
   begin
      K := length(P);
      while (not (P[K] in PathSigns)) and (K>0) do
         dec(K);
      DePathed := copy (P,succ(K),256);
   end; {Depathed}

   function FilledOutFNam(FNam: string): string;
   var
      Tmp:    string;
      FStuff: FSplitType;
      SRec:   SearchRec;
   begin
      with FStuff do begin
         P := FExpand(FNam);
         if pos(P,'*')=0 then
            if (IsDir(P)=0) and (P[length(P)]<>'\') then
                  P := P + '\';
         FSplit(P,D,N,E);
         if P=D then
            FilledOutFNam := P + '*.*'
         else
            FilledOutFNam := P;
         PathStub := D;
         ThatDrv.Let := D[1];
         ThatDrv.Num := ord(ThatDrv.Let)-64;
         while D[length(D)]='\' do
            dec(D[0]);
         if D[length(d)]=':' then
            D := D + '\';
         if ThatDir='' then begin
            ThatDir := D;
            DskErr := IsDir(ThatDir);
            NoSuchDir := True;
            case DskErr of
                   0: NoSuchDir := False;
                   3: Title := 'No such directory as ' + PathStub;
                  15: Title := 'No such drive as ' + ThatDrv.Let + ':';
                 152: Title := 'Drive '+ ThatDrv.Let+': not ready (no disk? door open?)';
                 else Title := 'Can''t read Drive ' + ThatDrv.Let + ':';
            end; {Case}
            if Volume='' then begin
               FindFirst(ThatDrv.Let+':\*.*',VolumeID,SRec);
               if DosError=0 then
                  Volume := SRec.Name
               else if DskErr <15 then
                  Volume := 'Unnamed Disk'
               else
                  Volume := '?';
            end; {if Volume}
         end; {if ThatDir}
      end; {with}
   end; {FilledOutFNam}

   procedure EnlistName(FN:Str128);
   begin
      if NameBase = nil then begin
         Temp := FilledOutFNam(FN);
         FNam := Temp;
         FFNam := FNam;
         New(NameBase);
         if NamePtr^.Next=nil then
            Bummer('Insufficient RAM for Name list',1);
         NamePtr := NameBase;
         NamePtr^.N := DePathed(Temp);
         PathStub:= DeNamed(Temp);
         NamePtr^.Next := nil;
      end {if nil}
      else begin
         Temp := DePathed(Temp);
         if Temp<>'' then begin
            FNam := FNam + ' ' + Temp;
            New(NamePtr^.Next);
            if NamePtr^.Next=nil then
               Bummer('Insufficient RAM for Name list',1);
            NamePtr := NamePtr^.Next;
            NamePtr^.N := Temp;
            NamePtr^.Next := Nil;
            MoreThan1 := True;
         end; {if <>''}
      end; {else not 1st name}
   end; {EnlistName}

   procedure GetThisParam;
   var
      K: byte;
   begin
     Temp := InCapitals(ParamStr(B));
     if not (Temp[1] in ParamSigns) then
        EnlistName(Temp)
    else begin
       for K := 1 to length(Temp) do
          if Temp[K] in AttrChars then
             AttStrg := Attstrg + Temp[K]
          else if Temp[K] in SortChars then
             case Temp[K] of
                'N': Sort := None;
                'F': Sort := FileName;
                'X': Sort := Extension;
                'T': Sort := Date;
                'B': Sort := Siz;
                'O': begin
                        if (length(Temp)>K)
                           and (Temp[succ(K)] in PramSigns) then begin
                           OutFile := copy(Temp,K+2,256);
                           exit;
                        end
                        else
                           OutFile := ''
                     end; {'O'}
                'V': Reverse := True;
                'G': Global := True;
                'J': JustTotals := True;
             end {case}
          else if Temp[K] in LegitN then begin
             Columns  := Ord(Temp[K])-48;
             FixedColumns := Columns;
          end; {if LeginN}
       end; {if ParamSign}
    end; {GetThisParam}

begin {GetParams}
   FoundC       := ColorsAsFound;
  { ClrScr  ;}
   Sort         := None;
   LnsPerPg     := ScreenLinesPerPage;
   LnsSoFar     := -2;
   LnsOnPg      := -3;
   Columns      := 0;
   Global       := False;
   FixedColumns := 0;
   GlobDirBase  := nil;
   GlobDirPtr   := nil;
   AttStrg      := '';
   OutFile      := '&&';
   CurDir       := CurrentDriveAndDirectory;
   MoreThan1    := False;
   Reverse      := False;
   JustTotals   := False;
   NameBase     := nil;
   NamePtr      := nil;
   ExitWarning  := '';
   Volume       := '';
   ThatDir      := '';
   Title        := '';
   with GlobTot do begin
      NrDirs    := 0;
      NrFiles   := 0;
      FilSiz    := 0;
      NrClust   := 0;
   end; {with GlobTot}
   if ParamCount>0 then
      FNam := InCapitals(ParamStr(1));
   if (FNam='/?')
      or (FNam='/H')
      or (FNam='/HELP')then begin
         OutFile := '';
         SetOutPut;
         GiveHelp;
      end; {if /?}
   PathStub := '';
   FNam := '';
   V := ParamCount;
   for B := 1 to V do begin
      GetThisParam;
   end; {else <2 params}
   if FNam= '' then begin
      FNam := '*.*';
      EnlistName(FNam);
   end; {else no FNam}
   FilAtt := UnpackedAttribute(AttStrg,RealAtt);
   AttStrg := FileAttStrg(RealAtt);
   if FilAtt<$3F then
      while AttStrg[length(AttStrg)]=' ' do dec(AttStrg[0])
   else
      AttStrg := 'All';
   if OutFile<>'&&' then
      SetOutput;
   GetFatDat(ThatDrv.Let{FNam[1]},DriveData);
   while (FFNam>'') and not (FFNam[length(FFNam)] in PathSigns)  do
      dec(FFNam[0]);
end; {GetParams}

procedure Init;
begin
   DirBase := nil;
   DirPtr  := nil;
   {Recurses := 0;}
end; {Init}


procedure FindDirs(FilNam: PathStr);
var
   K: byte;
(*
   procedure PrintList;
   begin
      DirPtr := DirBase;
      Emitln('Printing Dirs:');
      while DirPtr<>nil do begin
         Emitln(DirPtr^.Name);
         DirPtr := DirPtr^.Next;
      end;
   end; {PrintList}
*)
   procedure PutInList(P: PathStr);

   begin
      if Root(P) then
         P := Slash(P);
      if DirBase=nil then begin
         New(DirBase);
         if DirBase=nil then
            Bummer('Can''t make DirBase',1);
         DirBase^.Name := P;
         DirBase^.Next := nil;
         DirPtr := DirBase;
      end {if DirBase}
      else begin
         new(DirPtr^.Next);
         if DirPtr^.Next=nil then
            Bummer('Insufficient RAM for pointer to '+P,1);
         DirPtr := DirPtr^.Next;
         DirPtr^.Name := P;
         DirPtr^.Next := nil;
      end;
   end; {PutInList}

   function CleanPathName(P: PathStr): PathStr;
   begin
      while pos('*',P)<>0 do dec(P[0]);
      if P[length(P)]='\' then dec(P[0]);
      CleanPathName := P;
   end; {CleanPathName}

   procedure PrepareDir(var P: PathStr; SR: Str12);
   begin
      P := CleanPathName(P);
      P := P;
      PutInList(P);
   end; {PrepareDir}

   Procedure GetTheDirs(P: PathStr;SR: SearchRec);
   var
      Err: word;
      Stub: PathStr;
   begin
      PrepareDir(P,SR.Name);
      Stub := P;
      FindFirst(Slash(P)+'*.*',Directory,SR);
      while DOSError<>18 do begin
         if SR.Name[1]<>'.' then begin
            P := Slash(Stub) + SR.Name;
            if (SR.Attr and Directory)=Directory then begin
               {inc(Recurses);}
               GetTheDirs(Slash(P),SR);    {============= Recursion Here}
               {write(Recurses,' ');
               dec(Recurses);}
            end
            else
               SR.Attr := directory;
         end; {if <> '.'}
         FindNext(SR);
      end; {while DOSError}
   end; {GetTneDirs}

begin {FindDirs}
   Init;
   with SplitName do begin
      FSplit(FilNam,D,N,E);
      FilNam := D;
   end; {with}
   FilNam := CleanPathName(FilNam);
   if FilNam[length(FilNam)]<>':'
      then FilNam := FExpand(FilNam)
      else FilNam[1] := UpCase(FilNam[1]);
   if (Isdir(FilNam)>0) and (FilNam[length(FilNam)]='\') then
      dec(FilNam[0]);
   if Global then
      GetTheDirs(FilNam,SR)
   else
      PutInList(FilNam);
(*   PrintList;
   EmitLn('End of Dir List (press any key to continue');
   repeat until Keypressed; *)
end; {FindDirs}


begin {main}
   HeapError := @HeapFunc;
   GetParams;
   FindDirs(FNam);
   if not NosuchDir then begin
      DirPtr := DirBase;
      while DirPtr<>nil do begin
         FindAndShow(DirPtr^.Name);
         DirPtr := DirPtr^.Next;
      end {while DirPtr}
   end {if not NoSuchDir}
   else begin
      for E := 1 to MaxFiles do DSt[E] := nil;
      DrK := 0;
      Display(DSt,DrK,FNam);
   end;
   if (OutFile<>'&&') and (OutFile<>'') then
      close(OutF);
(*   repeat until keypressed; *)
end. {main}