/* FL.C  -- FILE LOCATOR by Michael P. Kelly

   This program was written in Turbo C v2.0 and will search your current
   disk drive (hard or floppy) for the file(s) that you request.

*/

#include <stdio.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include <stdlib.h>
#include <ctype.h>
#include <bios.h>
#include <flash.h>

#define		DIRS		50    	/* max number of subdirectories */
#define		SIZE		13	/* filename.ext length		*/
#define		PATHLEN		67	/* max length of path name	*/

struct ffblk info;                     	/* holds file find information  */
char original[PATHLEN];                 /* users original directory	*/
char filespec[SIZE];                   	/* filespec user is looking for */
int matches = 0;			/* matches of filespec found	*/
char *months[] = { "JAN","FEB","MAR","APR","MAY","JUN",
		   "JUL","AUG","SEP","OCT","NOV","DEC" };
char *location;
char drive[MAXDRIVE];
char dir[MAXDIR];
char file[MAXFILE];
char ext[MAXEXT];
char test[PATHLEN];

void traverse(char *subname);
int getsubdirs(char (*mike)[SIZE]);
void look(char *lostfile);
char *str_2_lower(char *str);
void file_time(unsigned t);
void file_date(unsigned t);
char *justify(char *name);
void userwait(void);
int read_key(void);
int wbuffer;

main(int argc, char *argv[])
{
   /* make <filespec> global and get the original directory  	*/
   strcpy(filespec,argv[1]);
   getcwd(original,PATHLEN-1);

   /* if there are no arguments, display the instructions and quit.	*/
   if(argc < 2) {
      location = searchpath("FL.DAT");
      fnsplit(location,drive,dir,file,ext);
      if(strcmp("\\",dir) != 0)
	 dir[strlen(dir)-1] = '\0';
      chdir(dir);
      if(win_lib("FL.DAT")) {
	 printf("\nNo help available since FL.DAT cannot be found.\n");
	 printf("\nHINT:  Place FL.EXE and FL.DAT in any of your PATH directories!\n");
	 return(0);
      }
      wbuffer = open_win("title",WE_CENTER_OUT,3);
      read_key();
      close_win(wbuffer,WE_SLIDE_DOWN,1);
      wbuffer = open_win("instruct",WE_SLIDE_UP,1);
      read_key();
      close_win(wbuffer,WE_CURTAIN,1);
      wbuffer = open_win("final",WE_CENTER_OUT,1);
      chdir(original);
      return(0);
   }

   clrscr();
   printf("\nFL - File Locator by 2LT Michael P. Kelly, (c) 1988-1989.\n");

   /* start at users request or the root directory		*/
   if(argc == 3)
      traverse(argv[2]);
   else
      traverse("\\");

   /* return user to the same directory that he started in.	*/
   chdir(original);
   printf("\n\n%d files found meeting the %s criteria.\n",matches,filespec);

   return(0);
}

void traverse(char *subname)
{
   char (*dir)[SIZE];		/* pointer to an array of SIZE chars	*/
   register int total;  	/* number of directories found   	*/
   register int index;  	/* counter               		*/
   char (*tmp)[SIZE];

   /* allocate enough memory and initialize the pointer to it.	*/
   dir = malloc(DIRS * SIZE + 1);
   if(dir == NULL) {
      printf("\nERROR:  Failed memory allocation.\n");
      chdir(original);
      exit(1);
   }
   tmp = dir;

   /* check to be sure that the directory change worked.	*/
   if(chdir(subname) != 0) {
      printf("\n    ERROR:  Directory %s does not exist.\n",subname);
      chdir(original);
      exit(1);
   }

   /* get the number & names of subdirectories and check out each one	*/
   total = getsubdirs(dir);
   for(index = 0;index < total;dir++,index++)
      traverse((char *)dir);

   /* check for <filespec>, free memory, go to previous subdirectory	*/
   look(filespec);
   free(tmp);
   chdir("..");
}

/*
   Accepts a pointer to an array of SIZE characters, fills the arrays with
   the names of any subdirectories it finds and returns the number found
   to the calling routine.
*/
getsubdirs(char (*ptr)[SIZE])
{
   register int count = 0;

   findfirst("*.*", &info, FA_DIREC);	/* start looking       		*/
   if(info.ff_name[0] == '.') {    	/* do we have the . subdir?   	*/
      findnext(&info);        		/* yes, get the .. subdir too 	*/
      if(findnext(&info) != 0)    	/* is there another dir?  	*/
	 return(0);                	/* no, so return 0 subdirs here */
   }

   if(info.ff_attrib == FA_DIREC) {             /* is this a subdir?    */
      strcpy(*ptr++,info.ff_name);     		/* yes, place in array  */
      count++;                             	/* increment counter    */
   }

   while(findnext(&info) == 0) {        	/* go thru the rest     */
      if(info.ff_attrib == FA_DIREC) {          /* is this a subdir?    */
	 strcpy(*ptr++,info.ff_name);   	/* yes, place in array  */
	 count++;                          	/* increment counter    */
      }
   }

   return(count);          		/* return number of directories */
}

/*
   Check for any file(s) that meet the <filespec> criteria in this
   directory.  If found, print directory, file names and increment
   matches counter.
*/
void look(char *lostfile)
{
   char here[PATHLEN];                  	/* used to hold pathname  */

   if(findfirst(lostfile,&info,0x00) == 0) {
      getcwd(here,PATHLEN-1);
      printf("\n\n%s",here);
      printf("\n\t%s",justify(str_2_lower(info.ff_name)));
      printf("\t%7ld bytes ",info.ff_fsize);
      file_time(info.ff_ftime);
      file_date(info.ff_fdate);
      matches++;
      while(findnext(&info) == 0) {
	 printf("\n\t%s",justify(str_2_lower(info.ff_name)));
	 printf("\t%7ld bytes ",info.ff_fsize);
	 file_time(info.ff_ftime);
	 file_date(info.ff_fdate);
	 matches++;
      }
   }
}

/*
   When passed a pointer to a character string, it will convert the string
   to all uppercase.  It also returns a pointer to that string as well.
*/
char *str_2_lower(char *str)
{
   char *tmp;

   tmp = str;
   while(*str != '\0')
      *str++ = tolower(*str);
   return(tmp);
}

/*
   The unsigned number from the ffblk structure is coded as follows:

	HHHHHMMM MMMSSSSS   -- as unsigned int
	  c[1]     c[0]     -- as two unsigned characters
*/
void file_time(unsigned t)
{
   union twobytes {
      unsigned char c[2];
      unsigned u;
   } f;
   unsigned hours;
   unsigned mins;
   char zone[3] = "am";

   f.u = t;
   hours = f.c[1] >> 3;
   mins = ((f.c[1] & 7) << 3) + (f.c[0] >> 5);
   if(hours > 11) {
      strcpy(zone,"pm");
      if(hours > 12)
	 hours -= 12;
   }
   if(hours == 0)
      hours = 12;
   printf(" %2u:%02u %s ",hours,mins,zone);
}

/*
   The unsigned number from the ffblk structure is coded as follows:

	YYYYYYYM MMMDDDDD    -- as unsigned int
	  c[1]     c[0]      -- as two unsigned characters
*/
void file_date(unsigned t)
{
   union twobytes {
      unsigned char c[2];
      unsigned u;
   } f;
   unsigned day;
   unsigned month;
   unsigned year;

   f.u = t;
   day = (f.c[0] & 31);
   month = ((f.c[1] & 1) * 8) + (f.c[0] >> 5);
   year = 1980 + (f.c[1] >> 1);
   printf(" %s %2u %4u ",months[month-1],day,year);
}

/*
   When passed a pointer to an array of SIZE characters, it will left-
   justify the filename and extension by padding with blank spaces.  It
   returns a pointer to the changed array.
*/
char *justify(char *name)
{
   char *tmp;
   char work[SIZE];
   int index;
   int count;

   tmp = work;
   for(index = 0;index < 13;index++)
      *(tmp + index) = ' ';
   *(tmp + 12) = '\0';
   for(index = 0;*(name + index) != '.';index++)
      *(tmp + index) = *(name + index);
   *(tmp + 8) = '.';
   index++;
   for(count = 9;*(name + index) != '\0';count++,index++)
      *(tmp + count) = *(name + index);
   strcpy(name,tmp);

   userwait();			/* best place to check for a pause!!!	*/
   return(name);
}

/*
   This function checks for any keystroke.  If found it pauses and waits
   for another keystroke before returning to the caller.
*/
void userwait(void)
{
   if(bioskey(1) != 0) {
      bioskey(0);
      while(bioskey(1) == 0);
      bioskey(0);
   }
}