
   NNAAMMEE
      ls - list the contents of a directory

   SSYYNNOOPPSSIISS
      llss [ -aAbcCdfFghilmnopqrRstux ] [ _f_i_l_e_n_a_m_e ]...

   DDEESSCCRRIIPPTTIIOONN
      For each _f_i_l_e_n_a_m_e which is a directory, llss lists the contents of
      the directory;  for each _f_i_l_e_n_a_m_e which is a file, llss repeats its
      name and any other information requested.  By default, the output
      is sorted alphabetically.  When no argument is given, the current
      directory is listed.  When several arguments are given, the
      arguments are first sorted appropriately, but file arguments are
      processed before directories and their contents.

      This version uses a file globbing mechanism similar to sshh(1), so
      giving commands like "ls */*.[ch]" will produce results similar to
      those produced by sshh(1).

      In order to determine output formats for the --CC, --xx, and --mm
      options, llss examines the COLUMNS environment variable to determine
      the number of character positions available on an output line.  If
      this variable is not set, 80 columns are assumed.

      The mode printed under the --ll option contains 6 characters
      interpreted as follows.  Each character represents one bit of the
      directory attribute field.  The characters represent:
         a     the ARCHIVE attribute;
         d     entry is a directory;
         v     entry is a volume label;
         s     the SYSTEM attribute;
         h     the HIDDEN attribute;
         r     the READ-ONLY attribute.

      Dates and times are always printed with the same format, to make
      life easier for scripts and token parsers.

   OOPPTTIIOONNSS
      The following options can appear either on the command line
      (preceding any other arguments) or in the environment variable
      LSFLAGS (for example, "set LSFLAGS=ACbp").

      --aa List all entries;  in the absence of this option, the "." and
         ".." entries or entries that have the HIDDEN or SYSTEM attribute
         are nnoott listed.

      --AA Same as -a, except that "." and ".." are not  listed.

      --bb Force printing of non-graphic characters to be in the octal \ddd
         notation.

      --cc Use time of last modification for sorting or printing.  If not
         available, 0 is used and dashes are printed.

      --CC Force multi-column output, with entries sorted down the
         columns.

      --dd If argument is a directory, list only its name (not its
         contents);  often used with --ll to get the status of a directory.

      --ff Not supported.

      --FF Mark directories with a trailing slash ('/') and executable
         files with a trailing asterisk ('*').  llss is generous in the
         interpretation of "executable".

      --gg Same as --ll.

      --hh Display a more complete usage description on the standard
         output.

      --ii Not supported.

      --ll List in long format, giving attributes, size in bytes, and time
         of last modification for each file.  If the file is a device the
         attribute field will contain the string "DEVICE", and the size
         field will contain the hexadecimal representation of the magic
         number returned by the system.

      --mm Stream output format;  the file names are printed as a  list
         separated by commas, with as many entries as possible printed on
         a line.

      --nn Same as --ll.

      --oo Same as --ll.

      --pp Put a slash ('/') after each filename if that file is a
         directory.

      --qq Display non-graphic characters in filenames as the character ?;
         this is the default when output is to a terminal.

      --rr Reverse the order of sort to get reverse alphabetic or oldest
         first as appropriate.

      --RR Recursively list subdirectories encountered.

      --ss Give size of each file in kilobytes.

      --tt Sort by time modified (latest first) instead of by name.

      --uu Use time of last access instead of last modification for sorting
         (with the -t option) and/or printing (with the -l option).

      --xx Multi-column output with entries sorted across rather than down
         the page.

   Copyright (c) 1991  Frank E. Whaley  All rights reserved
