/*
  ---------------------------------------------------------------------------
  This program is placed into the public domain.  While it does not have all
  the bells and whistles of other programs like SYSID, it does provide the
  basics.

  ACKNOWLEDGEMENTS

	a.  Bruce Morgan's EMSFUNC.C functions enlightened me to the Turbo C
		geninterrupt () function as well as the use of _AX, etc in place of
		r.x.ax.  I also used his type definitions.

	b.  Info on other portions of the program were obtained from Robert
		Alonso's superb book, "Turbo C DOS UTILITIES."

  If you enhance this program (and feel free to do so)
  please let me know, and please, do not name your program INFO.EXE as it
  causes confusion among users.

  Most of the functions are self-documenting; however, I have placed comments
  where further explanation is necessary.
  ---------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <string.h>
#include <dos.h>
#include <conio.h>
#include <graphics.h>
#include <fcntl.h>

#define TRUE		1
#define FALSE		0
#define getEMS()    geninterrupt (0x67);  /* Turbo C's get interrupt func- */
										  /* tion.  Int 67 is for EMS      */
typedef unsigned char byte;
typedef unsigned int word;

char *current_directory (char *path)
{
	strcpy (path, "X:\\");			/* copy X:\\ into path   */
	path[0] = 'A' + getdisk();      /* get current drive     */
	getcurdir (0, path+3);          /* get current directory */
	return (path);
}

union REGS r;

void main (), memory_check (), dos_version ();
void hard_drive_check (), system_check (), restor_cur ();
void directory_and_environment (), hard_disk_ok ();
void video_check (), ems_memory (), del_cur ();

/* *env[] reads the environment string (requires argc and argv */
void main (int argc, char *argv[], char *env[])
{
	clrscr ();
	textbackground (BLUE);
	textcolor (YELLOW);
	cprintf ("Quick System Info, 4 February 1990, BSG Software\n\r");
	textbackground (BLACK);
	dos_version ();
	memory_check ();
    ems_memory ();
    video_check ();
	hard_drive_check ();
	hard_disk_ok ();
	system_check ();
	cprintf ("\n\n\rPress any key to continue");
    del_cur ();
	getche ();
    restor_cur ();
	clrscr ();
	directory_and_environment (env);
	textcolor (WHITE);
	cprintf ("\n\n\rPress any key to continue");
    del_cur ();
	getch ();
    restor_cur ();
}


mem_stats()
{
	r.h.ah = 0x88;
	return int86 (0x15, &r, &r);
}


void dos_version (void)
{
	r.h.ah = 0x30;
	r.h.al = 0x00;
	intdos (&r, &r);

	textcolor (WHITE);
	cprintf ("\n\rDOS version");
	textcolor (LIGHTGREEN);
	cprintf (" %d.%d", r.h.al, r.h.ah);
	textcolor (WHITE);
	cprintf (" is installed\n\r");
}


void memory_check (void)
{
	int i, mem_size;

    mem_size = biosmemory ();
	i = mem_stats ();
	textcolor (WHITE);
	cprintf ("\n\rMemory is configured as..... ");
	textcolor (YELLOW);
	if (i < 0)
		cprintf ("%dK base, 0K extended", mem_size);
	else cprintf ("%dK base, %dK extended",mem_size,i);
}


void system_check (void)
{
	int status;

    status = biosequip ();		/* determine presense of coprocessor */
	textcolor (WHITE);
	cprintf ("\n\rA math coprocessor is.......");
	textcolor (YELLOW);
	if ((status & 0x02) == 2)
		cprintf (" present");
	else
		cprintf (" not present");

	status = biosequip ();
	status &= 0xE000;
	textcolor (WHITE);
	cprintf ("\n\rParallel ports attached.....");
	textcolor (YELLOW);
	switch (status) {
		case      0 : cprintf (" 0");
					  break;
		case  16384 : cprintf (" 1");
					  break;
		case  32768 : cprintf (" 2");
					  break;
		case  49152 : cprintf (" 3");
					  break;
	}

    status = biosequip ();
	status &= 0xE00;
	textcolor (WHITE);
	cprintf ("\n\rSerial ports attached.......");
	textcolor (YELLOW);
	switch (status) {
		case  0 : cprintf (" 0");
				  break;
		case 512: cprintf (" 1");
				  break;
		case 1024 : cprintf (" 2");
				  break;
		case 1536 : cprintf (" 3");
				  break;
	}

	status = biosequip ();
	textcolor (WHITE);
	cprintf ("\n\rSerial printers attached....");
	textcolor (YELLOW);
	if ((status & 0x2000) == 0)
		cprintf (" 0\n\r");
	else
		cprintf (" 1\n\r");

    textcolor (WHITE);
	cprintf ("Game port present...........");
	textcolor (YELLOW);
	if ((status & 0x1000) == 0)
		cprintf (" No");
	else
		cprintf (" Yes");

	textcolor (WHITE);
}

void directory_and_environment (env)
char *env[];
{
	int i;
	char curdir[MAXPATH];

    textcolor (WHITE);
	current_directory (curdir);
	cprintf ("\n\rThe current directory is.... ");
	textcolor (YELLOW);
	cprintf ("%s", curdir);

    textcolor (WHITE);
	cprintf ("\n\n\rThe environment string(s) are: \n\n\r");

	textcolor (YELLOW);
    for (i=0; env[i] != NULL; i++)
        cprintf ("   %s\n\r", env[i]);
}



void hard_drive_check (void)
{
    int i, value;
	char c[2], type[25];

    textcolor (WHITE);
	cprintf ("\n\rExistent floppy drives...... ");
	for (i=0; i<7; i++) {
		r.h.ah = 0x08;
		r.h.dl = i;
		int86 (0x13, &r, &r);

		switch (i) {
			case 0 : strcpy (c,"A");
					break;
			case 1 : strcpy (c,"B");
					break;
			case 2 : strcpy (c,"C");
					break;
			case 3 : strcpy (c,"D");
					break;
			case 4 : strcpy (c,"E");
					break;
			case 5 : strcpy (c,"F");
					break;
			case 6 : strcpy (c,"G");
					break;
			case 7 : strcpy (c,"H");
					break;
			case 8 : strcpy (c,"I");
					break;
		}

		switch (r.h.bl) {
			case 1 : strcpy (type, "360 KB, 40 track, 5.25\"");
					break;
			case 2 : strcpy (type, "1.2 MB, 80 track, 5.25\"");
					break;
			case 3 : strcpy (type, "720 KB, 80 track, 3.50\"");
					break;
			case 4 : strcpy (type, "1.44 MB, 80 track, 3.50\"");
					break;
		}

        if (r.h.bl != 0) {
			textcolor (YELLOW);
			cprintf ("%s is a %s drive\n\r", c, type);
			cprintf ("                             ");

		}
	}

    textcolor (WHITE);
	cprintf ("\rLogical hard drives present: ");
	textcolor (YELLOW);

	_AH = 0x0E;				/* calls DOS's interrupt 21, function 0EH - */
    _DL = 8;                /*   select disk & returns # logical drives */
    geninterrupt (0x21);

    value = _AL;
    for (i=_AL; i>0; --i) {
        _AH = 0x36;
        _DL = value;
        geninterrupt (0x21);
        if (_AX != 0xffff || _BX < 2000)
            break;
        else value--;
    }
    cprintf ("%d ", value);
}

void hard_disk_ok ()
{
	int i, number = 0;

	textcolor (WHITE);
	cprintf ("\n\rNumber physical hard drives: ");
	for (i=0; i<27; i++) {
		r.h.ah = 0x10;
		r.h.dl = 0x80+i;
		int86 (0x13, &r, &r);

		if (r.h.ah == 0) {
			number += 1;
			textcolor (YELLOW);
			cprintf ("%d ", number);
		}
	}

}


void video_check ()
{
	int graphdriver = DETECT;			/* automatically determine driver*/
	int graphmode;

	/* call detectgraph to determine hardware */
	detectgraph (&graphdriver, &graphmode);

	if (graphdriver < 0) {
		cprintf ("No graphics hardware available!\n\r");
		exit (1);
	}

	/* report detected hardware */
	textcolor (WHITE);
	cprintf ("\n\rType graphics adaptor....... ");
	textcolor (YELLOW);
	switch (graphdriver) {
		case CGA     : cprintf ("Color Graphics Adapter (CGA)");
					   break;
		case MCGA    : cprintf ("Multicolor Graphics Array (MCGA)");
					   break;
		case EGA     :
		case EGA64   :
		case EGAMONO : cprintf ("Enhanced Graphics Adapter (EGA)");
					   break;
		case HERCMONO: cprintf ("Hercules Color Card");
					   break;
		case ATT400  : cprintf ("AT&T 640x400 Card");
					   break;
		case PC3270  : cprintf ("IBM PC 3270");
					   break;
		case VGA     : cprintf ("Video Graphics Array (VGA)");
					   break;
	}
}


void ems_memory ()
{
	word totalMem, freeMem;
	char *ptr;

	ptr = DetectEMM ();

	if (ptr != FALSE) {
		_AH = 0x42;     /* get number of ems pages */
		getEMS();

		totalMem = _DX;
		freeMem  = _BX;

		textcolor (WHITE);
		if (_AH == 0) {
			cprintf ("\n\rTotal expanded memory.......");
			textcolor (YELLOW); cprintf (" %4u K bytes, %4u K bytes unused",\
										 totalMem*16, freeMem*16);
		}
	} else {
		textcolor (WHITE);
		cprintf ("\n\rTotal expanded memory.......");
		textcolor (YELLOW); cprintf (" None");
	}
}


DetectEMM()
{
	int fh, retval;
	char dummy[128];

	if ((fh=_open ("EMMXXXX0", O_RDONLY)) == -1)
		return FALSE;			/* EMM driver is not present */

	retval = ioctl (fh, 7, dummy, 0);
	_close (fh);

	return retval;
}


/* remove the cursor when waiting for input - looks unprofessional */
void del_cur ()
{
    r.h.ah = 01;
    r.h.ch = 0x26;
    r.h.cl = 7;
    int86 (0x10, &r, &r);
}



/* restore the cursor to the screen */
void restor_cur ()
{
    r.h.ah = 01;
    r.h.bh = 00;
    r.h.ch = 6;
    r.h.cl = 7;
    int86 (0x10, &r, &r);
}
