/*-
 * pwd.c  -- main program for `pwd' for MSDOS
 * Barry Schwartz, 21 August 1990
 *
 * Command usage:
 *    pwd [drive ...]
 *
 * Each drive may be specified with or without a trailing colon.
 * If no drive is given, the default drive is assumed.
 *
 * If any of the `drive' specifications is invalid for some reason,
 * the message "invalid drive specification: %s", where %s is replaced
 * by the drive specification (or "<default drive>" if no arguments
 * were given and for some bizarre and probably scary reason the default
 * drive has been found to be "invalid"), is inserted in the output stream,
 * and the exit status will be 2.  Otherwise the exit status will be 0.
 * (The exit status 1 is reserved for possible future use to denote
 * some kind of fatal error.)
 */


#include <stdio.h>
#include <ctype.h>
#include <dos.h>
#include <stdlib.h>
#include "msdosmac.h"


char           *get_working_directory();


#if 0
char           *progname;
#endif
int             exit_status;



void
print_invalid_drive_spec(char *arg)
{
    printf("invalid drive specification: %s\n", arg);
    exit_status = 2;
}



void
print_working_directory(int drive, char *arg)
{
    static char     buf[_MAX_DIR];

    if (!get_working_directory(buf, drive))
	print_invalid_drive_spec(arg);
    else
    {
	CONVERT_TO_SLASHES(buf);
	printf("%c:/%s\n", drive + 'a' - 1, buf);
    }
}


#if 0

void
usage()
{
    fprintf(stderr, "usage: %s [drive ...]\n", progname);
    exit(1);
}

#endif



int
main(argc, argv)
int             argc;
char          **argv;
{
    int             drive;

    exit_status = 0;

#if 0
    EXTRACT_PROGRAM_NAME(argv[0]);
    progname = argv[0];
#endif

    if (argc == 1)
    {
	_dos_getdrive(&drive);
	print_working_directory(drive, "<default drive>");
    }
    else
    {
	int             arg_index = 0;
	char           *arg;

	while (++arg_index != argc)
	{
	    arg = argv[arg_index];
	    drive = tolower(arg[0]);	/* Requires a `smart' tolower() */
	    if (!islower(drive) || (arg[1] && (arg[1] != ':' || arg[2])))
		print_invalid_drive_spec(arg);
	    else
	    {
		drive -= 'a' - 1;	/* Convert to 1, 2, 3, ... */
		print_working_directory(drive, arg);
	    }
	}
    }

    return exit_status;
}
