/*
  note: include this file to spawn a new window whenever
        program is executed
*/
#include "..\shared\syncdir.h"
#include <commctrl.h>

static char      name[MAX_PATH]; // program name
static char     *cmdLine;
static char    **argv = 0;
static int       argc = 0;

int sysError()
{
  return errno;
}

int parseCmdLine(LPSTR pCmdLine)
{
  GetModuleFileName(0, name, sizeof(name));
  cmdLine = VMALLOC(char, strlen(pCmdLine));
  strcpy(cmdLine, pCmdLine);

  for ( ; ; )
  {
    char *ptr = cmdLine;
    argc = 1;
    //
    // ignore preceding whitespace
    //
    while (isspace(*ptr))
      ptr++;
    while (*ptr)
    {
      if (*ptr == '"')
      {
        ptr++;
        if (argv)
          argv[argc] = ptr;
        while (*ptr && (*ptr != '"'))
          ptr++;
      } else
      {
        if (argv)
          argv[argc] = ptr;
        while (*ptr && !isspace(*ptr) && (*ptr != '"'))
          ptr++;
      }
      if (*ptr)
      {
        if (argv)
          *ptr = 0;
        ptr++;
      }
      while (isspace(*ptr))
        ptr++;
      argc++;
    }
    if (argv)
      break;
    else
    {
      argv = REALLOC(char *, argv, argc);
      argv[0] = name;
    }
  }
  return argc;
}

int WINAPI WinMain(HINSTANCE inst, HINSTANCE pInst, LPSTR lpCmdLine, int nShow)
{
  int ret;
  UNUSED(inst);
  UNUSED(pInst);
  UNUSED(nShow);

  InitCommonControls();
  parseCmdLine(lpCmdLine);

  ret = syncdir(argc, argv);
  free(argv);
  free(cmdLine);
  return ret;
}
