program cacherep;

{ Program to print cache report; needs to have CACHEMON loaded before
  and after the disk cache }

uses opstring,opinline;
type
  cachemon_ptr = ^cachemon_rec;
  cachemon_rec = record
    read_count,
    read_sects,
    write_count,
    write_sects : longint;
    drive_id : byte;
    more_sig : longint;
    my_name  : string[8];
  end;

  buftype = array[0..$8000+30] of char;

var
  bt : btable;

const
  signature:string[32] = 'CACHEMON 1.0 disk access monitor';
  more_sig : longint = $12345678;

function find_driver(prev:cachemon_ptr):cachemon_ptr;
var
  buf : ^buftype;
  match : word;
  monitor : cachemon_ptr;
  segment,offset : word;

begin
  segment := seg(prev^);
  offset := ofs(prev^);
  repeat
    buf := ptr(segment,offset);
    if offset < sizeof(buftype) then
      match := bmsearch(buf^, sizeof(buftype)-offset, bt, signature)
    else
      match := $FFFF;

    if match <> $FFFF then
    begin
      monitor := ptr(segment,match+offset+length(signature));
      if monitor^.more_sig = more_sig then
      begin
        find_driver := monitor;
        exit;
      end;
      offset := offset + match + length(signature);
    end
    else
    begin
      inc(segment, $800);
      offset := 0;
    end;
  until segment > $f000;
  find_driver := nil;
end;

procedure syntax_exit;
begin
  writeln('Syntax:  CACHEREP [/R]');
  writeln(' will search memory for CACHEMON monitors, and print results.');
  writeln(' /R option will reset all counters to 0.');
  halt;
end;

function pct(num,den:longint):integer;
begin
  if den = 0 then
    pct := 0
  else
    pct := (100*num + den div 2) div den;
end;

const
  tablesize = 10;

var
  monitor : cachemon_ptr;
  monitor_seg : word;
  i,num : integer;
  resetcounts : boolean;
  table : array[1..tablesize] of cachemon_ptr;
  maxreads : longint;
  last_loaded : integer;

begin
  writeln('CACHEREP v. 1.0 - copyright (c) 1990 D.J. Murdoch.');
  if paramcount > 1 then
    syntax_exit;
  if paramcount = 1 then
  begin
    if stupcase(paramstr(1)) <> '/R' then
      syntax_exit;
    resetcounts := true;
  end
  else
    resetcounts := false;

  bmmaketable(signature,bt);

  monitor := nil;
  num := 0;

  { Find the monitors }

  repeat
    monitor := find_driver(monitor);
    if monitor <> nil then
    begin
      monitor_seg := seg(monitor^) + ofs(monitor^) div 16;
      if (monitor_seg < prefixseg) or (monitor_seg > seg(freeptr^)+$1000) then
      begin
        inc(num);
        table[num] := monitor;
      end;
    end;
  until (monitor=nil) or (num=tablesize);

  if num = 0 then
  begin
    writeln('No cache monitors found!');
    halt;
  end;

  { find the one with the largest number of reads }
  maxreads := 0;
  last_loaded := 1;
  for i:=1 to num do
    if table[i]^.read_count > maxreads then
    begin
      last_loaded := i;
      maxreads := table[i]^.read_count;
    end;

  writeln(' #     Name     Reads  %   Sectors  %     Writes  %   Sectors  %');
  for i:=1 to num do
    with table[i]^ do
      writeln(i:2, my_name:9,
        read_count:10, pct(read_count,table[last_loaded]^.read_count):4,
        read_sects:8, pct(read_sects,table[last_loaded]^.read_sects):5,
       write_count:10,pct(write_count,table[last_loaded]^.write_count):4,
       write_sects:8,pct(write_sects,table[last_loaded]^.write_sects):5);

  if resetcounts then
  begin
    writeln('Resetting all counters to 0.');
    for i:=1 to num do
      with table[i]^ do
      begin
        read_count := 0;
        read_sects := 0;
        write_count := 0;
        write_sects := 0;
      end;
  end;

end.
