/*************************************************************
 *                                                           *
 * Program DCOPY - physical sector to sector copy     	     *
 * Copyright (c) 1986 Joerg Genius, Munich, West-Germany     *
 *                                                           *
 * Rev. 3.1.2 added /r command to verify only                *
 * Rev. 3.3.0 added support for 3.5" disks                   *
 *************************************************************/

#include <stdio.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "dcdefs.h"


main(argc,argv)

int argc;
char *argv[];

{
   int source,destination;
   FILE *fopen(),*outfile;
   char filename[257];

   printf (text[0],VERSION);
   printf (text[1],REV_DATE);
   if (dcinit()==-1) {
      fprintf (stderr,text[2]);
      return (-1);
   }
   if (argc<3 || argc>5) {
      usage();
      return (0);
   }
   if (argv[1][1]!=':' && argv[2][1]!=':') {
      usage();
      return (0);
   }
   if (argv[2][1]==':' && argv[1][1]==':' && argv[2][2]=='\0' && argv[1][2]=='\0') {
      source=toupper(argv[1][0])-'A';
      destination=toupper(argv[2][0])-'A';
      if (source==destination) {
         fprintf (stderr,text[3]);
         return (0);
      }
      if (source<0 || source>MAX_DRV || destination<0 || destination>MAX_DRV) {
         fprintf (stderr,text[4],MAX_DRV+'A');
         return (0);
      } 
      dcopy(source,destination,(strcmp(argv[3],"/v")==0 ? 1 : 
                               (strcmp(argv[3],"/r")==0 ? 2 : 0)));
   }
   else if (argv[1][1]==':' && argv[1][2]=='\0') {
      source=toupper(argv[1][0])-'A';
      if (source<0 || source>MAX_DRV) {
         fprintf (stderr,text[4],MAX_DRV+'A');
         return (0);
      } 
      strcpy(filename,argv[2]);
      if (strchr(argv[2],'.')==NULL)
      	 strcat(filename,".IMG");
      if ((outfile=fopen(filename,"wb"))==NULL) {
      	 fprintf (stderr,text[5],filename);
      	 return (0);
      }
      if (dfdestination(filename,source,outfile,(strcmp(argv[3],"/n")==0 || strcmp(argv[4],"/n")==0 ? 1 : 0))==0)
         fclose (outfile);
      else {
         fclose (outfile);
         unlink (filename);
      }
   }
   else if (argv[2][1]==':' && argv[2][2]=='\0') {
      destination=toupper(argv[2][0])-'A';
      if (destination<0 || destination>MAX_DRV) {
         fprintf (stderr,text[4],MAX_DRV+'A');
         return (0);
      } 
      strcpy(filename,argv[1]);
      if (strchr(argv[1],'.')==NULL)
      	 strcat(filename,".IMG");
      if ((outfile=fopen(filename,"rb"))==NULL) {
      	 fprintf (stderr,text[6],filename);
      	 return (0);
      }
         dfsource(filename,outfile,destination,(strcmp(argv[3],"/v")==0 || strcmp(argv[4],"/v")==0 ? 1 :
                                               (strcmp(argv[3],"/r")==0 || strcmp(argv[4],"/r")==0 ? 2 : 0)),
                                               (strcmp(argv[3],"/n")==0 || strcmp(argv[4],"/n")==0 ? 1 : 0));
      fclose (outfile);
   }
   else
      usage();
}
