/*************************************************************
 *                                                           *
 * Program DCOPY - physical sector to sector copy     	     *
 * Copyright (c) 1986 Joerg Genius, Munich, West-Germany     *
 *                                                           *
 *************************************************************/

#include <stdio.h>
#include <alloc.h>
#include <dos.h>
#include "dcdefs.h"


dcinit()

{
   unsigned int cnt=120;
   union REGS regs;

   while ((disk_buffer=malloc(cnt*512))==NULL)
      cnt--;
   if (cnt<=5) {
      return -1;
   }
   blk_p_buffer=cnt;
   regs.h.ah=0x19;
   intdosx(&regs,&regs,NULL);
   regs.h.dl=regs.h.al;
   regs.h.ah=0x0e;
   intdosx(&regs,&regs,NULL);
   MAX_DRV=regs.h.al-1;
   return 0;
}


get_drive_data(disk,drive_s)

int disk;
struct drive_data *drive_s;

{
   union REGS regs;

   regs.h.ah=0x1c;
   regs.h.dl=disk+1;
   intdosx(&regs,&regs,NULL);
   if (regs.h.al==0xff) {
      fprintf (stderr,text[7],disk+'A');
      return 1;
   }
   drive_s->sec_p_cluster=regs.h.al;
   drive_s->bytes_p_sec=regs.x.cx;
   drive_s->cluster_p_drive=regs.x.dx;
   drive_s->sec_p_drive=drive_s->sec_p_cluster*drive_s->cluster_p_drive;
   switch (drive_s->sec_p_drive) {
      case 768 :
                 drive_s->sec_p_drive=800;
                 break;
      case 351 :
                 drive_s->sec_p_drive=360;
                 break;
      case 708 :
                 drive_s->sec_p_drive=720;
                 break;
      case 313 :
                 drive_s->sec_p_drive=320;
                 break;
      case 630 :
                 drive_s->sec_p_drive=640;
                 break;
      case 2371:
                 drive_s->sec_p_drive=2400;
                 break;
      case 1426:
                 drive_s->sec_p_drive=1440;
                 break;
      case 2847:
                 drive_s->sec_p_drive=2880;
                 break;
      default:
                 drive_s->sec_p_drive=0;
   }
   if (drive_s->sec_p_drive==0) {
      fprintf (stderr,text[28],disk+'A');
   } else
      return 0;
}


unsigned int get_max_blocks(blocks_per_drive)

int blocks_per_drive;

{
   switch (blocks_per_drive) {
      case 2400 :
                  disk_type=0;
                  return (blk_p_buffer/30==0 ? blk_p_buffer-1 : (blk_p_buffer/30)*30);
      case  800 :
                  disk_type=1;
                  return (blk_p_buffer/10==0 ? blk_p_buffer-1 : (blk_p_buffer/10)*10);
      case  720 :
                  disk_type=2;
                  return (blk_p_buffer/18==0 ? blk_p_buffer-1 : (blk_p_buffer/18)*18);
      case  640 :
                  disk_type=3;
                  return (blk_p_buffer/16==0 ? blk_p_buffer-1 : (blk_p_buffer/16)*16);
      case  360 :
                  disk_type=4;
                  return (blk_p_buffer/9==0 ? blk_p_buffer-1 : (blk_p_buffer/9)*9);
      case  320 :
                  disk_type=5;
                  return (blk_p_buffer/8==0 ? blk_p_buffer-1 : (blk_p_buffer/8)*8);
      case 1440:
                  disk_type=6;
                  return (blk_p_buffer/9==0 ? blk_p_buffer-1 : (blk_p_buffer/9)*9);
      case 2880:
                  disk_type=7;
                  return (blk_p_buffer/18==0 ? blk_p_buffer-1 : (blk_p_buffer/18)*18);
   }
}


read_block(disk_src,start_block,num_blocks,buffer_adr)

int disk_src;
unsigned int start_block,num_blocks;
char *buffer_adr;

{
   union REGS iregs;
   struct SREGS isregs;
   
   iregs.h.al=disk_src;
   iregs.x.dx=start_block;
   iregs.x.cx=num_blocks;
   iregs.x.bx=FP_OFF(buffer_adr);
   isregs.ds=FP_SEG(buffer_adr);
   int86x(0x25,&iregs,&iregs,&isregs);
   return (iregs.h.al);
}

write_block(disk_dest,start_block,num_blocks,buffer_adr)

int disk_dest;
unsigned int start_block,num_blocks;
char *buffer_adr;

{
   union REGS iregs;
   struct SREGS isregs;
   
   iregs.h.al=disk_dest;
   iregs.x.dx=start_block;
   iregs.x.cx=num_blocks;
   iregs.x.bx=FP_OFF(buffer_adr);
   isregs.ds=FP_SEG(buffer_adr);
   int86x(0x26,&iregs,&iregs,&isregs);
   return (iregs.h.al);
}
