Procedure MaxCyl(Var Drive,CylMax:Integer);
{
    This procedure determines how many cylinders are on the specified drive

    Input        Drive    Integer specifying drive to test

    Output       MaxCyl   Number of usable cylinders on specified Drive

    Strategy     (1)      Request bios to interrogate disk controller and
                          find the highest cylinder on the hard disk drive

                 (2)      Increment to get total number of usable cylinders

                 (3)      Write cylinder count for user

}
Type
    Result=Record
                 Ax,Bx,Cx,Dx,Bp,Si,Di,Ds,Es,Flags:Integer;
    End;
Var
   Sys:Result;
Begin
     SYS.AX:=$8*$0100+$01 { AH=8 means get parameters, AL=sector };
     SYS.CX:=$0*$0100+$01 { CH=Cylinder, CL=Sector };
     SYS.DX:=$0*$0100+$80+drive { DH=head, DL=$80+Drive };
     Intr($13,Sys);
     If Odd(Sys.Flags) then
        begin
             NormVideo;
             Writeln('Error finding maximum cylinder on drive ',Drive);
             Halt;
        End;

     CylMax:=Hi(Sys.Cx)+(Lo(Sys.Cx) Div $40)*$0100;

     CylMax:=CylMax+1;

     LowVideo;
     Write('   ..Found ');
     NormVideo;
     Write(CylMax);
     LowVideo;
     Write(' cylinders.  ');

End;