
//=========================================================//
void clean_file(uint cluster,ulong file_size)
	{
	// uint cluster = first cluster of the file
	// ulong file_size = size of this file
    ulong	j;
	ulong	first_sector;    // first_sector = first sector of the cluster
	ulong	last_sector;     // last_sector = last sector of the cluster
	uint 	next_cluster;	 // next_cluster = value of a cluster - points to next cluster
	uint	last_cluster;	 // last cluster number
	ulong 	fat_sector;      // fat_sector = relative sector number of the fat table
	ulong	next_fat_sector; // next_fat_sector = relative sector number of the fat table for the next cluster
	ulong	num_clusters;    // num_clusters = number of clusters in the directory
	uint 	fat_offset;      // fat_offset = offset into the sector to find the next cluster value
	uint	next_fat_offset; // next_fat_offset = same for next cluster
	uchar 	*fat_sec_buf;       // *fat_sec_buf = pointer to fat sector buffer
	uchar 	*next_fat_sec_buf;  // *next_fat_sec_buf = pointer to next fat sector buffer
	ulong	file_size_left;		// whats left in the last cluster
    uchar	far* data_buf;		// holds the last cluster of data

	fat_sec_buf = (uchar *)calloc(hdb.bytes_sector, sizeof(uchar));
	if( fat_sec_buf == NULL )
		{
		cprintf("\n\rFailed to allocate fat_sec_buf in cln_file");
		getch();
		exit(0);
		}

	next_fat_sec_buf = (uchar*)calloc(hdb.bytes_sector,sizeof(uchar));
	if( next_fat_sec_buf == NULL )
		{
		cprintf("\n\rFailed to alloc next_fat_sec_buf in cln_file");
		getch();
		exit(0);
		}

	data_buf = (uchar far*)farcalloc( (ulong)hdb.sectors_cluster*(ulong)hdb.bytes_sector, sizeof(uchar) );
	if( data_buf == NULL )
		{
		cprintf("\n\rFailed to allocate data_buf in cln_file");
		getch();
		exit(0);
		}

	fat_sector =  ((ulong)cluster * 2L)/(ulong)hdb.bytes_sector
				  // use the first fat so add in the reserved sectors
				  + (ulong)hdb.reserved_sectors;
	fat_offset = (uint)(((ulong)cluster * 2L) % (ulong)hdb.bytes_sector);
	read_sec((uchar far*)fat_sec_buf, fat_sector,1);  // read the fat sector
	next_cluster = *(uint*)&fat_sec_buf[(uint)fat_offset];

	last_cluster = cluster; // save it
	// count the clusters for this directory
	num_clusters = 1L; // got at least one
	file_size_left = file_size;
	while( next_cluster != 0xffff )
		{
		last_cluster = next_cluster; // the next cluster value is not 0xffff so save the number
		file_size_left -= (ulong)hdb.sectors_cluster*(ulong)hdb.bytes_sector;
		num_clusters += 1L; // go more than one
		// find the sector holding the next cluster
		next_fat_sector =  (ulong)((next_cluster * 2)/hdb.bytes_sector)
				+ (ulong)hdb.reserved_sectors;  // use the first fat so add in the reserved sectors
		// find the offset into the sector for the next cluster
		next_fat_offset = (next_cluster * 2) % hdb.bytes_sector;
		// read the fat sector
		read_sec((uchar far*)next_fat_sec_buf, next_fat_sector,1);
		// get the value of the cluster
		next_cluster = *(uint*)&next_fat_sec_buf[(uint)next_fat_offset];
		}  // when finished - num_clusters has the number of clusters in the directory

	calc_cluster_sectors( last_cluster, &first_sector, &last_sector );
	// here last_cluster holds the last cluster number of the chain and the last cluster number
	// of the file
	// file_size_left holds the remaining file data size
	// first_sector holds the first sector value
	// number of sectors in the cluster is hdb.sectors_cluster

	// get the data in the data_buf
	rd_multi( (uchar far*)data_buf, first_sector, 1, hdb.sectors_cluster );
	// now overwrite the data in the cluster, cleaning it all
	wt_multi( (uchar far*)big_bufzero, first_sector, 1, hdb.sectors_cluster );
	wt_multi( (uchar far*)big_buf55, first_sector, 1, hdb.sectors_cluster );
	wt_multi( (uchar far*)big_bufaa, first_sector, 1, hdb.sectors_cluster );
	wt_multi( (uchar far*)big_bufzero, first_sector, 1, hdb.sectors_cluster );
	// put the data back

	// zero the unused area of the data buffer
	j = file_size_left;
	while( j < hdb.sectors_cluster*hdb.bytes_sector )
		{
		*(data_buf+(uint)j) = 0x00;
		j++;
		}
	// now write the data back to the cluster
	wt_multi( (uchar far*)data_buf, first_sector, 1, hdb.sectors_cluster );
	// finished
	free(fat_sec_buf);
	free(next_fat_sec_buf);
	farfree(data_buf);
	}

