/*
 * df_cmd.c - ancillary routines for checking df's command line
 */

#include <stdio.h>
#include <dir.h>
#include <ctype.h>
#include "dfbits.h"

/* see if we have an argument on the command line.  If so, just print help
 * and return non-zero; otherwise, return zero.  Crude but effective.
 */
int found_an_option( int ac, char **av )
{
	int i, found_one;
	char c;
	char prgname[9];

	for( i = 1, found_one = 0; i <= ac; ++i )
	{
		if( av[i][0] == '/' || av[i][0] == '-' )
		{
			found_one = 1;
			break;

		}
	}

	if( found_one )
	{
		if( tolower(av[i][1]) != 'h' && av[i][1] != '?' )
			fprintf( stderr, "invalid option\n\n" );

        fnsplit( av[0], NULL, NULL, prgname, NULL );
		fprintf( stderr, "usage: %s [/? | /h | [drive...]]\n", prgname );
		fprintf( stderr, "       /? or /h : prints this message\n" );
		fprintf( stderr, "       drive... is 0 or more drives (A: through Z:)\n" );
		fprintf( stderr, "       run df with no parameters to check all drives\n" );

		return( 1 );
	}
	else
    	return( 0 );
}



/*
 * scan the command line for drive arguments, update drive flags as needed
 */
void check_drive_args( int ac, char **av, long *dbits )
{
	int i;
    char c;


	if( ac > 1 )	/* then we presumably have some drive args */
	{
    	CLEAR_ALL( *dbits );
		for( i = 1; i <= ac; ++i )
		{
			if( isalpha(c=av[i][0]) )        // we're looking at the 1st
			{                                // char of each command line
				tolower(c);                  // arg & junking it if it's
				SET_BIT( *dbits, (c-'a') );  // not a letter
			}
		}

		if( *dbits == 0 )     	/* none of the args were valid */
			SET_ALL( *dbits );
	}
}
