REM Ellipse function. PD 2002.

DEFSNG A-Z
DECLARE FUNCTION rho# (ntheta#, a!, b!)

COMMON SHARED ndta AS INTEGER
COMMON SHARED sumtheta, deltheta AS INTEGER

CLS
SCREEN 12, 0
COLOR 1

pi = ATN(1) * 4    ' define PI
dpts = 180         ' data points per pi control circle arclength
hypC = 1

instar = 24
pixratio = 48 / 64 ' screen pixels
scrnset = 4 / 3
pix = 64 * .5 ' pixels per inch

clrC = 13: clrE = 5: clrRF = 1  ' color curve, ellipse, ref lines

DIM SHARED rvctr1(dpts, 3)
DIM SHARED rvctr2(dpts, 3)

DIM SHARED phi(6) AS DOUBLE
DIM SHARED phi4(6) AS DOUBLE

deltheta = (dpts / 180) * 18 ' for surface fuselage lines at ** degree intervals

' plx = parallax (eye separation) / 2
plx = 1.2
setx = 330:   sety = 240    ' v-basic screen set zero on 640 * 200 pixels

epi = pi / dpts    ' epsilon for eliminating discontinuity at pi/2, -pi/2
                    ' skips data point: note for error report
a1 = 1.7: b1 = 1.5     ' upper test ellipse:  b must be less than a
a2 = 1.6: b2 = 1.5      ' lower test ellipse:   also  [ b < a ]

thestar = pi / 12'pi '7 * pi / 12 'pi / 2   ' stack, test data points
phistar = 0 'pi / 2'-pi / 3            ' roll, yaw, pitch
omstar = 0   'pi / 3'pi / 2'pi / 6 '-pi / 3 ' pi / 6  '      [ trials ]

xref = 0  '  deltx     three axis reference translation
yref = 0  '  delty     vector on [ x' y' z' ]
zref = 0  '  deltz     [ trial data points ]

a = a1: b = b1         ' for integration 0 to pi/2 - epi  (top ellipse and
clr = 1          ' color for reference lines               '   mirror image)
last2 = 0: last4 = 0
thestart = 0
cntrl = 1
se = 0
selocal = 0
selast = 0

flaghalf = -1
FOR theta = epi TO pi / 2 - epi STEP pi / dpts  'increment theta
ndta = ndta + 1
GOSUB vectors
NEXT

a = a2: b = b2         ' bottom ellipse and mirror image
selocal = 0
se = 0                      ' error note:   last interval of top half
ndta = 0                          ' ellipse gets left out here;  will correct with
'last2 = 0: last4 = 0          ' exact expansion series for arcellipse
thestart = pi / 2              ' see weierstrass  1879
cntrl = 2

flaghalf = 0
FOR theta = epi + pi / 2 TO -epi + pi STEP pi / dpts
ndta = ndta + 1
GOSUB vectors
NEXT

DO

FOR phistar = pi / 36 TO 2 * pi STEP pi / 12
omstar = omstar + pi / 36
IF omstar > 2 * pi - pi / 36 THEN omstar = 0

' integrate ellipse zero to pi/2 - epi
sumtheta = 0

FOR ndta = 1 TO dpts
    x = rvctr1(ndta, 1): y = rvctr1(ndta, 2): z = rvctr1(ndta, 3)
    Rx = x: Ry = y: Rz = z
    GOSUB curvplot
    Rx = x: Ry = y: Rz = -z
    GOSUB curvplot
    Rx = x: Ry = -y: Rz = z
    GOSUB curvplot
    Rx = x:   Ry = -y: Rz = -z
    GOSUB curvplot
    x = rvctr2(ndta, 1): y = rvctr2(ndta, 2): z = rvctr2(ndta, 3)
    Rx = x: Ry = y: Rz = z
    GOSUB curvplot           ' plot hyperbolic cosine curve
    Rx = x: Ry = y: Rz = -z
    GOSUB curvplot             ' plot mirror image: y = -y
    Rx = x: Ry = -y: Rz = z
    GOSUB curvplot
    Rx = x:   Ry = -y: Rz = -z
    GOSUB curvplot
NEXT
NEXT
LOOP
END

arcellipse:     ' integrates arclength of reference ellipse

'phi0 = thestart      ' set interval begin
phi2 = 0                ' reset transition variables
phi4 = 0             ' note : parabolic approximation
arcse = 0              ' also note : interval pi/2 - epi to pi/2 will be
                           ' left out due to discontinuity at pi/2
FOR n = 0 TO 6
   phi(n) = theta - epi + (pi / dpts) * n / 6
NEXT

FOR n = 1 TO 5
   phi2 = phi2 + 2 * rho(phi(n), a, b)
NEXT

FOR n = 1 TO 6
   phi4 = phi4 + 4 * rho(((phi(n) + phi(n - 1)) / 2), a, b)
NEXT

front = (phi(6) - phi(0)) / 36
start = phi(0) + phi(6)

arcse = front * (start + phi2 + phi4)
selocal = selocal + arcse

IF cntrl = 1 THEN     ' for bottom portion of hypC curve
   se = selocal          ' se in radians
   selast = se         ' ERROR REPORT:  arclength from pi/2-epi tp pi/2 will
ELSE                   ' plotted off by this amount, unoticeable but not okay;
   se = selocal + selast     ' have exact arclength solution almost ready -
END IF                   ' very difficult series - will check with weierstrass
RETURN                            ' 05 MAR 2002       pfm

rotate:     ' rotation matrix, or tensor, in vector form, very beautiful tri-symmetry

xdelx = -Rx * SIN(thestar)
xdely = Rx * COS(thestar) * COS(omstar)
xdelz = Rx * COS(thestar) * SIN(omstar)

ydelx = Ry * SIN(phistar) * COS(thestar)
ydely = -Ry * (COS(phistar) * SIN(omstar) - SIN(phistar) * SIN(thestar) * COS(omstar))
ydelz = Ry * (COS(phistar) * COS(omstar) + SIN(phistar) * SIN(thestar) * SIN(omstar))

zdelx = Rz * COS(phistar) * COS(thestar)
zdely = Rz * (COS(phistar) * SIN(thestar) * COS(omstar) + SIN(phistar) * SIN(omstar)) ' * COS(thestar))
zdelz = Rz * (COS(phistar) * SIN(thestar) * SIN(omstar) - SIN(phistar) * COS(omstar))

deltx = xdelx + ydelx + zdelx      ' accumulate vector components from
delty = xdely + ydely + zdely       ' [ x y z ] vector to [ x' y' z' ]
deltz = xdelz + ydelz + zdelz         ' ( 3-d vector spaces, 4-d in motion )

RETURN

image:                       ' calculate screen images, input is [ x' y' z' ]
zstrI = (pix * instar - zprmI) '    and output is:
Iphi = ATN(xprmI / zstrI)      '         ImC   mono x screen position (xstar)
'xstrI = 12 * 80 * TAN(Iphi)   '         ImY   y screen position (ystar)
Iomega = ATN(yprmI / zstrI)    '       zstrI   depth from screen
                               '         ImL   left screen xstar

ImC = instar * pix * TAN(Iphi)
ImR = instar * pix * (xprmI + plx * pix) / (instar * pix - zprmI) - plx * pix
ImL = instar * pix * (xprmI - plx * pix) / (instar * pix - zprmI) + plx * pix
ImY = -instar * pix * scrnset * pixratio * TAN(Iomega)

RETURN

vectors:   ' calculates hypC and ellipse vectors in [ x y z ]

bva = b ^ 2 / a ^ 2          ' b squared over a '
avb = 1 / bva                ' a squared over b squared
x11 = (1 - (1 - bva) * COS(theta) ^ 2)
x = SGN(COS(theta)) * a * SQR(1 - (SIN(theta) ^ 2) / x11)
y11 = (1 - (1 - avb) * SIN(theta) ^ 2)
y = SGN(SIN(theta)) * b * SQR(1 - (COS(theta) ^ 2) / y11)

rhosq = x ^ 2 + y ^ 2

GOSUB arcellipse ' calculates se


z = hypC * (EXP(se) + EXP(-se)) / 2        ' hyperbolic cosine se(theta)
                                  ' in flat (transform zero) development

IF flaghalf = -1 THEN
   rvctr1(ndta, 1) = x
   rvctr1(ndta, 2) = y
   rvctr1(ndta, 3) = z
ELSE
   rvctr2(ndta, 1) = x
   rvctr2(ndta, 2) = y
   rvctr2(ndta, 3) = z
END IF
RETURN

curvplot:

'  receives Rx : Ry : Rz   and rotates to xprime, yprime, zprime
'                       then translates  xref, yref, zref   and finally
'                    transforms to xstarL, xstarR, and ystar
IF Rz >= 6 THEN Rz = 6
IF Rz <= -6 THEN Rz = -6
GOSUB rotate

xprime = pix * (xref + deltx)
yprime = pix * (yref + delty)
zprime = pix * (zref + deltz)

zstar = (instar * pix - zprime)
IF zstar > 0 THEN     ' zstar postitive for red-green mix

Iphi = ATN(xprime / zstar)
Iomega = ATN(yprime / zstar)

xstar = instar * pix * TAN(Iphi)   ' note for behind eye angles > pi/2
xstarR = instar * pix * (xprime + plx * pix) / (instar * pix - zprime) - plx * pix
xstarL = instar * pix * (xprime - plx * pix) / (instar * pix - zprime) + plx * pix
ystar = -instar * pix * scrnset * pixratio * TAN(Iomega)

PSET (xstar + setx, ystar + sety), clrC

END IF

Rzhold = Rz
Rz = 0

GOSUB rotate
Exprime = pix * (xref + deltx)
Eyprime = pix * (yref + delty)
Ezprime = pix * (zref + deltz)

Ezstar = (instar * pix - Ezprime)         ' redundant (first composition) imaging
Iphi = ATN(Exprime / Ezstar)       ' solution, refined in subroutine image
Iomega = ATN(Eyprime / Ezstar)      ' - modulating program in progress -

Exstar = instar * pix * TAN(Iphi)
ExstarR = instar * pix * (Exprime + plx * pix) / (instar * pix - Ezprime) - plx * pix
ExstarL = instar * pix * (Exprime - plx * pix) / (instar * pix - Ezprime) + plx * pix
Eystar = -instar * pix * scrnset * pixratio * TAN(Iomega)

PSET (Exstar + setx, Eystar + sety), clrE
Rz = Rzhold

IF INKEY$ = CHR$(27) THEN         ' eject  = escape
   END
END IF
RETURN

FUNCTION rho# (ntheta#, a!, b!)
   rho# = 1 / SQR((COS(ntheta#) / a!) ^ 2 + (SIN(ntheta#) / b!) ^ 2)
END FUNCTION

