'The following example uses the Absolute routine to execute a
'machine-language program stored in an array. The program prints a
'message indicating whether or not a math coprocessor is installed.
 
'Note: To use the Absolute routine, you must load the Quick library
'QBX.QLB using the /L switch when you begin QBX.
 
'AsmBytes is a label; nASMBYTES is a symbolic constant.
CONST nASMBYTES = 14
DEFINT A-Z
DIM AsmProg(1 TO (nASMBYTES / 2))
 
'The machine-language program stored as data to read into the array.
AsmBytes:
DATA &H55              : 'PUSH BP        Save base pointer.
DATA &H8B, &HEC        : 'MOV  BP,SP     Get our own.
DATA &HCD, &H11        : 'INT  11H       Make the ROM-BIOS call.
DATA &H8B, &H5E, &H06  : 'MOV  BX,[BP+6] Get argument address.
DATA &H89, &H07        : 'MOV  [BX],AX   Save list in argument.
DATA &H5D              : 'POP  BP        Restore base pointer.
DATA &HCA, &H02, &H00  : 'RET  2         Pop argument off stack
                         '               and make far return.
'Get the starting offset of the array.
P = VARPTR(AsmProg(1))
'Poke the machine-language program into the array.
DEF SEG = VARSEG(AsmProg(1))   'Change the segment.
FOR I = 0 TO nASMBYTES - 1
   READ J
   POKE (P + I), J
NEXT I
 
'Execute the program. The program expects a single integer argument.
CALL Absolute(X%, VARPTR(AsmProg(1)))
DEF SEG   ' Restore the segment.
'X% now contains bit-encoded equipment list returned by DOS.
'Mask off all but the coprocessor bit (bit 2).
CoProcessor = X% AND &H2
'Print the appropriate message.
IF CoProcessor = 2 THEN
    PRINT "Math coprocessor present."
ELSE
    PRINT "No math coprocessor."
END IF
END

