Rem Program: Clrscrn v3.0a for DOS.

Rem Purpose: Blanks screen, waits for keypress or mouse activity then
Rem   waits for password (can be specified on command line).

Rem Author: Erik Jon Oredson
Rem Status: Public Domain 2002.
Rem Email: eoredson@yahoo.com

' get include file
Rem $Include: 'clrscrn.inc'

' read command line
Call GetCommandLine (CommandLine$)

' parse command line
If Len(CommandLine$) Then
   CommandLine$=Mid$(CommandLine$,2)
Endif

' store password
Password="password"
If Len(CommandLine$) Then
   Select Case CommandLine$
   Case "?", "-?", "/?"
      Goto Boot.Usage
   Case Else
      Password=CommandLine$
   End Select
Endif

' install new interrupt service routine
' traps Print-Screen & Control-Break
Call SetInt

' declare standard error trap
On Error Goto Error.Routine

' trap Control-Alt-Delete
Key 15, Chr$(12)+Chr$(83)
On Key(15) Gosub Trap
Key (15) On

' trap Shift-Control-Alt-Delete
Key 16, Chr$(15)+Chr$(83)
On Key(16) Gosub Trap
Key (16) On

Rem Could trap more shift states, such as:
Rem CapsLock-Shift-Control-Alt-Delete.

' start program loop
Do
   ' clear screen
   Cls

   ' clear mouse buttons
   Call MouseFunction(5,0)
   Call MouseFunction(5,1)
   Call MouseFunction(5,2)

   ' reset keyboard variable
   Keyboard=False

   ' store keyboard state
   Def Seg=0
   Keyboard1=Peek(&h417)
   Keyboard2=Peek(&h418)
   Def Seg

   ' reset mouse variables
   Mouse.Button1=False
   Mouse.Button2=False
   Mouse.Button3=False
   Mouse.Position=False

   ' store initial mouse position
   Call MouseFunction(3,0)
   Mouse.Y=OutregsX.CX
   Mouse.X=OutregsX.DX

   ' start clear screen loop
   Do

      ' call mouse subroutine
      Call MouseDriver
      If Mouse.Button1 Then
         Exit Do
      Endif
      If Mouse.Button2 Then
         Exit Do
      Endif
      If Mouse.Button3 Then
         Exit Do
      Endif
      If Mouse.Position Then
         Exit Do
      Endif

      ' call keyboard shift state subroutine
      Call KeyboardState
      If Keyboard Then
         Exit Do
      Endif

      ' check keyboard for keypress
      If Inkey$<>Nul Then
         Exit Do
      Endif

      ' release time slice
      Var=Release.Time
   Loop

   ' verify password
   Call ScreenPassword(Var0)
   If Var0 Then
      Exit Do
   Endif

   ' restart program loop
   Beep
Loop

' restore key trapping
Call RestInt

' clear screen
Cls

' end program
End

' critical error trap
Error.Routine:
 Data.Error = Err
 Select Case Data.Error
 Case 53
    Temp.Outpt$ = "File not found."
 Case 57
    Temp.Outpt$ = "Device I/O error."
 Case 61
    Temp.Outpt$ = "Disk full."
 Case 70
    Temp.Outpt$ = "Permission denied."
 Case 71
    Temp.Outpt$ = "Disk not ready."
 Case Else
    Temp.Outpt$ = "Untrapped error" + STR$(Data.Error) + "."
 End Select

 ' display critical error
 Color 10, 0
 Print Temp.Outpt$
 Color 7, 0

 ' restore key trapping
 Call RestInt

 ' end program
 End

' return after Control-Alt-Delete
Trap:
 ' make small sound
 Sound 1000,.1
 Return

' boot usage display
Boot.Usage:
 Color 15, 0
 Print "Clrscrn v3.0a for DOS."
 Print "Boot Usage:"
 Color 14, 0
 Print "Enter 'Clrscrn' on command line. Program clears screen, waits for"
 Print "keyboard or mouse acitivity, then prompts for password.  Password"
 Print "defaults to 'password'. Password is case-sensitive and may be"
 Print "entered on the command line, for example:"
 Color 15,0
 Print "Clrscrn pass2"
 Color 14,0
 Print "Program public domain 2002.
 Color 7,0
 End

' reads command line from PSP
Sub GetCommandLine (Var$)
 Var$ = Nul
 InregsX.AX = &h6200
 Call InterruptX(&h21, InregsX, OutregsX)
 PSPsegment = OutregsX.BX
 PSPoffset = 128
 Def Seg = PSPsegment
 For Count = 1 To 127
    Command.Char = Peek(PSPoffset + Count)
    Select Case Command.Char
    Case 0, 10, 13
       Exit For
    Case Else
       Var$ = Var$ + Chr$(Command.Char)
    End Select
 Next
 Def Seg
End Sub

' subroutine checks password
Sub ScreenPassword (VarX)
 VarX=False
 Cls
 Locate 13,35
 Color 15,0
 Print "Password";
 Color 7,0
 Uinput$=Nul
 Timer.Temp!=Timer
 Do
    ' get keyboard input
    Char$=Nul
    While Char$=Nul
       ' check elapsed time
       If Time.Elapsed(Timer.Temp!,15!) Then
          Exit Sub
       Endif
       ' store keystroke
       Char$=Inkey$
       ' release time slice
       Var=Release.Time
    Wend
    ' check Control-Break
    If Char$=Chr$(0)+Chr$(0) Then
       Char$=Nul
    Endif
    ' check input length
    If Len(Char$) Then
       ' check against password
       If Char$=Chr$(13) Then
          ' reset password flag
          If Uinput$=Password Then
             VarX=True
          Endif
          Exit Do
       Endif
       ' store input
       Uinput$=Uinput$+Char$
       ' check input length
       If Len(Uinput$)>127 Then
          Exit Do
       Endif
    Endif
 Loop
End Sub

' subroutine reads shift state of keyboard
Sub KeyboardState
 ' read keyboard shift state
 Def Seg=0
 Key1=Peek(&h417)
 Key2=Peek(&h418)
 Def Seg
 ' compare against stored state
 If Key1<>Keyboard1 Then
    Keyboard=True
 Endif
 ' compare against stored state
 If Key2<>Keyboard2 Then
    Keyboard=True
 Endif
End Sub

' subroutine checks mouse activity
Sub MouseDriver
 ' read left mouse button state
 Call MouseFunction(5,0)
 If OutregsX.BX>0 Then
    Mouse.Button1=True
    Exit Sub
 Endif
 ' read right mouse button state
 Call MouseFunction(5,1)
 If OutregsX.BX>0 Then
    Mouse.Button2=True
    Exit Sub
 Endif
 ' read middle mouse button state
 Call MouseFunction(5,2)
 If OutregsX.BX>0 Then
    Mouse.Button3=True
    Exit Sub
 Endif
 ' read mouse position
 Call MouseFunction(3,0)
 VarY=OutregsX.CX
 VarX=OutregsX.DX
 ' compare against stored state
 If VarX<>Mouse.X Then
    Mouse.Position=True
 Endif
 If VarY<>Mouse.Y Then
    Mouse.Position=True
 Endif
End Sub

' subroutine calls mouse bios function
Rem INT 33h, AX=03 - Return position and button status
Rem INT 33h, AX=05 - Return button press data

Sub MouseFunction(Var1,Var2)
 InregsX.AX=Var1
 InregsX.BX=Var2
 Call InterruptX(&h33,InregsX,OutregsX)
End Sub

' function determines elapsed time
Function Time.Elapsed(Start.Time!,Wait.Time!)
 ' store elapsed time
 Elapsed.Time!=Timer-Start.Time!
 ' check after midnight
 If Elapsed.Time!<0! Then
    Elapsed.Time!=Elapsed.Time!+86400!
 Endif
 ' compare to time
 If Elapsed.Time!>=Wait.Time! Then
    Time.Elapsed=True
 Else
    Time.Elapsed=False
 Endif
End Function

' function to release time slice in windows
Function Release.Time
 If Supported.Call=False Then
    InregsX.AX=&H1680
    InregsX.BX=&H0000
    Call InterruptX(&H2F,InregsX,OutregsX)
    If (OutregsX.AX And &HFF)=&H80 Then
       Supported.Call=True
    Endif
 Endif
 Release.Time=True
End Function
