	    .model  medium, basic	    ;Stay compatible with BASIC.
	    extrn   SETUEVENT: far
            .code
public      SETINT

SETINT      proc    uses ds                 ;Get old interrupt vector
            mov     ax, 3505H               ;and save it.
            int     21h
            mov     word ptr cs:OldVector, bx
            mov     word ptr cs:OldVector + 2, es
            push    cs                      ;Set the new
            pop     ds                      ;interrupt vector
            lea     dx, EventHandler        ;to the address
            mov     ax, 2505H               ;of our service
            int     21H                     ;routine.
            ret 
SETINT	    endp

public  EVENTHANDLER                        ;Make this routine
                                            ;public for debugging--
EVENTHANDLER	proc			    ;it will check to see if
                                            ;control-break has been pressed.
            push    ax                      ;save registers, and
            push    bx                      ;have BASIC set the
            push    cx                      ;user event flag.
            push    dx
            push    es
            call    SETUEVENT               ;call basic event notifier
            pop     es
            pop     dx                      ;Restore registers.
            pop     cx
            pop     bx
            pop     ax
            iret                            ; eat control-break keystroke
;           jmp     cs:OldVector            ;Continue on with the
                                            ;old service routine.

OldVector   dd      0                       ; keep data in code segment

EVENTHANDLER	endp

public      RESTINT

RESTINT     proc    uses ds                 ;Restore the old
            lds     dx, cs:OldVector        ;interrupt vector
            mov     ax, 2505H               ;so things will
            int     21h                     ;keep working when
            ret                             ;this BASIC program is
RESTINT     endp			    ;finished.
            end
