/*
 *	This program is Copyright (C) 1987 by the Board of Trustees of the
 *	University of Illinois, and by the author Dirk Grunwald.
 *
 *	This program may be freely copied, as long as this copyright
 *	message remaines affixed. It may not be sold, although it may
 *	be distributed with other software which is sold. If the
 *	software is distributed, the source code must be made available.
 *
 *	No warrenty, expressed or implied, is given with this software.
 *	It is presented in the hope that it will prove useful.
 *
 *	Hacked in ignorance and despiration by jonah@db.toronto.edu
 */
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <stdio.h>
#include <ctype.h>
#include "pxl.h"

/*
 *      The code to handle the \specials generated by tpic was modified
 *      by Dirk Grunwald using the code Tim Morgan at Univ. of Calif, Irvine
 *      wrote for TeXsun.
 */

	/* globals from xbmdvi.c */

extern char *prog;
extern Display *dsp;
extern struct bitmap *page_bm;
extern GC gcc;
extern double specialConv;

struct frame {
        long pxl_h, dvi_h, pxl_v, dvi_v, w, x, y, z;
};

extern struct frame *stack;
extern int stackp;

#define PXL_H   stack[stackp].pxl_h
#define PXL_V   stack[stackp].pxl_v


#define COMLEN  4

void applicationDoSpecial(cp)
char *cp;
{
    char command[COMLEN], *orig_cp;
    register int len;

    orig_cp = cp;
    while (isspace(*cp)) ++cp;
    len = 0;
    while (!isspace(*cp) && *cp && len < COMLEN-1) command[len++] = *cp++;
    command[len] = '\0';
    if (strcmp(command, "pn") == 0) set_pen_size(cp);
    else if (strcmp(command, "fp") == 0) flush_path(0);
    else if (strcmp(command, "ip") == 0) flush_path(1);
    else if (strcmp(command, "da") == 0) flush_dashed(cp, 0);
    else if (strcmp(command, "dt") == 0) flush_dashed(cp, 1);
    else if (strcmp(command, "pa") == 0) add_path(cp);
    else if (strcmp(command, "ar") == 0) arc(cp, 0);
    else if (strcmp(command, "ia") == 0) arc(cp, 1);
    else if (strcmp(command, "sp") == 0) flush_spline(0);
    else if (strcmp(command, "sh") == 0) shade_last(cp);
    else if (strcmp(command, "wh") == 0) whiten_last();
    else if (strcmp(command, "bk") == 0) blacken_last();
    else fprintf(stderr, "[%s] special \"%s\" not implemented\n",
		prog, orig_cp);
}

/* Things we need from dvi_draw, unfortunately */
extern int pen_size, blacken, whiten, shade;

#define toint(x)        ((int) ((x) + 0.5))
#define xconv(x) (toint(specialConv*(x)) + PXL_H)
#define yconv(y) (toint(specialConv*(y)) + PXL_V)

/*
 * Draw a line from (fx,fy) to (tx,ty).
 * Right now, we ignore pen_size.
 */
void line_btw(fx, fy, tx, ty)
int fx, fy, tx, ty;
{
    bitLine(page_bm, xconv(fx), yconv(fy), xconv(tx), yconv(ty));
}

/*
 * Draw a dot at (x,y)
 */
void dot_at(x, y)
{
    line_btw(x,y,x+1,y);
}

/*
 * Apply the requested attributes to the last path (box) drawn.
 * Attributes are reset.
 */
void do_attribute_path(last_min_x, last_max_x, last_min_y, last_max_y)
int last_min_x, last_max_x, last_min_y, last_max_y;
{
#ifdef lint
	(void) (last_min_x + last_max_x + last_min_y + last_max_y);
#endif
}

