/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/types.h,v 2.71 1992/08/08 08:27:29 william Exp $
 */

#include "const.h"

typedef struct BBRec {
   int	ltx, lty, rbx, rby;
} * BBRecPtr;

typedef struct PtRec {
   int		x, y;
   struct PtRec	* next;
} * PtRecPtr;

typedef struct ObjRec {
   int			x, y, type, color, id, dirty, rotation;
   short		marked, locked;
   struct BBRec		obbox;	/* object bounding box */
   struct BBRec		bbox;	/* real bounding box */
   struct ObjRec	* next, * prev;
   struct AttrRec	* fattr, * lattr; /* first and last attributes */
   union {
      struct GroupRec	* r;
      struct PolyRec	* p;
      struct PolygonRec	* g;
      struct BoxRec	* b;
      struct OvalRec	* o;
      struct TextRec	* t;
      struct ArcRec	* a;
      struct RCBoxRec	* rcb;
      struct XBmRec	* xbm;
      struct XPmRec	* xpm;
   } detail;
} * ObjRecPtr;

typedef struct AttrRec {
   char			name[MAXSTRING+1]; /* attribute name */
   char			s[MAXSTRING+1]; /* attribute value string */
   short		shown; /* TRUE if the attribute is shown */
   short		nameshown; /* TRUE if the attr name is also shown */
   short		inherited; /* TRUE if attr was inherited */
   struct ObjRec	* obj; /* the OBJ_TEXT object that represent the attr */
   struct ObjRec        * owner; /* ptr to owner obj of the record */
   struct AttrRec	* next, * prev; /* next and prev attributes */
} * AttrRecPtr;

typedef struct GroupRec {
   struct ObjRec	* first, * last;
   char			s[MAXSTRING+1];
   int			rotate, flip;
} * GroupRecPtr;

typedef struct PolyRec {
   int			n;	/* number of points in the polyline */
   XPoint		* vlist;
   XPoint		* rvlist; /* rotated vlist */
   int			sn;	/* number of points in the spline polyline */
   XPoint		* svlist;
   int			asn;	/* spline polyline with arrows */
   XPoint		* asvlist;
   int			style, width, pen, curved, fill, dash, aw, ah;
} * PolyRecPtr;

typedef struct PolygonRec {
   int			n;	/* number of points in the polygon */
   XPoint		* vlist;
   XPoint		* rvlist; /* rotated vlist */
   int			sn;	/* number of points in the spline polygon */
   XPoint		* svlist;
   int			fill, width, pen, curved, dash;
} * PolygonRecPtr;

typedef struct BoxRec {
   int		fill, width, pen, dash;
   XPoint	* rvlist; /* rotated vlist */
} * BoxRecPtr;

typedef struct OvalRec {
   int	fill, width, pen, dash;
} * OvalRecPtr;

typedef struct StrRec {
   char			s[MAXSTRING+1];
   struct StrRec	* next, * prev;
} * StrRecPtr;

typedef struct TextRec {
   int			just;
   int			lines;
   int			font, style, size, dpi, rotate, pen, fill;
   int			asc, des, v_space, image_w, image_h, image_scale;
   struct AttrRec       * attr; /* ptr to attr record if text obj is an attr */
   struct StrRec	* first, * last;
   XImage		* image;
   Pixmap		cached_bitmap;
   int			cached_zoom, cached_zoomed, cached_rotate;
   int			cached_w, cached_h;
} * TextRecPtr;

typedef struct SelRec {
   struct ObjRec	* obj;
   struct SelRec	* next, * prev;
} * SelRecPtr;

typedef struct VSelRec {
   struct ObjRec	* obj;
   int			n, max_v, * v_index, * x, * y;
   struct VSelRec	* next, * prev;
} * VSelRecPtr;

typedef struct SubCmdRec {
   union {
      struct MoveSubCmdRec	* mv;
   } detail;
} * SubCmdRecPtr;

typedef struct MoveSubCmdRec {
   int	dx, dy;
} * MoveSubCmdRecPtr;

typedef struct CmdRec {
   int			type, dx, dy, undone;
   int			* pos_before, count_before;
   int			* pos_after, count_after;
   struct SelRec	* top_before, * bot_before;
   struct SelRec	* top_after, * bot_after;
   struct CmdRec	* next, * prev;
   struct CmdRec	* first, * last;
} * CmdRecPtr;

typedef struct StkRec {
   struct ObjRec	* first, * last, * sel;
   struct StkRec	* next;
   struct CmdRec	* first_cmd, * last_cmd, * cur_cmd;
   int			history_count;
   int			name_valid, file_mod, id, page_style;
   int			orig_x, orig_y, zoom, zoomed;
   int			grid_system, english_grid, metric_grid, grid_on;
   int			color, h_align, v_align, line_w, line_s;
   int			fill, pen, dash, just, font, f_style, f_size, f_dpi;
   int			print_mag, v_space, grid_shown, move_mode;
   int			text_rotate, rcb_radius;
   char			name[MAXPATHLENGTH+1], domain[MAXPATHLENGTH+1];
   char			dir[MAXPATHLENGTH+1], sym_dir[MAXPATHLENGTH+1];
   char			* saved_comments;
   int			saved_comments_len;
} * StkRecPtr;

typedef struct ArcRec {
   int	fill, width, pen, dash, style, aw, ah;
   int	xc, yc, x1, y1, x2, y2, dir;
   int	ltx, lty, w, h, angle1, angle2;
} * ArcRecPtr;

typedef struct RCBoxRec {
   int		fill, width, pen, dash, radius;
   XPoint	* rvlist; /* rotated vlist */
} * RCBoxRecPtr;

typedef struct XBmRec {
   int		fill, real_type, flip, rotate, image_w, image_h, eps_w, eps_h;
   char		* data;
   char		* filename;
   char		* * epsflines;
   char		write_date[32];
   int		num_epsf_lines, epsf_level;
   int		llx, lly, urx, ury; /* these values are x1000 */
   XImage	* image;
   Pixmap	bitmap;
   Pixmap	cached_bitmap;
   int		cached_zoom, cached_zoomed, cached_rotate, cached_flip;
   int		cached_w, cached_h;
} * XBmRecPtr;

typedef struct XPmRec {
   int		fill, flip, rotate, image_w, image_h;
   int		ncolors;
   int		chars_per_pixel;
   int		first_pixel_is_bg;
   int		* pixels, * red, * green, * blue;
   char		* color_char;
   char		* * color_str;
   char		* data;
   XImage	* image;
   Pixmap	pixmap;
   Pixmap	cached_pixmap;
   int		cached_zoom, cached_zoomed, cached_rotate, cached_flip;
   int		cached_w, cached_h;
} * XPmRecPtr;

typedef struct WinInfoRec {
   Window	window;
   int		mapped;
   int		raise;
   int		(* ev_handler)();
   void		(* expose_handler)();
   void		(* cleanup)();
} * WinInfoPtr;

typedef struct MtrxRec {
   float	m[2][2], rev_m[2][2], h_scale, v_scale;
   float	image_w, image_h, w, h, transformed_w, transformed_h;
   float	dump_h_scale, dump_v_scale;
   int		rotate, flip, degree;
} * MtrxPtr;
