;  EDZACK.ASM TEXT EDITOR PROGRAM
; This text editor program is written in assembler language for 8086 mode
; for DOS by Eric Matteson. This public domain program is FREE for two
; reasons.
;  1) it only provides <= 640Kb memory because it uses a unassisted
;  DOS real mode memory set of subroutines in this edzack version of
;  text editor.
;  ..
;  2) edzack uses the vga bios TEXT screen and looks like a traditional
;  DOS DOS text editor. No graphics screen and no Windows is used in
;  edzack so edzack is FREE and can be run on a unlimited number of
;  IBM PC compatible computers and edzack uses a easy to use one key
;  at a time control interface. Edzack is great for text files that do
;  not need more memory than DOS provides it in unassited real mode.
;  ..
; The  alt key does not work with edzack easy keyread subroutine.
; The end key is different than normal. First to beginning of line then
; back and forth between end of file+1 and beginning of file.
; The home and end keys need getting used to. The rest of the keys
; act like a common text editor.
;  Edzack uses home gets menu and a list of one-letter commands on menu to
; make edzack easy to use. No multiple ctrl alt key control sequences
; or F keys to remember !!!!
; ..
; Four numbers are at the bottom of the edzack text editing screen.
; a three digit x coordinate of 1 to 80.
; a five digit y Ylinenumber between 1 and EOF + 1.
; a two digit screen line number between 1 and 24.
; a four digit how many more big lines can fit in real mode memory number....
; Warning. Edzack will fail if text file exceeds available real memory !!
; remember to vote against resuming the wartime U.S. military draft
; text editor with DOS using I/O subroutines written by Eric Matteson  /  /
; when calling 16 bit c compliant subroutines push rightmost argument
;                                                            first .
; after returning from subroutines add sp,(twice number of arguments)
; ..   This edzack.asm is the 02/16/2002 version of edzack.asm
; to assemble this edzack with the netwide assembler NASM use
; NASM -f bin edzack.asm -o edzack.com
; EDZACK.ASM may be assembled on any free assembler that is compatible
; with netwide assembler NASM. Follow the directions for the assembler used.
; Permission is granted to copy edzack.asm and its resulting edzack.com
;--------------------------------------------------------------------
; io16("CW",*handlevalue)
; io16("CR",*handlevalue)
; io16("OW",oiasciiz)
; io16("OR",oiasciiz)
; io16("FL",*handlevalue)
; io16("FR",*handlevalue,*dosbuffer,reclen)
; io16("FW",*handlevalue,*dosbuffer,reclen)
; io16("KY",nzwait)
; io16("MO",nzmouseallow)
; io16("LP",*lineptr,zurtext,maxlen)
; cadd(cah,cal,cbh,cbl)     results for four math DX:AX
; csubtract(cbigh,cbigl,ctinyh,ctinyl) CX bit 3 borrow ,bit 2 sign  ,1 unequal
; cmpy(cslh,csll,csrh,csrl)
; cposdiv(numerh,numerl,denomh,denoml)
;   readone(*rhanptr)
; reedline(*rhanptr,*databuffer,maxreclen)  even 08 flenl at *rhanptr+8 KEY
; printfi(*wrline,handlevalue,*doswritebuffer,maxreclen)  odd maxreclen scrn
; fncopy(*targetfn,*rawfn,maxreclen)
; CDOSIO.TXT    RDOSIO.TXT ; clearhanr(*location)
; rprline(*ptrtobitmap,*ptrtofontbase,z80width,ytinyshift,*ptrtocharline,
;                                         maincursorpos,moucursorpos)
; ..
; alselset(*xyptr,linenumber)
; clearline(*xyptr,linenumber)
; lalocal12(*xyptr)
; cvgcline(*xyptr,sslsel,spos,howmany)    chrvgapage(*xyptr,howmany)
; laput12(*xyptr)  clenval(*xyptr,linenumber)  ikx1864(*xyptr,keychr%,alselone)
; iek2000(*xyptr,nzkey)   gek2040(*xyptr,zurtwo)     dkx2050(*xyptr,deltype)
; numberprn(*xyptr,startline,startsubscript,width,base,nuh,nuL)
; cdigitval(character)
; numberget(*xyptr,startline,startsubscript,width,base)
; regkey2176(*xyptr  )       outlinecopy(*xyptr,xyln,*otherptr,otherln)
;     bscr2330(*xyptr)    clralocal2346(*xyptr)
; prmenu2398(*xyptr)     read2426(*xyptr,readsel12)     clrprn2462(*xyptr,line).
; write2470(*xyptr,file2)     open2520(*xyptr,opensel)   new2608(*xyptr,new2)
; findone2822(*xyptr)  john2880(*xyptr)  john2938(*xyptr)  ron2640(*xyptr,rv)
; cpr11(*xyptr)    qpr11(*xyptr)     tra11to55(*xyptr)    pr1155(*xyptr)
; symmget(*abstarg,*alsrcsel,stpos,maxpos)    symcmp(*lefta,*righta)
; cmatchsym(*xyptr)    keycline(*xyptr)    vprn(*xyptr,nonzurY,comheight)
; prqreadc(*xyptr,*cslistbase,linenumber)    insersubd(*xyptr,incbnonzur)
;    hexoline(*xyptr,*rhanptr)
; adverpar(*xyptr,*adbase,numberoflines)
; inputsir(*xyptr,endzur)  maryjimlprn(*xyptr)
; areedline(*xyptr,dindex)    rine12(*xyptr,destline)
; copen3520(*xyptr,zurtwosel6,clearzur)
;   filefind(*xyptr,*dtaptr,firstnext,attrib)
; acread(*xyptr)    acwrite(*xyptr)    commandfind(*xyptr)
; casesub(*xyptr,linedex)   findfilelist(*xyptr)
; dx=seg,cx=seglen ax=zeronoerror slateseg(*xyptr,yh,yl)
; slatereadstr(*xyptr,destne0a) needs 044 set to incoming line number 1 min
; -> slateacread(*xyptr,acrline)   needs 044  incoming line number
; ax=zeronoerror  wrslaterseg(*xyptr,segwrval,yh,yl)
; -> slateacwrite(*xyptr,writelnn) 044,046
; slacinsertde(*xyptr,iph,ipl,up)
; slacdeletede(*xyptr,dph,dpl,dn)
; slatewbinvd(*xyptr)  0110,0112
; slaterinsert(*xyptr,insertlocal) uses 044,046
; slaterdelete(*xyptr) 044,046
; multidelete(*xyptr,numberoftimes) 044,046
; wratostring(*xyptr) uses  0110,0112 instead of 044,046
; -> acinsertb(*xyptr) 014.016 y    0034 insel%
; -> beldlinesdel(*xyptr,howmany) 014.016 y
; -> aclinedel(*xyptr) 014.016 y
; ax=linesleft82(*xyptr) 0102
;*******************************************************************
; record at *rhanptr  00 repeat   02 onechr   04 fileposl    06 fileposh
;         08 flenl    0a flenh    0c handlevalue   0e dosreadcharacter
;  at handle=0 keyboard even or odd 08 flenl controls return key 0d 0a
; 16-bit C compliant subroutine calls push rightmost argument first
          bits 16
        org 0100h
csubskip:  mov sp,00f4h
          cld
         jmp mainappc
; artihmetic subroutines return result in DX:AX
; radd(cah,cal,cbh,cbl)
;  bp+ variables
;    0a cbl    08 cbh    06 cal    04 cah    02 retad    00 bpsave
; returns with sum in DX:AX
radd:  push bp
      mov bp,sp
      mov ax,[bp+0ah]
      add ax,[bp+06h]
      mov dx,[bp+08h]
      adc dx,[bp+04h]
      pop bp
      ret
; rsubtract(cbigh,cbigl,ctinyh,ctinyl)
; 32-bit subtract result is in DX:AX
; CX is comparision result
; RETURNS CX=0000 equal. Or cx,08h for borrow  or cx,04h for sign
; or cx,02h for UNEQUAL.
; bp+variables in stack
;  0e ctinyl    0c ctinyh      0a cbigl      08 cbigh
;  06 retad       04 disave     02 sisave    00 bpsave
rsubtract:  push di
  push si
      push bp
      mov bp,sp
      mov ax,[bp+0ah]
      mov dx,[bp+08h]
      mov si,[bp+0eh]
      mov di,[bp+0ch]
      sub ax,si
      sbb dx,di
      jb aresdone
      jne aresdone
      mov di,dx
      or di,ax
      jz aresdone
      or di,000fh
      and di,000fh
aresdone:  jb abparcond
      js asparcond
      je aeqcond
agrcond:  mov cx,0002h
      jmp acmpbot
aeqcond: mov cx,0000h
      jmp acmpbot
asparcond:  mov cx,0006h
      jmp acmpbot
abparcond: js abscond
      je abeqcond
abgrcond: mov cx,000ah
      jmp acmpbot
abeqcond: mov cx,0008h
      jmp acmpbot
abscond: mov cx,000eh
acmpbot:  pop bp
      pop si
      pop di
      ret
; rmpy(slh,sll,srh,srl)
; returns 32 bit ordinal product in DX:AX
; stack variables bp+
;  0c srl      0a srh     08 sll    06 slh
;  04 retad      02 bpsave      00 cxsave
rmpy:  push bp
  push cx
      mov bp,sp
      xor dx,dx
      xor ax,ax
rmpyl:  test word [bp+0ch],01h
      jz rkipaddm
      add ax,[bp+08h]
      adc dx,[bp+06h]
rkipaddm:  shr word [bp+0ah],1
      rcr word [bp+0ch],1
      shl word [bp+08h],1
      rcl word [bp+06h],1
      mov cx,[bp+0ch]
      or cx,[bp+0ah]
      jnz rmpyl
      pop cx
      pop bp
      ret
; rposdiv(numerh,numerl,denomh,denoml)
; returns fraction in DX:AX
; 22 denoml       20 denomh       1e numerl
; 1c numerh     1a retad     18 disave    16 sisave     14 bpsave
; 12 bxsave     10 dxsave     0e cxsave     0c axsave     0a bigl
; 08 bigh     06 dlctr     04 negctr     02 resultl    00 resulth
rposdiv:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      xor di,di
      push di
      push di
      push di
      push di
      push di
      push di
      mov bp,sp
      cmp word [bp+020h],00h
      jns askipnegden
      push word [bp+022h]
      push word [bp+020h]
      push di
      push di
      call rsubtract
      add sp,0008h
      mov [bp+022h],ax
      mov [bp+020h],dx
      inc word [bp+04h]
askipnegden:  cmp word [bp+01ch],00h
      jns askipnegnum
      push word [bp+01eh]
      push word [bp+01ch]
      push di
      push di
      call rsubtract
      add sp,008h
      mov [bp+01eh],ax
      mov [bp+01ch],dx
      inc word [bp+04h]
askipnegnum:  shl word [bp+02h],1
      rcl word [bp+00h],1
      shl word [bp+01eh],1
      rcl word [bp+01ch],1
      rcl word [bp+0ah],1
      rcl word [bp+08h],1
      push word [bp+022h]
      push word [bp+020h]
      push word [bp+0ah]
      push word [bp+08h]
      call rsubtract
      add sp,0008h
      test cx,08h
      jnz askipdiv
      mov [bp+0ah],ax
      mov [bp+08h],dx
      inc word [bp+02h]
      jnz askipdiv
      inc word [bp+00h]
askipdiv:  inc word [bp+06h]
      cmp word [bp+06h],0020h
      jns acheckneg
      jmp askipnegnum
acheckneg:  test word [bp+04h],01h
      jz aposres
      push word [bp+02h]
      push word [bp+00h]
      push di
      push di
      call rsubtract
      add sp,0008h
aposres:  pop word [bp+010h]
      pop word [bp+0ch]
      add sp,0008h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; end of I/O arithmetic section is line 000263  000268
; rintshield(type,axi,cxi,dxi,bxi)
; RIntshield is used to save BX BP SI DI ES DS while in interrupt
; ES and DS are set to SS for dos interrupt because SS contains
; LOCAL DS value for DOS routines. DS ES restored afterwards.
; Carry flag setting during error is or CX,0008h If no dos
; error CX is set to 0000h. (carry flag itself is destroyed
; by ADD SP,000AH after returning from this !!!!!!!! )
; AX and DX are returned with values resulting from interrupt.
;  18 bxi       16 dxi       14 cxi
;  12 axi      10 type      0e retad      0c disave      0a sisave
;  08 bpsave      06 bxsave      04 dssave    02 essave    00 intvar
rintshield:  push di
      push si
      push bp
      push bx
      push ds
      push es
      xor di,di
      push di
      mov bp,sp
      mov si,ss
      mov ds,si
      mov es,si
      mov ax,[bp+012h]
      mov cx,[bp+014h]
      mov dx,[bp+016h]
      mov bx,[bp+018h]
      cmp word [bp+010h],010h
      jz iten
      cmp word [bp+010h],021h
      jz idos
      cmp word [bp+010h],033h
      jz imouse
unknownint:  pop di
      pop es
      pop ds
      pop bx
      pop bp
      pop si
      pop di
      ret
idos:  clc
      int 21h
      jnb xcxint
ierrorset:  or word [bp+00h],08h
xcxint:  mov cx,[bp+00h]
      jmp unknownint
iten:  int 10h
      jmp unknownint
imouse:  int 33h
         mov ax,bx
      jmp unknownint
rdosquit:  mov ax,04c00h
      push ax
      push ax
      push ax
      push ax
      mov ax,0021h
      push ax
      call rintshield
      add sp,0ah
      jmp rdosquit
; rfclose(handlevalue)
;  DOS close is AH=3E BX=HANDLE  INT 21H CARRY if error
; 06 handlevalue    04 retad    02 bpsave     00 dxsave
; returns with CX=00 no error   0008 if error
rfclose:  push bp
      push dx
      mov bp,sp
      xor dx,dx
      push word [bp+06h]
      push dx
      push dx
      mov dx,03e00h
      push dx
      mov dx,0021h
      push dx
      call rintshield
      add sp,000ah
      pop dx
      pop bp
      ret
; rfopeno(oiasciiz)  rfopeni(oiasciiz)
; 08 oiasciiz     06 retad     04 sisave     02 bpsave     00 dxsave
; returns with AX=handle  CX=0000 no error
rfopeno:  push si
      push bp
      push dx
      mov bp,sp
      mov si,03c00h
fopenb:  mov dx,000h
      push dx
      push word [bp+08h]
      mov dx,0020h
      push dx
      push si
      mov dx,0021h
      push dx
      call rintshield
      add sp,000ah
      pop dx
      pop bp
      pop si
      ret
rfopeni:  push si
      push bp
      push dx
      mov bp,sp
      mov si,03d00h
      jmp fopenb
; DOS open  exsisting file AH=3D AL=00 for read only    AL=02 for R/W
; DOS Open new file for output AH=3c
; CX = attributes typical 0020h
; both opens use  DS:DX address of ASCIIZ filename string
; int 21h returns new file handle in AX. Carry set if error.
; fopeni and fopeno return the new handlevalue in ax  , cx=0000h if no error
; -------------------------------------------
; dx:ax=rfileposition(handle,posH,posL,ZURpos)
; ZURpos=0 start at beginning of file, =2 start at end of file.
; 16 ZURpos   14 posL   12 posH    10 handle    0e retad    0c disave
; 0a sisave   08 bpsave   06 bxsave   04 dxsave   02 cxsave    00 axsave
rfileposition:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov bp,sp
      mov ax,[bp+016h]
      and ax,0003h
      or ax,04200h
      push word [bp+010h]
      push word [bp+014h]
      push word [bp+012h]
      push ax
      mov si,021h
      push si
      call rintshield
      add sp,0ah
      mov [bp+00h],ax
      mov [bp+02h],cx
      mov [bp+04h],dx
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
;---------------------------------------------------------------------
; rfgetlen(handlevalue)
; 10 handlevalue  0e retad    0c disave   0a sisave   08 bpsave
; 06 bxsave     04 dxsave    02 cxsave     00 axsave
; DOS FILE POINTER MOVE OR GET FILELENGTH
; AH=42h
; AL=00h start from beginning of file
; AL=01h start at current location
; AL=02h start at end of file
;  CX:DX number of bytes to move file pointer.
; INT 21h
; returns with DX:AX as new file pointer value after calling.
; CX=0000 if no error 0008 if error
rfgetlen:  push di
   push si
      push bp
      push bx
      xor bx,bx
      push bx
      push bx
      push bx
      mov bp,sp
      mov ax,02h
      push ax
      push bx
      push bx
      push word [bp+0010h]
      call rfileposition
      add sp,0008h
      mov word [bp+0000h],ax
      mov word [bp+0004h],dx
      or word [bp+0002h],cx
      push bx
      push bx
      push bx
      push word [bp+0010h]
      call rfileposition
      add sp,0008h
      or word [bp+0002h],cx
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; rfread(handlevalue,dosbuffer,reclen)  rfwrite(handlevalue,dosbuffer,reclen)
; 0c reclen       0a dosbuffer      08 handlevalue
; 06 retad     04 sisave     02 bpsave    00 dxsave
; returns with ax = number of read or written bytes cx=0 for no error
; DOS READ AH=3F    DOS WRITE AH=40h
; DOS R/W   CX=number of bytes to transfer
; DS:DX address of data buffer
;    BX = handle
; Handle is >= 0005h for opened file
; unopened handles for non-files
; 0004h printer
; 0003h standard aux (serial)
; 0002h standard error
; 0001h standard out (display)
; 0000h keyboard
; int 21h
; returns ax=number of bytes transfered. CF is set if error.
rfread:  push si
      mov si,03f00h
fdosrw:  push bp
      push dx
      mov bp,sp
      push word [bp+08h]
      push word [bp+0ah]
      mov dx,[bp+0ch]
      push dx
      push si
      mov dx,0021h
      push dx
      call rintshield
      add sp,000ah
      cmp ax,[bp+0ch]
      jz qio
      or cx,0008h
qio:  pop dx
      pop bp
      pop si
      ret
rfwrite:  push si
      mov si,04000h
      jmp fdosrw
; first part of system is above  000693     000966
; moonlprint(*lineptr,zurtext,maxlen)
; 24 maxlen    22 zurtext    20 *lineptr    1e retad    1c disave    1a sisave
; 18 bpsave    16 bxsave     14 dxsave      12 cxsave   10 axsave
; 0e textlenpr    0c cst21    0a cst0500    08    06 proctr    04 prictr    02
moonlprint:  push di
             push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov si,[bp+0020h]
      sub si,bp
      mov dx,si
      add si,[bp+0024h]
      cmp word [bp+0022h],0000h
      jz moonjimb
      jmp lucymoon
moonjimb:  dec si
      cmp si,dx
      js jimmoond
      cmp byte [bp+si],020h
      jz moonjimb
jimmoond:  inc si
      sub si,dx
      mov [bp+0eh],si
      mov bx,00h
      mov word [bp+0ch],0021h
      mov word [bp+0ah],0500h
      mov word [bp+06h],0002h
jimlpro:  mov word [bp+04h],0000h
      mov si,[bp+0020h]
      sub si,bp
jimmyi:  mov ax,00h
      mov dx,ax
      mov dl,[bp+si]
      inc si
      add word [bp+04h],0001h
; repeatable print int
      push ax
      push dx
      push ax
      push word [bp+0ah]
      push word [bp+0ch]
      call rintshield
      add sp,0ah
; -----     0009
      mov ax,[bp+04h]
      cmp ax,[bp+0eh]
      js jimmyi
      mov dx,0dh
      mov ax,00h
; repeatable print int
      push ax
      push dx
      push ax
      push word [bp+0ah]
      push word [bp+0ch]
      call rintshield
      add sp,0ah
; -----     0009
      dec word [bp+06h]
      jnz jimlpro
      mov dx,000ah
      mov ax,0000h
; repeatable print int
      push ax
      push dx
      push ax
      push word [bp+0ah]
      push word [bp+0ch]
      call rintshield
      add sp,0ah
; -----     0009
lucymoon:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; rkeyread(nzwait)
;  0a nzwait           08 retad      06 bpsave
;  04 dxuppercase      02 cxctr      00 axvalue
; returns with ascii key in al or ax  counter cx is  0  or  1 or  2
; 0000 key not ready    0001 normal key   0002 special key like arrow etc
; returns with               dx = uppercase version of key
rkeyread:  push bp
      sub sp,0006h
      mov bp,sp
      cmp word [bp+0ah],00h
      jz jesresup
keyupwait:  mov ax,0600h
      mov cx,00ffh
      push ax
      push cx
      push cx
      push ax
      mov cx,0021h
      push cx
      call rintshield
      mov cx,0001h
      jnz skipresup
      mov cx,0000h
skipresup:  add sp,000ah
      cmp cx,0000h
      jnz keyupwait
jesresup:   mov word [bp+0004h],0020h
      mov word [bp+0002h],0000h
      mov word [bp+0000h],0000h
keydownwait:  mov ax,0600h
      mov cx,00ffh
      push ax
      push cx
      push cx
      push ax
      mov cx,0021h
      push cx
      call rintshield
      mov cx,0001h
      jnz skipresdn
      mov cx,0000h
skipresdn:  add sp,000ah
      cmp cx,0000h
      jnz foundky
      cmp word [bp+000ah],0000h
      jnz keydownwait
      jmp popklt
foundky:  inc word [bp+0002h]
      cmp al,00h
      jz keydownwait
      or [bp+00h],al
      jmp popklyt
popklt:  pop ax
      pop cx
      pop dx
      pop bp
      ret
popklyt:  and word [bp+0000h],007fh
  cmp word [bp+0000h],0020h
  jns popkfclt
popkfcec:  jmp popklt
popkfclt:  cmp word [bp+0000h],007eh
      ja popkfcec
      mov ax,[bp+00h]
      mov [bp+04h],ax
      cmp word [bp+00h],07ah
      ja popklt
      cmp word [bp+00h],061h
      jb popklt
      sub word [bp+0004h],0020h
      jmp popklt
; end of rkeyread. ax=key character in al cx=0,1,2 type dx=uppercase.
; io16(("type"),pr1,pr2,pr3,pr4,pr5,pr6,pr7)
; rightmost argument is pushed first before calling
; variable argument list.
; 2e pr7    2c pr6    2a pr5    28 pr4    26 pr3    24 pr2    22 pr1
; 20 type   1e retad    1c disave    1a sisave    18 bpsave    16 bxsave
; 14 dxsave    12 cxsave    10+bufferdiff  axsave
; bufferstart is bp+0010h
; 0e r7    0c r6    0a r5    08 r4    06 r3    04 r2    02 r1    00 typevalue
; io16 is DOS VERSION OF 16-BIT I/O
io16:  push di
    push si
      push bp
      push bx
      push dx
      push cx
      push ax
; mov bx,bufferdiff
      mov bx,0050h
      sub sp,0010h
      sub sp,bx
      mov bp,sp
      mov cx,0008h
      mov di,0000h
      mov si,bx
      add si,0020h
io16dnrep:   mov dx,[bp+si]
      mov [bp+di],dx
      add si,02h
      add di,02h
      dec cx
      jnz io16dnrep
; begin io16 if tree
      mov ax,[bp+0000h]
      cmp ah,04bh
      js io16285
      jg io16287
      cmp al,059h
      jnz io16fail
      jmp io16ky
io16fail:  jmp io16failj
io16285:  cmp ah,044h
      js io16243
      jg io16245
      cmp al,053h
      jnz io16fail
      jmp rdosquit
io16243:  cmp ah,043h
          jnz io16fail
         cmp al,052h
      jnz io16343
      jmp io16cr
io16343:  cmp al,057h
      jnz io16fail
      jmp io16cw
io16245:  cmp ah,045h
      jnz io1646mp
      cmp al,053h
      jnz io16fail
      jmp rdosquit
io1646mp:  cmp ah,046h
      jnz io16fail
      cmp al,052h
      js io164c
      jg io1657
      jmp io16fr
io164c:  cmp al,04ch
      jnz io16failj
      jmp io16fl
io1657:  cmp al,057h
      jnz io16failj
      jmp io16fw
io16287:  cmp ah,04fh
      js io164d
      jg io1653t
      cmp al,052h
      jnz io1657x
      jmp io16or
io1657x:  cmp al,057h
      jnz io16failj
      jmp io16ow
io164d:  cmp ah,04dh
      js io164ctw
      jg io16failj
      cmp al,04fh
      jnz io16failj
      jmp io16mo
io164ctw:  cmp ah,04ch
           jnz io16failj
           cmp al,050h
           jnz io16failj
           jmp io16lp
io16failj:  jmp io16fail
; insert new code here
io1653r:  cmp al,047h
      jnz io1654a
      jmp rdosquit
io1654a:  cmp al,054h
      jnz io16failj
;      jmp io16st
      jmp rdosquit
io1653t:  cmp ah,053h
      jz io1653r
      cmp ah,057h
      jz io1657y
      jmp io16failj
io1657y:  cmp ah,057h
      jnz io16failj
      cmp al,053h
      jnz io16failj
      jmp rdosquit
; end io16 if tree
; because bp+00h is already selected tree route, last argument pushed
; into these low level subroutines is bp+02h
io16lp:   push word [bp+06h]
      push word [bp+04h]
      push word [bp+02h]
      call moonlprint
      add sp,06h
        jmp io16done
io16cw:  jmp io16cr
io16cr:  push word [bp+02h]
        call rfclose
      add sp,02h
      jmp io16done
io16ow:  push word [bp+02h]
      call rfopeno
      add sp,02h
      jmp io16done
io16or:  push word [bp+02h]
      call rfopeni
      add sp,02h
      jmp io16done
io16fl:  push word [bp+02h]
      call rfgetlen
      add sp,02h
      jmp io16done
io16fr:  push word [bp+06h]
         push word [bp+04h]
         push word [bp+02h]
      call rfread
      add sp,06h
      jmp io16done
io16fw:  push word [bp+06h]
         push word [bp+04h]
         push word [bp+02h]
      call rfwrite
      add sp,06h
      jmp io16done
io16ky:  push word [bp+02h]
      call rkeyread
      add sp,02h
      jmp io16done
io16mo:  cmp word [bp+02h],0000h
       jz io16nonmo
       mov ax,07fffh
       mov cx,0033h
       mov dx,0003h
       push ax
       push ax
       push ax
       push dx
       push cx
       call rintshield
       add sp,000ah
io16nonmo:  jmp io16done
io16done:  mov di,bx
      add di,0010h
      mov [bp+di],ax
      mov [bp+di+02h],cx
      mov [bp+di+0004h],dx
      add sp,bx
      add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; end of dos subroutine io16
; io16("CW",*handlevalue)
; io16("CR",*handlevalue)
; io16("OW",oiasciiz)
; io16("OR",oiasciiz)
; io16("FL",*handlevalue)
; io16("FR",*handlevalue,*dosbuffer,reclen)
; io16("FW",*handlevalue,*dosbuffer,reclen)
; io16("KY",nzwait)
; bad io16("WS",xz,yz,*bmpfilename)
; bad io16("ES",segmentnumber,*xyptr)
; bad io16("DS",segmentnumber,*xyptr)
; io16("MO",nzmouseallow)
; bad io16("SG",mode12h)
; bad io16("ST",mode03h)
; io16("LP",*lineptr,zurtext,maxlen)
cadd: jmp radd
csubtract: jmp rsubtract
cmpy: jmp rmpy
cposdiv: jmp rposdiv
; non I/O artihmetic subroutines return result in DX:AX
; end of non I/O arithmetic section is   line   000875
; below fwrite or rfwrite 000694
; needs read pointer to read handle with accessories   *rhanptr
; *rhanptr points to memory record  when handle < 5
; 00 repeat    02 onechr    04 fileposL    06 fileposH
; 08 flenL     0a flenH     0c handlevalue    0e dosreadcharacter
; flenl is odd to seek aditional keys after first return
; ....................
; *rhanptr points to memory record  when handle > 4
; 00 repeat    02 onechr    04 fileposL    06 fileposH
; 08 flenL     0a flenH     0c handlevalue    0e position0toF
; 010 thru 01F is record of 16 characters from DISK
; ....................
; readone(*rhanptr)
; returns onechr dosreadcharacter ax=character
; cx=0008 error    0 no error     dx=01 end of file dx=00 still left
; 12 *rhanptr     10 retad     0e disave    0c sisave     0a bpsave
; 08 bxsave     06 dxsave     04 cxsave    02 axsave    00 cst1 or length
readone:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov ax,0001h
      push ax
      mov bp,sp
      mov di,[bp+012h]
      sub di,bp
;                [bp+di] points to *rhanptr target
     mov bx,0000h
     mov si,di
      mov word [bp+06h],0000h
      mov word [bp+04h],0000h
      cmp word [bp+di+0ch],0005h
      jnb roteof2
      jmp noteof2
;     (filepos-filelen)<0 o.k.
roteof2:      push word [bp+di+08h]
      push word [bp+di+0ah]
      push word [bp+di+04h]
      push word [bp+di+06h]
      call csubtract
      add sp,0008h
      test cx,0008h
      jnz rnoteof
      or word [bp+06h],0001h
      mov al,020h
      jmp yrnoteol
yreof:  or word [bp+06h],0001h
yrnoteof:  mov al,[bp+si+0eh]
yrnoteol:      and ax,00ffh
      mov [bp+di+02h],ax
      mov [bp+02h],ax
      add sp,02h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
rnoteof:  mov word [bp+00h],010h
      push word [bp+di+04h]
      push word [bp+di+06h]
      push word [bp+di+08h]
      push word [bp+di+0ah]
      call csubtract
      add sp,0008h
      mov si,010h
      push si
      mov si,ax
      push bx
      push ax
      push dx
      call csubtract
      add sp,0008h
      test cx,000ch
      jz bigleftnoteof
      mov [bp+00h],si
bigleftnoteof:  lea si,[di+02h]
      cmp word [bp+di+0eh],010h
      js rfastonec
      mov word [bp+di+0eh],01h
      jmp noteof2
rfastonec:  add si,[bp+di+0eh]
      add word [bp+di+0eh],01h
      jmp ybnc
noteof2:  push word [bp+00h]
      lea ax,[bp+si+0eh]
      push ax
      push word [bp+di+0ch]
      mov ah,046h
      mov al,052h
      push ax
      call io16
      add sp,02h
      add sp,0006h
      or [bp+04h],cx
ybnc:    cmp word [bp+di+0ch],0005h
      jnb xbnc
      jmp yrnoteof
xbnc:      inc word [bp+di+04h]
      jnz ylnc
      inc word [bp+di+06h]
ylnc:  push word [bp+di+08h]
      push word [bp+di+0ah]
      push word [bp+di+04h]
      push word [bp+di+06h]
      call csubtract
      add sp,0008h
      test cx,0008h
      jz yxrlnc
      jmp yrnoteof
yxrlnc:      jmp yreof
; reedline(*rhanptr,*databuffer,maxreclen)
; returns with dx bit 3 set is eof bit 2 set is repeat
; also sets repeat [bp+di+00h] cx=0 no error  ax=linelength
; check repeat 4 before eof 8
; 1c maxreclen     1a *databuffer     18 *rhanptr
; 16 retad     14 disave      12 sisave     10 bpsave
; 0e bxsave              0c dxsave     0a cxsave     08 axsave
; 06 ctra reedloopctr     04 ctrb 0Dctr      02 ctrc     00 ctrd
; -----------------------------------------------------------------
; *rhanptr       00 repeat   02 onechr    04 fileposl    06 fileposh
;                08 flenl    0a flenh     0c handlevalue  0e index0toF
;                10 to 1f extended dos buffer
; --
reedline:  push di
  push si
      push bp
      push bx
      mov si,0000h
      push si
      push si
      push si
      push si
      push si
      push si
      push si
      mov bp,sp
      mov di,[bp+018h]
      sub di,bp
reedloop:  mov bx,[bp+06h]
      cmp bx,[bp+01ch]
      js chkrep
      jmp afterloop
chkrep:  test word [bp+di+00h],0004h
      jnz crepeat
      push word [bp+018h]
      call readone
      add sp,0002h
      or word [bp+0ah],cx
      cmp dx,00h
      jz crepeat
      or word [bp+0ch],08h
crepeat:  mov ax,[bp+di+02h]
      and word [bp+di+00h],00fbh
      jmp cmpxc
cmpxd:  jmp afterlined
cmpxa:  jmp afterlinea
cmpxc:  cmp al,00h
      jz cmpxd
      cmp al,0dh
      jz cmpxd
      cmp al,01ah
      jz cmpxa
      cmp al,0ah
      jz cmpxa
      cmp al,0cch
      jz cmpxa
      mov si,[bp+01ah]
      sub si,bp
      mov dx,[bp+di+02h]
      and dx,00ffh
      cmp dx,0020h
      jns bigchr
      mov dx,0020h
bigchr:  add si,[bp+06h]
      mov [bp+si],dl
      inc word [bp+06h]
      cmp word [bp+di+0ch],0005h
      js chkrev
xreedj:    jmp reedloop
chkrev:   cmp al,08h
      jnz xreedj
      dec word [bp+06h]
      jz xreedj
      dec word [bp+06h]
      jmp xreedj
afterlined:  jmp afterlinea
aftquit:     jmp  blanright
afterlinea:  cmp al,0ah
      jz aftquit
      cmp al,01ah
      jz aftquit
      cmp al,0cch
      jz aftquit
dfirst:  cmp word [bp+di+0ch],0005h
      jns dseek
      test word [bp+di+08h],01h
; IF EVEN FILELENGTH include dseek in keyboard return key
      jz dseek
      jmp aftquit
dseek:  cmp al,0dh
      jz dloopp
      cmp al,00h
      jz dloopp
      or word [bp+di+00h],04h
      jmp aftquit
dloopp:  test word [bp+0ch],08h
      jz dloop
      jmp aftquit
dloop:  push word [bp+018h]
      call readone
      add sp,0002h
      mov ax,[bp+di+02h]
      or word [bp+0ah],cx
      cmp dx,00h
      jz xtafterlinea
      or word [bp+0ch],08h
xtafterlinea:  inc word [bp+04h]
      cmp word [bp+04h],0004h
      js atafterlinea
; *** ERROR *** when a multiple of four endings of type 0d or 00 are
; encountered and next is non-end the first character of the next line is not
; repeated and is deleted . This error was discovered late on 08/21/01
         cmp al,00h
         jz reefixdz
         cmp al,0dh
         jz reefixdz
         jmp atafterlinea
; insert FIX above this line --------
reefixdz:      jmp aftquit
atafterlinea:  jmp afterlinea
blanright:     mov si,[bp+01ah]
      sub si,bp
      mov bx,[bp+06h]
      mov [bp+08h],bx
blanlop: mov si,[bp+01ah]
         sub si,bp
         add si,[bp+06h]
      mov ax,[bp+06h]
      cmp ax,[bp+01ch]
      jns rpopline
      mov byte [bp+si],020h
      inc word [bp+06h]
      jmp blanlop
rpopline:  mov ax,[bp+di+00h]
      and ax,0004h
      or [bp+0ch],ax
      add sp,0008h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
afterloop:  test word [bp+0ch],08h
      jz alproca
      jmp aftquit
alproca:  cmp word [bp+di+0ch],0005h
      jns alprocb
      jmp aftquit
alprocb:  push word [bp+018h]
      call readone
      mov ax,[bp+di+02h]
      add sp,0002h
      or word [bp+0ah],cx
      cmp dx,00h
      jz rtafterlinea
      or word [bp+0ch],08h
rtafterlinea:  jmp afterlinea
; printfi(*wrline,handlevalue,*doswritebuffer,maxreclen)
; odd maxreclen checks for dollar sign at end of displayed line
;   01e maxreclen    1c *doswritebuffer    1a handlevalue
;    18 *wrline    16 retad    14 disave
;    12 sisave    10 bpsave    0e bxsave    0c dxsave
;    0a cxsave nonzero if error    08 axsave
;    06 ctre   writelength         04 ctrf   writectr
;    02 ctrg   cst1                00 ctrh
; returns cx=0000 if no error
printfi:  push di
      push si
      push bp
      push bx
      push dx
      xor di,di
      push di
      push ax
      push di
      push di
      push di
      push di
      mov bp,sp
      mov si,[bp+018h]
      sub si,bp
      mov word [bp+02h],0001h
      mov bx,[bp+01eh]
      cmp bx,0050h
      jz wlenchk
      cmp word [bp+01ah],0005h
      jnb wlenchk
      dec bx
      jmp wlong
wlenchk:  dec bx
      jz wlong
      lea di,[bx+si+0000h]
      cmp byte [bp+di+00h],00h
      jz wlenchk
      cmp byte [bp+di+00h],020h
      jz wlenchk
wlong:  lea ax,[bx+0001h]
      mov [bp+06h],ax
wwrlop:  mov si,[bp+018h]
      sub si,bp
      add si,[bp+04h]
      mov al,[bp+si]
      mov di,[bp+01ch]
      sub di,bp
      mov [bp+di],al
      cmp word [bp+01ah],05h
      jnb wwrnext
      test word [bp+01eh],01h
      jz wwrnext
      cmp al,024h
      jnz wwrnext
      jmp wcrcmp
; odd maxreclen checks for dollar sign at screen
wwrnext:  push word [bp+02h]
      push word [bp+01ch]
      push word [bp+01ah]
      mov ah,046h
      mov al,057h
      push ax
      call io16
      add sp,02h
      add sp,0006h
      or [bp+0ah],cx
      inc word [bp+04h]
      mov dx,[bp+04h]
      cmp dx,[bp+06h]
      js wwrlop
wcrcmp:  mov ax,[bp+04h]
    cmp word [bp+01ah],05h
      jnb wcrcmdv
      inc ax
      inc ax
wcrcmdv:  cmp ax,[bp+01eh]
      js wcrtn
      jz wcrtn
      jmp skipwcrtn
wcrtn:  mov si,[bp+01ch]
      sub si,bp
      mov byte [bp+si],0dh
      push word [bp+02h]
      push word [bp+01ch]
      push word [bp+01ah]
      mov ah,046h
      mov al,057h
      push ax
      call io16
      add sp,02h
      add sp,0006h
      or [bp+0ah],cx
      mov byte [bp+si],0ah
      push word [bp+02h]
      push word [bp+01ch]
      push word [bp+01ah]
      mov ah,046h
      mov al,057h
      push ax
      call io16
      add sp,02h
      add sp,0006h
      or [bp+0ah],cx
skipwcrtn:      add sp,0008h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; fncopy(*targetfn,*rawfn,maxreclen)
; 12 maxreclen     10 *rawfn     0e *targetfn     10 retad
; 0a disave     08 sisave     06 bpsave    04 dxsave
; 02 cxsave         00 axsave filenamelength
; returns with AX=filenamelength
fncopy:  push di
  push si
  push bp
      push dx
      push cx
      xor di,di
      push di
      mov bp,sp
      mov si,[bp+010h]
      sub si,bp
      mov di,[bp+0eh]
      sub di,bp
      mov dx,[bp+012h]
      dec dx
fncopylop:  mov cx,[bp+00h]
      cmp cx,dx
      jns skipcopy
      mov al,[bp+si]
      inc si
      cmp al,00h
      jz skipcopy
      cmp al,020h
      jz skipcopy
      cmp al,0dh
      jz skipcopy
      cmp al,0ah
      jz skipcopy
      inc word [bp+00h]
      mov [bp+di],al
      inc di
      jmp fncopylop
skipcopy:  mov byte [bp+di],00h
      pop ax
      pop cx
      pop dx
      pop bp
      pop si
      pop di
      ret
; end of cdosio.txt version 03/12/00
; next version is RDOSIO.TXT  adding clearhanr(*location)  03/16/00
;  0a *location      08 retad      06 disave
;  04 bpsave  saves callers BP                         02 cxsave
;  00 axsave  returns (*location-callersBP) in AX after returning
;  this clears 16 bytes starting at *location
clearhanr:  push di
      push bp
      push cx
      push ax
      mov bp,sp
      mov di,[bp+000ah]
      sub di,bp
      mov cx,0008h
clearhanrlop:    mov word [bp+di],0000h
      inc di
      inc di
      dec cx
      jnz clearhanrlop
      mov cx,[bp+000ah]
      sub cx,[bp+04h]
      mov [bp+00h],cx
      pop ax
      pop cx
      pop bp
      pop di
      ret
; edjim.mid end of clearhanr
; rprline(*ptrtobitmap,*ptrtofontbase,z80width,shiftorlittley
;                          ,*ptrtocharline,maincursorpos,moucursorpos)
; 3a moucursorpos    38 maincursorpos    36 *ptrtocharline
; 34 shiftorlittley     32 z80width    30 *ptrtofontbase    2e *ptrtobitmap
; 2c retad    2a disave    28 sisave    26 bpsave    24 bxsave    22 dxsave
; 20 cxsave    1e axsave    1c dssave    1a essave    18 ctr
; 16 loop_counter??    14 cst8000    12 currlocbyte    10 currem
; 0e fontabnormal    0c    0a newsistart    08    06 newbx
; 04 newdx    02 newcx    00 newax
rprline:  push di
   push si
      push bp
      push bx
      push dx
      push cx
      push ax
      push ds
      push es
      mov cx,000dh
      mov bx,0000h
prlinefab:  push bx
      dec cx
      jnz prlinefab
      mov bp,sp
      mov ax,[bp+0036h]
      sub ax,bp
      mov [bp+000ah],ax
      mov word [bp+0002h],0001h
      mov ax,[bp+0034h]
      dec ax
      and ax,003fh
      mov [bp+0005h],al
      mov word [bp+0000h],0200h
qzfablop:  mov si,[bp+0018h]
      cmp si,[bp+0032h]
      jns izfabsot
      mov ax,si
      mov [bp+04h],al
      add si,[bp+000ah]
      mov dl,[bp+si]
      mov [bp+00h],dl
      inc ax
      mov [bp+0018h],ax
      mov word [bp+0006h],001fh
      mov cx,[bp+003ah]
      and cx,00ffh
      cmp ax,cx
      jnz qzwhile
      mov word [bp+06h],004fh
qzwhile:  mov ax,[bp+0000h]
      mov cx,[bp+0002h]
      mov dx,[bp+04h]
      mov bx,[bp+06h]
      push bp
      int 10h
      pop bp
      mov ah,09h
      mov al,[bp+00h]
      mov cx,[bp+02h]
      mov dx,[bp+04h]
      mov bx,[bp+06h]
      push bp
      int 10h
      pop bp
      jmp qzfablop
izfabsot:  mov ax,[bp+0038h]
      and ax,00ffh
      dec ax
      mov [bp+0018h],ax
      cmp ax,0000h
      js skipqzth
      cmp ax,[bp+0032h]
      jns skipqzth
      mov si,[bp+0018h]
      mov cx,si
      mov [bp+04h],cl
      add si,[bp+000ah]
      mov dl,[bp+si]
      mov [bp+00h],dl
      mov word [bp+06h],005fh
      mov cx,[bp+0038h]
      and cx,03c00h
      xor cx,03c00h
      jz skipqrzz
      mov word [bp+06h],006fh
skipqrzz:  mov cx,[bp+003ah]
      and cx,00ffh
      dec cx
      cmp cx,ax
      jnz skipqzone
      mov word [bp+06h],002fh
skipqzone:  mov bx,[bp+06h]
      mov dx,[bp+04h]
      mov cx,[bp+02h]
      mov ax,[bp+00h]
      push bp
      int 10h
      pop bp
      mov bx,[bp+06h]
      mov dx,[bp+04h]
      mov cx,[bp+02h]
      mov ah,09h
      mov al,[bp+00h]
      push bp
      int 10h
      pop bp
skipqzth:  add sp,001ah
      pop es
      pop ds
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; *xyptr points to
; 00           04          08          0c
; 10 x         14 y        18 xp       1c yp
; 20 prindiff  24 prinjill 28 moux     2c mouy&
; 30           34 insel%   38 esdsswitch    3c essu  3e dssu
; 40 alsel%    44 ytaelon&   48 slavechecksum   4a error    4c A80W%
; 50 AFILELEN& 54 numberofsegments   58 limit   5c esprv  5e dsprv
; ----------
; 60 segsubL   62 LEN_1    64 offset_1    66 start_1   68 segnumberL
;     6A           6C          6E
; 70 segsubH   72 LEN_2    74 offset_2    76 start_2   78 segnumberH
;     7A           7C          7E
; 080 &A*ptrtobitmap  082 &A*ptrtofontbase  084 readtypezur   086 ypheight%
; 088 chnext%    08A chdoc%      08C ch%       08e insertype%
; 090 inspg%      092 marginselect      094 alocalh
; 096 findbase%      098 findlen%       09a *ptrtoplate025
; 09c prindiffprv    0a0 uprighty&      0a4 lowlefty&
; 0a8 tnymouxprv   0aa tnymouyprv
;     0ac  mouallowlocal      0ae mouallowglobal
; 0b0  yre&      0b4 jysrc&   0b8 tzby&    0bc jyheight&
; 0c0 yyectr&     0c4 jydiff&
; 0c8 lowleftc&  0cc jydest&
; 0d0  uprightx%    0d4 lowleftx%    0d8 bkgnd%
; 0da helpfindtest      0dc jxwidth%
; 0e0 xe%    0e2    0e4 jxdiff%   0e6 readfnskipzur
; 0e8 lowleftb%     0ec uppercase     0ee comeofdelay
; 0f0 afilelenprv&   0f4 moubutprv    0f6 moucounter
; 0f8                0fc localsegloc      0fe cst3700firstseg
; 0100 segmentoffirst 0102 numbervalidl 0104             0106
; 0108                010a              010c             010e
; 0110 ybufflow       0112 ybuffhigh    0114 ywritelow   0116 ywritehigh
; 0118                011a toohi0A000h  011c
; 0120 rhanptrrecord_1
;      0120 repeat    0122 onechr    0124 fileposL    0126 fileposH
;      0128 flenL     012A flenH     012C handlevalue    012E position0toF
;         0130 to 013F reserved   for disk characters buffer
; 0140 rhanptrrecord_2
; 0160 to 01ff     line  1 mainline    alselset uses 0160h
; 0200 to 029f    line  2  secondline   ,3 delline,4 insertline
;                 5 prnline  6 findline  7 tempfilename  8 permfilename
; 0660 to 06ff    line 9  home gets menu line
;                 line 10  string buffer edslater
;                 line 11 command line input line. line 12 data
;-------
; 0b60 to 105f    line 17
; 1060 to 155f         25               12-55 is 44 lines of upside down
; 1560 to 1a5f         33               display.
; 1a60 to 1f5f         41
; 1f60 to 245f         49     end is 56
; 2460
;-----------
; DX:AX = alselset(*xyptr,linenumber)
;  12 linenumber   10 *xyptr      0e retad
;  0c disave      0a sisave      08 bpsave
;  06 bxsave      04 dxsave      02 cxsave      00 axsave
alselset:  push di
  push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov bp,sp
      mov bx,0000h
      mov si,[bp+012h]
      mov di,0001h
      push di
      push bx
      push si
      push bx
      call csubtract
; ( linenumber-1 ) is now in DX:AX
      add sp,0008h
      mov si,[bp+010h]
      sub si,bp
      mov di,[bp+si+004ch]
      push di
      push bx
      push ax
      push dx
      call cmpy
      add sp,0008h
      push ax
      push dx
      push word [bp+010h]
      push bx
      call cadd
      add sp,0008h
      mov cx,0160h
      push cx
      push bx
      push ax
      push dx
      call cadd
      add sp,0008h
      mov [bp+00h],ax
      mov [bp+04h],dx
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; end of alselset . two arguments.
; clearline(*xyptr,linenumber)
; clears chosen local line within *xyptr area
; 16 linenumber    14 *xyptr   12 retad   10 disave   0e sisave   0c bpsave
; 0a bxsave   08 dxsave   06 cxsave   04 axsave   02 selptr   00 blanctr
clearline:  push di
  push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0004h
      mov bp,sp
      push word [bp+016h]
      push word [bp+014h]
      call alselset
      add sp,0004h
      mov [bp+02h],ax
      mov si,[bp+014h]
      sub si,bp
      mov ax,[bp+si+04ch]
      mov [bp+00h],ax
      mov di,[bp+02h]
      sub di,bp
clearal:  dec word [bp+00h]
      cmp word [bp+00h],0000h
      js clearcal
      mov byte [bp+di],020h
      inc di
      jmp clearal
clearcal:  add sp,0004h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
;lalocal12(*xyptr)
; 16.18 *xyptr      insert 16 retad     14 disave   12 sisave   10 bpsave
; 0e bxsave     0c dxsave     0a cxsave     08 axsave     06   04   02   00
lalocal12:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0008h
      mov bp,sp
; IF (y&-1)<0 THEN y&=1
      mov si,[bp+0018h]
      sub si,bp
      mov ax,0001h
      mov dx,0000h
      push ax
      push dx
      push word [bp+si+0014h]
      push word [bp+si+0016h]
      call csubtract
      add sp,0008h
      test cx,000ch
      jz skiyonel
      mov word [bp+si+0016h],0000h
      mov word [bp+si+0014h],0001h
      jmp skiyaflenone
; IF (afilelen&-y&)<0 THEN y&=afilelen&+1
skiyonel:  push word [bp+si+0014h]
      push word [bp+si+0016h]
      push word [bp+si+0050h]
      push word [bp+si+0052h]
      call csubtract
      add sp,0008h
      test cx,000ch
      jz skiyaflenone
      mov ax,0001h
      mov dx,0000h
      push ax
      push dx
      push word [bp+si+0050h]
      push word [bp+si+0052h]
      call cadd
      add sp,0008h
      mov [bp+si+0014h],ax
      mov [bp+si+0016h],dx
skiyaflenone:  mov ax,0001h
      mov dx,0000h
      push ax
      push dx
      push word [bp+si+0014h]
      push word [bp+si+0016h]
      call cadd
      add sp,0008h
      mov [bp+si+0044h],ax
      mov [bp+si+0046h],dx
      mov cx,02h
      push cx
      push word [bp+018h]
      call slateacread
      add sp,04h
      mov ax,[bp+si+0014h]
      mov dx,[bp+si+0016h]
      mov [bp+si+0044h],ax
      mov [bp+si+0046h],dx
      mov cx,01h
      push cx
      push word [bp+018h]
      call slateacread
      add sp,04h
; fix x% [bp+si+0010h]  x%>a80w% x%=1     x%<1 x%=a80w%
za2180: mov word [bp+si+012h],0000h
      push word [bp+si+0010h]
      push word [bp+si+012h]
      push word [bp+si+04ch]
      push word [bp+si+012h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz za2182
      mov word [bp+010h],0001h
za2182:  mov ax,0001h
      push ax
      push word [bp+si+012h]
      push word [bp+si+010h]
      push word [bp+si+012h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz za2183
      mov ax,[bp+si+04ch]
      mov [bp+si+010h],ax
; x% is in wraparround mode
za2183:  add sp,0008h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; line 3403
;  cvgcline(*xyptr,sslsel,spos,howmany)
; sslsel is 5 for segmented array read
; sslsel is <>5 for local read
; spos is screen vertical position
; when sslsel=5 howmany is checked howmany=0,1,2
; howmany={0 align prindiff only,  1 print y& only  = 2 print all >2 nocursor}
; temp yyph.yypl = prindiff32 + 0.spos
; 3a 38  ??      36 howmany   34 spos      32 sslsel     30 *xyptr
; 2e retad      2c disave     2a sisave     28 bpsave     26 bxsave
; 24 dxsave     22 cxsave     20 axsave    1e   1c fn    1a moucursorpos
; 18 maincursorpos     16 *ptrtocharline     14 shift    12 z80width
; 10 *ptrtofontbase
; 0e *ptrtobitmap
; *** ERROR *** TWO MEANINGS FOR [BP+0EH]
; ** WARNING ** bp+0eh ptr to bitmap will  change LATER for vgabmp.io16
; 0c yzz     0a xzz
; 08   06 yypH   04 yypL   02   00
cvgcline:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov cx,0010h
      mov bx,0000h
cvgcsa:  push bx
      dec cx
      jnz cvgcsa
      mov bp,sp
      mov di,[bp+0030h]
      sub di,bp
; **
      mov cx,[bp+0034h]
      mov [bp+0014h],cx
      mov cx,0000h
      cmp word [bp+0032h],0005h
      jz cvgcsd
      jmp cvgnonfiv
;  line 3440
cvgcsd:  mov ax,04000h
      add ax,ax
      and ax,[bp+di+022h]
      jz cvgcse
      mov word [bp+di+022h],0000h
      mov word [bp+di+020h],0000h
cvgcse:  push word [bp+di+020h]
      push word [bp+di+022h]
      push word [bp+di+0014h]
      push word [bp+di+016h]
      call csubtract
      add sp,0008h
      mov [bp+di+024h],ax
      mov [bp+di+026h],dx
      push word [bp+di+024h]
      push word [bp+di+026h]
      mov ax,[bp+di+086h]
; REM mov dx, 0 or 1 next  statement
      mov dx,0000h
      sub ax,dx
      push ax
      push bx
      call csubtract
      add sp,0008h
      test cx,000ch
      jz zwr1784
      push word [bp+di+0086h]
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,0008h
      mov [bp+di+020h],ax
      mov [bp+di+022h],dx
; rem next zwr1784 mov ax, 1 or 2      line  3475
zwr1784:  mov ax,0001h
      push ax
      push bx
      push word [bp+di+024h]
      push word [bp+di+026h]
      call csubtract
      add sp,0008h
      test cx,000ch
      jz zwr1786
      mov ax,01h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,0008h
      mov [bp+di+020h],ax
      mov [bp+di+022h],dx
zwr1786:  push word [bp+0034h]
      push bx
      push word [bp+di+0020h]
      push word [bp+di+0022h]
      call cadd
      add sp,0008h
      mov [bp+04h],ax
      mov [bp+06h],dx
      push word [bp+04h]
      push word [bp+06h]
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,0008h
      cmp word [bp+0036h],0000h
      jnz cvgcyone
      jmp cvgcquit
;    line           3511
cvgcyone:      test cx,000eh
      jnz cvgcnotya
      cmp word [bp+036h],02h
      ja  cvgcnotya
      mov ax,[bp+di+0010h]
      or ax,01800h
; setting ah part of ax to show cursor dots for regular key cursor
      cmp word [bp+di+008eh],00h
      jz cvgc18set
      or ax,03c00h
cvgc18set:      mov [bp+0018h],ax
      jmp cvgcnotyb
cvgcnotya:  cmp word [bp+0036h],0002h
            jns cvgcnotyb
            jmp cvgcquit
cvgcnotyb:       mov ax,[bp+04h]
      mov dx,[bp+06h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      push word [bp+0032h]
      push word [bp+0030h]
      call slateacread
      add sp,0004h
      cmp word [bp+0036h],0002h
      ja cvgcskipmo
      cmp word [bp+di+00aeh],0000h
      jz cvgcskipmo
      push word [bp+di+09ch]
      push word [bp+di+09eh]
      push word [bp+di+020h]
      push word [bp+di+022h]
      call csubtract
      add sp,08h
      push ax
      push dx
      push word [bp+di+02ch]
      push word [bp+di+02eh]
      call cadd
      add sp,08h
      mov [bp+di+02ch],ax
      mov [bp+di+02eh],dx
      push word [bp+di+020h]
      pop word [bp+di+009ch]
      push word [bp+di+022h]
      pop word [bp+di+009eh]
      push word [bp+04h]
      push word [bp+06h]
      push word [bp+di+002ch]
      push word [bp+di+002eh]
      call csubtract
      add sp,08h
      test cx,000eh
      jnz cvgcskipmo
      cmp word [bp+di+00ach],0000h
      jz cvgcskipmo
      mov ax,[bp+di+0028h]
      cmp ax,01h
      js cvgcskipmo
      or ax,05a00h
      mov [bp+001ah],ax
cvgcskipmo:   jmp cvgcprcom
cvgnonfiv:  cmp word [bp+0036h],0002h
      ja cvgcprcom
      cmp word [bp+0032h],0bh
      jz cvgcaltcur
      cmp word [bp+0032h],08h
      ja cvgcprcom
      cmp word [bp+0032h],06h
      jb cvgcprcom
cvgcaltcur:   mov ax,[bp+di+0010h]
      or ax,03c00h
      mov [bp+018h],ax
cvgcprcom:  push word [bp+0032h]
      push word [bp+0030h]
      call alselset
      add sp,04h
      mov [bp+0016h],ax
;      mov word [bp+0014h],0004h
;      and word [bp+0014h],0000h
; [bp+0014h] was shift that controls screen size    line 3547
      mov ax,[bp+di+04ch]
      mov [bp+0012h],ax
      mov ax,[bp+di+0082h]
      mov [bp+010h],ax
      mov ax,[bp+di+080h]
      mov [bp+0eh],ax
      mov si,001ah
      mov cx,0007h
cvgct:    push word [bp+si]
      dec si
      dec si
; 1a 18 16 14 12 10 0e
      dec cx
      jnz cvgct
      call rprline
      add sp,000eh
; do not revalue [bp+0eh]
cvgcquit:      add sp,0020h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; line       3601.3418
; chrvgapage(*xyptr,howmany)
; howmany=0,1,2
; =0 align prindiff only   =1 print line at y only   =2 print all lines
; 14 howmany     12 *xyptr     10 retad     0e disave     0c sisave
; 0a bpsave     08 dxsave   06 cxsave   04 axsave   02 sposctr   00 cstfiv
chrvgapage:  push di
      push si
      push bp
      push dx
      push cx
      push ax
      mov di,0000h
      push di
      mov di,0005h
      push di
      mov bp,sp
      mov si,[bp+0012h]
      sub si,bp
      mov di,[bp+si+0086h]
chrvgatop:  inc word [bp+0002h]
      cmp di,[bp+0002h]
      js chrvgabot
      push word [bp+0014h]
      push word [bp+0002h]
      push word [bp+0000h]
      push word [bp+0012h]
      call cvgcline
      add sp,0008h
      jmp chrvgatop
chrvgabot:  add sp,0004h
      pop ax
      pop cx
      pop dx
      pop bp
      pop si
      pop di
      ret
; laput12(*xyptr)
; laput12 store y&,(y&+1 using chnext%)
; resets ch% 08c   chnext% 088
; 18 *xyptr     16 retad    14 disave    12 sisave    10 bpsave
; 0e bxsave     0c dxsave   0a cxsave   08 axsave     06   04   02   00
laput12:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0008h
      mov bp,sp
      mov di,[bp+0018h]
      sub di,bp
      mov bx,0000h
      cmp word [bp+di+088h],0000h
      jnz z1803
      jmp z1808
z1803:  mov ax,01h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call cadd
      add sp,08h
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      mov ax,02h
      push ax
      push word [bp+0018h]
      call slateacwrite
      add sp,0004h
; z1807 unauthorized checking (y+1) > afilelen
z1807:  push word [bp+di+044h]
      push word [bp+di+046h]
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz z1808
      mov ax,[bp+di+044h]
      mov dx,[bp+di+046h]
      mov [bp+di+050h],ax
      mov [bp+di+052h],dx
; end of unauthorized z1807 section.
z1808:  mov ax,[bp+di+0014h]
      mov dx,[bp+di+0016h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      mov ax,01h
      push ax
      push word [bp+0018h]
      call slateacwrite
      add sp,0004h
      push word [bp+di+014h]
      push word [bp+di+016h]
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,0008h
      test cx,000ch
      jz z1814
      mov ax,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+050h],ax
      mov [bp+di+052h],dx
z1814:  mov ax,0000h
      mov [bp+di+08ch],ax
      mov [bp+di+088h],ax
      add sp,08h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
;  clenval(*xyptr,linenumber)
; returns length of line to rightmost non-blank in AX
; AX=exact byte line length
; returns required number of 16-byte paragraphs (0-5) in cx
; 16 linenumber     14 *xyptr     12 retad     10 disave
; 0e sisave     0c bpsave     0a bxsave     08 dxsave
; 06 cxsave      04 axsave lval%       02 (albase%-1)        00
clenval:  push di
  push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,04h
      mov bp,sp
      mov di,[bp+0014h]
      sub di,bp
      mov bx,0000h
      mov ax,[bp+di+004ch]
      mov [bp+04h],ax
      push word [bp+0016h]
      push word [bp+0014h]
      call alselset
      add sp,04h
      sub ax,bp
      dec ax
      mov [bp+02h],ax
z1848:  mov si,[bp+02h]
      add si,[bp+04h]
      mov dl,[bp+si]
      cmp dl,00h
      jz z1856
      cmp dl,020h
      jnz z1860
z1856:  sub word [bp+04h],0001h
      cmp word [bp+04h],0000h
      ja z1848
z1860:  mov dx,[bp+04h]
      add dx,000fh
      mov cx,0004h
      shr dx,cl
      mov [bp+06h],dx
      add sp,04h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; ikx1864 (*xyptr,keychr%,alselone)
; insert keychr% at x%      ikx1873 without alselone=1
; alsel%=alselone
; 24 alselone    22 keychr%   20 *xyptr    1e retad    1c disave    1a sisave
; 18 bpsave     16 bxsave     14 dxsave     12 cxsave    10 axsave
; 0e albase%     0c iisub%     0a lval%    08   06   04   02   00
ikx1864:  push di
  push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      mov bx,0000h
      mov ax,[bp+0024h]
      mov [bp+di+0040h],ax
      cmp ax, 0001h
      jnz ikx1873
      mov ax,02h
      push ax
      push word [bp+0020h]
      call clearline
      add sp,0004h
      mov word [bp+di+008ah],01h
ikx1873:  mov word [bp+di+0090h],00h
      push word [bp+di+040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      sub ax,bp
      mov [bp+0eh],ax
      mov ax,[bp+0eh]
      add ax,[bp+di+010h]
      sub ax,0001h
      mov [bp+0ch],ax
      mov word [bp+di+08ch],0001h
      mov word [bp+di+088h],0000h
      push word [bp+di+040h]
      push word [bp+020h]
      call clenval
      add sp,04h
      mov [bp+0ah],ax
      cmp word [bp+di+08eh],00h
      jnz z1886
z1880:  mov ax,07fh
      and ax,[bp+022h]
      cmp ax,0020h
      jns zay1880
      mov ax,0020h
zay1880:  mov si,[bp+0ch]
      mov [bp+si],al
      add word [bp+di+0010h],0001h
      mov ax,05h
      cmp ax,[bp+di+040h]
      js z1885
      push word [bp+0020h]
      call laput12
      add sp,02h
z1885:  jmp z1990
z1886:  mov ax,05h
      cmp ax,[bp+di+040h]
      js z1896
      mov ax,[bp+di+04ch]
      sub ax,0001h
      sub ax,[bp+0ah]
      cmp ax,00h
      jns z1892
      jmp z1928
z1892:   mov ax,[bp+di+04ch]
      sub ax,01h
      sub ax,[bp+di+010h]
      cmp ax,00h
      jns z1896
      jmp z1960
z1896:  mov cx,[bp+0ah]
      mov dx,[bp+di+010h]
z1900:  mov si,[bp+0eh]
      add si,cx
      sub si,01h
      cmp cx,dx
      js z1924
      mov al,[bp+si]
      mov [bp+si+01h],al
      dec cx
      jmp z1900
z1924:  jmp z1880
z1928: mov ax,00ffh
       push ax
       push word [bp+020h]
      call iek2000
      add sp,04h
      mov word [bp+di+090h],01h
z1960:      mov ax,[bp+di+010h]
      cmp ax,[bp+di+04ch]
      js z1896
      mov ax,07fh
      and ax,[bp+022h]
      cmp ax,0020h
      jns z1963
      mov ax,0020h
z1963:  mov si,[bp+0ch]
      mov [bp+si],al
z1978:  mov ax,02h
      push ax
      push word [bp+020h]
      call gek2040
      add sp,04h
      mov word [bp+di+034h],0001h
      mov ax,01h
      push ax
      push word [bp+020h]
      call clearline
      add sp,04h
      push word [bp+020h]
      call acinsertb
      add sp,02h
      mov ax,01h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      mov word [bp+di+090h],0001h
z1990:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; iek2000(*xyptr,nzkey)
; 22 nzkey     20 *xyptr     1e retad     1c disave
; 1a sisave   18 bpsave    16 bxsave   14 dxsave    12 cxsave   10 axsave
; 0e albase%    0c erd%   0a erxsub%     08 erchk%   06 ercmp%    04  02  00
iek2000:  push di
  push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov bx,0000h
      mov ax,[bp+di+04ch]
      mov [bp+0ch],ax
      mov ax,[bp+di+0010h]
      sub ax,01h
      mov [bp+0ah],ax
      mov dx,02h
      push dx
      push word [bp+0020h]
      call clearline
      add sp,04h
      mov word [bp+di+0040h],0001h
      push word [bp+di+0040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      sub ax,bp
      mov [bp+0eh],ax
      mov word [bp+08h],00h
z2006:  mov si,[bp+0eh]
      add si,[bp+0ah]
      mov al,[bp+si]
      and ax,00ffh
      mov [bp+06h],ax
      cmp word [bp+06h],0020h
      jz z2012
      mov word [bp+08h],0001h
z2012:  mov si,[bp+0eh]
      add si,[bp+0ch]
      mov dx,[bp+06h]
      mov [bp+si],dl
      mov si,[bp+0eh]
      add si,[bp+0ah]
      mov byte [bp+si],020h
      add word [bp+0ch],0001h
      add word [bp+0ah],0001h
      mov ax,[bp+0ah]
      cmp ax,[bp+di+04ch]
      jns z2020bt
      jmp z2006
z2020bt:  cmp word [bp+022h],00h
      jz z2022
z2020:  cmp word [bp+08h],0000h
      jz z2036
z2022:  mov ax,01h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call cadd
      add sp,0008h
      mov [bp+di+016h],dx
      mov [bp+di+014h],ax
      mov word [bp+di+034h],02h
      push word [bp+0020h]
      call acinsertb
      add sp,02h
      mov ax,02h
      push ax
      push word [bp+020h]
      call clearline
      add sp,04h
      mov ax,02h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      mov word [bp+di+040h],01h
      push word [bp+di+040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      sub ax,bp
      mov [bp+0eh],ax
z2036:  add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; gek2040(*xyptr,zurtwo)
; general enter key
; 18 zurtwo   16 *xyptr
; 14 retad   12 disave   10 sisave   0e bpsave   0c bxsave
; 0a dxsave   08 cxsave     06 axsave   04   02   00
gek2040:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,06h
      mov bp,sp
      mov di,[bp+016h]
      sub di,bp
      mov bx,0000h
      cmp word [bp+018h],0000h
      jnz gek2042
      mov ax,00h
      push ax
      push word [bp+016h]
      call iek2000
      add sp,04h
gek2042:  mov word [bp+di+088h],00h
      push word [bp+016h]
      call laput12
      add sp,02h
; uncertain x%=1 ??
      mov ax,0001h
      mov [bp+di+010h],ax
      mov dx,01h
      push dx
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
; if y%>afilelen causes problem remove skipgekup
skipgekup: jmp gek2048
     push ax
      push dx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,0008h
      test cx,000ch
      jns gek2048
      mov ax,03h
      push ax
      push word [bp+016h]
      call clearline
      add sp,04h
      mov word [bp+di+034h],03h
      mov ax,01h
      push ax
      push bx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      push word [bp+016h]
      call acinsertb
      add sp,02h
gek2048:  add sp,06h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; dkx2050(*xyptr,deltype)
; deltype does not change alsel% except deltype=???0
; deltype last hex digit matches replacement line numbers last digit
; 2050 delete key at x%    2054 undefined alsel%    2055 undefined inspg%
; 2156 backwards delete      2158 undefined alsel%
; or alsel% 040h to disable deleting next line as in backwards delete x%<>1
; 22 deltype    20 *xyptr   1e retad    1c disave    1a sisave    18 bpsave
; 16 bxsave     14 dxsave     12 cxsave     10 axsave   0e albase%
; 0c iisub%     0a lval%     08 ix%    06 deldisp%     04   02   00
dkx2050: push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      mov bx,0000h
      mov ax,[bp+0022h]
      and ax,000fh
      cmp al,00h
      jnz dkxnz
      jmp zy2050
dkxnz:  cmp al,04h
      jnz dkxnf
      jmp z2054
dkxnf:  cmp al,05h
      jnz dkxnfv
      jmp z2055
dkxnfv:  cmp al,06h
      jnz dkxs
      jmp z2156
dkxs:  cmp al,08h
      jnz dkxq
      jmp z2158
dkxq: jmp zxz2142
zy2050:  mov word [bp+di+040h],0001h
z2054:   mov word [bp+di+090h],0000h
z2055:   mov word [bp+di+008ch],0001h
      push word [bp+di+040h]
      push word [bp+0020h]
      call alselset
      add sp,04h
      sub ax,bp
      mov [bp+0eh],ax
      mov word [bp+di+088h],0000h
      mov si,[bp+0eh]
      add si,[bp+di+010h]
      sub si,0001h
      mov [bp+0ch],si
      cmp word [bp+di+040h],05h
      ja z2070
      cmp word [bp+di+08eh],00h
      jnz z2070
      mov si,[bp+0ch]
      mov byte [bp+si],0020h
z2067:  cmp word [bp+di+040h],0005h
      js z2068
      jz z2068
      jmp zxz2142
z2068:  push word [bp+020h]
      call laput12
      add sp,02h
      jmp zxz2142
z2070:  push word [bp+di+040h]
      push word [bp+020h]
      call clenval
      add sp,04h
      mov [bp+0ah],ax
      cmp word [bp+di+040h],05h
      ja z2076
z2074:  test word [bp+022h],040h
      jnz z2076
      mov dx,[bp+0ah]
      cmp dx,[bp+di+010h]
      jns z2076
      jmp z2096
z2076:  mov ax,[bp+di+010h]
      mov [bp+08h],ax
z2080:  mov si,[bp+0eh]
      add si,[bp+08h]
      sub si,0001h
      mov ax,[bp+08h]
      cmp ax,[bp+0ah]
      jns z2090
z2084:  mov dl,[bp+si+01h]
      mov [bp+si],dl
      add word [bp+08h],01h
      jmp z2080
z2090:  mov byte [bp+si],020h
      jmp z2067
z2096:  mov ax,01h
      add ax,[bp+di+004ch]
      sub ax,[bp+di+010h]
      mov [bp+06h],ax
      mov word [bp+di+040h],01h
      push word [bp+di+040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      sub ax,bp
      mov [bp+0eh],ax
      mov ax,[bp+di+010h]
      mov [bp+08h],ax
z2100:  mov cx,[bp+08h]
      sub cx,01h
      mov dx,cx
      add dx,[bp+06h]
      cmp cx,[bp+di+04ch]
      js z2106
      jmp z2112
z2106:  mov si,dx
      add si,[bp+0eh]
      mov al,[bp+si]
      mov si,cx
      add si,[bp+0eh]
      mov [bp+si],al
      add word [bp+08h],01h
      jmp z2100
z2112:  mov ax,[bp+06h]
      mov [bp+08h],ax
z2114:  mov si,cx
      add si,[bp+0eh]
      mov byte [bp+si],020h
      inc cx
      sub word [bp+08h],01h
      cmp word [bp+08h],00h
      jnz z2114
z2120:  mov word [bp+08h],00h
z2122:  mov cx,[bp+di+04ch]
      add cx,[bp+08h]
      mov si,cx
      add si,[bp+0eh]
      cmp byte [bp+si],020h
      jz z2130
      mov word [bp+di+090h],01h
      mov word [bp+di+088h],01h
      jmp z2067
z2130:  add word [bp+08h],01h
      mov ax,[bp+08h]
      cmp ax,[bp+di+04ch]
      js z2122
      mov ax,01h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
z2136:  push word [bp+020h]
      call aclinedel
      add sp,02h
      mov word [bp+di+090h],01h
      mov ax,01h
      push ax
      push bx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,08h
      mov [bp+di+016h],dx
      mov [bp+di+014h],ax
      jmp z2067
zxz2142:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
z2156:  mov word [bp+di+040h],0001h
      mov word [bp+di+08ah],01h
z2158:  sub word [bp+di+010h],01h
      mov word [bp+di+090h],00h
      push word [bp+di+040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      sub ax,bp
      mov [bp+0eh],ax
      cmp word [bp+di+010h],01h
      js z2162
z2161:  jmp z2054
z2162:  mov word [bp+di+090h],01h
      push word [bp+di+014h]
      push word [bp+di+016h]
      mov ax,01h
      push ax
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz z2167
      mov ax,01h
      mov [bp+di+010h],ax
      mov [bp+di+012h],bx
      mov [bp+di+014h],ax
      mov [bp+di+016h],bx
      jmp z2055
z2167:  mov ax,01h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      push word [bp+020h]
      call lalocal12
      add sp,02h
      push word [bp+di+040h]
      push word [bp+020h]
      call clenval
      add sp,04h
      mov [bp+0ah],ax
      mov dx,[bp+0ah]
      add dx,01h
      mov [bp+di+010h],dx
      and word [bp+0022h],0ffbfh
      mov ax,[bp+di+010h]
      cmp ax,[bp+di+04ch]
      js z2174
      mov dx,[bp+di+04ch]
      mov [bp+di+010h],dx
z2174:  jmp z2055
; end of dkx2050 delete key at x%
; numberprn(*xyptr,startline,startsubscript,width,base,numberhigh,numberlow)
; 40 numberlow       3e numberhigh
; 3c base  base of number               3a width
; 38 startsubscript        x  position within line
; 36 startline   34 *xyptr
; 32 retad    30 disave    2e sisave    2c bpsave      2a bxsave
; 28 dxsave    26 cxsave    24 axsave    22 diga      20 dig8
; 1e dig6    1c dig4    1a dig2    18 dig0    16 tnh    14 tnl
; 12 tfh    10 tfl    0e totalsubscript    0c prnctr    0a
; 08    06    04    02    00
numberprn:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0024h
      mov bp,sp
      mov bx,00h
      mov di,[bp+034h]
      sub di,bp
      push word [bp+036h]
      push word [bp+034h]
      call alselset
      add sp,04h
      sub ax,bp
      add ax,[bp+038h]
      sub ax,01h
      mov [bp+0eh],ax
      cmp word [bp+03ch],02h
      jns hexcmpy
prnbasezur:  jmp prnbasequit
hexcmpy:     cmp word [bp+03ch],010h
      ja prnbasezur
      cmp word [bp+03ah],0ch
      ja prnbasezur
      cmp word [bp+03ah],01h
      js prnbasezur
      mov ax,[bp+03ah]
      mov [bp+0ch],ax
      push word [bp+040h]
      pop word [bp+014h]
      push word [bp+03eh]
      pop word [bp+016h]
mberloopxp:  sub word [bp+0ch],0001h
      jns mberloopyp
      jmp mberlooprbot
mberloopyp:  push word [bp+03ch]
      push bx
      push word [bp+014h]
      push word [bp+016h]
      call cposdiv
      add sp,08h
      push ax
      push dx
      push word [bp+03ch]
      push bx
      mov [bp+010h],ax
      mov [bp+012h],dx
      call cmpy
      add sp,08h
      push ax
      push dx
      push word [bp+014h]
      push word [bp+016h]
      call csubtract
      add sp,08h
      push word [bp+010h]
      pop word [bp+014h]
      push word [bp+012h]
      pop word [bp+016h]
      cmp ax,000ah
      js prfoureight
      add ax,037h
      jmp prdigithy
prfoureight:  add ax,0030h
prdigithy:    mov si,[bp+0ch]
      mov [bp+si+018h],al
      jmp mberloopxp
mberlooprbot:  mov word [bp+0ch],0000h
      mov dx,[bp+016h]
      or dx,[bp+0014h]
      jz mberloopnext
      jmp prnbasezur
mberloopnext:  mov si,[bp+0ch]
      cmp si,[bp+03ah]
      jns mberdoney
      mov al,[bp+si+018h]
      add si,[bp+0eh]
      mov [bp+si],al
      inc word [bp+0ch]
      jmp mberloopnext
mberdoney:  jmp prnbasezur
prnbasequit:  add sp,024h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
;  dx:ax = cdigitval(character)
;  dx=0 numeric  dx=1 non numeric
; 0e character   0c retad   0a disave
; 08 sisave   06 bpsave    04 resuH   02 cxsave     00 resuL
cdigitval:  push di
      push si
      push bp
      mov dx,00h
      push dx
      push cx
      sub sp,02h
      mov bp,sp
      mov ax,[bp+0eh]
      and ax,00ffh
      cmp ax,066h
      ja ucdigcomp
      cmp ax,061h
      jb ucdigcomp
      sub ax,057h
      jmp digcommon
ucdigcomp:  cmp ax,046h
      ja decdigcmp
      cmp ax,041h
      jb decdigcmp
      sub ax,037h
      jmp digcommon
decdigcmp:  cmp ax,039h
      ja nondigcmp
      cmp ax,030h
      jb nondigcmp
      sub ax,030h
      jmp digcommon
nondigcmp: mov word [bp+04h],01h
      mov ax,00h
digcommon:  add sp,02h
      pop cx
      pop dx
      pop bp
      pop si
      pop di
      ret
; dx:ax = numberget(*xyptr,startline,startsubscript,width,base)
; 28 base       26 width      24 startsubscript
; 22 startline    20 *xyptr    1e retad    1c disave
; 1a sisave   18 bpsave   16 bxsave   14 dxsave   12 cxsave   10 axsave
; 0e totalsubscript       0c prnctr       ; 0a   08   06   04   02   00
numberget:  push di
  push si
      push bp
      push bx
      mov dx,0000h
      push dx
      push cx
      push dx
      sub sp,010h
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      mov bx,00h
      push word [bp+0022h]
      push word [bp+0020h]
      call alselset
      add sp,04h
      add ax,[bp+0024h]
      sub ax,01h
      sub ax,bp
      mov [bp+0eh],ax
      cmp word [bp+026h],01h
      jb widfailget
      cmp word [bp+026h],0ch
      ja widfailget
      jmp basegetnx
widfailget:  jmp numberquit
basegetnx:  cmp word [bp+028h],02h
      jb widfailget
      cmp word [bp+028h],010h
      ja widfailget
      mov word [bp+0ch],0000h
      mov si,[bp+0eh]
numberprv:  mov dl,[bp+si]
      push dx
      call cdigitval
      add sp,02h
      inc si
      cmp dx,0000h
      jz numberbth
      inc word [bp+0ch]
      mov cx,[bp+0ch]
      cmp cx,[bp+026h]
      js numberprv
      jmp widfailget
numberbth:  dec si
numberbca:  mov dl,[bp+si]
      inc si
      push dx
      call cdigitval
      add sp,02h
      cmp dx,00h
      jnz widfailget
      push ax
      push dx
      push word [bp+028h]
      push bx
      push word [bp+010h]
      push word [bp+014h]
      call cmpy
      add sp,08h
      push ax
      push dx
      call cadd
      add sp,08h
      mov [bp+010h],ax
      mov [bp+014h],dx
      inc word [bp+0ch]
      mov cx,[bp+0ch]
      cmp cx,[bp+026h]
      js numberbca
      jmp widfailget
numberquit:  add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; regkey2176 (*xyptr        )
; 20 *xyptr    1e retad     1c disave    1a sisave    18 bpsave
; 16 bxsave    14 dxsave    12 cxsave    10 axsave    0e propposH
; 0c propposL    0a   08  06 dkey   04 ckey   02 akey   00
regkey2176:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov bx,0000h
      mov word [bp+di+00ach],0001h
reginkey2176:  push word [bp+020h]
      call lalocal12
      add sp,02h
      mov ax,02h
      push ax
      push word [bp+020h]
      call chrvgapage
      add sp,04h
reginkey2190:  push word [bp+di+020h]
      push word [bp+di+022h]
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      mov [bp+0ch],ax
      mov [bp+0eh],dx
      cmp word [bp+0eh],0000h
      jz contin2190
fail2190:  jmp slow2190
contin2190:  mov ax,[bp+di+086h]
      cmp ax,[bp+0ch]
      jb fail2190
      cmp word [bp+0ch],01h
      js fail2190
      mov dx,05h
      mov ax,02h
      push ax
      push word [bp+0ch]
      push dx
      push word [bp+0020h]
      call cvgcline
      add sp,0008h
      jmp endof2190
slow2190:  mov ax,01h
      push ax
      push word [bp+020h]
      call chrvgapage
      add sp,04h
; undocumented untill endof2190
      push word [bp+di+020h]
      push word [bp+di+022h]
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      mov [bp+0ch],ax
      mov [bp+0eh],dx
endof2190:  push word [bp+020h]
     call lalocal12
      add sp,02h
     push word [bp+di+010h]
      push word [bp+di+012h]
      mov ax,0ah
      mov dx,03h
      push ax
      push dx
      mov ax,09h
      mov dx,02ch
      push dx
      push ax
      push word [bp+0020h]
      call numberprn
      add sp,000eh
      push word [bp+di+014h]
      push word [bp+di+016h]
      mov ax,0ah
      mov dx,05h
      push ax
      push dx
      mov ax,09h
      mov dx,031h
      push dx
      push ax
      push word [bp+0020h]
      call numberprn
      add sp,0eh
      push word [bp+0ch]
      push word [bp+0eh]
      mov ax,0ah
      mov dx,02h
      push ax
      push dx
      mov ax,09h
      mov dx,038h
      push dx
      push ax
      push word [bp+0020h]
      call numberprn
      add sp,0eh
; diagnostic
        push word [bp+0020h]
        call linesleft82
        add sp,0002h
        mov dx,00h
        push ax
        push dx
      mov ax,0ah
      mov dx,04h
      push ax
      push dx
      mov ax,09h
      mov dx,03bh
      push dx
      push ax
      push word [bp+0020h]
      call numberprn
      add sp,0eh
   mov dx,02h
      push dx
      mov ax,[bp+di+086h]
      add ax,01h
      push ax
      mov dx,09h
      push dx
      push word [bp+020h]
      call cvgcline
      add sp,08h
      mov ax,01h
      push ax
      push word [bp+0ch]
      mov ax,05h
      push ax
      push word [bp+0020h]
      call cvgcline
      add sp,08h
; end of print x%  y&   yp%
      test word [bp+di+04ah],0fffh
      jz z2194
      jmp z2298
z2194:  mov ax,0000h
      push ax
      mov ah,04bh
      mov al,059h
      push ax
      call io16
      add sp,02h
      add sp,02h
      cmp cx,00h
      jz moa01
      jmp keyvalid2194
moa01:  cmp word [bp+di+00aeh],00h
      jz z2194
      cmp word [bp+di+00ach],00h
      jz z2194
;  check for mouse here
      cmp word [bp+di+004ch],0050h
      jnz mo29
      mov ax,01h
      and ax,[bp+di+00ach]
      and ax,[bp+di+00aeh]
      cmp ax,0000h
      jnz mo23
mo29:  jmp z2194
mo23:  cmp word [bp+di+00f6h],01h
      jns mo25
mo24:  mov word [bp+di+00f6h],0020h
      jmp mo31
mo25:  cmp word [bp+di+00f6h],0020h
      jg mo24
      dec word [bp+di+00f6h]
      jmp mo29
mo31:  push ax
      mov ah,04dh
      mov al,04fh
      push ax
      call io16
      add sp,04h
;  ax=button  cx=x 0 to 027fh      dx=y 0 to 0c7h
      mov [bp+02h],ax
      mov [bp+04h],cx
      mov [bp+06h],dx
      mov ax,08h
      mov dx,00h
      push ax
      push dx
      push word [bp+04h]
      push dx
      call cposdiv
      add sp,08h
      add ax,01h
      mov [bp+04h],ax
      mov ax,08h
      mov dx,00h
      push ax
      push dx
      push word [bp+06h]
      push dx
      call cposdiv
      add sp,08h
      add ax,01h
      mov [bp+06h],ax
      cmp word [bp+04h],01h
      jns mo41
      mov word [bp+04h],01h
mo41:  cmp word [bp+06h],01h
      jns mo43
      mov word [bp+06h],01h
mo43:  mov ax,[bp+04h]
      mov dx,[bp+di+004ch]
      cmp ax,dx
      js mo45
      mov [bp+04h],dx
mo45:  mov ax,[bp+06h]
      mov dx,[bp+di+0086h]
      cmp ax,dx
      js mo47
      mov [bp+06h],dx
mo47:  push word [bp+04h]
      pop word [bp+di+0028h]
      mov dx,0000h
      push word [bp+06h]
      push dx
      push word [bp+di+0020h]
      push word [bp+di+0022h]
      call cadd
      add sp,0008h
mourey:  mov [bp+di+002ch],ax
         mov [bp+di+002eh],dx
        push ax
      push dx
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz mo49
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      call cadd
      add sp,08h
      mov [bp+di+002ch],ax
      mov [bp+di+002eh],dx
mo49:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+002ch]
      push word [bp+di+002eh]
      call csubtract
      add sp,08h
      test cx,0ch
      jz mo51
      mov word [bp+di+002ch],01h
      mov word [bp+di+002eh],00h
mo51:  test word [bp+02h],0fffch
      jz mo53
      mov word [bp+di+00aeh],0000h
      jmp mo29
mo53:  mov ax,[bp+02h]
      mov dx,[bp+di+00f4h]
      mov [bp+di+00f4h],ax
      cmp dx,0000h
      jnz moupa
      cmp ax,0000h
      jz moupa
      jmp moupb
moupa:  jmp moup
moupb:  mov ax,[bp+di+0028h]
      cmp ax,[bp+di+0010h]
      jnz moudowna
      push word [bp+di+002ch]
      push word [bp+di+002eh]
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,08h
      test cx,000eh
      jnz moudowna
      jmp moudownb
moudowna:  jmp moudown
moudownb:      mov ax,[bp+di+0086h]
      cmp ax,[bp+06h]
      jnz mo57
      test word [bp+di+0028h],0001h
      jz mymo56
      sub ax,04h
      mov dx,0000h
      push ax
      push dx
      push word [bp+di+002ch]
      push word [bp+di+002eh]
      call cadd
      add sp,08h
      mov  [bp+di+002ch],ax
      mov  [bp+di+002eh],dx
      jmp z2242
mymo56:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+002ch]
      push word [bp+di+002eh]
      call cadd
      add sp,08h
      mov [bp+di+002ch],ax
      mov [bp+di+002eh],dx
      jmp z2231
mo57:  cmp word [bp+06h],01h
      jnz moudowna
      test word [bp+di+0028h],0001h
      jz mymo58
      sub ax,04h
      mov dx,0000h
      push ax
      push dx
      push word [bp+di+002ch]
      push word [bp+di+002eh]
      call csubtract
      add sp,0008h
      mov [bp+di+002ch],ax
      mov [bp+di+002eh],dx
      jmp z2238
mymo58:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+002ch]
      push word [bp+di+002eh]
      call csubtract
      add sp,08h
      mov [bp+di+002ch],ax
      mov [bp+di+002eh],dx
      jmp z2234
moudown:  push word [bp+di+0028h]
      pop word [bp+di+0010h]
      mov ax,[bp+di+002ch]
      mov dx,[bp+di+002eh]
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
mo59:  jmp reginkey2176
moup:  mov cx,[bp+di+00a8h]
       mov dx,[bp+di+00aah]
       push word [bp+04h]
      pop word [bp+di+00a8h]
      push word [bp+06h]
      pop word [bp+di+00aah]
      cmp cx,[bp+04h]
      jnz mo71
      cmp dx,[bp+06h]
      jnz mo71
; cx is freed dx needs to be locked
mo67:  jmp mo29
mo71:  cmp  dx,01h
      js mo67
      mov ax,[bp+di+0086h]
      cmp ax,dx
      js mo67
      mov ax,05h
      mov cx,0012h
      push cx
      push dx
      push ax
      push word [bp+0020h]
      call cvgcline
      add sp,08h
      mov cx,02h
      mov dx,05h
      push cx
      push word [bp+06h]
      push dx
      push word [bp+0020h]
      call cvgcline
      add sp,08h
      jmp reginkey2190
keyvalid2194:  and ax,00ffh
               and cx,00ffh
               and dx,00ffh
; got valid key
      mov [bp+02h],ax
      mov [bp+04h],cx
      mov [bp+06h],dx
      push word [bp+di+020h]
      push word [bp+di+022h]
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      mov [bp+0ch],ax
      mov [bp+0eh],dx
      cmp word [bp+0eh],00h
      jnz endkey2176
      mov dx,[bp+di+086h]
      cmp dx,[bp+0ch]
      jb endkey2176
      cmp word [bp+0ch],01h
      js endkey2176
      mov dx,12h
      push dx
      push word [bp+0ch]
      mov dx,05h
      push dx
      push word [bp+020h]
      call cvgcline
      add sp,08h
endkey2176:  mov dx,[bp+06h]
      mov cx,[bp+04h]
      mov ax,[bp+02h]
      cmp al,08h
      jnz z2196
      jmp z2294
z2196:  cmp al,0dh
      jz z2197
      jmp z2200
z2197:  mov ax,00h
      push ax
      push word [bp+0020h]
      call gek2040
      add sp,04h
      mov word [bp+di+08ah],01h
      mov ax,[bp+di+0092h]
      mov [bp+di+0010h],ax
      jmp reginkey2176
z2200:  cmp cx,01h
      jz z2201
      jmp z2216
z2201:  cmp ax,0020h
      jns z2202
ztny2201:  mov ax,0020h
z2202:    cmp ax,07eh
      ja ztny2201
z2203:  mov si,01h
      push si
      push ax
      push word [bp+0020h]
      call ikx1864
      add sp,06h
z2208:  push word [bp+di+014h]
      push word [bp+di+016h]
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz z2212
      mov ax,01h
      push ax
      push bx
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      call cadd
      add sp,08h
      mov [bp+di+050h],ax
      mov [bp+di+052h],dx
z2212:  cmp word [bp+di+090h],00h
      jnz z2214
      jmp reginkey2190
z2214:  jmp reginkey2176
z2216:  cmp al,050h
      jnz z2217
      jmp z2231
z2217:  cmp al,048h
      jnz z2218
      jmp z2234
z2218:  cmp al,049h
      jnz z2219
      jmp z2238
z2219:  cmp al,051h
      jnz z2220
      jmp z2242
z2220:  cmp al,04dh
      jnz z2221
      jmp z2246
z2221:  cmp al,04bh
      jnz z2222
      jmp z2252
z2222:  cmp al,04fh
      jnz z2223
      jmp z2263
z2223:  cmp al,052h
      jnz z2224
      jmp z2274
z2224:  cmp al,053h
      jnz z2226
      jmp z2290
z2226:  cmp al,047h
      jnz z2227cb
      jmp z2228
z2227cb:  cmp al,03dh
       jnz z2227
       jmp z2228
z2227: jmp reginkey2176
z2228: jmp z2298
z2231:  mov ax,01h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      jmp reginkey2176
z2234:  mov ax,01h
    push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      jmp reginkey2176
z2238:  push word [bp+di+086h]
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      push ax
      push dx
      mov ax,04h
      push ax
      push bx
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      jmp reginkey2176
z2242:  mov ax,[bp+di+086h]
      sub ax,04h
      js z2244
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
z2244:  jmp reginkey2176
z2246:  mov dx,[bp+di+010h]
      add dx,01h
      mov [bp+di+010h],dx
      mov ax,[bp+di+04ch]
      cmp ax,dx
      js z2249
      jmp reginkey2190
z2249:  mov word [bp+di+010h],0001h
      jmp z2231
z2252:  mov ax,[bp+di+010h]
      sub ax,01h
      mov [bp+di+010h],ax
      cmp ax,00h
      js z2254
      jz z2254
      jmp reginkey2190
z2254:  mov ax,02h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz z2256
      mov ax,01h
      push ax
      push bx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
z2256:  push word [bp+020h]
      call lalocal12
      add sp,02h
      mov ax,01h
      push ax
      push word [bp+020h]
      call clenval
      add sp,04h
      add ax,01h
      mov [bp+di+010h],ax
      cmp ax,[bp+di+04ch]
      js z2261
      mov ax,[bp+di+04ch]
      mov [bp+di+010h],ax
z2261:  jmp reginkey2176
z2263:  cmp word [bp+di+010h],0001h
      jz z2267
      mov word [bp+di+010h],0001h
      jmp reginkey2190
z2267:  push word [bp+di+014h]
      push word [bp+di+016h]
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz z2270
      mov ax,01h
      push ax
      push bx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      jmp reginkey2176
z2270:  mov word [bp+di+016h],0000h
      mov word [bp+di+014h],01h
      jmp reginkey2176
z2274:  mov ax,01h
      sub ax,[bp+di+08eh]
      mov [bp+di+08eh],ax
      jmp reginkey2190
z2290:  mov ax,00h
      push ax
      push word [bp+020h]
      call dkx2050
      add sp,04h
      mov word [bp+di+08ah],01h
      jmp z2212
z2294:  mov ax,06h
      or ax,0040h
      push ax
      push word [bp+0020h]
      call dkx2050
      add sp,04h
      mov word [bp+di+08ah],01h
      jmp z2212
z2298:  mov word [bp+di+00ach],0000h
       add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; outlinecopy(*xyptr,xyln,*otherptr,otherln)
; IF *xyptr == *otherptr THEN (xyln) = (otherln) lines within ss a80w% long
; unequal *otherptr points to CS: otherln ends with 024h character
; 26 otherln   24 *otherptr    22 xyln    20 *xyptr    1e retad    1c disave
; 1a sisave    18 bpsave    16 bxsave    14 dxsave    12 cxsave    10 axsave
; 0e xyaddress    0c otheraddress   0a xyrctr    08 outerctr    06
; 04 dssave       02 00
outlinecopy:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov bx,00h
      mov ax,ds
      mov [bp+04h],ax
      push word [bp+022h]
      push word [bp+020h]
      call alselset
      add sp,04h
      sub ax,bp
      mov [bp+0eh],ax
      push word [bp+022h]
      push word [bp+020h]
      call clearline
      add sp,04h
      push word [bp+026h]
      push word [bp+020h]
      call alselset
      sub ax,bp
      add sp,04h
      mov [bp+0ch],ax
      mov dx,[bp+024h]
      cmp dx,[bp+020h]
      jz copyssr
      jmp copycsr
copyssr:  mov word [bp+0ah],00h
copyssrlop:  mov dx,[bp+0ah]
      cmp dx,[bp+di+04ch]
      js copyssrlap
      jmp copyssrbot
copyssrlap:  mov si,[bp+0ah]
      add si,[bp+0ch]
      mov al,[bp+si]
      mov si,[bp+0ah]
      add si,[bp+0eh]
      mov [bp+si],al
      inc word [bp+0ah]
      jmp copyssrlop
copycsr:  mov word [bp+08h],00h
      mov si,[bp+024h]
      mov [bp+0ch],si
jcsrolop:  inc word [bp+08h]
      mov dx,[bp+08h]
      cmp dx,[bp+0026h]
      jns copycsrzur
      mov word [bp+0ah],0000h
jcsrilop:  mov si,[bp+0ch]
      inc word [bp+0ch]
      mov dx,[bp+0ah]
      cmp dx,[bp+di+04ch]
      jns jcsrolop
      inc word [bp+0ah]
      mov dx,cs
      add dx,0000h
      mov ds,dx
      nop
      cmp byte [si],024h
      jz jcsrolop
      jmp jcsrilop
copycsrzur:  mov word [bp+0ah],00h
copycsrone:  mov dx,[bp+0ah]
      cmp dx,[bp+di+04ch]
      js copycsrlbp
      jmp copyssrbot
copycsrlbp:  mov si,[bp+0ah]
      add si,[bp+0ch]
      mov ax,cs
      add ax,0000h
      mov ds,ax
      nop
      mov al,[si]
      cmp al,024h
      jz copyssrbot
      mov si,[bp+0ah]
      add si,[bp+0eh]
      mov [bp+si],al
      inc word [bp+0ah]
      jmp copycsrone
copyssrbot:  mov ax,[bp+04h]
      mov ds,ax
      add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; bscr2330 (*xyptr)
; 14 *xyptr        12 retad    10 disave    0e sisave    0c bpsave
; 0a dxsave        08 cxsave    06 axsave    04 cyp%    02    00
bscr2330:  push di
  push si
      push bp
      push dx
      push cx
      push ax
      sub sp,06h
      mov bp,sp
      mov di,[bp+014h]
      sub di,bp
      push word [bp+014h]
      call lalocal12
      add sp,02h
      mov ax,02h
      push ax
      push word [bp+014h]
      call clearline
      add sp,04h
      mov word [bp+04h],0000h
bscr2336:  add word [bp+04h],01h
      mov ax,02h
      push ax
      push word [bp+04h]
      mov ax,02h
      push ax
      push word [bp+014h]
      call cvgcline
      add sp,08h
      mov dx,[bp+04h]
      mov ax,[bp+di+086h]
      inc ax
      cmp dx,ax
      js bscr2336
      mov word [bp+di+040h],01h
      push word [bp+di+040h]
      push word [bp+014h]
      call clearline
      add sp,04h
      add sp,06h
      pop ax
      pop cx
      pop dx
      pop bp
      pop si
      pop di
      ret
; clralocal2346 (*xyptr)
; 12 *xyptr    10 retad     0e disave    0c sisave    0a bpsave
; 08 dxsave    06 cxsave    04 axsave    02 ctr       00
clralocal2346:  push di
      push si
      push bp
      push dx
      push cx
      push ax
      sub sp,04h
      mov bp,sp
      mov di,[bp+012h]
      sub di,bp
      mov word [bp+02h],00h
clralocal2348:  add word [bp+02h],01h
      push word [bp+02h]
      push word [bp+012h]
      call clearline
      add sp,04h
      mov ax,[bp+02h]
      cmp ax,[bp+di+094h]
      js clralocal2348
      add sp,04h
      pop ax
      pop cx
      pop dx
      pop bp
      pop si
      pop di
      ret
; prmenu2398  (*xyptr)
; ??    12 *xyptr    10 retad    0e disave    0c sisave    0a bpsave
; 08 dxsave    06 cxsave    04 axsave    02 counter    00
prmenu2398: push di
  push si
      push bp
      push dx
      push cx
      push ax
      sub sp,04h
      mov bp,sp
      mov di,[bp+012h]
      sub di,bp
      mov word [bp+02h],00h
      push word [bp+012h]
      call bscr2330
      add sp,0002h
prmenu2403: add word [bp+02h],01h
      push word [bp+02h]
      push word [bp+di+09ah]
      mov dx,03h
      push dx
      push word [bp+012h]
      call outlinecopy
      add sp,08h
      mov ax,02h
      push ax
      push word [bp+02h]
      mov dx,03h
      push dx
      push word [bp+012h]
      call cvgcline
      add sp,08h
      mov ax,[bp+02h]
      cmp ax,014h
      jns prmenu2414
      jmp prmenu2403
prmenu2414:  add sp,04h
      pop ax
      pop cx
      pop dx
      pop bp
      pop si
      pop di
      ret
; fntoonine(*xyptr,opensel122)
; 26 opensel122    24 *xyptr    22 retad    20 disave    1e sisave
; 1c bpsave        1a bxsave    18 dxsave   16 cxsave    14 axsave
; 12 opensel+6     10 sourceaddress    0e destinationaddress    0c length
fntoonine:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0014h
      mov bp,sp
      mov ax,[bp+0026h]
      add ax,0006h
      mov [bp+012h],ax
      push ax
      push word [bp+024h]
      call alselset
      add sp,0004h
      mov [bp+0010h],ax
      mov cx,09h
      push cx
      push word [bp+0024h]
      call alselset
      add sp,0004h
      mov [bp+000eh],ax
      push word [bp+0012h]
      push word [bp+0024h]
      call clenval
      add sp,04h
      mov [bp+0ch],ax
      cmp word [bp+0026h],0002h
      jnz fnthreenine
      cmp word [bp+000ch],0005h
       js fnthreenine
      cmp word [bp+0ch],000fh
      jns fnthreenine
      mov cx,[bp+000ch]
      mov si,[bp+0010h]
      mov di,[bp+000eh]
      sub si,bp
      sub di,bp
fntooninel:  mov dl,[bp+si]
      mov [bp+di],dl
      inc si
      inc di
      dec cx
      jnz fntooninel
      mov byte [bp+di],020h
fnthreenine:  add sp,0014h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; read2426(*xyptr,readsel12)
; returns read status in ax   ax=0 o.k.    ax<>0  bad filename
; 18 readsel12    16 *xyptr    14 retad    12 disave    10 sisave
; 0e bpsave   0c dxsave   0a cxsave   08 axsave   06 *rhanptr
; 04 albase    02 dlbase    00 *databuffer
read2426:  push di
      push si
      push bp
      push dx
      push cx
      push ax
      sub sp,08h
      mov bp,sp
      mov di,[bp+016h]
      sub di,bp
      mov word [bp+06h],0120h
      mov ax,[bp+di+0050h]
       or ax,[bp+di+0052h]
      jz readchktwo
      mov word [bp+di+008ah],0001h
readchktwo:      cmp word [bp+018h],02h
      jnz read2427
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      mov word [bp+06h],0140h
read2427:  mov ax,[bp+016h]
      add [bp+06h],ax
      mov si,[bp+06h]
      sub si,bp
      mov word [bp+si+000eh],07ffh
      cmp word [bp+018h],02h
     jnz readazza
     mov ax,08h
      push ax
      push word [bp+016h]
      call clenval
      add sp,04h
      cmp ax,00h
      jz readazza
      cmp word [bp+di+00e6h],0000h
      jnz readazza
      mov ax,[bp+di+0050h]
       or ax,[bp+di+0052h]
     jnz readazza
      push word [bp+018h]
      push word [bp+016h]
      call fntoonine
      add sp,04h
      jmp readayya
readazza:  push word [bp+018h]
      push word [bp+016h]
      call open2520
      add sp,04h
readayya:  mov ax,[bp+018h]
      mov word [bp+di+00e6h],000fh
      add ax,06h
      push ax
      push word [bp+016h]
      call alselset
      add sp,04h
      mov [bp+04h],ax
      mov ax,03h
      push ax
      push word [bp+016h]
      call alselset
      add sp,04h
      mov [bp+02h],ax
      push word [bp+di+04ch]
      push word [bp+04h]
      push word [bp+02h]
      call fncopy
      add sp,06h
      mov word [bp+08h],00h
      cmp ax,00h
      jnz readfnok
badreadfn:  mov word [bp+08h],01h
      jmp readquit2460
readfnok:  push word [bp+02h]
      mov ah,04fh
      mov al,052h
      push ax
      call io16
      add sp,02h
      add sp,02h
      mov si,[bp+06h]
      sub si,bp
      mov [bp+si+0ch],ax
      mov dx,00h
      mov [bp+si+06h],dx
      mov ax,00h
      mov [bp+si+04h],ax
      mov word [bp+si+00h],00h
      cmp cx,00h
      jnz badreadfn
      push word [bp+si+0ch]
      mov ah,046h
      mov al,04ch
      push ax
      call io16
      add sp,02h
      add sp,02h
      mov [bp+si+08h],ax
      mov [bp+si+0ah],dx
      mov word [bp+di+034h],01h
      mov ax,01h
      push ax
      push word [bp+016h]
      call alselset
      add sp,04h
      mov [bp+00h],ax
readfilelop:  cmp word [bp+di+0084h],0002h
      jz hexread24
      push word [bp+di+04ch]
      push word [bp+00h]
      push word [bp+06h]
      call reedline
      add sp,06h
      jmp testread24
hexread24:  push word [bp+06h]
            push word [bp+016h]
            call hexoline
            add sp,0004h
testread24:      test dx,04h
      jnz read2429
      test dx,08h
      jz read2429
      mov word [bp+0018h],0000h
      jmp read2429
cpclose2428:  push word [bp+si+0ch]
      mov ah,043h
      mov al,052h
      push ax
      call io16
      add sp,02h
      add sp,02h
      mov word [bp+di+010h],01h
      cmp word [bp+di+0084h],0000h
      jz readquit2460
      mov ax,0008h
      push ax
      push word [bp+0016h]
      call clearline
      add sp,0004h
      jmp readquit2460
read2429:   push word [bp+016h]
      call acinsertb
      add sp,02h
      cmp word [bp+di+004ah],0000h
      jnz cpclose2428
      cmp word [bp+0018h],0000h
      jz cpclose2428
      jmp readfilelop
readquit2460: mov word [bp+di+0084h],0000h
      add sp,08h
      pop ax
      pop cx
      pop dx
      pop bp
      pop si
      pop di
      ret
; clrprn2462(*xyptr,line)
; 16 line    14 *xyptr    12 retad    10 disave    0e sisave    0c bpsave
; 0a dxsave    08 cxsave    06 axsave    04    02    00
clrprn2462:  push di
      push si
      push bp
      push dx
      push cx
      push ax
      sub sp,06h
      mov bp,sp
      mov di,[bp+014h]
      sub di,bp
      push word [bp+014h]
      call bscr2330
      add sp,02h
      mov ax,[bp+016h]
      sub ax,08h
      push ax
      push word [bp+di+09ah]
      mov ax,03h
      push ax
      push word [bp+014h]
      call outlinecopy
      add sp,08h
      mov dx,02h
      push dx
      mov ax,01h
      and ax,[bp+016h]
      add ax,03h
      push ax
      mov dx,03h
      push dx
      push word [bp+014h]
      call cvgcline
      add sp,08h
      add sp,06h
      pop ax
      pop cx
      pop dx
      pop bp
      pop si
      pop di
      ret
; write2470(*xyptr,file2)
; 1a file2    18 *xyptr    16 retad    14 disave    12 sisave    10 bpsave
; 0e bxsave    0c dxsave    0a cxsave    08 axsave    06 *writeln
; 04 *doswritechr    02 ctrH    00 ctrL
write2470:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,08h
      mov bp,sp
      mov di,[bp+018h]
      mov si,di
      sub di,bp
      add si,0140h
      sub si,bp
      mov word [bp+si+0ch],04h
      lea ax,[bp+si+0eh]
      mov word [bp+04h],ax
      mov dx,03h
      push dx
      push word [bp+018h]
      call alselset
      add sp,04h
      mov [bp+06h],ax
      mov word [bp+02h],00h
      mov word [bp+00h],00h
      cmp word [bp+01ah],02h
      jz arite2471
      jmp skipwritedop
arite2471:      mov ax,[bp+di+050h]
      or ax,[bp+di+052h]
      jnz unskipwrited
      jmp write2517
badwritefn:  jmp write2516
unskipwrited:  mov ax,02h
      push ax
      push word [bp+018h]
      call open2520
      add sp,04h
;  WAS wrong location for writefn length check
unskipwritec:  mov ax,08h
    push ax
    push word [bp+018h]
    call clenval
    add sp,04h
    cmp ax,00h
    jnz unskipwritef
; moved writefn length check
    jmp write2517
unskipwritef:  mov ax,04h
      push ax
      push word [bp+018h]
      call alselset
      add sp,04h
      mov bx,ax
      mov dx,08h
      push dx
      push word [bp+018h]
      call alselset
      add sp,04h
      push word [bp+di+04ch]
      push ax
      push bx
      call fncopy
      add sp,06h
      push bx
      mov ah,04fh
      mov al,057h
      push ax
      call io16
      add sp,02h
      add sp,02h
      test cx,08h
      jnz badwritefn
      mov [bp+si+0ch],ax
skipwritedop:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+00h]
      push word [bp+02h]
      call cadd
      add sp,08h
      mov [bp+00h],ax
      mov [bp+02h],dx
      push ax
      push dx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz write2476
      jmp write2514
write2476:  mov ax,[bp+00h]
      mov dx,[bp+02h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      mov ax,03h
      push ax
      push word [bp+018h]
      call slateacread
      add sp,04h
      push word [bp+di+04ch]
      push word [bp+04h]
      push word [bp+si+0ch]
      push word [bp+06h]
      call printfi
      add sp,08h
      jmp skipwritedop
write2514:  mov word [bp+di+010h],01h
      cmp word [bp+01ah],02h
      jnz write2517
write2516:  push word [bp+si+0ch]
      mov ah,043h
      mov al,057h
      push ax
      call io16
      add sp,02h
      add sp,02h
      mov word [bp+di+08ah],00h
write2517:  add sp,08h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; open2520(*xyptr,opensel)
; opensel=0 find           1 tempfilename     2 permfilename
; 22 opensel    20 *xyptr    1e retad    1c disave    1a sisave    18 bpsave
; 16 bxsave    14 dxsave    12 cxsave    10 axsave    0e lval%
; 0c oyp%    0a keyd    08 keyc    06 keya    04    02    00
open2520:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov word [bp+di+08eh],01h
      mov ax,[bp+022h]
      add ax,06h
      mov [bp+di+040h],ax
      mov dx,01h
      cmp dx,[bp+022h]
      js z2526
      push word [bp+di+040h]
      push word [bp+020h]
      call clearline
      add sp,04h
z2526:    push word [bp+di+040h]
      push word [bp+020h]
      call clenval
      add sp,04h
      mov [bp+0eh],ax
      mov dx,01h
      add dx,[bp+0eh]
      mov [bp+di+010h],dx
z2530:  mov word [bp+0ch],0ah
      mov ax,02h
      push ax
      push word [bp+0ch]
      push word [bp+di+040h]
      push word [bp+020h]
      call cvgcline
      add sp,08h
z2532:  mov si,00h
      push si
      mov ah,04bh
      mov al,059h
      push ax
      call io16
      add sp,02h
      add sp,02h
      jcxz z2532
      mov [bp+0ah],dx
      mov [bp+08h],cx
      mov [bp+06h],ax
      mov dx,[bp+022h]
      add dx,06h
      mov [bp+di+040h],dx
      push word [bp+di+040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+di+096h],ax
      cmp byte [bp+06h],0dh
      jnz z2536
      jmp z2584
z2536:  cmp byte [bp+06h],08h
      jnz z2537
      jmp z2546
z2537:  cmp byte [bp+08h],01h
      jz z2538
      jmp z2564
z2538:  cmp word [bp+022h],01h
      js z2543
z2542:  mov dx,[bp+0ah]
      mov [bp+06h],dx
z2543:  mov ax,[bp+di+04ch]
      cmp ax,[bp+di+010h]
      js z2545
      push word [bp+di+040h]
      push word [bp+06h]
      pop word [bp+di+00dah]
      push word [bp+06h]
      push word [bp+020h]
      call ikx1864
      add sp,06h
z2545:  jmp z2548
z2546:  cmp word [bp+di+010h],02h
      js z2548
      mov ax,058h
      push ax
      push word [bp+020h]
      call dkx2050
      add sp,04h
z2548:  mov ax,02h
      push ax
      push word [bp+0ch]
      push word [bp+di+040h]
      push word [bp+020h]
      call cvgcline
      add sp,08h
      jmp z2530
z2560:  mov ax,054h
      push ax
      push word [bp+020h]
      call dkx2050
      add sp,04h
      jmp z2548
z2564:  cmp byte [bp+0ah],053h
      jz z2560
      cmp byte [bp+0ah],04dh
      jz z2574
      cmp byte [bp+0ah],04bh
      jz z2580
      cmp byte [bp+0ah],04fh
      jnz z2570
      mov word [bp+di+010h],0001h
      jmp z2548
z2570:  cmp byte [bp+0ah],052h
      jz z2577
      jmp z2548
z2574:  add word [bp+di+010h],01h
      mov ax,[bp+di+04ch]
      cmp ax,[bp+di+010h]
      jns z2576
      mov [bp+di+010h],ax
z2576:  jmp z2548
z2577:  mov ax,01h
      sub ax,[bp+di+08eh]
      mov [bp+di+08eh],ax
      jmp z2548
z2580:  sub word [bp+di+010h],01h
      cmp word [bp+di+010h],01h
      jns z2582
      mov word [bp+di+010h],01h
z2582:  jmp z2548
z2584:  mov dx,[bp+022h]
      add dx,06h
      mov [bp+di+040h],dx
      push word [bp+di+040h]
      push word [bp+020h]
      call clenval
      add sp,04h
      mov word [bp+di+098h],ax
      push word [bp+0022h]
      push word [bp+0020h]
      call fntoonine
      add sp,0004h
; before z2600 copy filename to home gets menu   z2585
z2600:  mov di,[bp+020h]
        sub di,bp
         mov word [bp+di+010h],01h
      add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; new2608(*xyptr,new2)
; 16 new2    14 *xyptr    12 retad    10 disave    0e sisave    0c bpsave
; 0a dxsave    08 cxsave    06 axsave    04    02    00
new2608:  push di
  push si
      push bp
      push dx
      push cx
      push ax
      sub sp,06h
      mov bp,sp
      mov di,[bp+014h]
      sub di,bp
; skip 054 numberofsegments            058 limit
      mov si,di
      mov cx,02ah
newchero:  mov word [bp+si],00h
      inc si
      inc si
      dec cx
      jnz newchero
       add si,08h
      mov cx,052h
newcherd:  mov word [bp+si],00h
      inc si
      inc si
      dec cx
      jnz newcherd
      mov word [bp+di+03ch],0ffffh
      mov word [bp+di+03eh],0ffffh
      mov word [bp+di+05ch],0ffffh
      mov word [bp+di+05eh],0ffffh
      mov word [bp+di+00feh],03700h
; 00feh is offset of first local data segment within ss
; decide width 004ch={50,a0}
          cmp word [bp+016h],02h
      jz new2612
      mov word [bp+di+04ch],050h
      mov word [bp+di+086h],018h
      jmp z2614
new2612:  mov word [bp+di+04ch],04eh
;                          02.52
      add word [bp+di+04ch],0002h
      mov word [bp+di+086h],018h
z2614:  mov word [bp+di+04eh],00h
      mov word [bp+di+050h],00h
      mov word [bp+di+0b0h],01h
      mov word [bp+di+0e0h],01h
      mov word [bp+di+010h],01h
      mov word [bp+di+0092h],0001h
      mov word [bp+di+00ech],0000h
      mov word [bp+di+014h],01h
z2620:  mov word [bp+di+08ah],00h
      mov word [bp+di+0d4h],01h
      mov word [bp+di+0a4h],01h
      mov word [bp+di+08eh],01h
      mov word [bp+di+0d8h],020h
      mov word [bp+di+094h],024h
; begin initializing strings
      mov ax,ss
      add ax,01002h
      mov [bp+di+0100h],ax
      mov word [bp+di+0102h],0000h
      mov word [bp+di+0110h],0000h
      mov word [bp+di+0112h],0000h
      mov word [bp+di+0114h],0000h
      mov word [bp+di+0116h],0000h
      mov si,0002h
      mov dx,cs
      mov ds,dx
      mov dx,[si]
      mov [bp+di+011ah],dx
; bottom of initialize strings
      mov ax,[bp+014h]
      mov [bp+di+080h],ax
      add word [bp+di+080h],02d60h
      lea dx,[plate025]
      mov [bp+di+09ah],dx
      mov si,[bp+di+0080h]
       sub si,bp
z2636: push word [bp+014h]
      call clralocal2346
      add sp,02h
; moved to alternate place         16  ur
  mov ax,0009h
      push ax
      push word [bp+014h]
      call clearline
      add sp,04h
  lea dx,[homegetline]
      mov ax,01h
      mov si,09h
      push ax
      push dx
      push si
      push word [bp+0014h]
      call outlinecopy
      add sp,08h
;  end of movable block             lr
      mov ax,08h
      push ax
      push word [bp+014h]
      call clearline
      add sp,04h
z2638:  add sp,06h
      pop ax
      pop cx
      pop dx
      pop bp
      pop si
      pop di
      ret
; findone2822(*xyptr)
; check line at y& and compare with local 6 from opensel=0
; returns ax=0 if equal          1 if not equal or line too short
; 20 *xyptr    1e retad    1c disave    1a sisave    18 bpsave
; 16 bxsave    14 dxsave    12 cxsave    10 axsave or findeq% 0 if equal
; 0e albase%    0c findctr%    0a lval%    08 find902ugr     06  04  02  00
findone2822:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov word [bp+0008h],0000h
uz2827b:  mov word [bp+010h],0000h
      mov word [bp+di+040h],0001h
      push word [bp+di+040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+0eh],ax
      mov dx,[bp+di+016h]
      mov ax,[bp+di+014h]
      mov [bp+di+046h],dx
      mov [bp+di+044h],ax
      push word [bp+di+0040h]
      push word [bp+0020h]
      call slateacread
      add sp,04h
      push word [bp+di+040h]
      push word [bp+020h]
      call clenval
      add sp,04h
      mov word [bp+0ah],ax
      cmp word [bp+di+098h],01h
      js uz2838
      push word [bp+di+014h]
      push word [bp+di+016h]
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz uz2838
      mov ax,[bp+0ah]
      sub ax,[bp+0008h]
      cmp al,[bp+di+098h]
      js uz2838
      jmp uz2840
uz2838:  mov word [bp+010h],01h
      jmp uz2856
uz2840:  mov word [bp+0ch],00h
uz2842:  mov si,[bp+di+096h]
      add si,[bp+0ch]
      sub si,bp
      mov dl,[bp+si]
      cmp dl,020h
      jz uz2853
      mov si,[bp+0eh]
      add si,[bp+0ch]
      add si,[bp+0008h]
      sub si,bp
      cmp dl,[bp+si]
      jnz uz2838
uz2853:  add word [bp+0ch],01h
      mov dx,[bp+0ch]
      cmp dx,[bp+di+098h]
      js uz2842
uz2856:  cmp word [bp+010h],0000h
      jz uzr2858
      test word [bp+di+00dah],005fh
      jnz uzr2858
      inc word [bp+08h]
      mov cx,[bp+08h]
      cmp cx,[bp+di+004ch]
      jns uzr2858
      jmp uz2827b
uzr2858:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; sandoval 4305
; john2880(*xyptr)
; animation with just one line
; 20 *xyptr    1e retad    1c disave    1a sisave    18 bpsave    16 bxsave
; 14 dxsave    12 cxsave    10 axsave    0e albase    0c jxctr    0a
; 08     06    04    02
john2880: push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov word [bp+di+040h],06h
      push word [bp+di+040h]
      push word [bp+020h]
      call clearline
      add sp,0004h
      push word [bp+di+040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      mov word [bp+di+096h],ax
      mov word [bp+di+040h],01h
      push word [bp+di+040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      mov word [bp+0eh],ax
      push word [bp+di+040h]
      push word [bp+020h]
      call clearline
      add sp,04h
      mov ax,[bp+di+0b4h]
      mov dx,[bp+di+0b6h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      push word [bp+di+040h]
      push word [bp+020h]
      call slateacread
      add sp,04h
      mov word [bp+0ch],00h
uz2894:  mov si,[bp+0eh]
      add si,[bp+0ch]
      add si,[bp+di+0d4h]
      sub si,01h
      sub si,bp
      mov dl,[bp+si]
      mov si,[bp+di+096h]
      add si,[bp+0ch]
      sub si,bp
      mov [bp+si],dl
      add word [bp+0ch],01h
      mov ax,[bp+0ch]
      cmp ax,[bp+di+0dch]
      js uz2894
      push word [bp+di+040h]
      push word [bp+020h]
      call clearline
      add sp,04h
      push word [bp+di+0cch]
      push word [bp+di+0ceh]
      push word [bp+di+0f0h]
      push word [bp+di+0f2h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz uz2914
      mov ax,[bp+di+0cch]
      mov dx,[bp+di+0ceh]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      push word [bp+di+040h]
      push word [bp+020h]
      call slateacread
      add sp,04h
      jmp uz2916
uz2914:  push word [bp+di+050h]
      push word [bp+di+052h]
      push word [bp+di+0cch]
      push word [bp+di+0ceh]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz uz2916
      mov ax,[bp+di+0cch]
      mov dx,[bp+di+0ceh]
      mov [bp+di+050h],ax
      mov [bp+di+052h],dx
uz2916:  mov word [bp+0ch],0000h
uz2918:  mov si,[bp+di+096h]
      add si,[bp+0ch]
      sub si,bp
      mov dl,[bp+si]
      mov si,[bp+0eh]
      add si,[bp+0ch]
      add si,[bp+di+0e8h]
      sub si,bp
      sub si,01h
      mov [bp+si],dl
      add word [bp+0ch],01h
      mov ax,[bp+0ch]
      cmp ax,[bp+di+0dch]
      js uz2918
      mov ax,[bp+di+0cch]
      mov dx,[bp+di+0ceh]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      push word [bp+di+040h]
      push word [bp+020h]
      call slateacwrite
      add sp,04h
john4724:   add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; john2938(*xyptr)
; copy animation rectangle
; 20 *xyptr    1e retad    1c disave    1a sisave    18 bpsave   16 bxsave
; 14 dxsave    12 cxsave    10 axsave   0e jynextH    0c jynextL
; 0a yjnH    08 yjnL    06 jyctrH    04 jyctrL    02   00
john2938:   push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov ax,00h
      add ax,[bp+di+0d0h]
      sub ax,[bp+di+0d4h]
      mov [bp+di+0dch],ax
      mov ax,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+0c8h],ax
      mov [bp+di+0cah],dx
      push word [bp+di+0a4h]
      push word [bp+di+0a6h]
      push word [bp+di+0a0h]
      push word [bp+di+0a2h]
      call csubtract
      add sp,08h
      mov [bp+di+0bch],ax
      mov [bp+di+0beh],dx
      push ax
      push dx
      push word [bp+di+0c8h]
      push word [bp+di+0cah]
      call cadd
      add sp,08h
      mov [bp+0ch],ax
      mov [bp+0eh],dx
      push word [bp+di+0a4h]
      push word [bp+di+0a6h]
      push word [bp+di+0c8h]
      push word [bp+di+0cah]
      call csubtract
      add sp,08h
      mov [bp+di+0c4h],ax
      mov [bp+di+0c6h],dx
      mov ax,[bp+di+050h]
      mov dx,[bp+di+052h]
      mov [bp+di+0f0h],ax
      mov [bp+di+0f2h],dx
      mov ax,[bp+di+010h]
      mov [bp+di+0e8h],ax
      mov dx,[bp+di+0e8h]
      sub dx,[bp+di+0d4h]
      mov [bp+di+0e4h],dx
      cmp word [bp+di+0dch],00h
      jns uz2952
      jmp uz2984
uz2952:  mov ax,04000h
      add ax,ax
      and ax,[bp+di+0beh]
      jz uz2953
      jmp uz2984
uz2953:  add word [bp+di+0dch],01h
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0bch]
      push word [bp+di+0beh]
      call cadd
      add sp,08h
      mov [bp+di+0bch],ax
      mov [bp+di+0beh],dx
      mov ax,04000h
      add ax,ax
      and ax,[bp+di+0c6h]
      js uz2972
      mov ax,[bp+di+0a0h]
      mov dx,[bp+di+0a2h]
      mov [bp+di+0b4h],ax
      mov [bp+di+0b6h],dx
      mov word [bp+08h],0ffffh
      mov word [bp+0ah],0ffffh
      mov ax,[bp+0ch]
      mov dx,[bp+0eh]
      mov [bp+di+0cch],ax
      mov [bp+di+0ceh],dx
      jmp uz2976
uz2972:  mov ax,[bp+di+0a4h]
      mov dx,[bp+di+0a6h]
      mov [bp+di+0b4h],ax
      mov [bp+di+0b6h],dx
      mov word [bp+08h],0001h
      mov word [bp+0ah],0000h
      mov ax,[bp+di+0c8h]
      mov dx,[bp+di+0cah]
      mov [bp+di+0cch],ax
      mov [bp+di+0ceh],dx
uz2976:  mov word [bp+04h],00h
      mov word [bp+06h],00h
uz2977:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+04h]
      push word [bp+06h]
      call cadd
      add sp,08h
      mov [bp+04h],ax
      mov [bp+06h],dx
      push word [bp+020h]
      call john2880
      add sp,02h
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+di+0b4h]
      push word [bp+di+0b6h]
      call cadd
      add sp,08h
      mov [bp+di+0b4h],ax
      mov [bp+di+0b6h],dx
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+di+0cch]
      push word [bp+di+0ceh]
      call cadd
      add sp,08h
      mov word [bp+di+0cch],ax
      mov word [bp+di+0ceh],dx
      push word [bp+di+0bch]
      push word [bp+di+0beh]
      push word [bp+04h]
      push word [bp+06h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz uz2984
      jmp uz2977
uz2984:  add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; 05 23 2001  end of subroutine list provided by rdosio.txt
; 06 25 2001  begin subroutines for command line input mode
; cpr11(*xyptr) with cursor                qpr11(*xyptr) without cursor
;  08 *xyptr    06 retad    04 disave    02 sisave     00 bpsave
cpr11:  push di
      push si
      push bp
      mov bp,sp
      mov di,[bp+08h]
      sub di,bp
      mov si,0002h
      jmp cmcpr11
qpr11:  push di
      push si
      push bp
      mov bp,sp
      mov di,[bp+08h]
      sub di,bp
      mov si,0012h
cmcpr11:   push si
      mov si,[bp+di+0086h]
      inc si
      push si
      mov si,0bh
      push si
      push word [bp+08h]
      call cvgcline
      add sp,08h
      pop bp
      pop si
      pop di
      ret
;  tra11to55(*xyptr)
;  20 *xyptr    1e retad    1c disave    1a sisave    18 bpsave
;  16 bxsave    14 dxsave   12 cxsave    10 axsave     0e
;   0c ctr      0a    08    06    04    02    00
tra11to55:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+0020h]
      mov word [bp+0ch],036h
tra11tolop:  cmp word [bp+0ch],0bh
      js tra11tobot
      push word [bp+0ch]
      push word [bp+020h]
      mov ax,[bp+0ch]
      add ax,01h
      push ax
      push word [bp+020h]
      call outlinecopy
      add sp,08h
      dec word [bp+0ch]
      jmp tra11tolop
tra11tobot:     mov ax,0bh
      push ax
      push word [bp+020h]
      call clearline
      add sp,04h
      add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
;pr1155(*xyptr)
;  20 *xyptr    1e retad    1c disave    1a sisave    18 bpsave
;  16 bxsave    14 dxsave   12 cxsave    10 axsave     0e
;   0c        0a upctr (11 to 55)      08      06 downctr (down to 1 )
;   04    02 cst11       00
pr1155:  push di
     push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov ax,[bp+di+086h]
      add ax,01h
      mov [bp+06h],ax
      mov word [bp+0ah],0bh
      mov word [bp+02h],011h
pr1156lop:    cmp word  [bp+0ah],038h
      jns pr1180
      cmp word [bp+06h],01h
      js  pr1180
      push word [bp+02h]
      push word [bp+06h]
      push word [bp+0ah]
      push word [bp+020h]
      call cvgcline
      add sp,08h
      inc word [bp+0ah]
      dec word [bp+06h]
      jmp pr1156lop
pr1180:  add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; ron2640(*xyptr,rv)
; 22 rv       20 *xyptr   1e retad   1c disave   1a sisave   18 bpsave
; 16 bxsave   14 dxsave   12 cxsave   10 axsave   0e ronctr   0c opensel%
; 0a flponeH   08 flponeL   06 tzrx%  or nexYH  04 xxjctr% or nexYL
; 02 xxjsub%  00 albase%
ron2640:  push di
  push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov bx,00h
      mov cx,01h
      mov dx,[bp+022h]
      and dx,07fh
      mov ax,dx
      mov word [bp+di+020h],00h
      mov word [bp+di+022h],00h
      jmp zrv2652
z2640:  jmp z2648
z2642:  push word [bp+020h]
      call bscr2330
      add sp,02h
      mov ax,[bp+di+0e0h]
      mov dx,[bp+di+0e2h]
      mov [bp+di+010h],ax
      mov [bp+di+012h],dx
      mov ax,[bp+di+0b0h]
      mov dx,[bp+di+0b2h]
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      push word [bp+020h]
      call regkey2176
      add sp,02h
      mov ax,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+0b0h],ax
      mov [bp+di+0b2h],dx
      mov ax,[bp+di+010h]
      mov dx,[bp+di+012h]
      mov [bp+di+0e0h],ax
      mov [bp+di+0e2h],dx
z2648:  push word [bp+020h]
      call prmenu2398
      add sp,02h
      test word [bp+di+04ah],0fffh
      jz z2650
      jmp z3098
; rem forgot error checking in swap file routines
z2650:  mov ax,00h
      push ax
      mov ah,04bh
      mov al,059h
      push ax
      call io16
      add sp,02h
      add sp,02h
      jcxz z2650
zrv2652:      cmp al,0dh
      jnz zfix2653
      jmp z2642
zfix2653:   cmp cx,0001h
         jz  z2655
         jmp z2642
z2655:  cmp al,01bh
      jnz z2662
      jmp z2800
z2662:  cmp dl,052h
      jnz zabc2663x
      jmp z2642
zabc2663x:  cmp dl,058h
            jnz z2664
            cmp word [bp+di+0092h],0001h
            jz  za2663atone
            mov word [bp+di+0092h],0001h
            jmp z2642
za2663atone:   mov word [bp+di+0092h],0007h
               jmp z2642
z2664:  cmp dl,04eh
      jnz z2678
bqz2674:  mov si,0000h
      push si
      push word [bp+020h]
      call new2608
      add sp,04h
      push word [bp+020h]
      call bscr2330
      add sp,02h
      jmp z2642
z2678:    cmp dl,059h
      jz y3101fix
z3099fix:  jmp z2680
y3101fix:  mov word [bp+0ch],00h
           mov ax,022h
           push ax
      push word [bp+0020h]
      call clrprn2462
            add sp,0004h
      push word [bp+0ch]
      push word [bp+020h]
      call open2520
      add sp,04h
      cmp word [bp+di+098h],01h
      js z3099fix
      mov ax,0ah
      push ax
      push word [bp+di+098h]
      mov dx,01h
      push dx
      mov ax,06h
      push ax
      push word [bp+020h]
      call numberget
      add sp,0ah
      mov [bp+04h],ax
      mov [bp+06h],dx
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+04h]
      push word [bp+06h]
      call csubtract
      add sp,08h
      test cx,0ch
      jz y3102fix
      mov word [bp+06h],00h
      mov word [bp+04h],01h
y3102fix: push word [bp+04h]
      push word [bp+06h]
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,08h
      test cx,0ch
      jz y3103fix
      push word [bp+di+050h]
      push word [bp+di+052h]
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      call cadd
      add sp,08h
      mov [bp+04h],ax
      mov [bp+06h],dx
y3103fix:  mov ax,[bp+04h]
      mov dx,[bp+06h]
      mov [bp+di+0b0h],ax
      mov [bp+di+0b2h],dx
      jmp z2642
z2680:  cmp dl,04fh
      jnz z2682
      jmp z2733
z2682:  cmp dl,04ch
      jnz z2684
      jmp z2736
z2684:  cmp dl,041h
      jnz z2686
      jmp z2776
z2686:  cmp dl,045h
      jnz z2688
      jmp z2782
z2688:  cmp dl,051h
      jnz z2690
      jmp z2800
z2690:  cmp dl,046h
      jnz z2692
      jmp z2804
z2692:  cmp dl,047h
       jnz z2694
      jmp z2814
z2694:  cmp dl,043h
       jz zwt2694
      jmp zt2695
commandnew:  mov si,00h
             push si
             push word [bp+0020h]
             call new2608
             add sp,04h
zwt2694:      mov si,0ah
zclr2694:  inc si
           cmp si,038h
           jns comm2694
      push si
      push word [bp+0020h]
      call clearline
      add sp,04h
      jmp zclr2694
comm2694:      jmp commandstart
zt2695:  cmp dl,050h
       jnz z2696
       jmp z2988
z2696:  cmp dl,04dh
      jnz z2698
      jmp z3000
z2698:  cmp dl,054h
      jnz z2700
      jmp z2708
z2700:  cmp dl,042h
      jnz z2702
      jmp z2714
z2702:  cmp dl,056h
      jnz z2703
;      jmp z2703 change to v
z2703:  cmp dl,044h
      jnz z2703a
      jmp z2720
z2703a  cmp dl,04ah
      jnz z2704b
      mov dx,0001h
      sub dx,[bp+di+00aeh]
      mov [bp+di+00aeh],dx
      jmp z2642
z2704b  cmp dl,055h
      jnz z2704
      mov dx,0061h
      sub dx,[bp+di+00ech]
      mov [bp+di+00ech],dx
      jmp z2642
z2704:  cmp dl,049h
      jnz z2705
      jmp z2860
z2705:  cmp dl,048h
      jnz y2706
      jmp z3054
y2706:  cmp dl,05ah
        jnz z2706
        cmp word [bp+di+008ah],0000h
        jz z2706
        jmp z2648
z2706:  jmp z2642
z2708:  mov dx,00h
      mov ax,01h
      mov [bp+di+0b2h],dx
      mov [bp+di+0b0h],ax
      mov [bp+di+0e2h],dx
      mov [bp+di+0e0h],ax
      jmp z2642
z2714:    mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call cadd
      add sp,08h
      mov [bp+di+0b0h],ax
      mov [bp+di+0b2h],dx
      mov word [bp+di+0e0h],01h
      mov word [bp+di+0e2h],00h
      jmp z2642
z2720:  mov word [bp+di+0d8h],020h
      mov dx,021h
      push dx
      push word [bp+020h]
      call clrprn2462
      add sp,04h
z2727:  mov ax,00h
      push ax
      mov ah,04bh
      mov al,059h
      push ax
      call io16
      add sp,02h
      add sp,02h
      jcxz z2727
      mov [bp+di+0d8h],dl
      jmp z2642
z2733:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      mov word [bp+0ch],02h
       mov ax,08h
       push ax
       push word [bp+020h]
       call clenval
       add sp,04h
       cmp ax,00h
       jz z2737
       cmp word [bp+di+00e6h],0000h
       jnz z2737
       mov ax,[bp+di+052h]
         or ax,[bp+di+050h]
         jz zre2738
      jmp z2737
z2736:  mov word [bp+0ch],01h
z2737:  mov ax,01dh
      push ax
      push word [bp+020h]
      call clrprn2462
      add sp,04h
zre2738:   push word [bp+0ch]
      push word [bp+020h]
      call read2426
      add sp,04h
      cmp ax,00h
      jz z2744
      jmp z2640
z2744:  mov ax,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+0b0h],ax
      mov [bp+di+0b2h],dx
      jmp z2642
z2776:  mov word [bp+0ch],02h
      mov dx,01eh
      push dx
      push word [bp+020h]
      call clrprn2462
      add sp,04h
      push word [bp+0ch]
      push word [bp+020h]
      call write2470
      add sp,04h
      jmp z2642
z2782:  cmp word [bp+di+08ah],00h
      jnz z2784
      jmp z2800
z2784:  mov dx,020h
      push dx
      push word [bp+020h]
      call clrprn2462
      add sp,04h
z2792:  mov dx,00h
      push dx
      mov ah,04bh
      mov al,059h
      push ax
      call io16
      add sp,02h
      add sp,02h
      jcxz z2792
      cmp dl,04eh
      jnz z2795
      jmp z2800
z2795:  cmp dl,059h
      jz z2797
      jmp z2640
z2797:  mov word [bp+0ch],02h
       mov dx,01eh
      push dx
      push word [bp+020h]
      call clrprn2462
      add sp,04h
      push word [bp+0ch]
      push word [bp+020h]
      call write2470
      add sp,04h
z2800:  jmp z3098
z2804:  mov ax,[bp+di+0e0h]
      mov dx,[bp+di+0e2h]
      mov [bp+di+0d4h],ax
      mov [bp+di+0d6h],dx
      mov ax,[bp+di+0b0h]
      mov dx,[bp+di+0b2h]
      mov [bp+di+0a4h],ax
      mov [bp+di+0a6h],dx
      jmp z2642
z2814:  mov ax,[bp+di+0e0h]
      mov dx,[bp+di+0e2h]
      mov [bp+di+0d0h],ax
      mov [bp+di+0d2h],dx
      mov ax,[bp+di+0b0h]
      mov dx,[bp+di+0b2h]
      mov [bp+di+0a0h],ax
      mov [bp+di+0a2h],dx
      jmp z2642
z2860:  mov ax,01fh
      push ax
      push word [bp+020h]
      call clrprn2462
      add sp,04h
      mov word [bp+0ch],00h
      push word [bp+0ch]
      push word [bp+020h]
      call open2520
      add sp,04h
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call cadd
      add sp,08h
      mov [bp+08h],ax
      mov [bp+0ah],dx
z2868:  push word [bp+020h]
      call findone2822
      add sp,02h
      cmp ax,00h
      jnz z2872
      jmp z2878
z2872:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call cadd
      add sp,08h
      mov [bp+di+0b0h],ax
      mov [bp+di+0b2h],dx
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+di+014h]
      push word [bp+di+016h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz z2876
      jmp z2868
z2876:  jmp z2648
z2878:  jmp z2642
z2988:  push word [bp+020h]
      call john2938
      add sp,02h
z2990:  mov ax,[bp+di+0e8h]
      mov dx,[bp+di+0eah]
      mov [bp+di+0d4h],ax
      mov [bp+di+0d6h],dx
      mov ax,[bp+di+0c8h]
      mov dx,[bp+di+0cah]
      mov [bp+di+0a4h],ax
      mov [bp+di+0a6h],dx
      push word [bp+di+0c4h]
      push word [bp+di+0c6h]
      push word [bp+di+0a0h]
      push word [bp+di+0a2h]
      call cadd
      add sp,08h
      mov [bp+di+0a0h],ax
      mov [bp+di+0a2h],dx
      mov ax,[bp+di+0e4h]
      add [bp+di+0d0h],ax
      mov word [bp+di+08ah],01h
      jmp z2642
z3000:  push word [bp+020h]
      call john2938
      add sp,02h
      mov word [bp+di+08ah],01h
      cmp word [bp+di+0dch],01h
      jns z3003
      jmp z2642
z3003:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0bch]
      push word [bp+di+0beh]
      call csubtract
      add sp,08h
      test cx,000ch
      jz z3004
      jmp z2642
z3004:  mov ax,[bp+di+0d4h]
      cmp ax,[bp+di+0e8h]
      jnz z3008
      push word [bp+di+0a4h]
      push word [bp+di+0a6h]
      push word [bp+di+0c8h]
      push word [bp+di+0cah]
      call csubtract
      add sp,08h
      test cx,000eh
      jnz z3008
      jmp z2642
z3008:  mov ax,[bp+di+0e4h]
      add ax,[bp+di+0d0h]
      mov [bp+06h],ax
      push word [bp+di+0c4h]
      push word [bp+di+0c6h]
      push word [bp+di+0a0h]
      push word [bp+di+0a2h]
      call cadd
      add sp,08h
      mov [bp+di+0b8h],ax
      mov [bp+di+0bah],dx
      mov ax,[bp+di+0a4h]
      mov dx,[bp+di+0a6h]
      mov [bp+di+0c0h],ax
      mov [bp+di+0c2h],dx
z3020:  mov ax,[bp+di+0d4h]
      mov [bp+04h],ax
      mov word [bp+di+040h],01h
      push word [bp+di+040h]
      mov ax,[bp+di+0c0h]
      mov dx,[bp+di+0c2h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      push word [bp+020h]
      call slateacread
      add sp,04h
      push word [bp+di+040h]
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+00h],ax
z3028:  mov dx,[bp+04h]
      add dx,[bp+00h]
      sub dx,01h
      sub dx,bp
      mov [bp+02h],dx
      mov ax,[bp+04h]
      cmp ax,[bp+di+0e8h]
      jns z3032
      jmp z3040
z3032:  mov ax,[bp+06h]
      cmp ax,[bp+04h]
      jns z3034
      jmp z3040
z3034:  push word [bp+di+0c8h]
      push word [bp+di+0cah]
      push word [bp+di+0c0h]
      push word [bp+di+0c2h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz z3036
      jmp z3040
z3036:  push word [bp+di+0c0h]
      push word [bp+di+0c2h]
      push word [bp+di+0b8h]
      push word [bp+di+0bah]
      call csubtract
      add sp,08h
      test cx,0ch
      jz z3042
z3040:  mov si,[bp+02h]
      mov ax,[bp+di+0d8h]
      mov [bp+si],al
z3042:  add word [bp+04h],01h
      push word [bp+di+040h]
      push word [bp+020h]
      call slateacwrite
      add sp,04h
      mov ax,[bp+04h]
      mov dx,[bp+di+0d0h]
      add dx,01h
      cmp ax,dx
      jns z3047
      jmp z3028
z3047:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0c0h]
      push word [bp+di+0c2h]
      call cadd
      add sp,08h
      mov [bp+di+0c0h],ax
      mov [bp+di+0c2h],dx
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0a0h]
      push word [bp+di+0a2h]
      call cadd
      add sp,08h
      push ax
      push dx
      push word [bp+di+0c0h]
      push word [bp+di+0c2h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz z3050
      jmp z3020
z3050:  jmp z2990
z3054:  mov ax,[bp+di+0b0h]
      mov dx,[bp+di+0b2h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      mov word [bp+di+040h],01h
      push word [bp+di+040h]
      push word [bp+020h]
      call slateacread
      add sp,04h
      push word [bp+di+040h]
      push word [bp+020h]
      call clenval
      add sp,04h
      add ax,01h
      cmp ax,[bp+di+0e0h]
      jz zt3066
      mov [bp+di+0e0h],ax
      cmp ax,[bp+di+04ch]
      js z3068
zt3066:      mov dx,[bp+di+04ch]
      mov [bp+di+0e0h],dx
z3068:  push word [bp+di+040h]
      push word [bp+020h]
      call clearline
      add sp,04h
      jmp z2642
commandstart:  mov si,04h
      mov word [bp+di+00aeh],0000h
commandtdisp:  mov ax,06h
      sub ax,si
      lea dx,[commandlisa]
      mov cx,0bh
      push ax
      push dx
      push cx
      push word [bp+020h]
      call outlinecopy
      add sp,08h
      push word [bp+020h]
      call tra11to55
      add sp,02h
      dec si
      jnz  commandtdisp
      push word [bp+020h]
      call pr1155
      add sp,02h
commandnh:    push word [bp+di+0014h]
              push word [bp+di+0016h]
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz commandytiny
      mov ax,[bp+di+0050h]
      mov dx,[bp+di+0052h]
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
commandytiny:    mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz commandkey
      mov word [bp+di+0014h],0001h
      mov word [bp+di+0016h],0000h
commandkey:      push word [bp+020h]
      call keycline
      add sp,02h
      push word [bp+020h]
      call tra11to55
      add sp,02h
      push word [bp+020h]
      call cmatchsym
      add sp,02h
      push dx
      push cx
      push ax
      mov si,cx
      push ax
      push dx
; make cx number base next for six digit count
      mov cx,0ah
      push cx
      mov cx,06h
      push cx
      mov cx,09h
      push cx
      mov cx,0bh
      push cx
      push word [bp+020h]
      call numberprn
      add sp,000eh
      mov dx,00h
      push si
      push dx
; make cx number base for 3 digit command symbol count
      mov cx,010h
      push cx
      mov cx,03h
      push cx
      mov cx,04h
      push cx
      mov cx,0bh
      push cx
      push word [bp+0020h]
      call numberprn
      add sp,000eh
      push word [bp+0020h]
      call tra11to55
      add sp,02h
      push word [bp+020h]
      call pr1155
      add sp,02h
      pop ax
      pop cx
      pop dx
      cmp cx,0001h
      jns yctopa
ycwrong:  mov si,05h
      jmp commandtdisp
yctopa:  cmp cx,01h
      jnz yc02
;     jmp insertb
      mov cx,00h
insert:  push cx
      push word [bp+020h]
      call insersubd
      add sp,04h
      mov word [bp+di+008ah],0001h
      jmp    commandstart
yc02:     cmp cx,02h
      jnz yc03
      mov cx,01h
     jmp insert
yc03:     cmp cx,03h
      jnz yc04
;     jmp delete
      push ax
      push word [bp+020h]
      call beldlinesdel
      add sp,0004h
      mov word [bp+di+008ah],0001h
      jmp  commandstart
yc04:     cmp cx,04h
      jnz yc05
;     jmp af
      mov cx,01h
      push cx
      lea cx,[homegetline]
      push cx
      push word [bp+0020h]
      call adverpar
      add sp,06h
      mov cx,01ah
      push cx
      lea cx,[plate025]
      push cx
      push word [bp+0020h]
      call adverpar
      add sp,06h
      mov cx,09h
      push cx
      push word [bp+0020h]
      push word [bp+0020h]
      call adverpar
      add sp,06h
      mov cx,010h
; increase above cx from 7 to higher number if command line input
;  needs more lines of text to request input
      push cx
      lea cx,[commandlisa]
      push cx
      push word [bp+0020h]
      call adverpar
      add sp,06h
      mov word [bp+di+008ah],0001h
;     bottom of adverfile yc04
      jmp  commandstart
yc05:   cmp cx,05h
      jnz yc06
;   jmp m
      mov cx,08h
      push cx
      mov cx,01h
      push cx
      push word [bp+0020h]
      call vprn
      add sp,06h
      jmp  commandstart
yc06:  cmp cx,06h
    jnz yc07
;  jmp k
      mov ax,08h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,08h
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
      mov ax,08h
      push ax
      mov ax,01h
      push ax
      push word [bp+0020h]
      call vprn
      add sp,06h
      mov ax,08h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,08h
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
      jmp commandstart
yc07:  cmp cx,07h
  jnz yc08
;  jmp tof
tof:  mov word [bp+di+0014h],0001h
      mov word [bp+di+0016h],0000h
commandprone:      mov cx,0001h
      push cx
      mov cx,0001h
      push cx
      push word [bp+0020h]
      call vprn
      add sp,0006h
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,08h
      mov word [bp+di+0014h],ax
      mov word [bp+di+0016h],dx
      jmp commandstart
yc08:  cmp cx,08h
  jnz yc09
;  jmp bot
bot:  mov cx,[bp+di+0050h]
       or cx,[bp+di+0052h]
      jz tof
      mov ax,[bp+di+0050h]
      mov dx,[bp+di+0052h]
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
      jmp commandprone
yc09:  cmp cx,09h
  jnz yc10
;  jmp up
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,0008h
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
      mov ax,0001h
      mov dx,0000h
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz ycbot09
      jmp tof
ycbot09:  jmp commandprone
yc10:  cmp cx,0ah
  jnz yc11
;   jmp down
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call cadd
      add sp,08h
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz ycbel10
      jmp bot
ycbel10:  jmp commandprone
yc11:  cmp cx,0bh
   jnz yc12
;  jmp input
input:   mov cx,00h
inputc:  push cx
      push word [bp+0020h]
      call inputsir
      add sp,0004h
      mov word [bp+di+008ah],0001h
      jmp commandstart
yc12:  cmp cx,0ch
   jnz yc13
;  jmp quit
yc12quit:   mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      or ax,dx
      jnz yc12diffy
      mov ax,[bp+di+0014h]
      mov dx,[bp+di+0016h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
yc12diffy:  mov dx,000bh
      push dx
      push word [bp+0020h]
      call slateacread
      add sp,04h
      push word [bp+0020h]
      call qpr11
      add sp,02h
      jmp z3098
yc13:  cmp cx,0dh
    jnz yc14
;  jmp print
       cmp word [bp+di+008ah],0000h
       jz printeji
   jmp ycwrong
printeji:   push word [bp+0020h]
      call maryjimlprn
      add sp,02h
      jmp  commandstart
yc14:  cmp cx,0eh
    jnz yc15
    jmp ycwrong
yc15:  cmp cx,0fh
  jz yczur15
  jmp yc16
;  jmp replace
yczur15:  mov ax,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      mov cx,0bh
      push cx
      push word [bp+0020h]
      call slateacread
      add sp,04h
      push word [bp+020h]
      call tra11to55
      add sp,02h
      lea cx,[commandlist]
      mov dx,08h
      mov ax,0bh
      push dx
      push cx
      push ax
      push word [bp+0020h]
      call outlinecopy
      add sp,08h
      push word [bp+0020h]
      call tra11to55
      add sp,02h
      push word [bp+0020h]
      call pr1155
      add sp,02h
      push word [bp+0020h]
      call keycline
      add sp,02h
      push word [bp+0020h]
      call tra11to55
      add sp,02h
      mov ax,0ch
      push ax
      push word [bp+0020h]
      call clenval
      add sp,04h
      cmp ax,0000h
      jnz ytcc15
; 0ch line is at line 12   if nonzero length
      mov dx,09h
      lea cx,[commandlist]
      mov ax,0bh
      push dx
      push cx
      push ax
      push word [bp+020h]
      call outlinecopy
      add sp,08h
      push word [bp+020h]
      call tra11to55
      add sp,02h
      push word [bp+020h]
      call pr1155
      add sp,02h
      push word [bp+020h]
      call keycline
      add sp,02h
      push word [bp+0020h]
      call tra11to55
      add sp,02h
; 0eh line is at line 14  if zero length line
      mov ax,0ch
      push ax
      push word [bp+020h]
      call alselset
      add sp,04h
      sub ax,bp
      mov si,ax
      mov dl,[bp+si]
      cmp dl,079h
      jz ytce15
      cmp dl,059h
      jz ytce15
      jmp ycwrong
ytce15:  mov ax,0eh
      jmp ytcg15
ytcc15:  mov ax,0ch
ytcg15:  push ax
      push word [bp+020h]
      call slateacwrite
      add sp,04h
      mov word [bp+di+008ah],0001h
       jmp  commandstart
yc16:  cmp cx,010h
  jnz yc17
;  jmp v
yc16v:      mov ax,[bp+di+0014h]
            mov dx,[bp+di+0016h]
yc16wx:     mov [bp+di+0044h],ax
            mov [bp+di+0046h],dx
      mov dx,08h
      mov ax,00h
      push dx
      push ax
      push word [bp+0020h]
      call vprn
      add sp,06h
       jmp  commandstart
yc17:  cmp cx,011h
  jnz yc18
; jmp open
   push word [bp+0020h]
   call acread
   add sp,02h
   cmp cx,0000h
   jnz yc17wrngr
   jmp yc16v
yc17wrngr:  push word [bp+020h]
      call findfilelist
      add sp,0002h
      jmp zrv2652
yc17wrng:   jmp ycwrong
yc18:  cmp cx,012h
  jnz yc19
;  jmp save
   push word [bp+0020h]
   call acwrite
   add sp,02h
   cmp cx,0000h
   jnz  yc17wrng
   mov ax,00h
   mov dx,00h
   jmp  yc12quit
yc19:  cmp cx,013h
  jnz yc20
;  jmp new
    jmp commandnew
yc20:  cmp cx,014h
   jz ycr20
   jmp yc21
;  jmp change
ycr20:  mov ax,[bp+di+0014h]
        mov dx,[bp+di+0016h]
      mov [bp+di+0044h],ax
      mov [bp+di+0046h],dx
      mov ax,0bh
      push ax
      push word [bp+0020h]
      call slateacread
      add sp,04h
      push word [bp+0020h]
      call tra11to55
;  origional line at y& at 0ch
      add sp,02h
    lea dx,[commandlist]
    mov ax,0dh
    mov cx,0bh
      push ax
      push dx
      push cx
      push word [bp+0020h]
      call outlinecopy
      add sp,08h
      push word [bp+0020h]
      call tra11to55
      add sp,02h
; origional line  0dh
      push word [bp+0020h]
      call pr1155
      add sp,02h
      push word [bp+0020h]
      call keycline
      add sp,02h
      push word [bp+0020h]
      call tra11to55
      add sp,02h
;     origional line is at 0eh  keyed change request is at line 0ch
;    need to finish change    06 04 02 free
      mov ax,0eh
      push ax
      push word [bp+0020h]
      call alselset
      add sp,04h
      mov [bp+06h],ax
;  06 is location of origional line at 0e
      mov ax,0ch
      push ax
      push word [bp+0020h]
      call alselset
      add sp,04h
      mov [bp+04h],ax
;  04 is location of keyed request line 0ch
      mov ax,0ch
      push ax
      push word [bp+0020h]
      call clenval
      add sp,04h
      mov cx,ax
; 02 is counter   cx is length of requested line
      cmp cx,0000h
      jz comchangeb
      mov word [bp+02h],0000h
; 02 ctr    04 request        06 changeable line
cmdchangelop:   mov si,[bp+02h]
      add si,[bp+04h]
      sub si,bp
      mov dl,[bp+si]
      mov al,020h
      cmp dl,al
      jz cmdchangeblb
      mov dl,[bp+si]
      mov si,[bp+02h]
      add si,[bp+06h]
      sub si,bp
      mov [bp+si],dl
cmdchangeblb:  add word [bp+02h],01h
      mov dx,[bp+02h]
      cmp dx,cx
      js cmdchangelop
      mov ax,0eh
      push ax
      push word [bp+0020h]
      call slateacwrite
      add sp,04h
      mov word [bp+di+008ah],0001h
comchangeb:  jmp commandstart
yc21:  cmp cx,015h
   jnz yc22
;  jmp  find
      push word [bp+0020h]
      call commandfind
      add sp,02h
      cmp ax,0000h
      jnz cmdnotfound
      jmp    yc16v
cmdnotfound:  jmp ycwrong
yc22:  cmp cx,016h
      jz yc22a
   jmp  yc23
;  jmp list
yc22a:      mov cx,[bp+di+0050h]
            or  cx,[bp+di+0052h]
      jnz  yc22c
      jmp  ycerror22
yc22c:      mov word [bp+di+0044h],ax
            mov word [bp+di+0046h],dx
yc22loop:  mov dx,08h
      mov  ax,00h
      push dx
      push ax
      push word [bp+0020h]
      call vprn
      add sp,06h
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      push word [bp+di+0044h]
      push word [bp+di+0046h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz yc22key9
      test cx,000eh
      jnz yc22bot
; ------
yc22key9:      lea cx,[commandlist]
      mov dx,000eh
      mov ax,0bh
      push dx
      push cx
      push ax
      push word [bp+0020h]
      call outlinecopy
      add sp,08h
      push word [bp+0020h]
      call tra11to55
      add sp,02h
      push word [bp+0020h]
      call pr1155
      add sp,02h
; -------------------------
      push word [bp+0020h]
      call keycline
      add sp,02h
      mov ax,0bh
      push ax
      push word [bp+0020h]
      call clenval
      add sp,04h
      cmp ax,0000h
      jnz ycerror22
      jmp yc22loop
yc22bot:            jmp commandstart
ycerror22:  jmp ycwrong
yc23:  cmp cx,017h
  jnz yc24
;  jmp inputc
      mov ax,01h
      push ax
      push word [bp+0020h]
      call inputsir
      add sp,04h
      mov word [bp+di+008ah],0001h
      jmp commandstart
yc24:  cmp cx,018h
  jnz yc25
;  jmp  uc
      mov word [bp+di+00ech],0061h
      jmp commandstart
yc25:  cmp cx,019h
  jnz yc26
;  jmp  lc
      mov word [bp+di+00ech],0000h
      jmp commandstart
yc26:  cmp cx,01ah
  jnz yc27
  jmp commandbot
yc27;  cmp cx,01bh
  jnz ycbot
ycbot:  jmp  ycwrong
commandbot:    mov ax,[bp+di+010h]
      mov dx,[bp+di+012h]
      mov [bp+di+0e0h],ax
      mov [bp+di+0e2h],dx
      mov ax,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+0b0h],ax
      mov [bp+di+0b2h],dx
      jmp z2642
z3098:  add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; symmget(*abstarg,*alsrcsel,stpos,maxpos)
; returns ax is next stpos   *abstarg+02 is string  *abstarg is LENWORD
; returns dx is CURRENT position of current symbol
;  26 maxpos    24 stpos    22 *alsrcsel    20 *abstarg    1e retad
;  1c disave    1a sisave    18 bpsave    16 bxsave     14 dxsave
;  12 cxsave    10 axsave    0e destbase    0c srcbase    0a maxposL
;  08 ctr        06 symlen    04 dssave     02        00
symmget:   push di
   push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov ax,[bp+0020h]
      sub ax,bp
      mov [bp+0eh],ax
      mov cx,ds
      mov [bp+04h],cx
      mov cx,[bp+0024h]
      dec cx
      mov [bp+08h],cx
      mov word [bp+06h],0000h
      mov dx,[bp+022h]
      sub dx,bp
      mov [bp+0ch],dx
      mov ax,[bp+0026h]
      and ax,01ffh
      mov [bp+0ah],ax
      cmp word [bp+0026h],0200h
      js symmss
      add [bp+0ch],bp
      jmp symmcs
; upper left corner
symmss:  mov si,[bp+08h]
      inc word [bp+08h]
      cmp si,[bp+0ah]
      js symmssa
      jmp dunsymget
symmssa:  add si,[bp+0ch]
; choose segment register
      cmp byte [bp+si],020h
      jz symmss
      dec word [bp+08h]
      mov ax,[bp+08h]
      mov [bp+014h],ax
symmssb:  mov si,[bp+08h]
      mov di,[bp+06h]
      inc word [bp+08h]
      cmp si,[bp+0ah]
      js symmssc
symmssab:  jmp dunsymget
symmssc:    add si,[bp+0ch]
      add di,[bp+0eh]
;  choose segment register
      mov al,[bp+si]
      cmp al,020h
      jz symmssab
      inc word [bp+06h]
      cmp word [bp+06h],000fh
      jns  symmssab
      mov [bp+di+02h],al
      jmp symmssb
; --
; upper left corner
symmcs:  mov si,[bp+08h]
      inc word [bp+08h]
      cmp si,[bp+0ah]
      js symmcsa
      jmp dunsymget
symmcsa:  add si,[bp+0ch]
; choose segment register
      mov ax,cs
      add ax,0000h
      mov ds,ax
      nop
      cmp byte [si],020h
      jz symmcs
      dec word [bp+08h]
      mov ax,[bp+08h]
      mov [bp+014h],ax
symmcsb:  mov si,[bp+08h]
      mov di,[bp+06h]
      inc word [bp+08h]
      cmp si,[bp+0ah]
      js symmcsc
symmcsab:  jmp dunsymget
symmcsc:    add si,[bp+0ch]
      add di,[bp+0eh]
;  choose segment register
      mov ax,cs
      add ax,0000h
      mov dx,ax
      nop
      mov al,[si]
      cmp al,020h
      jz symmcsab
      inc word [bp+06h]
      cmp word [bp+06h],000fh
      jns  symmcsab
      mov [bp+di+02h],al
      jmp symmcsb
; --
dunsymget:  mov di,[bp+0020h]
      sub di,bp
      mov ax,[bp+06h]
      mov [bp+di],ax
      mov cx,[bp+08h]
      add cx,0001h
      mov [bp+0010h],cx
      mov cx,[bp+0004h]
      mov ds,cx
      add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; ax=symcmp(*lefta,*righta)
; ax=0 if symbols are equal.
; 14 *righta    12 *lefta    10 retad    0e disave    0c sisave
; 0a bpsave    08 bxsave    06 dxsave    04 cxsave    02 axsave    00
symcmp:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,02h
      mov bp,sp
      mov si,[bp+012h]
      mov di,[bp+014h]
      sub si,bp
      sub di,bp
      mov ax,[bp+si]
      cmp ax,00h
      jnz keepsymcmp
failsymcmp:  mov word [bp+02h],01fh
      jmp symcmpend
keepsymcmp:  cmp ax,[bp+di]
      jnz failsymcmp
      cmp ax,000fh
      jns failsymcmp
symcmplop:  mov dl,[bp+si+02h]
      cmp dl,[bp+di+02h]
      jnz failsymcmp
      inc di
      inc si
      dec ax
      jnz symcmplop
      mov word [bp+02h],00h
symcmpend:  add sp,02h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; dx:ax  cx=cmatchsym(*xyptr)
; cx=0 no match   dx:ax is repeat factor
; 40 *xyptr    3e retad    3c disave    3a sisave    38 bpsave    36 bxsave
; 34 dxsave    32 cxsave    30 axsave        20 symfromss      10 symfromcs
; 0e           0c calbase    0a ctpos   08 attempt    06 repeatfactor??
; 04 nextpos    02 numberpos    0000
cmatchsym:    push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov bx,00h
    mov cx,0018h
apushzurclop:  push bx
      dec cx
      jnz apushzurclop
      mov bp,sp
      mov di,[bp+040h]
      sub di,bp
      mov word [bp+0030h],0001h
      mov word [bp+0034h],0000h
      mov word [bp+0032h],0000h
      mov ax,000ch
      push ax
      push word [bp+0040h]
      call alselset
      add sp,04h
      mov [bp+0ch],ax
      mov dx,[bp+di+04ch]
      mov cx,01h
      push dx
      push cx
      push word [bp+0ch]
      lea ax,[bp+0020h]
      push ax
      call symmget
      add sp,08h
      mov [bp+02h],ax
      cmp word [bp+020h],0000h
      jnz cmatchstart
cmatchfail:  jmp cmatchend
cmatchstart:   cmp word [bp+0020h],000fh
      jns cmatchfail
      mov word [bp+0ah],01h
cmatchcar:  mov dx,01ffh
      or dx,0200h
      lea cx,[commandlist]
      lea ax,[bp+0010h]
      push dx
      push word [bp+0ah]
      push cx
      push ax
      call symmget
      add sp,0008h
      mov [bp+04h],ax
      mov [bp+0ah],dx
      cmp word [bp+0010h],0000h
      jz cmatchfail
      mov cx,[bp+0010h]
      cmp cx,[bp+0020h]
      jnz cmatchnext
; need to check for call to subroutine symcmp
      lea ax,[bp+0010h]
      lea cx,[bp+0020h]
      push ax
      push cx
      call symcmp
      add sp,04h
      cmp ax,00h
      jnz cmatchnext
      mov cx,[bp+08h]
      inc cx
      mov [bp+032h],cx
      mov dx,[bp+di+004ch]
      lea cx,[bp+0020h]
      push dx
      push word [bp+02h]
      push word [bp+0ch]
      push cx
      call symmget
      add sp,0008h
      cmp word [bp+0020h],0000h
      jnz cmatchnumber
      jmp cmatchfail
cmatchnumber:  mov dx,0ah
      mov cx,09h
      mov ax,0ch
      push dx
      push cx
      push word [bp+02h]
      push ax
      push word [bp+0040h]
      call numberget
      add sp,000ah
      mov [bp+0030h],ax
      mov [bp+0034h],dx
      jmp cmatchend
cmatchnext:  push word [bp+04h]
      pop word [bp+0ah]
      add word [bp+0008h],0001h
      jmp cmatchcar
cmatchend:  add sp,0030h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; keycline(*xyptr)
; keys to  eleventh line
; 20 *xyptr    1e retad    1c disave    1a sisave    18 bpsave    16 bxsave
; 14 dxsave    12 cxsave   10 axsave    0e xsave     0c  0a bsel    08 cstb
; 06 nzcst     04      02 ctrc      00
keycline:    push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov cx,08h
      mov bx,0000h
keypushtop:    push bx
      dec cx
      jnz keypushtop
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      mov ax,[bp+di+0010h]
      mov [bp+0eh],ax
      mov word [bp+08h],000bh
      push word [bp+08h]
      push word [bp+020h]
      call alselset
      add sp,04h
      sub ax,bp
      mov [bp+0ah],ax
      push word [bp+08h]
      push word [bp+020h]
      call clearline
      add sp,04h
keyupc:    push word [bp+06h]
      mov ah,04bh
      mov al,059h
      push ax
      call io16
      add sp,02h
      add sp,02h
      cmp cx,00h
      jnz keyupc
      mov word [bp+06h],0001h
keydc:   mov si,[bp+02h]
         cmp si,[bp+di+04ch]
         jns donekeydc
         mov ax,si
         add ax,0001h
         mov [bp+di+0010h],ax
         push word [bp+020h]
         call cpr11
         add sp,02h
keydcr:    push word [bp+06h]
      mov ah,04bh
      mov al,059h
      push ax
      call io16
      add sp,02h
      add sp,02h
      jcxz keydcr
afterkeydc:    dec cx
      jz regkeydc
      mov si,[bp+02h]
      cmp si,[bp+di+04ch]
      jns donekeydc
      add si,[bp+0ah]
      mov byte [bp+si],020h
      inc word [bp+02h]
      jmp regkeydc
donekeydc:  mov ax,[bp+0eh]
            mov [bp+di+0010h],ax
           add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
regkeydc:  mov si,[bp+02h]
      cmp si,[bp+di+04ch]
      jns donekeydc
      add si,[bp+0ah]
      and ax,007fh
      cmp ax,0020h
      js nonregkeyc
      mov [bp+si],al
      add word [bp+02h],01h
      jmp keydc
nonregkeyc:    mov byte [bp+si],020h
      cmp al,08h
      jz bkspacec
      cmp al,0dh
      jz donekeydc
      add word [bp+02h],01h
bkspacedone:   jmp keydc
bkspacec:  cmp word [bp+02h],01h
      js bkspacedone
      dec word [bp+02h]
      dec si
      mov byte [bp+si],020h
      jmp keydc
;  vprn(*xyptr,nonzurY,comheight)
;  24 comheight    22 nonzurY    20 *xyptr    1e retad    1c disave
;  1a sisave       18 bpsave     16 bxsave    14 dxsave   12 cxsave
;  10 axsave       0e cheight    0c           0a          08 ctr
;  06              04 cst11      02           00
vprn:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov cx,08h
      mov bx,00h
vprnpusht: push bx
      dec cx
      jnz vprnpusht
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov word [bp+04h],0bh
      mov ax,[bp+024h]
      mov word [bp+0eh],ax
      cmp word [bp+024h],01h
      jns vprnabh
      jmp vprnskip
vprnabh:  cmp word [bp+022h],00h
      jz vprnwoy
      mov ax,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
vprnwoy:  mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+044h]
      push word [bp+di+046h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz vprntae
vprnclrln:  push word [bp+04h]
      push word [bp+020h]
      call clearline
      add sp,04h
      jmp vprnrdy
vprntae:  push word [bp+di+044h]
      push word [bp+di+046h]
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz vprnclrln
      push word [bp+04h]
      push word [bp+020h]
      call slateacread
      add sp,04h
vprnrdy:  push word [bp+020h]
      call tra11to55
      add sp,02h
      add word [bp+08h],01h
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+044h]
      push word [bp+di+046h]
      call cadd
      add sp,08h
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      mov ax,[bp+08h]
      cmp ax,[bp+0eh]
      jns vprnybee
      jmp vprnwoy
vprnybee:  cmp word [bp+022h],00h
      jz vprnway
      mov ax,[bp+di+044h]
      mov dx,[bp+di+046h]
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
vprnway:  push word [bp+020h]
      call pr1155
      add sp,02h
vprnskip:  add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; prqreadc(*xyptr,*clistbase,linenumber)
; print request and input line command line input mode
; 024 linenumber     022 *clistbase    020 *xyptr    01e retad
; 01c disave    1a sisave    18 bpsave    16 bxsave    14 dxsave
; 12 cxsave     10 axsave    0e   0c  0a  08  06  04  02  00
; prqreadc(*xyptr,*clistbase,linenumber)
prqreadc:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov ax,0bh
      push word [bp+024h]
      push word [bp+022h]
      push ax
      push word [bp+020h]
      call outlinecopy
      add sp,08h
      push word [bp+020h]
      call tra11to55
      add sp,02h
      push word [bp+020h]
      call pr1155
      add sp,02h
      push word [bp+020h]
      call keycline
      add sp,02h
      push word [bp+020h]
      call tra11to55
      add sp,02h
      add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; insersubd(*xyptr,incbnonzur)
; insert line before Y&  incbnonzur == 0   [bp+di+0034h]  insel%=000c
; Y&=Y&+1 insert line    incbnonzur == 1     insel%=000c
; Y&=Y&+1 insert line    incbnonzur > 2  no read  insel%=incbnonzur
;  22 incbnonzur    20 *xyptr    1e retad    1c disave    1c sisave
;  18 bpsave    16 bxsave    14 dxsave    12 cxsave    10 axsave    0e
; 0c         0a         08          06         04         02        00
insersubd:  push di
    push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      cmp word [bp+022h],0003h
      js insersubc
      mov ax,[bp+022h]
      mov [bp+di+0034h],ax
      jmp inseraftnr
insersubc:    cmp word [bp+022h],00h
      jnz inserbh
      mov ax,05h
      jmp insersube
inserbh:  mov ax,06h
insersube:  lea si,[commandlist]
      push ax
      push si
      push word [bp+020h]
      call prqreadc
      add sp,06h
      mov word [bp+di+0034h],000ch
      cmp word [bp+022h],00h
      jz insersamey
inseraftnr:  push word [bp+di+014h]
             push word [bp+di+016h]
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz insersamey
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+014h]
      push word [bp+di+016h]
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
insersamey:  push word [bp+020h]
      call acinsertb
      add sp,02h
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
inserdiffy:  add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; adverpar(*xyptr,*adbase,numberoflines)
; 24 numberoflines    22 *adbase    20 *xyptr    1e retad
; 1c disave    1a sisave    18 bpsave    16 bxsave    14 dxsave
; 12 cxsave    10 axsave    0e            0c adverctr    0a
; 08           06           04            02             00
adverpar:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      mov word [bp+0ch],0000h
adverloop:  add word [bp+0ch],01h
      mov ax,[bp+0024h]
      cmp ax,[bp+000ch]
      js adverbot
      mov ax,[bp+0022h]
      cmp ax,[bp+0020h]
      jnz adverwail
      mov ax,[bp+0024h]
      cmp ax,[bp+000ch]
      jnz advertot
adverwail:    push word [bp+000ch]
      push word [bp+0022h]
      mov cx,0003h
      push cx
      push word [bp+0020h]
      call outlinecopy
      add sp,08h
      mov dx,03h
      push dx
      push word [bp+0020h]
      call insersubd
      add sp,04h
      cmp word [bp+di+004ah],0000h
      jnz adverbot
advertot:      jmp adverloop
adverbot:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; inputsir(*xyptr,endzur)
; 22 endzur    20 *xyptr    1e retad    1c disave    1a sisave
; 18 bpsave    16 bxsave    14 dxsave   12 cxsave    10 axsave
; 0e           0c           0a bcst     08
; 06           04           02          00
inputsir:    push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      mov bx,0000h
      cmp word [bp+0022h],0000h
      jnz inputsarge
      mov ax,01h
      push ax
      push bx
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      call cadd
      add sp,08h
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
inputsarge:  lea dx,[commandlist]
      mov ax,0007h
      mov word [bp+0ah],0bh
      push ax
      push dx
      push word [bp+000ah]
      push word [bp+0020h]
      call outlinecopy
      add sp,0008h
      push word [bp+0020h]
      call tra11to55
      add sp,02h
      push word [bp+0020h]
      call pr1155
      add sp,0002h
inputpfc:  push word [bp+0020h]
      call keycline
      add sp,0002h
      push word [bp+0020h]
      call tra11to55
      add sp,02h
      push word [bp+0020h]
      call pr1155
      add sp,0002h
      mov dx,000ch
      push dx
      push word [bp+0020h]
      call clenval
      add sp,0004h
      cmp ax,0000h
      jz inputmajor
      mov cx,0ch
      push cx
      push word [bp+0020h]
      call insersubd
      add sp,0004h
      jmp inputpfc
inputmajor:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; chdoc% 08ah    ytaelon& 44,46     50,52 afilelen&
; maryjimlprn(*xyptr)
; 20 *xyptr    1e retad    1c disave    10 axsave    0e lprnsel    0c
; 0a cst0b     08          06           04           02 czur       00
maryjimlprn:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      cmp word [bp+di+008ah],00h
      jz jimlpe
annieflp:  jmp annielprnf
jimlpe:   mov ax,[bp+di+0050h]
      or ax,[bp+di+0052h]
      jz annieflp
      cmp word [bp+di+00ech],0000h
      jnz annieflp
      mov word [bp+di+044h],00h
      mov word [bp+di+046h],00h
      mov word [bp+0ah],0bh
      push word [bp+0ah]
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+0eh],ax
      mov word [bp+02h],0000h
annjimlpl:  mov ax,0001h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+044h]
      push word [bp+di+046h]
      call cadd
      add sp,08h
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      push word [bp+0ah]
      push word [bp+020h]
      call slateacread
      add sp,04h
      push word [bp+di+04ch]
      push word [bp+02h]
      push word [bp+0eh]
      mov ah,04ch
      mov al,050h
      push ax
      call io16
      add sp,08h
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      push word [bp+di+0044h]
      push word [bp+di+0046h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz annjimlpl
annielprnf:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; record at *rhanptr  00 repeat   02 onechr   04 fileposl    06 fileposh
;         08 flenl    0a flenh    0c handlevalue   0e position within 16
;  010 to 01f                    up to 16 byte disk record
; areedline:  (*xyptr,dindex)
; returns ax=linelength  cx=nonzero error   dx bits 2 repeat   3 eof
; check dx bit 2 repeat 04 before eof bit 3 08
; dx bits 8-15 are delayed eof
; delayed EOF is [bp+di+0eeh]
; 22 dindex     20 *xyptr     1e retad    1c disave    1a sisave    18 bpsave
; 16 bxsave     14 dxsave     12 cxsave   10 axsave    0e bufsel    0c add140
; 0a            08            06          04           02           00
areedline:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov di,[bp+0020h]
      mov ax,di
      sub di,bp
      mov bx,00h
      add ax,0140h
      mov [bp+0ch],ax
      push word [bp+022h]
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+0eh],ax
      cmp word [bp+di+00eeh],0000h
      jz areedb02
      jmp areedblnk34
areedb02:  push word [bp+di+004ch]
      push word [bp+0eh]
      push word [bp+0ch]
      call reedline
      add sp,06h
      mov [bp+010h],ax
      mov [bp+012h],cx
      mov [bp+014h],dx
      test dx,04h
      jnz skipreebeof
      test dx,08h
      jz skipreebeof
areedeof4:  sal word [bp+di+00eeh],1
      or word [bp+di+00eeh],0001h
skipreebeof:  mov cx,[bp+di+00eeh]
      and cx,0ff00h
      or word [bp+014h],cx
      add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
areedblnk34:  push word [bp+022h]
      push word [bp+020h]
      call clearline
      add sp,04h
      jmp  areedeof4
;  end of   areedline
; line 12 after first symbol to destline
; rine12(*xyptr,destline)
; ax and cx are zero if invalid
; 22 destline    20 *xyptr    1e retad    1c disave    1a sisave
; 18 bpsave      16 bxsave    14 dxsave   12 cxsave - length of rightmost
; 10 axsave - start of rightmost
; 0e             0c           0a totlen   08           06 cbase or dbase
; 04 destbase    02           00
rine12:  push di
      push si
      push bp
      push bx
      push dx
      mov bx,00h
      mov cx,0ah
rine12pu:  push bx
      dec cx
      jnz rine12pu
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      mov ax,0dh
      push ax
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+06h],ax
      push word [bp+022h]
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+04h],ax
      mov ax,0dh
      push ax
      push word [bp+020h]
      call clenval
      add sp,04h
      mov [bp+0ah],ax
      cmp word [bp+0ah],00h
      jnz rine12lel
rine12tny:  jmp rine12bot
rine12lel:  mov si,[bp+06h]
      sub si,bp
      mov cx,00h
rine12blnk:  mov dl,[bp+si]
      inc si
      inc cx
      cmp dl,020h
      jz rine12blnk
      dec si
      dec cx
rine12seek:  cmp byte [bp+si],020h
      jz rinelengot
      inc si
      inc cx
      cmp cx,[bp+di+004ch]
      js rine12seek
      jmp rine12tny
rinelengot:  inc cx
      cmp cx,[bp+0ah]
      jns rine12tny
      mov [bp+0010h],cx
      mov ax,[bp+0ah]
      sub ax,cx
      add ax,0000h
      mov [bp+012h],ax
      push word [bp+022h]
      push word [bp+020h]
      call clearline
      add sp,04h
      mov si,[bp+06h]
      sub si,bp
      add si,[bp+0010h]
      mov di,[bp+04h]
      mov cx,[bp+012h]
      sub di,bp
rinetran:  mov al,[bp+si]
      mov [bp+di],al
      inc si
      inc di
      dec cx
      jnz rinetran
rine12bot:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; copen3520(*xyptr,zurtwosel6,clearzur)
; 24 clearzur    22 zurtwosel6    20 *xyptr    1e retad
; 1c disave      10 axsave        0e outline68    0c     0a addr03
copen3520:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,010h
      mov bp,sp
      mov bx,00h
      mov di,[bp+0020h]
      mov si,di
      add si,0140h
      push si
      call clearhanr
      add sp,02h
      sub di,bp
      mov ax,[bp+022h]
      add ax,06h
      mov [bp+0eh],ax
      push word [bp+0eh]
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+di+096h],ax
      mov ax,03h
      push ax
      push word [bp+0020h]
      call clearline
      add sp,0004h
      cmp word [bp+0024h],0000h
      jnz copen3521
      push word [bp+0eh]
      push word [bp+020h]
      call clearline
      add sp,04h
copen3521:  push word [bp+0eh]
      push word [bp+0020h]
      call rine12
      add sp,04h
      cmp ax,0000h
      jz copen3523
      jmp copen3526
copen3523:  push word [bp+0eh]
      push word [bp+020h]
      call clenval
      add sp,04h
      cmp ax,0000h
      jz copen3524
      jmp copen3526
copen3524:  mov ax,[bp+022h]
      add ax,0ah
      push ax
      lea dx,[commandlist]
      push dx
      mov cx,0bh
      push cx
      push word [bp+0020h]
      call outlinecopy
      add sp,08h
      push word [bp+020h]
      call tra11to55
      add sp,02h
      push word [bp+020h]
      call pr1155
      add sp,02h
      push word [bp+020h]
      call keycline
      add sp,02h
      push word [bp+020h]
      call tra11to55
      add sp,02h
      mov ax,0ch
      push ax
      push word [bp+0020h]
      push word [bp+000eh]
      push word [bp+020h]
      call outlinecopy
      add sp,08h
copen3526:  push word [bp+000eh]
      push word [bp+020h]
      call clenval
      add sp,04h
      mov [bp+di+0098h],ax
      cmp word [bp+di+0098h],0000h
      jz copenbot
      mov ax,03h
      push ax
      push word [bp+0020h]
      call alselset
      add sp,04h
      mov [bp+0ah],ax
      push word [bp+di+004ch]
      push word [bp+di+0096h]
      push word [bp+0ah]
      call fncopy
      add sp,06h
copenbot:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; acread(*xyptr)
; returns cx=0000h no error at open
; 20 *xyptr    1e retad    1c disave    12 cxsave    10 axsave    0e
; 0c           0a cst12    08           06 crfn      04
acread:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov di,[bp+0020h]
      mov si,di
      add si,0140h
      sub di,bp
      sub si,bp
      mov ax,00h
      push ax
      mov ax,02h
      push ax
      push word [bp+0020h]
      call copen3520
      add sp,06h
      mov ax,03h
      push ax
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+06h],ax
      cmp word [bp+di+0098h],0000h
      jnz acreab
acreadfail:  mov word [bp+012h],08h
            jmp acreadbot
acreab:  push word [bp+06h]
      mov ah,04fh
      mov al,052h
      push ax
      call io16
      add sp,04h
      mov [bp+si+0ch],ax
      mov word [bp+si+0eh],07ffh
      test cx,0008h
      jnz acreadfail
      push word [bp+si+000ch]
      mov ah,046h
      mov al,04ch
      push ax
      call io16
      add sp,04h
      mov [bp+si+08h],ax
      mov [bp+si+0ah],dx
      mov ax,[bp+di+050h]
      mov dx,[bp+di+052h]
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      mov word [bp+di+0eeh],0000h
      mov word [bp+0ah],0ch
      or ax,dx
      jz aclread
      mov word [bp+di+008ah],0001h
aclread:  cmp word [bp+di+00eeh],0000h
      jnz aclclose
      push word [bp+0ah]
      push word [bp+020h]
      call areedline
      add sp,0004h
      mov ax,0ch
      push ax
      push word [bp+0020h]
      call insersubd
      add sp,04h
      cmp word [bp+di+004ah],0000h
      jnz aclclose
      jmp aclread
aclclose:  push word [bp+si+0ch]
      mov ah,043h
      mov al,052h
      push ax
      call io16
      add sp,04h
      mov word [bp+012h],00h
      mov ax,02h
      push ax
      push word [bp+0020h]
      call fntoonine
      add sp,0004h
acreadbot:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
;  acwrite(*xyptr)
; returns cx=00h no error at open
; 20 *xyptr    1e retad    1c disave    12 cxsave    10 axsave    0e
; 0c *doswritebuffer       0a wrthandle     08 *wrtlineaddr       06
; 04 al3            02               00
acwrite:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov di,[bp+020h]
      sub di,bp
      mov word [bp+012h],00h
      mov ax,0bh
      push ax
      push word [bp+0020h]
      call alselset
      add sp,04h
      mov [bp+08h],ax
      mov ax,[bp+di+0050h]
      or  ax,[bp+di+0052h]
      jnz acwritb
acwritebadfn:  mov word [bp+0012h],0001h
      jmp acwritebot
acwritb:  mov ax,01h
      push ax
      mov ax,02h
      push ax
      push word [bp+0020h]
      call copen3520
      add sp,06h
      cmp word [bp+di+0098h],00h
      jz acwritebadfn
      mov ax,03h
      push ax
      push word [bp+020h]
      call alselset
      add sp,04h
      mov [bp+04h],ax
      push word [bp+04h]
      mov ah,04fh
      mov al,057h
      push ax
      call io16
      add sp,04h
      mov [bp+0ah],ax
      test cx,0008h
      jnz acwritebadfn
      mov word [bp+di+014h],01h
      mov word [bp+di+016h],00h
acwriteloop:  mov ax,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      mov ax,0bh
      push ax
      push word [bp+0020h]
      call slateacread
      add sp,0004h
      push word [bp+di+004ch]
      lea cx,[bp+000ch]
      push cx
      push word [bp+0ah]
      push word [bp+08h]
      call printfi
      add sp,0008h
;  need to increment Y to unfreeze save
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call csubtract
      add sp,0008h
      test cx,000ch
      jz acwriteclose
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call cadd
      add sp,08h
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
      jmp acwriteloop
acwriteclose:  push word [bp+0ah]
      mov ah,043h
      mov al,057h
      push ax
      call io16
      add sp,04h
acwritebot:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
;    commandfind(*xyptr)
; compares (y&) (6) y&=1,afilelen&
; returns ax=0 match found at y&
; 20 *xyptr    1e retad    1c disave    10 axsave    0e    0c    0a
; 08           06          04           02           00
commandfind:  push di
              push si
              push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      mov word [bp+0010h],000fh
      mov ax,[bp+di+0050h]
      or ax,[bp+di+0052h]
      jnz cmdfinda
cmdnotfind:  jmp cmdfindbot
cmdfinda:    mov ax,0000h
      push ax
      mov ax,0000h
      push ax
      push word [bp+0020h]
      call copen3520
      add sp,0006h
      cmp word [bp+di+0098h],0000h
      jz cmdnotfind
cmdfindloop:  push word [bp+di+0014h]
              push word [bp+di+0016h]
      push word [bp+di+0050h]
      push word [bp+di+0052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz cmdnotfind
      mov word [bp+di+00dah],004fh
      push word [bp+0020h]
      call findone2822
      add sp,0002h
      cmp ax,0000h
      jz cmdfound
      mov ax,01h
      mov dx,00h
      push ax
      push dx
      push word [bp+di+0014h]
      push word [bp+di+0016h]
      call cadd
      add sp,0008h
      mov [bp+di+0014h],ax
      mov [bp+di+0016h],dx
      jmp cmdfindloop
cmdfound:  mov word [bp+0010h],0000h
cmdfindbot:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; casesub(*xyptr,linedex)
; 22 linedex    20 *xyptr    1e retad    1c disave    10 axsave
; 0e            0c lineaddr  0a          08           06
casesub:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
      cmp word [bp+di+00ech],0061h
      jz casesel
casefail:  jmp casebot
casesel:   push word [bp+0022h]
      push word [bp+0020h]
      call alselset
      add sp,0004h
      mov [bp+0ch],ax
      mov cx,[bp+di+004ch]
      jcxz casefail
      mov si,[bp+0ch]
      sub si,bp
caseloop:  mov dx,07fh
      and dl,[bp+si]
      cmp dl,061h
      jb caseb61
      cmp dl,07ah
      ja casea7a
      sub dl,020h
      jmp casebulb
casea7a:  cmp dl,07eh
      ja caseblank
      jmp casebulb
caseb61:  cmp dl,020h
      jb caseblank
      jmp casebulb
caseblank:  mov dl,020h
casebulb:  mov [bp+si],dl
      inc si
      dec cx
      jnz caseloop
casebot:  add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; dtajunk 00-001Dh  001Eh 13 bytes asciiz filename    002Ch filespec 007ch
; filefind(24*xyptr,  26*dtaptr,  28firstnext,  2a attrib)
; 22 retad  20 dssave     10 axsave   0e dosdtaseg    0c dosdtaoffset  0a
filefind: push ds
    push es
      push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0010h
      mov bp,sp
      mov word [bp+0010h],000fh
      mov cx,ss
      mov ds,cx
      mov es,cx
      mov ax,02f00h
      push bp
      int 21h
      pop bp
      mov cx,es
      mov [bp+0eh],cx
      mov [bp+0ch],bx
      mov cx,ss
      mov ds,cx
      mov dx,[bp+0026h]
      mov ax,01a00h
      push bp
      int 21h
      pop bp
ajrefind:  mov cx,ss
      mov ds,cx
      mov dx,[bp+0026h]
      cmp word [bp+0028h],0040h
      js setdirchk
      mov dx,[bp+0028h]
      sub dx,0041h
      cmp dx,001ah
      js setdriveab
      sub dx,0020h
setdriveab:  mov ax,0e00h
      jmp setdirint
setdirchk:  cmp word [bp+0028h],0004h
      js firstnextch
      jg setdrivefail
      add dx,001eh
      mov ax,03b00h
setdirint:  push bp
      int 21h
      pop bp
setdrivefail:  jmp restoredta
firstnextch:  add dx,002ch
      mov cx,[bp+002ah]
      mov ax,04e00h
      cmp word [bp+0028h],0002h
      js stilfindfirs
      mov ax,04f00h
stilfindfirs:    push bp
      clc
      int 21h
      pop bp
      jnb undtablue
      jmp restoredta
undtablue:      mov word [bp+0028h],0002h
      mov cx,ss
      mov ds,cx
      mov dx,[bp+0026h]
      add dx,001eh
      mov ax,04300h
      push bp
      int 21h
      pop bp
      xor cx,[bp+002ah]
      and cx,0010h
      jz jjrefound
      jmp ajrefind
jjrefound:  push word [bp+0024h]
      call tra11to55
      add sp,0002h
      mov word [bp+0010h],0000h
      mov ax,0ch
      push ax
      push word [bp+0024h]
      call clearline
      add sp,04h
      mov ax,000ch
      push ax
      push word [bp+0024h]
      call alselset
      add sp,0004h
      mov di,ax
      sub di,bp
      mov si,[bp+0026h]
      add si,001eh
      sub si,bp
      mov cx,0001fh
findnextop:  mov dl,[bp+si]
      cmp dl,00h
      jz findnextbot
      mov [bp+di],dl
      inc si
      inc di
      dec cx
      jnz findnextop
findnextbot:  push word [bp+0024h]
      call pr1155
      add sp,0002h
restoredta: mov cx,[bp+0eh]
      mov ds,cx
      mov dx,[bp+000ch]
      mov ax,01a00h
      int 21h
      add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      pop es
      pop ds
      ret
; hexoline(*xyptr,*rhanptr)
; 24 *rhanptr    22 *xyptr   20 retad    1e disave    12 axsave
; 10 line1loc    0e ctr07
hexoline:  push di
      push si
      push bp
      push bx
      xor bx,bx
      mov cx,000ch
hexzurpu:  push bx
      dec cx
      jnz hexzurpu
      mov bp,sp
      mov di,[bp+022h]
      sub di,bp
      xor ax,ax
      inc ax
      push ax
      push word [bp+022h]
      call alselset
      add sp,04h
      mov [bp+010h],ax
      xor cx,cx
      inc cx
      push cx
      push word [bp+022h]
      call clearline
      add sp,04h
      mov word [bp+0eh],05h
      mov si,[bp+010h]
      sub si,bp
      mov byte [bp+si+01h],044h
      mov byte [bp+si+02h],042h
loop533:  cmp word [bp+000eh],0028h
      jg bot533
      push word [bp+0024h]
      call readone
      inc sp
      inc sp
      cmp dx,bx
      jz loop534
      mov word [bp+0016h],08h
loop534:  or [bp+014h],cx
      jz loop536
      jmp bot533
loop536:  cmp word [bp+000eh],0005h
      jz skiprh0537
      mov si,[bp+010h]
      sub si,bp
      add si,[bp+0eh]
      dec si
      dec si
      mov byte [bp+si],02ch
skiprh0537:  push ax
      push bx
      mov cx,010h
      push cx
      mov cx,03h
      push cx
      push word [bp+0eh]
      xor cx,cx
      inc cx
      push cx
      push word [bp+022h]
      call numberprn
      add sp,0eh
      mov si,[bp+010h]
      sub si,bp
      add si,[bp+0eh]
      inc si
      inc si
      mov byte [bp+si],048h
      add word [bp+000eh],0005h
      cmp [bp+016h],bx
      jz loop533
bot533:  add sp,012h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; findfilelist(*xyptr
; fc *xyptr  fa retad
; f8 disave    f6 sisave    f4 bpsave    f2 bxsave
; f0 dxsave    ee cxsave    ec axsave
; 009ch filespec *.ext
; 0070h dtajunk
; 06e    06c    06a width
; 068 attrib    066 firstnext    064 counter    062 *dtaptr    060h ictr
; 05eh inlen    05ch repeat
findfilelist:  push di
    push si
      push bp
      push bx
      mov dx,0043h
      mov cx,0001h
      push dx
      push cx
      push dx
      sub sp,00ech
      mov bp,sp
      mov di,[bp+00fch]
      sub di,bp
      mov [bp+0066h],cx
      mov ax,0000h
      mov [bp+0068h],ax
      mov [bp+0060h],ax
      mov [bp+0064h],cx
      lea dx,[bp+0070h]
      mov [bp+0062h],dx
      mov dx,[bp+di+004ch]
      mov [bp+006ah],dx
      mov cx,0008h
      push cx
      push word [bp+00fch]
      call alselset
      add sp,0004h
      push word [bp+006ah]
      push ax
      mov si,[bp+0062h]
      add si,002ch
      push si
      call fncopy
      add sp,0006h
      sub si,bp
      mov ax,08h
      push ax
      push word [bp+00fch]
      call clenval
      add sp,04h
      cmp ax,03h
      jns ffndreg
      mov dl,[bp+si]
      cmp dl,02eh
      jnz drvset
      mov byte [bp+si+00h],02ah
      mov byte [bp+si+01h],02eh
      mov byte [bp+si+02h],02ah
      mov byte [bp+si+03h],000h
      mov word [bp+0068h],0010h
      jmp ffndreg
drvset:  mov dl,[bp+si]
      and dx,00ffh
      mov [bp+0066h],dx
singleffnds:  push word [bp+0068h]
      push word [bp+0066h]
      push word [bp+0062h]
      push word [bp+00fch]
      call filefind
      add sp,08h
      jmp fnfindquit
ffndreg:  lea dx,[commandlist]
      mov ax,00bh
      mov cx,000fh
      push cx
      push dx
      push ax
      push word [bp+00fch]
      call outlinecopy
      add sp,08h
      push word [bp+00fch]
      call tra11to55
      add sp,02h
firstlopfd:  push word [bp+0068h]
      push word [bp+0066h]
      push word [bp+0062h]
      push word [bp+00fch]
      call filefind
      add sp,0008h
      mov word [bp+0066h],0002h
      cmp ax,0000h
      jz findkeyfn
      jmp fnfindquit
findkeyfn: mov word [bp+005ch],0001h
    push word [bp+00fch]
    call keycline
      add sp,02h
      mov ax,000bh
      push ax
      push word [bp+00fch]
      call clenval
      add sp,04h
      mov word [bp+005eh],ax
      cmp word [bp+005eh],0000h
      jnz findftwocmp
      jmp oorefindfn
findftwocmp:  cmp word [bp+005eh],0002h
      js findkeyone
      mov ax,000ah
      push ax
      mov dx,04h
      push dx
      push word [bp+005ch]
      mov ax,000bh
      push ax
      push word [bp+00fch]
      call numberget
      add sp,000ah
      mov [bp+005ch],ax
findkeyone:  mov ax,000bh
      push ax
      push word [bp+00fch]
      call alselset
      add sp,0004h
      mov si,ax
      sub si,bp
      mov dl,[bp+si]
      cmp dl,07ah
      ja casekff
      cmp dl,061h
      jb casekff
      sub dl,020h
casekff: and dx,00ffh
         cmp word [bp+05eh],0001h
      js oorefindfn
      cmp dl,048h
      jnz val04fzff
      test word [bp+0068h],0010h
      jnz findonegone
      mov word [bp+di+0084h],0002h
findonegone:  mov dx,004fh
val04fzff:    cmp dl,04fh
     jnz morefindfn
      test word [bp+0068h],0010h
      jnz rnfindadir
      mov [bp+00ech],dx
      mov [bp+00f0h],dx
      jmp rnfindquit
rnfindadir:  mov word [bp+0066h],0004h
      jmp singleffnds
rnfindquit:  mov dx,000ch
      mov ax,0008h
      push dx
      push word [bp+00fch]
      push ax
      push word [bp+00fch]
      call outlinecopy
      add sp,0008h
fnfindquit:  mov ax,0bh
      push ax
      push word [bp+00fch]
      call clearline
      add sp,04h
      add sp,00ech
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
morefindfn:  cmp dl,043h
      jz fnfindquit
      cmp dl,051h
      jz fnfindquit
      cmp dl,02bh
      jnz fnfindother
oorefindfn:  dec word [bp+05ch]
      cmp word [bp+005ch],0000h
      jns morefindfw
      jmp findkeyfn
morefindfw:  push word [bp+0068h]
      push word [bp+0066h]
      push word [bp+0062h]
      push word [bp+00fch]
      call filefind
      add sp,0008h
      cmp ax,0000h
      jnz borefindfn
      inc word [bp+0064h]
      jmp oorefindfn
borefindfn:  jmp findkeyfn
fnfindother:  cmp dl,054h
      jnz fnfindosher
      mov word [bp+0066h],0001h
      mov word [bp+0064h],0001h
      jmp firstlopfd
fnfindosher: cmp dl,02dh
    jnz minusbotcff
    mov word [bp+0060h],0000h
    mov ax,[bp+0064h]
      sub ax,[bp+005ch]
      mov [bp+0064h],ax
      mov word [bp+066h],01h
findfminusl:  push word [bp+068h]
      push word [bp+0066h]
      push word [bp+0062h]
      push word [bp+00fch]
      call filefind
      add sp,0008h
      mov word [bp+0066h],0002h
      cmp ax,0000h
      jnz minusbotcff
      inc word [bp+0060h]
      mov ax,[bp+0060h]
      cmp ax,[bp+0064h]
      js findfminusl
minusbotcff: jmp findkeyfn
; bottom of findfilelist
; slateacread(*xyptr,acrline)
; uses 044 ytaelon
; 1c acrline    1a *xyptr    18 retad    16 disave    14 sisave
; 12 bpsave    10 bxsave    0e dxsave    0c cxsave    0a axsave
; 08      06    04    02    00
slateacread:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0ah
      mov bp,sp
      mov di,[bp+001ah]
      sub di,bp
      xor bx,bx
      xor ax,ax
      inc ax
      push ax
      push bx
      push word [bp+di+0044h]
      push word [bp+di+0046h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz keepacsr
      push word [bp+001ch]
      push word [bp+001ah]
      call clearline
      add sp,0004h
      jmp accrquit
keepacsr:  push word [bp+di+0110h]
      push word [bp+di+0112h]
      push word [bp+di+044h]
      push word [bp+di+046h]
      call csubtract
      add sp,08h
      test cx,000eh
      jz acrshortcpy
      push word [bp+001ch]
      push word [bp+001ah]
      call slatereadstr
      add sp,04h
      jmp accrquit
acrshortcpy:  mov ax,0ah
      push ax
      push word [bp+001ah]
      push word [bp+001ch]
      push word [bp+001ah]
      call outlinecopy
      add sp,0008h
accrquit:  mov di,[bp+001ah]
      sub di,bp
      cmp word [bp+di+00ech],0000h
      jz accrquitlc
      push word [bp+001ch]
      push word [bp+001ah]
      call casesub
      add sp,0004h
accrquitlc:  add sp,000ah
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; slatereadstr(*xyptr,destne0a)
; uses 044 ytaelon&
; 30 destne0a    2e *xyptr    2c retad    2a disave    28 sisave
; 26 bpsave    24 bxsave    22 dxsave    20 cxsave    1e axsave
; 1c dssave    1a essave    18 distick    16 seg      14 numberofsegs
; 12 nzerror   10 destaddr-bp             0e     0c    0a
; 08    06    04    02    00
slatereadstr:  push di
       push si
      push bp
      push bx
      push dx
      push cx
      push ax
      push ds
      push es
      sub sp,001ah
      mov bp,sp
      mov di,[bp+002eh]
      sub di,bp
      xor bx,bx
      mov [bp+0018h],di
      push word [bp+di+0044h]
      push word [bp+di+0046h]
      push word [bp+002eh]
      call slateseg
      add sp,0006h
      mov [bp+0012h],ax
      mov [bp+0014h],cx
      mov [bp+0016h],dx
      push word [bp+0030h]
      push word [bp+02eh]
      call clearline
      add sp,04h
      push word [bp+0030h]
      push word [bp+002eh]
      call alselset
      add sp,04h
      sub ax,bp
      mov [bp+0010h],ax
      cmp [bp+0012h],bx
      jz slreadkeep
slreaderror:  jmp slreadquit
slreadkeep:  cmp [bp+0014h],bx
      jz slreaderror
slreadoll:  mov ax,[bp+0016h]
      mov ds,ax
      inc word [bp+0016h]
      xor si,si
      mov di,[bp+0010h]
      add word [bp+0010h],0010h
      mov cx,0010h
slreadil: mov dl,[si]
      mov [bp+di],dl
      inc si
      inc di
      dec cx
      jnz slreadil
      dec word [bp+0014h]
      jnz slreadoll
slreadquit:  add sp,001ah
      pop es
      pop ds
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; slateseg(*xyptr,yh,yl)
; returns ax=0 no error    cx=seglen in number of segments   dx=segment of line
; 24 yl    22 yh    20 *xyptr    1e retad    1c disave    1a sisave
; 18 bpsave    16 bxsave    14 dxsave    12 cxsave    10 axsave
; 0e yevalhigh    0c yevallow    0a ctr1to2    08 dssave    06 seg+1
; 04 seg+0    02 srhi    00 srlo
slateseg:  push di
   push si
      push bp
      push bx
      xor bx,bx
      mov cx,000bh
slateztop:  push bx
      dec cx
      jnz slateztop
      mov bp,sp
      mov di,[bp+0020h]
      sub di,bp
slateslop:  push word [bp+0ah]
      push bx
      push word [bp+0024h]
      push word [bp+0022h]
      call cadd
      add sp,08h
      push ax
      push dx
      push bx
      push bx
;   0-(y&+ctr)
      call csubtract
      add sp,08h
      mov [bp+02h],dx
      mov [bp+00h],ax
      test cx,000ch
      jnz keepacseg
;                    sr < 0
      jmp errorslate
errorslater:  cmp [bp+di+0102h],bx
      jnz  erroracrte
      mov ax,[bp+di+0100h]
      mov [bp+04h],ax
      jmp errorslate
erroracrte:  cmp [bp+0ah],bx
      jnz errorslate
      mov [bp+022h],bx
      mov ax,[bp+di+0102h]
      mov [bp+0024h],ax
      jmp  slateslop
errorslate:  mov word [bp+010h],001fh
      jmp slatebote
keepacseg:  push ax
      push dx
      push word [bp+di+0102h]
      push bx
      call cadd
      add sp,08h
      sub dx,0000h
      js errorslater
;                   (  [bp+di+0102h] - sr )  < 0
      mov si,[bp+00h]
      add si,si
      and si,000eh
      mov ax,03h
acslasefixsr:      clc
      rcr word [bp+02h],1
      rcr word [bp+00h],1
      clc
      dec ax
      jnz acslasefixsr
      or word [bp+02h],0e000h
      push word [bp+00h]
      push word [bp+02h]
      push word [bp+di+011ah]
      push bx
      call cadd
      add sp,08h
      mov [bp+00h],ax
      mov [bp+02h],dx
      mov ax,ds
      mov [bp+08h],ax
      mov ax,[bp+00h]
      mov ds,ax
      mov cx,[si]
      mov si,[bp+08h]
      mov ds,si
; forgot to check segment value not overwrite its data
; ax needs to be large  (cx+7) needs to be small
      mov di,cx
      mov si,ax
      push cx
      push bx
      mov ax,037h
      push ax
      push bx
      call cadd
      add sp,08h
      push ax
      push dx
      push si
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jz kepblate
      jmp errorslate
kepblate:   mov cx,di
      mov di,[bp+0020h]
      sub di,bp
      mov si,[bp+0ah]
      add si,si
      mov [bp+si+0004h],cx
      inc word [bp+0ah]
      cmp word [bp+0ah],0002h
      jns slateootd
      jmp slateslop
slateootd:      mov ax,[bp+06h]
      sub ax,[bp+0004h]
      mov [bp+0012h],ax
slatebote:  mov ax,[bp+04h]
      mov [bp+014h],ax
      add sp,0010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; slatewbinvd(*xyptr) Write back and invalidate 0a,0110.0112
; 0c *xyptr    0a retad    08 disave    06 sisave    04 bpsave    02 bxsave
; 00 axsave
slatewbinvd:    push di
      push si
      push bp
      push bx
      xor bx,bx
      push bx
      mov bp,sp
      mov di,[bp+0ch]
      sub di,bp
      push word [bp+0ch]
      call wratostring
      add sp,02h
      mov [bp+di+0110h],bx
      mov [bp+di+0112h],bx
      mov [bp+00h],ax
      pop ax
      pop bx
      pop bp
      pop si
      pop di
      ret
; insert zero length line at 044.046
; slatewbinvd
; lopc8886: segctr32=[0102]
; if segctr32<044.046 then slateacwrite,exit
; segof(ptr32+1)=segof(ptr32)
; decrement segctr32   goto lopc8886
; slaterinsert(*xyptr,insertlocal) uses 044,046
; 26 insertlocal    24 *xyptr    22 retad    20 disave    1e sisave
; 1c bpsave    1a bxsave    18 dxsave    16 cxsave    14 axsave    12    10
; 0e    0c    0a ptr32h    08 ptr32l    06 hptrh    04 hptrl    02    00
slaterinsert:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,014h
      mov bp,sp
      mov di,[bp+024h]
      sub di,bp
      xor bx,bx
      mov [bp+014h],bx
      push word [bp+024h]
      call slatewbinvd
      add sp,02h
      or [bp+014h],ax
      push word [bp+di+0102h]
      pop word [bp+08h]
      mov [bp+0ah],bx
insercakelop:    push word [bp+di+044h]
                 push word [bp+di+046h]
      push word [bp+08h]
      push word [bp+0ah]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz insercakewrt
      push word [bp+08h]
      push word [bp+0ah]
      mov ax,01h
      push ax
      push bx
      call cadd
      add sp,08h
      mov [bp+04h],ax
      mov [bp+06h],dx
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+024h]
      call slateseg
      add sp,06h
      push word [bp+04h]
      push word [bp+06h]
      push dx
      push word [bp+024h]
      call wrslaterseg
      add sp,08h
      or [bp+014h],ax
      mov ax,01h
      push ax
      push bx
      push word [bp+08h]
      push word [bp+0ah]
      call csubtract
      add sp,08h
      mov [bp+08h],ax
      mov [bp+0ah],dx
      jmp insercakelop
insercakewrt:  push word [bp+026h]
      push word [bp+024h]
      call slateacwrite
      add sp,04h
      or [bp+014h],ax
      mov ax,01h
      push ax
      push bx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call cadd
      add sp,08h
      mov [bp+di+050h],ax
      mov [bp+di+052h],dx
      push word [bp+024h]
      call slatewbinvd
      add sp,02h
      or [bp+014h],ax
      add sp,014h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; botseg is based on 044.046
; diffseg=seg(044.046 + onemany)-botseg
; multidelete(*xyptr,numberoftimes)
; slaterdelete(*xyptr)  044 046
; 28 numberoftimes    26 *xyptr    24 retad    22 dssave    20 essave
; 1e disave    1c sisave    1a bpsave    18 bxsave    16 dxsave
; 14 cxsave    12 axsave    10 onemany    0e ctr32h    0c ctr32L
; 0a ctr32-onemanyH    08 ctr32-onemanyL    06 botseg    04 diffseg
; 02 0102seg                00 ctrseg
slaterdelete:  push ds
               push es
      push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0012h
      mov bp,sp
      mov word [bp+0010h],0001h
      xor bx,bx
      mov [bp+012h],bx
slacmndelete:  mov di,[bp+026h]
      sub di,bp
      push word [bp+026h]
      call slatewbinvd
      add sp,02h
      or [bp+012h],ax
; (0102-044.046 !< onemany)
; (0102-044.046 ) - onemany !< 0
      push word [bp+di+044h]
      push word [bp+di+046h]
      push word [bp+di+0102h]
      push bx
      call csubtract
      add sp,08h
      mov [bp+08h],ax
      mov [bp+0ah],dx
      push word [bp+010h]
      push bx
      push word [bp+08h]
      push word [bp+0ah]
      call csubtract
      add sp,08h
      test cx,000ch
      jz slacbndelete
      mov ax,[bp+08h]
      mov [bp+010h],ax
      cmp [bp+0ah],bx
      jns slacbndelete
      mov [bp+010h],bx
slacbndelete:  cmp [bp+010h],bx
      jnz rlacmndelete
      jmp quitmndelete
rlacmndelete:  push word [bp+di+044h]
               push word [bp+di+046h]
      push word [bp+026h]
      call slateseg
      add sp,06h
      mov [bp+06h],dx
      push word [bp+010h]
      push bx
      push word [bp+di+044h]
      push word [bp+di+046h]
      call cadd
      add sp,08h
      push ax
      push dx
      push word [bp+026h]
      call slateseg
      add sp,06h
      mov [bp+00h],dx
      sub dx,[bp+06h]
      mov [bp+04h],dx
      push word [bp+di+0102h]
      push bx
      push word [bp+0026h]
      call slateseg
      add sp,06h
      mov [bp+02h],dx
sddh01:  push word [bp+00h]
      push bx
      push word [bp+02h]
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz sddhbot01
      mov dx,[bp+00h]
      mov ds,dx
      sub dx,[bp+04h]
      mov es,dx
      xor si,si
      xor di,di
      mov dx,0010h
      mov cx,dx
      cld
sddi01:  movsb
      dec dx
      jnz sddi01
      mov di,[bp+026h]
      sub di,bp
      inc word [bp+00h]
      jmp sddh01
sddhbot01:  push word [bp+di+044h]
            push word [bp+di+046h]
      push word [bp+010h]
      push bx
      call cadd
      add sp,08h
      mov [bp+0ch],ax
      mov [bp+0eh],dx
sdde02:  push word [bp+0ch]
      push word [bp+0eh]
      push word [bp+di+0102h]
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz sddebot04
      push word [bp+010h]
      push bx
      push word [bp+0ch]
      push word [bp+0eh]
      call csubtract
      add sp,08h
      mov [bp+08h],ax
      mov [bp+0ah],dx
      push word [bp+0ch]
      push word [bp+0eh]
      push word [bp+026h]
      call slateseg
      add sp,06h
      sub dx,[bp+04h]
      push word [bp+08h]
      push word [bp+0ah]
      push dx
      push word [bp+026h]
      call wrslaterseg
      add sp,08h
      or word [bp+012h],ax
      push word [bp+0ch]
      push word [bp+0eh]
      mov ax,01h
      push ax
      push bx
      call cadd
      add sp,08h
      mov [bp+0ch],ax
      mov [bp+0eh],dx
      jmp sdde02
sddebot04:  push word [bp+010h]
      push bx
      push word [bp+di+0102h]
      push bx
      call csubtract
      add sp,08h
      mov [bp+di+0102h],ax
      push word [bp+010h]
      push bx
      push word [bp+di+050h]
      push word [bp+di+052h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz sddr52
      mov [bp+di+050h],bx
      mov [bp+di+052h],bx
      jmp quitmndelete
sddr52:  mov [bp+di+050h],ax
         mov [bp+di+052h],dx
quitmndelete:  add sp,0012h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      pop es
      pop ds
      ret
multidelete:  push ds
      push es
      push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0012h
      mov bp,sp
      mov ax,[bp+0028h]
      mov [bp+0010h],ax
      xor bx,bx
      mov [bp+012h],bx
      jmp slacmndelete
; replacement   wrslaterseg(*xyptr,segwrval,yh,yL)
; 4a yl    48 yh    46 segwrval    44 *xyptr    42 retad    40 dssave
; 3e disave    3c sisave    3a bpsave    38 bxsave    36 dxsave    34 cxsave
; 32 axsave    30    2e hyh    2c hyL    2a    28    26    24
; 22 swrhi    20 swrlow    1e    1c offsetwr    1a    18    16
; 14 addtosize    12    10    0c ctr    0a    08 segsave    06    04   02   00
wrslaterseg:  push ds
    push di
      push si
      push bp
      push bx
      xor bx,bx
      mov cx,001ch
wrslateytop:  push bx
      dec cx
      jnz wrslateytop
      mov bp,sp
      mov di,[bp+044h]
      sub di,bp
      mov ax,[bp+04ah]
      mov dx,[bp+048h]
      mov [bp+02ch],ax
      mov [bp+02eh],dx
      push word [bp+di+0102h]
      push bx
      mov ax,0fe00h
      push ax
      push bx
      call csubtract
      add sp,0008h
      test cx,000ch
      jnz wracerrorseg
      cmp word [bp+di+004ah],0000h
      jnz wracerrorseg
      push word [bp+02ch]
      push word [bp+02eh]
      mov ax,0fe00h
      push ax
      push bx
      call csubtract
      add sp,0008h
      test cx,000ch
      jnz wracerrorseg
      push word [bp+02ch]
      push word [bp+02eh]
      push word [bp+di+0102h]
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jz wsycmpeq
      jmp wsygt102
wsycmpeq:  test cx,000eh
      jnz wsylt102
      jmp wsyeq102
wracerrorseg:  mov word [bp+0032h],001fh
               mov word [bp+di+004ah],001fh
      jmp wracsegpop
; choice Y < 0102h
wsylt102:  push word [bp+02ch]
           push word [bp+02eh]
      push bx
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz wracnoerrorl
      jmp wracerrorseg
wracnoerrorl:  mov [bp+0020h],ax
               mov [bp+0022h],dx
      and ax,0007h
      add ax,ax
      mov [bp+001ch],ax
      mov dx,03h
wracshrrlt:  clc
      rcr word [bp+022h],1
      rcr word [bp+020h],1
      dec dx
      jnz wracshrrlt
      or word [bp+022h],0e000h
      push word [bp+0020h]
      push word [bp+0022h]
      push word [bp+di+011ah]
      push bx
      call cadd
      add sp,08h
      mov [bp+08h],ax
      push word [bp+0046h]
      push bx
      mov cx,037h
      push cx
      push bx
      call cadd
      add sp,08h
      push ax
      push dx
      push word [bp+08h]
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jz keepdlablt
      jmp wracerrorseg
keepdlablt:  mov ax,[bp+08h]
      mov ds,ax
      mov cx,[bp+0046h]
      mov si,[bp+001ch]
      mov [si],cx
wsyltbot:  jmp wracsegpop
; choice Y == 0102h
wsyeq102:  push word [bp+02ch]
           push word [bp+02eh]
      push bx
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz wracnoerrore
      jmp wracerrorseg
wracnoerrore:  mov [bp+0020h],ax
               mov [bp+0022h],dx
      and ax,0007h
      add ax,ax
      mov [bp+001ch],ax
      mov dx,03h
wracshrreq:  clc
      rcr word [bp+022h],1
      rcr word [bp+020h],1
      dec dx
      jnz wracshrreq
      or word [bp+022h],0e000h
      push word [bp+0020h]
      push word [bp+0022h]
      push word [bp+di+011ah]
      push bx
      call cadd
      add sp,08h
      mov [bp+08h],ax
      push word [bp+0046h]
      push bx
      mov cx,037h
      push cx
      push bx
      call cadd
      add sp,08h
      push ax
      push dx
      push word [bp+08h]
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jz keepdlabeq
      jmp wracerrorseg
keepdlabeq:  mov ax,[bp+08h]
      mov ds,ax
      mov cx,[bp+0046h]
      mov si,[bp+001ch]
      mov [si],cx
; before increment 2c.2e
      mov ax,01h
      push ax
      push bx
      push word [bp+002ch]
      push word [bp+002eh]
      call cadd
      add sp,08h
      mov [bp+002ch],ax
      mov [bp+002eh],dx
; finish adding one to 2c.2e
      cmp word [bp+0ch],01h
      jns wsyeqbot
      inc word [bp+0ch]
      jmp wsyeq102
wsyeqbot:  jmp wracsegpop
; choice Y > 0102h
wsygt102:  push word [bp+di+0102h]
           push bx
      mov ax,01h
      push ax
      push bx
      call cadd
      add sp,08h
      mov [bp+02ch],ax
      mov [bp+02eh],dx
wsygtlop:  push word [bp+02ch]
           push word [bp+02eh]
      push bx
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz wracnoerrorg
      jmp wracerrorseg
wracnoerrorg:  mov [bp+0020h],ax
               mov [bp+0022h],dx
      and ax,0007h
      add ax,ax
      mov [bp+001ch],ax
      mov dx,03h
wracshrrgt:  clc
      rcr word [bp+022h],1
      rcr word [bp+020h],1
      dec dx
      jnz wracshrrgt
      or word [bp+022h],0e000h
      push word [bp+0020h]
      push word [bp+0022h]
      push word [bp+di+011ah]
      push bx
      call cadd
      add sp,08h
      mov [bp+08h],ax
      push word [bp+0046h]
      push bx
      mov cx,037h
      push cx
      push bx
      call cadd
      add sp,08h
      push ax
      push dx
      push word [bp+08h]
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jz keepdlabgt
      jmp wracerrorseg
keepdlabgt:  mov ax,[bp+08h]
      mov ds,ax
      mov cx,[bp+0046h]
      mov si,[bp+001ch]
      mov [si],cx
; before increment 2c.2e
      mov ax,01h
      push ax
      push bx
      push word [bp+04ah]
      push word [bp+048h]
      call cadd
      add sp,08h
      push ax
      push dx
      push word [bp+02ch]
      push word [bp+02eh]
      call csubtract
      add sp,08h
      test cx,000ch
      jz wsygtaddlen
; begin increment 2c.2e
      mov ax,01h
      push ax
      push bx
      push word [bp+002ch]
      push word [bp+002eh]
      call cadd
      add sp,08h
      mov [bp+002ch],ax
      mov [bp+002eh],dx
; finish adding one to 2c.2e
      inc word [bp+014h]
      jmp wsygtlop
wsygtaddlen:  push word [bp+014h]
      push bx
      push word [bp+di+0102h]
      push bx
      call cadd
      add sp,08h
      mov word [bp+di+0102h],ax
wracsegpop:  add sp,0032h
           pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      pop ds
      ret
; need wratostring(*xyptr) uses 0110,0112 instead of 044,046
; slateacwrite(*xyptr,writelnn)  uses 044,046 ytaelon
; 24 writelnn    22 *xyptr    20 retad    1e disave    1c sisave    1a bpsave
; 18 bxsave    16 dxsave    14 cxsave    12 axsave    10    0e    0c    0a
slateacwrite:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0012h
      mov bp,sp
      mov di,[bp+0022h]
      sub di,bp
      xor bx,bx
      cmp [bp+di+00ech],bx
      jz slateacwrilc
      push word [bp+0024h]
      push word [bp+0022h]
      call casesub
      add sp,0004h
slateacwrilc:      mov [bp+012h],bx
      push word [bp+di+044h]
      push word [bp+di+046h]
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      call csubtract
      add sp,0008h
      test cx,000eh
      jz acwrdirect
      push word [bp+022h]
      call wratostring
      add sp,02h
      mov [bp+0012h],ax
      mov ax,[bp+di+044h]
      mov dx,[bp+di+046h]
      mov [bp+di+0110h],ax
      mov [bp+di+0112h],dx
acwrdirect:  push word [bp+0024h]
      push word [bp+0022h]
      mov dx,000ah
      push dx
      push word [bp+0022h]
      call outlinecopy
      add sp,0008h
      mov ax,[bp+012h]
      or [bp+di+04ah],ax
      add sp,0012h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; slacinsertde(*xyptr,iph,ipl,up)
; 3e up    3c 1pl    3a iph    38 *xyptr    36 retad    34 dssave    32 essave
; 30 disave    2e sisave    2c bpsave    2a bxsave    28 dxsave    26 cxsave
; 24 axsave    22 seg1    20 sseglen    1e botseg    1c chgsegment    1a
; 18    16    14    12    10    0e sadptrh    0c sadptrl    0a    08
; 06    04    02    00
slacinsertde:    push ds
      push es
      push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0024h
      mov bp,sp
      mov di,[bp+038h]
      sub di,bp
      xor bx,bx
      mov [bp+0024h],bx
      cmp word [bp+di+004ah],0000h
      jz flox9004
      mov word [bp+0024h],001fh
      jmp ndebot4
flox9004:      push word [bp+03ch]
      push word [bp+03ah]
      push word [bp+038h]
      call slateseg
      add sp,06h
      mov [bp+020h],cx
      mov [bp+022h],dx
      add dx,cx
      mov [bp+01eh],dx
      push word [bp+di+0102h]
      push bx
      push word [bp+038h]
      call slateseg
      add sp,06h
      mov word [bp+01ch],dx
ndelop01:  mov dx,[bp+01ch]
      cmp dx,[bp+01eh]
      jb rdetwo
      mov ds,dx
      add dx,[bp+03eh]
      mov es,dx
      cld
      xor si,si
      xor di,di
      mov dx,0010h
      mov cx,dx
      cld
ndelop02:  movsb
      dec dx
      jnz ndelop02
      dec word [bp+01ch]
      jmp ndelop01
rdetwo:  mov di,[bp+038h]
      sub di,bp
      mov ax,01h
      push ax
      push bx
      push word [bp+03ch]
      push word [bp+03ah]
      call cadd
      add sp,08h
      mov [bp+0ch],ax
      mov [bp+0eh],dx
ndelop03:  push word [bp+0ch]
           push word [bp+0eh]
      push word [bp+di+0102h]
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz ndebot4
      push word [bp+0ch]
      push word [bp+0eh]
      push word [bp+038h]
      call slateseg
      add sp,06h
      add dx,[bp+03eh]
      push word [bp+0ch]
      push word [bp+0eh]
      push dx
      push word [bp+038h]
      call wrslaterseg
      add sp,08h
      or [bp+di+004ah],ax
      or [bp+024h],ax
      cmp ax,bx
      jnz ndebot4
      mov ax,01h
      push ax
      push bx
      push word [bp+0ch]
      push word [bp+0eh]
      call cadd
      add sp,08h
      mov [bp+0ch],ax
      mov [bp+0eh],dx
      jmp ndelop03
ndebot4:  add sp,0024h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      pop es
      pop ds
      ret
; slacdeletede(*xyptr,dph,dpl,dn)
; 3e dn    3c dpl    3a dph    38 *xyptr    36 retad    34 dssave
; 32 essave    30 disave    2e sisave    2c bpsave    2a bxsave    28 dxsave
; 26 cxsave    24 axsave    22     20    1e segstart    1c seglen
; 1a loopseg    18 loopsegpldn    16 seg102    14    12    10    0e    0c
; 0a dnctrh    08 dnctrl    06    04    02    00
slacdeletede:    push ds
      push es
      push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,0024h
      mov bp,sp
      mov di,[bp+038h]
      sub di,bp
      xor bx,bx
      mov [bp+024h],bx
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      push word [bp+038h]
      call slateseg
      add sp,06h
      mov [bp+01eh],dx
      mov [bp+01ch],cx
      add dx,cx
      sub dx,[bp+03eh]
      mov [bp+01ah],dx
      push word [bp+di+0102h]
      push bx
      push word [bp+038h]
      call slateseg
      add sp,06h
      mov [bp+016h],dx
ddel04:  mov ax,[bp+01ah]
      mov es,ax
      add ax,[bp+03eh]
      mov ds,ax
      mov [bp+018h],ax
      push word [bp+018h]
      push bx
      push word [bp+016h]
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz deld5
      inc word [bp+01ah]
      xor si,si
      xor di,di
      mov dx,0010h
      mov cx,dx
      cld
ddelr4:  movsb
      dec dx
      jnz ddelr4
      jmp ddel04
deld5:  mov di,[bp+038h]
      sub di,bp
      mov ax,01h
      push ax
      push bx
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      call cadd
      add sp,08h
      mov [bp+08h],ax
      mov [bp+0ah],dx
ddelv7:  push word [bp+08h]
      push word [bp+0ah]
      push word [bp+di+0102h]
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz deld9
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+038h]
      call slateseg
      add sp,06h
      sub dx,[bp+03eh]
      push word [bp+08h]
      push word [bp+0ah]
      push dx
      push word [bp+038h]
      call wrslaterseg
      add sp,08h
      or [bp+024h],ax
      push word [bp+08h]
      push word [bp+0ah]
      mov ax,01h
      push ax
      push bx
      call cadd
      add sp,08h
      mov [bp+08h],ax
      mov [bp+0ah],dx
      jmp ddelv7
deld9:  add sp,0024h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      pop es
      pop ds
      ret
; wratostring(*xyptr)  uses 0110,0112 instead of 044,046
; 36 *xyptr    34 retad    32 disave    30 sisave    2e bpsave    2c bxsave
; 2a dxsave    28 cxsave    26 axsave    24 dssave    22 lena    20 lensegc
; 1e segvald    1c varlen   1a locationofa    18 varseg
;   16 chkh   14 chkl        12    10    0e
; 0c    0a    08    06    04    02    00
wratostring:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      push ds
      sub sp,024h
      mov bp,sp
      mov di,[bp+0036h]
      sub di,bp
      xor bx,bx
      mov [bp+0026h],bx
      mov ax,000ah
      push ax
      push word [bp+0036h]
      call alselset
      add sp,04h
      mov [bp+001ah],ax
      mov ax,0ah
      push ax
      push word [bp+0036h]
      call clenval
      add sp,04h
      mov [bp+022h],cx
      mov ax,01h
      push ax
      push bx
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      call csubtract
      add sp,08h
      test cx,0ch
      jz  zur102
      jmp spopacwra
zur102:   cmp [bp+di+0102h],bx
      jnz gt102
      mov ax,01h
      push ax
      push bx
      push word [bp+0036h]
      call slateseg
      add sp,06h
      mov ax,01h
      push ax
      push bx
      push dx
      push word [bp+0036h]
      call wrslaterseg
      add sp,08h
      or [bp+026h],ax
      jmp aftgt102
gt102:  push word [bp+di+0110h]
      push word [bp+di+0112h]
      push word [bp+di+0102h]
      push bx
      call csubtract
      add sp,0008h
      test cx,000ch
      jz aftgt102
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      push word [bp+036h]
      call slateseg
      add sp,06h
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      push dx
      push word [bp+036h]
      call wrslaterseg
      add sp,08h
      or [bp+026h],ax
aftgt102:  push word [bp+di+0110h]
      push word [bp+di+0112h]
      push word [bp+036h]
      call slateseg
      add sp,06h
      mov [bp+01eh],dx
      mov [bp+020h],cx
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      push bx
      push bx
      call csubtract
      add sp,08h
      mov cx,0003h
fixwa2shrlop:  clc
      rcr dx,1
      rcr ax,1
      dec cx
      jnz fixwa2shrlop
      or dx,0e000h
      push ax
      push dx
      push word [bp+di+011ah]
      push bx
      call cadd
      add sp,08h
      mov [bp+014h],ax
      mov [bp+016h],dx
      push word [bp+001eh]
      push bx
      mov cx,0007h
      push cx
      push bx
      call cadd
      add sp,08h
      push ax
      push dx
      push word [bp+014h]
      push word [bp+016h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz fixwa2keep
fixwa2crash:  or word [bp+026h],001fh
      or word [bp+di+004ah],001fh
      jmp spopacwra
fixwa2keep:  mov ax,[bp+di+004ah]
      or ax,[bp+0026h]
      jnz fixwa2crash
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      mov ax,0fe00h
      push ax
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz fixwa2crash
      mov dx,[bp+020h]
      mov ax,[bp+022h]
      push dx
      push bx
      push ax
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jnz acwrdel
      test cx,000eh
      jz acdirectwrt
;    rest of wratostring
acwrinsert:   mov ax,[bp+022h]
     sub ax,[bp+020h]
      push ax
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      push word [bp+036h]
      call slacinsertde
      add sp,08h
      or [bp+026h],ax
      jmp acdirectwrt
acwrdel:  mov ax,[bp+020h]
      sub ax,[bp+022h]
      push ax
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      push word [bp+036h]
      call slacdeletede
      add sp,08h
      or [bp+026h],ax
acdirectwrt:  push word [bp+01eh]
      pop word [bp+018h]
      push word [bp+022h]
      pop word [bp+01ch]
rcdirectwrt:  cmp word [bp+01ch],bx
      jnz dcdirectwrt
      push word [bp+di+0102h]
      push bx
      push word [bp+di+0110h]
      push word [bp+di+0112h]
      call csubtract
      add sp,08h
      test cx,000ch
      jz bodirectwrt
      jmp spopacwra
bodirectwrt:  push word [bp+di+0110h]
              push word [bp+di+0112h]
      mov ax,01h
      push ax
      push bx
      call cadd
      add sp,08h
      push ax
      push dx
      mov cx,[bp+01eh]
      add cx,[bp+022h]
      push cx
      push word [bp+036h]
      call wrslaterseg
      add sp,08h
      jmp spopacwra
dcdirectwrt:  mov si,[bp+01ah]
      sub si,bp
      mov cx,[bp+018h]
      mov ds,cx
      inc word [bp+018h]
      add word [bp+01ah],0010h
      dec word [bp+01ch]
      mov cx,0010h
      xor di,di
acdirectwoop:    mov al,[bp+si]
      mov [di],al
      inc si
      inc di
      dec cx
      jnz acdirectwoop
      mov di,[bp+0036h]
      sub di,bp
      jmp rcdirectwrt
spopacwra:  add sp,0024h
      pop ds
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; acinsertb(*xyptr) uses y 014.016   uses 0034 insel%  needs increment y014.016
; 22 *xyptr    20 retad    1e disave    1c sisave    1a bpsave    18 bxsave
; 16 dxsave    14 cxsave   12 axsave    10    0e    0c    0a    08
acinsertb:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,012h
      mov bp,sp
      mov di,[bp+022h]
      sub di,bp
      xor bx,bx
      mov ax,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+044h],ax
      mov [bp+di+046h],dx
      mov cx,01h
      push ax
      push dx
      push cx
      push bx
      call cadd
      add sp,08h
      mov [bp+di+014h],ax
      mov [bp+di+016h],dx
      push word [bp+di+0034h]
      push word [bp+022h]
      xor ax,ax
      call slaterinsert
      add sp,04h
      or word [bp+di+04ah],ax
      add sp,012h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; beldlinesdel(*xyptr,howmany) 014.016 delete lines at y&
; aclinedel(*xyptr) 014.016 delete line at y&
; 26 howmany    24 *xyptr    22 retad    20 disave    1e sisave    1c bpsave
; 1a bxsave    18 dxsave    16 cxsave    14 axsave    12    10    0e    0c
; 0a    08 counter    06    04    02    00
aclinedel:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,014h
      mov bp,sp
      mov word [bp+08h],0001h
acblinedel:  mov di,[bp+0024h]
      sub di,bp
      xor bx,bx
      xor ax,ax
      mov cx,[bp+di+014h]
      mov dx,[bp+di+016h]
      mov [bp+di+044h],cx
      mov [bp+di+046h],dx
      push word [bp+08h]
      push word [bp+024h]
      call multidelete
      add sp,04h
      or [bp+di+04ah],ax
      add sp,014h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
beldlinesdel:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      sub sp,014h
      mov bp,sp
      mov cx,[bp+026h]
      mov [bp+08h],cx
      jmp acblinedel
; ax=linesleft82(*xyptr)    returns with ax=linesleft or zero
; 2e *xyptr    2c retad    2a dssave    28 disave    26 sisave    24 bpsave
; 22 bxsave    20 dxsave    1e cxsave    1c axsave    1a
; 18 offset    16 highsegtah    14 highsegtal    12 shrh    10 shrl
; 0e lowsegtah    0c lowsegtal    0a zur77    08 cst77    06    04    02    00
linesleft82:  push ds
      push di
      push si
      push bp
      push bx
      push dx
      push cx
      xor bx,bx
      mov dx,000fh
linestopu82:  push bx
      dec dx
      jnz linestopu82
      mov bp,sp
      mov di,[bp+002eh]
      sub di,bp
      mov word [bp+0008h],0077h
      push word [bp+di+0102h]
      push bx
      mov ax,0f800h
      push ax
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jz flox9474
flox9473:  jmp linesquit82
flox9474:  cmp word [bp+di+004ah],bx
      jnz flox9473
floxleft82:  push word [bp+di+0102h]
      push bx
      push bx
      push bx
      call csubtract
      add sp,08h
      test cx,000ch
      jz flox9473
      mov [bp+0010h],ax
      and ax,0007h
      add ax,ax
      mov [bp+0018h],ax
      mov cx,0003h
      shr word [bp+0010h],cl
      add word [bp+0010h],0e000h
      dec word [bp+0012h]
      push word [bp+0010h]
      push word [bp+0012h]
      push word [bp+di+011ah]
      push bx
      call cadd
      add sp,08h
      mov [bp+0014h],ax
      mov cx,[bp+0014h]
      mov ds,cx
      mov si,[bp+0018h]
      mov dx,[si]
      mov [bp+0ch],dx
      push word [bp+0ch]
      push word [bp+0eh]
      push word [bp+08h]
      push word [bp+0ah]
      call cadd
      add sp,08h
      push ax
      push dx
      push word [bp+0014h]
      push word [bp+0016h]
      call csubtract
      add sp,08h
      test cx,000ch
      jnz linesquit82
      mov cx,[bp+di+004ch]
      add cx,0002h
      push cx
      push bx
      add ax,ax
      adc dx,dx
      add ax,ax
      adc dx,dx
      add ax,ax
      adc dx,dx
      add ax,ax
      adc dx,dx
      push ax
      push dx
      call cposdiv
      add sp,0008h
      mov [bp+001ch],ax
linesquit82:  add sp,001ch
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      pop ds
      ret
mainappc:  mov ax,0000h
       push ds
       mov si,0002h
       mov bx,[si]
       sub bx,0080h
      push ax
      sub sp,03700h
      mov bp,sp
      mov ax,ss
      add ax,01002h
;  REM 0054 number of real segments  0058 LIMIT
      mov word [bp+0058h],000fh
      mov word [bp+005ah],0000h
      mov word [bp+054h],07ffeh
; need maximum number of segments in 0054
      mov word [bp+056h],00h
      mov di,0000h
      mov word [bp+011eh],0000h
      mov ax,0010h
      mov cx,0003h
      mov dx,0000h
      push dx
      push dx
      push dx
      push cx
      push ax
      call rintshield
      add sp,000ah
secondseghgt:  mov bx,0000h
      mov si,00h
      push si
      push bp
      call new2608
      add sp,0004h
fnlistbot:  mov si,0080h
      mov dx,cs
      add dx,0000h
      mov ds,dx
      nop
      cmp byte [si],02h
      jns srwfc
      mov si,052h
      jmp swfssb
srwfc:  mov si,0082h
      mov dx,08h
        push dx
        push bp
        call alselset
        add sp,04h
swfe:  sub ax,bp
      mov di,ax
      mov bx,di
swfteepb:  mov dx,cs
      add dx,0000h
      mov ds,dx
      nop
      mov dl,[si]
      inc si
      cmp dl,020h
      jz swfteepb
      cmp dl,024h
      jz swfteepb
      dec si
      cmp dl,02fh
      jnz swfteepc
; insert jmp / here
swfteepc:  mov dx,cs
      add dx,0000h
      mov ds,dx
      nop
      mov dl,[si]
         cmp dl,020h
         jz swfh
         cmp dl,0dh
         jz swfh
         cmp dl,024h
         jz swfh
         mov ax,cs
         add ax,0000h
         mov ds,ax
         nop
         mov al,[0080h]
         and ax,007fh
         sub ax,02h
         add ax,0082h
         cmp ax,si
         js swfh
         mov [bp+di],dl
         inc si
         inc di
      jmp swfteepc
swfh:  mov ax,04fh
; after  swfh  copy filename to home gets menu
      mov cx,02h
      push cx
      push bp
      call fntoonine
      add sp,0004h
tz2600:  mov si,04fh
swfssb:  mov di,bx
         add di,[bp+004ch]
         sub di,02h
         mov byte [bp+di],020h
         mov byte [bp+di+01h],020h
rswfssb:   push bp
      call bscr2330
      add sp,02h
      push si
      push bp
      call ron2640
      add sp,04h
; fix screen at end
      push ds
      push es
      push bp
      mov ax,0200h
      mov bx,0000h
      mov dh,018h
      mov dl,000h
      int 10h
      mov ax,0800h
      mov bx,0000h
      int 10h
      mov ah,09h
      mov bx,0007h
      mov cx,0001h
      int 10h
      pop bp
      pop es
      pop ds
      mov ax,0000h
      add sp,03700h
      retf
homegetline  db "                ANTI-DRAFT EDITOR  XYdsp=       "
    db "              >>  HOME GETS MENU$"
plate025  db "a.sAve.as...u.Uppercase...j.Joymouse.....z.Zchangedoccheck.$"
          db "b.Bot............888888888888888888888888888888888888888888$"
          db "c.list.Commands..88888888......8888888.88.....8888.88888888$"
          db "d.set.bkgnD......88888888..88..88...88.88.....8888.88888888$"
          db "e.Exit...........88888888......88.8.88.8888.888888.8888..88$"
          db "f.set.upleFt.....88888888..88..88.8..8.8888.888888.88888888$"
          db "g.set.lowriGht...88888888..88..88.88...8888.888888.88888888$"
      db "h.rigHtmost......888888888888888888888888888888888888888888$"
  db "i.fInd...........888888888888888888888888888888888888888888$"
  db "l.Load...........88...88888......88......88......88.....888$"
  db "m.upleft.Move....88.8...888.888..88..88..88..88888888.88888$"
  db "n.New............88.888.888......88......88.....88888.88888$"
  db "o.Open...........88.8...888.8..8888..88..88..88888888.88888$"
  db "p.upleft.coPy....88...88888.88...88..88..88..88888888.88888$"
  db "q.Quit...........888888888888888888888888888888888888888888$"
  db "r.Return....x.Xmarginset....y.Ylinenumber..................$"
  db "t.Tof............8..EVEN.IF.THERE.IS.A.WAR.NOW.............$"
  db "v................8..VOTE.TO.ABOLISH.THE.US.MILITARY.DRAFT..$"
  db "w................8...AND.ITS..REGISTRATION...NOW...........$"
  db "0000..EDZACK.COM...........................................$"
      db "ENTER.INPUT.FILENAME.THEN.PRESS.ENTER.$"
      db "ENTER.FILENAME.TO.BE.WRITTEN.THEN.PRESS.ENTER.$"
      db "FIND.LEFTMOST.PORTION.EXCEPT..........BLANKS.$"
      db "SAVE.FILE..Y..N.....$"
      db "ENTER.ONE.CHARACTER.FOR.BACKGROUND.$"
      db "ENTER.LINE.BETWEEN.1.AND.LAST.LINE..$"
      db "$$$$$$"
commandlisa:  db  " unknown command u$"
commandlist:  db  "   insertb insert "
    db  "delete af m k tof "
    db  "bot up down input quit print d$"
    db  "      replace   v open save "
    db  "new change find list inputc uc "
    db  "     lc  gui c$"
  db " EDZACK.COM free text editor written by Eric Matteson for DOS $"
    db  " Vote against the U.S. military draft even in wartime $"
    db  "enter line to be inserted before $"
    db  "enter line to be inserted  $"
    db  "input  mode untill zero-length line $"
    db  " is to be replaced with  ? $"
    db  " is zero length line correct ? $"
    db  " enter leftmost portion of line to be found $?$"
    db  " enter filename $"
    db  " change leftmost portion of line except blanks $"
    db  " press enter to continue $"
; EDZACK - real mode assembler hex codes chart for commonly used instructions
; in edzack DOS real or V8086 mode programming ...... least significant --->
;0000111112222233333444445555566666777778888899999AAAAABBBBBCCCCCDDDDDEEEEEFFFF
;ADD ADD  ADD  ADD  .    .    PUSH POP  OR   OR   OR   OR   .    .    PUSH INVA
;0>b ->W  b<-  W<-            ES   ES   >b   >w   b<   W<             CS
;ADC ADC  ADC  ADC  .    .    PUSH POP  SBB  SBB  SBB  SBB  .    .    PUSH POP
;1                            SS   SS                                 DS   DS
;AND AND  AND  AND  .    .    ES:  daa? SUB  SUB  SUB  SUB  .    .    CS:  das?
;2                         override:                              prefix:
;XOR XOR  XOR  XOR  .    .    SS:  aaa? CMP  CMP  CMP  CMP  .    .    DS:  aas?
;3 each most significant hex digit is below its opcode line 3- is below xor
; INC INC  INC  INC  INC  INC  INC  INC  DEC  DEC  DEC  DEC  DEC  DEC  DEC  DEC
;4 AX  CX  DX   BX   SP   BP   SI   DI   AX   CX   DX   BX   SP   BP   SI   DI
;PUSH PUSH PUSH PUSH PUSH PUSH PUSH PUSH POP  POP  POP  POP  POP  POP  POP  POP
;5 AX  CX  DX   BX   SP   BP   SI   DI  AX   CX   DX   BX   SP   BP   SI   DI
;LINE 6x is invalid in 8088 or 8086
;6
;JV  JNV  JB   JNB  JE   JNE  JNA  JA   JS   JNS  JPE  JPO  JL   JNL  JNG  JG
;7
;page page INVAL....TEST TEST XCHG XCHG MOV  MOV  MOV  MOV  rm=sg LEA sg=rm POP
;8 80   81          byte word byte word rm b rm w reg  reg W     r,rm       R/M
;NOP .    .    .    .    .    .    .    cbw? cwd? CALL wait?PUSHFPOPF SAHF LAHF
;9                                                FAR D
;al=m ax=m m=al m=ax movsbMOVSWcmpsbCMPSW.   .   stosbSTOSWlodsbLODSWscasbSCASW
;A backwards dir  |
;MVI  MVI MVI  MVI  MVI  MVI  MVI  MVI  MVI  MVI  MVI  MVI  MVI  MVI  MVI  MVI
;B al cl   dl   bl   ah   ch   dh   bh   AX   CX   DX   BX   SP   BP   SI   DI
;INVALinval RET RET les  lds  MVI bMVI w inv INVA RETF RETF int3 INT  into IRET
;C         imed               m0rm /0             imed           imed
;page page page page aam aad  inva xlat .    .    .    .    .    .    .    .
;D d0  d1 d2   d3 vw  i  i         to al
;lopneLOOPEloop JCXZ in  IN w out OUT  CALL JMP  JMP  JMP  IN b IN W OUT  OUT W
;E i imed cx i rel8 imed imed imed lng rel16 rel FAR d rel8 DX] [DX] dx,al [dx]
;LOCK INVA repNZrepZ halt cmc  page page CLC  STC  CLI  STI  CLD  STD  page pg
;F               REP           F6   F7                                 FE   FF
;...........................................................................
;page 80 and 81 1000000w  80 mdISTr/m    81 --IST---  md   r/m half is used
;ADD  OR   ADC  SBB  AND  SUB  XOR  CMP
;-----------------------------------------------------------------------------
;page D0 D1 D2 D3  100000vw v=0 by 1  v=1 by cl  w=1 word   w=0 byte mdISTr/m
;ROL  ROR  RCL  RCR  SHL  SHR  INVA SAR
;                    SAL
;-----------------------------------------------------------------------------
;page f6 f7       1111011w  w=0 byte    w=1 word   md   r/m half is also used
;TEST INVA NOT  NEG  MUL  IMUL DIV  IDIV
;--------------------------------------------------------------------------
;page fe FF  1111111w w=0 INC DEC byte only,  W=1 WORD JUMP CALL
;INC  DEC  CALL CALL JMP iJMP iPUSH INVAL
;          iw   i FAR near FAR
; instruction is usually followed by mdregr/m byte when only one register is
; not used and instruction is a data instruction without string mode.
; string instructions end with sb or sw and use DS:SI to ES:DI
; ----
;          16 bit addressing modes in 8088 or 8086 CPU  mdregr/m
; ??reg??? field      size = 0  8-bit       size =1 16-bit
; 000                    al                   ax
; 001                    cl                   cx       least significant
; 010                    dl                   dx       byte is lowest address
; 011                    bl                   bx
; 100                    ah                   sp
; 101                    ch                   bp
; 110                    dh                   si
; 111                    bh                   di
; -----------------------------------------------------------
; md???r/m fields      both 8 and 16 bit data addressing with 16 bit address
; 00---000           ds:[bx+si]
; 00---001           ds:[bx+di]
; 00---010           ss:[bp+si]
; 00---011           ss:[bp+di]
; 00---100           ds:[si]
; 00---101           ds:[di]
; 00---110           ds:[displow disphigh]
; 00---111           ds:[bx]
; ..
; 10---000           ds:[bx+si+d16]
; 10---001           ds:[bx+di+d16]
; 10---010           ss:[bp+si+d16]
; 10---011           ss:[bp+di+d16]
; 10---100           ds:[si+d16]
; 10---101           ds:[di+d16]
; 10---110           ss:[bp+(displow disphigh)]
; 10---111           ds:[bx+d16]
; ..
; when md=11 r/m uses the reg field chart and both operands are registers.
; many instructions end with dw w=1 for 16 bit data. w=0 for 8-bit data.
;  d=1 for reg field is destination operand.
; segment registers are shifted left by 4 bits and added to effective
; address from md???r/m.
; segment override goes before instruction when needed
; inst md reg r/m
; example and
; 001000DW mdregr/m
; inc and dec do not alter carry flag but alter other flags
; jb uses carry flag as borrow
; js uses sign flag
; segment register numbers
; 00 es
; 01 cs
; 10 ss
; 11 ds
; prefix if any. instruction byte. mdregr/m byte . addrdisplh .datalh
; least significant byte is first. Address displacement is before data.
; end of 8086 real mode programming help  02/16/2002
    db  "file finder. t Topoflist   o Open file  "
    db  " c Commandlist  -1 previous     +1 next$too many$$$$$$$$$$$$$$$$$"
