/* Copyright (C) Stephen Chung, 1991-1993.  All rights reserved. */

#include "jwp.h"
#include "idm.h"

#define GNUGPL     "GNUGPL.WRI"


BOOL FAR PASCAL SimpleProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
        case WM_INITDIALOG:
            CenterDialogBox(hwnd);
            return (TRUE);

        case WM_KEYDOWN:
        case WM_CHAR:
            switch (wParam) {
                case VK_ESCAPE: SendMessage(hwnd, WM_COMMAND, IDOK, 0L);
                                return (TRUE);
            }
            break;

        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                case IDCANCEL:
                    EndDialog(hwnd, FALSE);
                    return (TRUE);
            }
            return (FALSE);
    }

    return (FALSE);
}



BOOL FAR PASCAL AboutProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
        case WM_INITDIALOG:
            CenterDialogBox(hwnd);
            return (TRUE);

        case WM_COMMAND:
            switch (wParam) {
                case 4201:      /* Disclaimers */
                    DialogBox (hInstance, "Disclaimers", hwnd, SimpleProc);
                    return (TRUE);

                case 4202: {    /* Read GNU GPL */
					int len;
                    OFSTRUCT of;
                    char buffer[MAXLINELEN];

                    WinHelp(global.hwnd, global.help, HELP_CONTEXT, Topic_GNUGPL);
                    return (0);

                    /* Find the GNU GPL file */
                    if (OpenFile(GNUGPL, &of, OF_EXIST) < 0) goto HasError;
                    if (_chmod(of.szPathName, 1, FA_RDONLY) == -1) {
                        if (YesNo(hwnd, "Cannot open file '" GNUGPL "' as read-only.  Open "
                                        "the file anyway?") != IDYES) return (TRUE);
                    }

                    GetWindowsDirectory(buffer, MAXLINELEN);
                    len = strlen(buffer);
                    if (buffer[len-1] == '\\') buffer[len-1] = '\0';
                    strcat(buffer, "\\WRITE " GNUGPL);

                    if (WinExec(buffer, SW_SHOW) < 32) goto HasError;
                    return (TRUE);

                HasError:
                    ErrorMessage(hwnd, "Cannot execute Windows Write.  You should run Windows "
                                          "Write yourself, and the load the file '" GNUGPL "' that "
                                          "comes with this package.");
					return (TRUE);
                }

                case 4203:      /* See Acknowledgements */
                    DialogBox (hInstance, "Acknowledgements", hwnd, SimpleProc);
                    return (TRUE);

                case IDOK:
                case IDCANCEL:
                    EndDialog(hwnd, FALSE);
                    return (TRUE);
            }
            return (TRUE);

        case WM_KEYDOWN:
        case WM_CHAR:
            switch (wParam) {
                case VK_ESCAPE: SendMessage(hwnd, WM_COMMAND, IDOK, 0L);
                                return (TRUE);
            }
            break;

    }

    return (FALSE);
}
